<?php
/**************************************************
  Coppermine 1.4 Plugin - Custom Home
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

global $CONFIG, $lang_plugin_customhome, $lang_plugin_customhome_config;
require('include/init.inc.php');

if (!GALLERY_ADMIN_MODE) cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);

require('plugins/custom_home/include/init.inc.php');

if (count($_POST) > 0) {
	if (isset($_POST['update_config'])) {
		$group_list = isset($_POST['group_list']) ? $_POST['group_list'] : '';
		if (is_array($group_list)) {
			foreach($group_list as $group) {
				$group = (int)$group;
				$catpost = $_POST['catmenu_'.$group];
				$catmenu = isset($catpost) && is_numeric($catpost) ? (int)$catpost : '';
				$sql = "REPLACE INTO `{$CONFIG['TABLE_PLUGIN_CUSTOMHOME']}` (`group_id`,`cat_id`)"
					." VALUES ('{$group}','{$catmenu}');\n";
				cpg_db_query($sql);
				if ($CONFIG['log_mode'] == CPG_LOG_ALL) {
					log_write('CONFIG UPDATE SQL: '.$sql.";\n"
						.'TIME: '.date("F j, Y, g:i a")."\n"
						.'USER: '.$USER_DATA['user_name']
						,CPG_DATABASE_LOG
					);
				}
			}
		}
	}
        pageheader($lang_plugin_customhome['display_name']);
        msg_box($lang_plugin_customhome['display_name'], $lang_plugin_customhome['page_success'], $lang_continue, 'index.php');
	pagefooter();
        exit;
}

pageheader($lang_plugin_customhome['display_name']);
starttable('100%', $lang_plugin_customhome['display_name'].' - <a href="pluginmgr.php" class="admin_menu">Plugin Manager</a>', 3);
echo '<tr><td>'."\n";

echo <<< EOT
	<br />
	<h2>{$lang_plugin_customhome['config_title']}</h2>
	<h3>{$lang_plugin_customhome_config['set_groups']}:</h3>
	<form action="{$_SERVER['REQUEST_URI']}" method="post">

EOT;

$sql = "SELECT cid, parent, name FROM {$CONFIG['TABLE_CATEGORIES']} ORDER BY pos";
$result = cpg_db_query($sql);
$cat_list = cpg_db_fetch_rowset($result);
mysql_free_result($results);

$cat_menu = <<< EOT
    <select name="catmenu_GID" class="listbox">
    <option value="">{$lang_plugin_customhome_config['no_category']}</option>

EOT;

    // Get the ancestry of the categories
    foreach ($cat_list as $cat) {
        $catParent[$cat['cid']] = $cat['parent'];
        $catName[$cat['cid']] = $cat['name'];
    }
    $catAnces = array();
    foreach ($catParent as $cid => $cid_parent) {
        $catAnces[$cid] = '';
        while ($cid_parent != 0) {
            $catAnces[$cid] = $catName[$cid_parent] . ($catAnces[$cid]?' - '.$catAnces[$cid]:'');
            $cid_parent = $catParent[$cid_parent];
        }
    }

foreach($cat_list as $i => $cat) {
	$cat_list[$i]['name'] = $catAnces[$cat['cid']] . ($catAnces[$cat['cid']]?' - ':'') . $cat['name'];
}
$cat_list = array_csort($cat_list,'name');

foreach($cat_list as $cat) {
	$cat_menu .= '<option value="'.$cat['cid'].'" id="cat_GID_'.$cat['cid'].'">'
		. $cat['name'] . '</option>'."\n";
}
$cat_menu .= '</select>'."\n";

$sql = <<<EOQ
    SELECT g.group_id AS group_id, g.group_name AS group_name, c.cat_id AS cat_id
    FROM {$CONFIG['TABLE_USERGROUPS']} AS g
    LEFT JOIN {$CONFIG['TABLE_PLUGIN_CUSTOMHOME']} AS c ON (g.group_id = c.group_id)
    ORDER BY `g`.`group_name`
EOQ;
$result = cpg_db_query($sql);
$group_list = cpg_db_fetch_rowset($result);
mysql_free_result($result);
$group_cb = '';
foreach($group_list as $group) {
	if ($group['group_id'] != 1 && $group['group_id'] != 4) {
		$cat_menu_group = preg_replace('/(id="cat_GID_'.$group['cat_id'].'")/', '$1 selected="selected"', $cat_menu);
		$cat_menu_group = preg_replace('/_GID/', '_'.$group['group_id'], $cat_menu_group);
		$group_cb .= $cat_menu_group
			.' - '.$group['group_name']
			.'<br />'."\n"
			.'<input type="hidden" name="group_list[]" value="'.$group['group_id'].'" />'."\n";
	}
}

echo <<< EOT
	$group_cb<br />
	$cat_hidden<br />
	<input type="submit" value="{$lang_plugin_customhome_config['button_done']}" name="update_config"/>
	</form>
EOT;

echo '</td></tr>'."\n";
endtable();
pagefooter();
ob_end_flush();
?>
