<?php
/**************************************************
  Coppermine Photo Gallery 1.4.10
  *************************************************
  PanoViewer Plugin 1.0
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

if (defined('DISPLAYIMAGE_PHP')){
    $thisplugin->add_filter('file_data','panoviewer_file_data');
}

function panoviewer_file_data($pic_data) {
	global $CONFIG;
	
	$fullsize_url = get_pic_url($pic_data);
	$pos=strrpos($fullsize_url,'.');
	if ($pos===false)
		return $pic_data;
	$ext=substr($fullsize_url,$pos+1);
	if (strcasecmp($ext,'jpg')!=0 && strcasecmp($ext,'jpeg')!=0)
		return $pic_data;

	$xml_url=substr($fullsize_url,0,$pos).'.ivp';
	if (!is_file($xml_url))
		return $pic_data;

	$pw=$CONFIG['picture_width'];
	$ph=intval(($pw*2)/3);

	$pic_data['html']= <<<EOT
	<APPLET archive="plugins/PanoViewer/PurePlayer.jar" code="PurePlayer" width="$pw" height="$ph">
				<param name="panorama" value="$xml_url">
				<param name="optimizememory" value="true">
    </APPLET>
EOT;
    
    return $pic_data;    
}

?>
