/*
 * $RCSfile: $
 *
 * SnapGalaxy4CPG - a plugin for Coppermine gallery to create photo prints, and print product gift items
 * Copyright (C) 2007 SnapGalaxy, Inc. 
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
 
/**
 * @version $Revision: $ $Date: $
 * @package SnapGalaxy4CPG
 * @author Bhavin Suthar <service@snapgalaxy.com> for SnapGalaxy, Inc. http://www.snapgalaxy.com/
 */

// Global javascript variables that we need for processing.
var snapgalaxyVisibleDiv = null;
var snapgalaxyImageCart = null;

/* **************************************************
 * Function to display the image cart
 ***************************************************/
function snapgalaxyOpenViewCart() {
    if(snapgalaxyVisibleDiv != null) {
      document.GetElementById(snapgalaxyVisibleDiv).style.display="none";
    }
    document.getElementById("snapgalaxy-cartview").style.display="block";
    snapgalaxyVisibleDiv="snapgalaxy-cartview";
} 


/* **************************************************
 * Function to display the image cart
 ***************************************************/
function snapgalaxyCloseViewDivs(divId) {
    document.getElementById(divId).style.display="none";
    snapgalaxyVisibleDiv=null;
} 

function snapgalaxyOpenViewImageOnItem() {
    if(snapgalaxyVisibleDiv != null) {
      document.GetElementById(snapgalaxyVisibleDiv).style.display="none";
    }
    document.getElementById("snapgalaxy-itemview").style.display="block";
    snapgalaxyVisibleDiv="snapgalaxy-itemview";
} // end: function snapgalaxyOpenViewItem()

function snapgalaxyProcessImageInCart(thumb,tWidth,tHeight,raw,rWidth,rHeight,status) {
      // Get the XML object.
      var xmlhttp =  xmlHttpRequestObj();

      // Open a post to the inquire_contact.pbp page.
      xmlhttp.open('post',snapgalaxySiteUrl+'plugins/SnapGalaxy4CPG/cart_control.php',true);

      // The callback function
      xmlhttp.onreadystatechange = function() {

          // When the readyState is for we are ready to give the user a response.
          if (xmlhttp.readyState == 4) {

              // if the xml status is 200 then clear the form and change the visible div.
              if (xmlhttp.status == 200) {
                xmldata = xmlhttp.responseXML;
                snapgalaxyPostProcessAddRemoveSequence(xmldata);
                snapgalaxyRebuildCartDisplay();
                if(document.getElementById('snapgalaxy-cartarea').firstChild == document.getElementById('snapgalaxy-cart-clear')){
                    snapgalaxyCloseViewDivs('snapgalaxy-cartview');
                }
              }
          }
      }

      if(status == "+ Cart"){
          queryString = 'thumbnail='+thumb+'&tWidth='+tWidth+'&tHeight='+tHeight+'&rawimage='+raw+'&rWidth='+rWidth+'&rHeight='+rHeight+'&action=Add';
      }else{
          queryString = 'thumbnail='+thumb+'&tWidth='+tWidth+'&tHeight='+tHeight+'&rawimage='+raw+'&rWidth='+rWidth+'&rHeight='+rHeight+'&action=Remove';
      }

      // Prepare the header
      xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

      xmlhttp.send(queryString);

    
} // end: snapgalaxyProcessImageInCart(thumb,tWidth,tHeight,raw,rWidth,rHeight)

function xmlHttpRequestObj(){
  var req = null;
  if (window.XMLHttpRequest) {
    reqObj = new XMLHttpRequest();
  } else if (window.ActiveXObject) {
    reqObj = new ActiveXObject("Microsoft.XMLHTTP");
  }

  return reqObj;
} // end: function xmlHttpRequestObj()

function snapgalaxyPostProcessAddRemoveSequence(responseXML){
    response = responseXML.getElementsByTagName('responsedata');
    if(response[0].getAttribute('success') == "true"){

        var buttonRefs = document.getElementsByName(response[0].getAttribute('processedimage'));

        for(cntr=0; cntr < buttonRefs.length; cntr++){
            if(response[0].getAttribute('action') == "Add" && buttonRefs[cntr].firstChild.data=='+ Cart'){
              buttonRefs[cntr].firstChild.data='- Cart'
            }else if(response[0].getAttribute('action') == "Remove" && buttonRefs[cntr].firstChild.data=='- Cart'){
              buttonRefs[cntr].firstChild.data='+ Cart'
            }else{
            }
        }

        snapgalaxyImageCart = responseXML.getElementsByTagName('imagedata');
        newTotal = snapgalaxyImageCart.length;
        if(newTotal == 0 || newTotal > 1 ){
            document.getElementById("snapgalaxy-cart-total").innerHTML=newTotal+' images';
        }else{
            document.getElementById("snapgalaxy-cart-total").innerHTML=newTotal+' image';
        }
    }
} //end: snapgalaxyPostProcessAddRemoveSequence(responseXML);

function snapgalaxyCheckout(){
    if(!snapgalaxyImageCart || snapgalaxyImageCart.length == 0){
        alert("Unable to checkout.  Your cart is empty.");
    }else{

      // Dynamically build the form so we can submit the data.
      snapgalaxyCheckoutForm = document.createElement('form');
      snapgalaxyCheckoutForm.method="post";
      snapgalaxyCheckoutForm.id="snapgalaxyCheckout";
      snapgalaxyCheckoutForm.action=snapgalaxyPostUrl;
      versionInput = document.createElement('input');
      versionInput.type="hidden";
      versionInput.name="version";
      versionInput.value="100";
      partnerInput = document.createElement('input');
      partnerInput.type="hidden";
      partnerInput.name="partnerid";
      partnerInput.value=snapgalaxyPartnerId;
      commandInput = document.createElement('input');
      commandInput.type="hidden";
      commandInput.name="cmd";
      commandInput.value="add";
      returnInput = document.createElement('input');
      returnInput.type="hidden";
      returnInput.name="returnurl";
      returnInput.value=window.location;
      addMoreInput = document.createElement('input');
      addMoreInput.type="hidden";
      addMoreInput.name="addmoreurl";
      addMoreInput.value=window.location;      
      imageCountInput = document.createElement('input');
      imageCountInput.type="hidden";
      imageCountInput.name="imagecount";
      imageCountInput.value=snapgalaxyImageCart.length;
      snapgalaxyCheckoutForm.appendChild(versionInput);
      snapgalaxyCheckoutForm.appendChild(partnerInput);
      snapgalaxyCheckoutForm.appendChild(commandInput);
      snapgalaxyCheckoutForm.appendChild(returnInput);
      snapgalaxyCheckoutForm.appendChild(addMoreInput);      
      snapgalaxyCheckoutForm.appendChild(imageCountInput);
      for(cntr=0; cntr < snapgalaxyImageCart.length; cntr++){
        thumbImageInput = document.createElement('input');
        thumbImageInput.type="hidden";
        thumbImageInput.name="thumb_" + (cntr + 1);
        thumbImageInput.value=snapgalaxyImageCart[cntr].getAttribute('thumbnail');
        thumbWidthInput = document.createElement('input');
        thumbWidthInput.type="hidden";
        thumbWidthInput.name="thumbwidth_" + (cntr + 1);
        thumbWidthInput.value=snapgalaxyImageCart[cntr].getAttribute('thumbwidth');
        thumbHeightInput = document.createElement('input');
        thumbHeightInput.type="hidden";
        thumbHeightInput.name="thumbheight_" + (cntr + 1);
        thumbHeightInput.value=snapgalaxyImageCart[cntr].getAttribute('thumbheight');
        rawImageInput = document.createElement('input');
        rawImageInput.type="hidden";
        rawImageInput.name="image_" + (cntr + 1);
        rawImageInput.value=snapgalaxyImageCart[cntr].getAttribute('rawimage');
        rawWidthInput = document.createElement('input');
        rawWidthInput.type="hidden";
        rawWidthInput.name="imagewidth_" + (cntr + 1);
        rawWidthInput.value=snapgalaxyImageCart[cntr].getAttribute('rawwidth');
        rawHeightInput = document.createElement('input');
        rawHeightInput.type="hidden";
        rawHeightInput.name="imageheight_" + (cntr + 1);
        rawHeightInput.value=snapgalaxyImageCart[cntr].getAttribute('rawheight');
 /*       rawHeightInput = document.createElement('input');
        rawHeightInput.type="hidden";
        rawHeightInput.name="backtext_"+imgNum;
        rawHeightInput.value=snapgalaxyImageCart[imgNum].getAttribute('rawheight'); */
        snapgalaxyCheckoutForm.appendChild(thumbImageInput);
        snapgalaxyCheckoutForm.appendChild(thumbWidthInput);
        snapgalaxyCheckoutForm.appendChild(thumbHeightInput);
        snapgalaxyCheckoutForm.appendChild(rawImageInput);
        snapgalaxyCheckoutForm.appendChild(rawWidthInput);
        snapgalaxyCheckoutForm.appendChild(rawHeightInput);
      }
      hiddenDiv = document.getElementById("snapgalaxy-hidden-divs");
      hiddenDiv.appendChild(snapgalaxyCheckoutForm);

      var clearhttp =  xmlHttpRequestObj();
      // Open a post to the inquire_contact.pbp page.
      clearhttp.open('post',snapgalaxySiteUrl+'plugins/SnapGalaxy4CPG/cart_control.php?action=clear');
      // The callback function
      clearhttp.onreadystatechange = function() {
          // When the readyState is for we are ready to give the user a response.
          if (clearhttp.readyState == 4) {
              // if the xml status is 200 then clear the form and change the visible div.
              if (clearhttp.status == 200) {
                  document.getElementById("snapgalaxyCheckout").submit();
              }
          }
      }
      clearhttp.send(null);
    }
} // end: function snapgalaxyCheckout()

function snapgalaxyRebuildCartDisplay(){

    cartDiv = document.getElementById('snapgalaxy-cartarea');

    while(cartDiv.hasChildNodes()){
     cartDiv.removeChild(cartDiv.firstChild);
    }

    for(cntr=0; cntr < snapgalaxyImageCart.length; cntr++){ 

      cartDiv.appendChild(snapgalaxyCartItemElement(snapgalaxyImageCart[cntr].getAttribute('thumbnail'),snapgalaxyImageCart[cntr].getAttribute('thumbwidth'),snapgalaxyImageCart[cntr].getAttribute('thumbheight'),snapgalaxyImageCart[cntr].getAttribute('rawimage'),snapgalaxyImageCart[cntr].getAttribute('rawwidth'),snapgalaxyImageCart[cntr].getAttribute('rawheight')));

    }

    // Now that we have the image in the cart we need a clear div
    cleardiv = document.createElement("div");
    cleardiv.style.clear="both";
    cleardiv.id="snapgalaxy-cart-clear";
    cartDiv.appendChild(cleardiv);
} // end function snapgalaxyRebuildCartDisplay(xmldata)

function snapgalaxyCartItemElement(thumb,tWidth,tHeight,raw,rWidth,rHeight){
        tmpImg = document.createElement('img');
        tmpImg.src=thumb; //snapgalaxyImageCart[cntr].getAttribute('thumbnail');
        tmpImg.width=tWidth; // snapgalaxyImageCart[cntr].getAttribute('thumbwidth');
        tmpImg.height=tHeight; //snapgalaxyImageCart[cntr].getAttribute('thumbheight');
        tmpImg.alt="";

        tmpLnk = document.createElement('a');
        tmpLnk.appendChild(document.createTextNode("- Cart"));
        tmpLnk.href="javascript:snapgalaxyProcessImageInCart('"+thumb+"',"+tWidth+","+tHeight+",'"+raw+"',"+rWidth+","+rHeight+",'- Cart')";

        tmpDiv = document.createElement('div');
        tmpDiv.appendChild(tmpImg);
        tmpDiv.appendChild(document.createElement('br'));
        tmpDiv.appendChild(tmpLnk);
        tmpDiv.style.width=tWidth;
        tmpDiv.style.paddingRight="25px";
        tmpDiv.style.paddingBottom="15px";
        tmpDiv.style.cssFloat="left";
        tmpDiv.style.styleFloat="left";

        return tmpDiv;
} // end: function snapgalaxyCartItemElement()

function snapgalaxyInitializeCart(){
    // Get the XML object.
    var xmlhttp =  xmlHttpRequestObj();

    // Open a post to the inquire_contact.pbp page.
    xmlhttp.open('post',snapgalaxySiteUrl+'plugins/SnapGalaxy4CPG/cart_control.php',true);

    // The callback function
    xmlhttp.onreadystatechange = function() {

        // When the readyState is for we are ready to give the user a response.
        if (xmlhttp.readyState == 4) {
            // if the xml status is 200 then clear the form and change the visible div.
            if (xmlhttp.status == 200) {
               snapgalaxyImageCart=xmlhttp.responseXML.getElementsByTagName('imagedata');
               snapgalaxyRebuildCartDisplay();
            }
        }
    }

    // Create the query string.
    queryString = 'action='+"cartlist";

    // Prepare the header
    xmlhttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

    xmlhttp.send(queryString);
} // end: function snapgalaxyCartItemElement(thumb,tWidth,tHeight,raw,rWidth,rHeight)

function snapgalaxyClearLocalCart(){
      var clearhttp =  xmlHttpRequestObj();
      // Open a post to the inquire_contact.pbp page.
      clearhttp.open('post',snapgalaxySiteUrl+'plugins/SnapGalaxy4CPG/cart_control.php?action=clear');
      // The callback function
      clearhttp.onreadystatechange = function() {
          // When the readyState is for we are ready to give the user a response.
          if (clearhttp.readyState == 4) {
              // if the xml status is 200 then clear the form and change the visible div.
              if (clearhttp.status == 200) {
                  return true;
              }else{
                  return false;
              }
          }
      }
      clearhttp.send(null);
} // end: snapgalaxyClearLocalCart();

