<?php
/*************************************************
* Swekey Plugin for Coppermine
* Version 1.0.0 revision 3578, 03/27/09
* (c) Musbe, Inc. 2008-2009 <support@swekey.com>
* *************************************************
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');
// Add an install & configure & uninstall actions
$thisplugin->add_action('plugin_install', 'swekey_install');
$thisplugin->add_action('plugin_configure', 'swekey__configure');
$thisplugin->add_action('plugin_uninstall', 'swekey_uninstall');
// Add a filter for the gallery header
$thisplugin->add_filter('page_html', 'swekey_main');
// Add actions
$thisplugin->add_action('page_start', 'swekey_page_start');

// Install Plugin
function swekey_install()
{
    global $CONFIG, $lang_plugin_swekey;
    require ('plugins/swekey/include/init.inc.php');

    require 'include/sql_parse.php';
    // create table
    $db_schema = 'plugins/swekey/schema.sql';
    $sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
    $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';');

    foreach($sql_query as $q) {
        cpg_db_query($q);
    }

    return true;
}

// Uninstall (ask admin about dropping table)
function swekey_uninstall()
{
/* DO NOT drop the table on uninstall
    global $CONFIG;
    cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PREFIX']}plugin_swekey");
*/
    return true;
}

/**
 * swekey_main()
 * Filter HTML and ADD Capthca image & confirmation
 *
 * @return HTML
 */
function swekey_main($html)
{
    global $CONFIG;
    $script = '';
    
	require_once(dirname(__FILE__).'/include/config.inc.php');
	require_once( dirname(__FILE__).'/include/init.inc.php');
 
    $params = array();      

    if (empty($swekey_promo_url))
	    $params['promo'] = 'coppermine';  
	else
		$params['swekey_promo_url'] = $swekey_promo_url; 

	if (! empty($swekey_brands))
		$params['brands'] = $swekey_brands;

    $params['swekey_url'] = 'plugins/swekey/shared/';

    switch ($_SERVER['PHP_SELF']) 
	{
        case 'login.php':
 		    $params['user_logged'] = false;
		    $params['authframe_url'] = $params['swekey_url'].'authframe.php?use_file=1';
		    if (! empty($swekey_check_server))
				$params['authframe_url'] .='&check_server='.urlencode($swekey_check_server);
		    if (! empty($swekey_rndtoken_server))
				$params['authframe_url'] .='&rndtoken_server='.urlencode($swekey_rndtoken_server);
		    $params['loginname_path'] = '["username"]';
		    $params['loginname_resolve_url'] = 'index.php?swekey_ajax=resolve&swekey_id=$swekey_id';
		    $params['image_xoffset'] = '1px';
		    $params['image_yoffset'] = '-2px';
		    $params['loginname_width_offset'] = 24;
		
		    // localized strings
		    $params['str_unplugged'] = $lang_plugin_swekey['SWEKEY_NOT_PLUGGED'];
		    $params['str_plugged'] = $lang_plugin_swekey['SWEKEY_PLUGGED'] ;
        	break;

        case 'profile.php':
        	if (USER_ID)
			{
     			$results = cpg_db_query("SELECT swekey_id FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE user_id = '".USER_ID."'");
    			if (mysql_num_rows($results)) 
				{
					$USER_DATA = mysql_fetch_array($results);
					$swekey_id = $USER_DATA['swekey_id'];
					$script = 
						'<script type="text/javascript" src="plugins/swekey/js/profile.js"></script>'.
						'<script type="text/javascript">'.
						'var swekey_btn_text = "'.$lang_plugin_swekey['SWEKEY_DETACH'].'";'.
						'var swekey_success_text = "'.$lang_plugin_swekey['SWEKEY_DETACHED'].'";'.
						'var swekey_failed_text = "'.$lang_plugin_swekey['SWEKEY_DETACHED_FAILED'].'";'.
						'swekey_customize_profile_page("'.$swekey_id.'");'.
						'</script>';
				}
			}
        	break;

		default: 
			if (USER_ID)
			{
				$params['user_logged'] = true;
     			$results = cpg_db_query("SELECT swekey_id FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE user_id = '".USER_ID."'");
    			if (mysql_num_rows($results)) 
				{
					$USER_DATA = mysql_fetch_array($results);
					$params['user_swekey_id'] = $USER_DATA['swekey_id'];
 					$params['logout_url'] = 'logout.php';
				}
					
				$params['attach_url'] = 'index.php?swekey_ajax=attach&swekey_id=$swekey_id&user_id='.USER_ID;
				// localized strings
				$params['str_attach_ask'] = $lang_plugin_swekey['SWEKEY_DETECTED'];
				$params['str_attach_success'] = $lang_plugin_swekey['SWEKEY_ATTACHED'] ;
				$params['str_attach_failed'] = $lang_plugin_swekey['SWEKEY_ATTACH_FAILED'];
			}
			else
			{
				$params['user_logged'] = false;
			}
			break;
    } // switch

	if (empty($script))
	{
	    include_once('shared/swekey_integrate.inc.php');
   		$script = Swekey_GetIntegrationScript($params);
   	}
   	
    $exper = '(</html>)';
    if (preg_match($exper, $html)) 
	{
        $html = preg_replace($exper, '</html>'.$script, $html);
    }

    return $html;
}

/**
 * swekey_page_start()
 * check/validate that the swekey is plugged when we log in
 *
 * @return
 */
function swekey_page_start()
{   
	global $CONFIG;

	// Ajax Calls
    if (! empty($_GET['swekey_ajax']))
    {
    	switch ($_GET['swekey_ajax'])
    	{
    		case 'resolve' :
     			$results = cpg_db_query("SELECT user_id FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE swekey_id = '".$_GET['swekey_id']."'");
    			if (mysql_num_rows($results)) 
				{
					$USER_DATA = mysql_fetch_array($results);
     				$results = cpg_db_query("SELECT user_name " . "FROM {$CONFIG['TABLE_USERS']} " . "WHERE user_id = '" . $USER_DATA['user_id'] . "'");
	    			if (mysql_num_rows($results)) 
					{
						$USER_DATA = mysql_fetch_array($results);
						echo $USER_DATA['user_name'];
					}
				}
		    	exit;

    		case 'attach' :
    			if (USER_ID != $_GET['user_id'])
    				return 'ERROR '.USER_ID.'->'.$_GET['user_id'];
    				
    		    cpg_db_query("DELETE FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE (user_id = '".USER_ID."') LIMIT 1");
    			cpg_db_query("INSERT INTO {$CONFIG['TABLE_PREFIX']}plugin_swekey (user_id,swekey_id) VALUES ('".USER_ID."','".$_GET['swekey_id']."')");
		    	echo 'OK';

    		case 'detach' :
    			if (USER_ID)
				{    				
    		    	cpg_db_query("DELETE FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE (user_id = '".USER_ID."') LIMIT 1");
		    		echo 'OK';
		    	}
    	}

    	echo 'ERROR invaid command:'.$_GET['swekey_ajax'];
    	exit;
    }
    
    if ($_SERVER['PHP_SELF'] == 'login.php' && ! empty($_POST['username']))
    {
    	$user_id = get_userid($_POST['username']);
    	if (! empty($user_id))
    	{
		    global $CONFIG;
    		$results = cpg_db_query("SELECT swekey_id FROM {$CONFIG['TABLE_PREFIX']}plugin_swekey WHERE user_id = '".$user_id."'");
    		if (mysql_num_rows($results)) 
			{
				$USER_DATA = mysql_fetch_array($results);
				$swekey_id = $USER_DATA['swekey_id'];
				if (ereg('[0-9A-F]{32}', $swekey_id))	
				{	
					global $gSwekeyStatusServer;
					$gSwekeyStatusServer = $swekey_status_server;
					include_once('shared/authframeres.inc.php');
    				if (! IsSwekeyAuthenticated($swekey_id, $swekey_allow_disabled))
    				{
						// make sure login will fail
				     	$_POST['username'] = 'swekey_is_not_plugged';	
						
						// Change the error message
						require_once( dirname(__FILE__).'/include/init.inc.php');
				    	global $lang_login_php;
				    	$short_id = substr($swekey_id, 0, 1).'..'.substr($swekey_id, 29);
				    	$lang_login_php['err_login'] = sprintf($lang_plugin_swekey['SWEKEY_REQUIRED'], $short_id);
    				}
				}	
			}
    	}
    }
}


?>