<?php
/**
 * Coppermine Photo Gallery
 * Coppermine version: 1.5.xx
 *
 * iScroll ver 2.1
 *
 * Based on mod. by rphMedia  http://forum.coppermine-gallery.net/index.php?action=profile;u=9702
 * Plugin Written by Joe Carver - http://gallery.josephcarver.com/natural/ - http://i-imagine.net/artists/
 * 16 June 2010
*/

	require_once('./plugins/iscroll/init.inc.php');

	if (!GALLERY_ADMIN_MODE) {
		cpg_die(ERROR, $lang_errors['perm_denied'], __FILE__, __LINE__);
	}
	
	if (in_array('plugins/iscroll/js/config.js', $JS['includes']) != TRUE) {
		$JS['includes'][] = 'plugins/iscroll/js/admin.js';
	}	
	
	if (in_array('js/jquery.spinbutton.js', $JS['includes']) != TRUE) {
	$JS['includes'][] = 'js/jquery.spinbutton.js';
	}
	pageheader(sprintf($iscroll_lang['configure_plugin_x'], $iscroll_lang['display_name']));
	
    global $lang_plugin_php, $CONFIG, $lang_common, $lang_pluginmgr_php, $lang_admin_php, $icon_array;

	list($timestamp, $form_token) = getFormToken();

	// get sanitized POST parameters
		if ($superCage->post->keyExists('submit')) {
		//Check if the form token is valid
		if(!checkFormToken()){
			cpg_die(ERROR, $lang_errors['invalid_form_token'], __FILE__, __LINE__);
		}
	
  // Define the sanitization patterns
  $sanitization_array = array(
  
      'iscroll_cfg_meta' => array('type' => 'int', 'min' => '1', 'max' => '4'),
      'iscroll_cfg_cpg_table' => array('type' => 'checkbox', 'min' => '0', 'max' => '1'),	  
      'iscroll_cfg_width' => array('type' => 'int', 'min' => '300', 'max' => '1400'),
      'iscroll_cfg_height' => array('type' => 'int', 'min' => '100', 'max' => '400'),
      'iscroll_cfg_count' => array('type' => 'int', 'min' => '5', 'max' => '60'),
      'main_page_layout' => array('type' => 'array', 'regex_ok' => '/^[a-z]+$/', 'delimiter' => '/'),	  
      'iscroll_cfg_swf' => array('type' => 'int', 'min' => '0', 'max' => '2'),	 	  
      'iscroll_cfg_home' => array('type' => 'int', 'min' => '0', 'max' => '2'),
      'iscroll_cfg_div' => array('type' => 'int', 'min' => '60', 'max' => '600'),	  
  );
  $config_changes_counter = 0;
  foreach ($sanitization_array as $san_key => $san_value) {
      if (isset($CONFIG[$san_key]) == TRUE) { // only loop if config value is set --- start
          if ($san_value['type'] == 'checkbox') { // type is checkbox --- start
            if ($superCage->post->getInt($san_key) == $san_value['max'] && $CONFIG[$san_key] != $san_value['max']) {
                $CONFIG[$san_key] = $san_value['max'];
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                $config_changes_counter++;
            } elseif($superCage->post->getInt($san_key) == $san_value['min'] && $CONFIG[$san_key] != $san_value['min']) {
                $CONFIG[$san_key] = $san_value['min'];
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                $config_changes_counter++;
            } elseif($superCage->post->keyExists($san_key) != TRUE && $CONFIG[$san_key] != '0') {
                $CONFIG[$san_key] = 0;
                cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                $config_changes_counter++;
            }
          } // type is checkbox --- end
          if ($san_value['type'] == 'int') { // type is integer --- start
              if ($superCage->post->getInt($san_key) <= $san_value['max'] && $superCage->post->getInt($san_key) >= $san_value['min'] && $superCage->post->getInt($san_key) != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $superCage->post->getInt($san_key);
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is integer --- end	
	          if ($san_value['type'] == 'array') { // type is array --- start              
          $evaluate_value = $superCage->post->getRaw($san_key);
              //print_r($superCage->post->getRaw($san_key));
              if (is_array($evaluate_value) && isset($san_value['regex_ok']) == TRUE && isset($san_value['delimiter']) == TRUE) {
                  $temp = '';
                  for ($i = 0; $i <= count($evaluate_value); $i++) {
                      if (preg_match($san_value['regex_ok'], $evaluate_value[$i])) {
                          $temp .= $evaluate_value[$i] . $san_value['delimiter'];
                      }
                  }
                  unset($evaluate_value);
                  $evaluate_value = rtrim($temp, $san_value['delimiter']);
                  unset($temp);
              }
              if ($evaluate_value != $CONFIG[$san_key]) {
                  $CONFIG[$san_key] = $evaluate_value;
                  cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value='{$CONFIG[$san_key]}' WHERE name='$san_key'");
                  $config_changes_counter++;
              }
          } // type is array --- end
      } // only loop if config value is set --- end
  }
}	
	
// +++++++++++++++++++++++	
	// vars from db and for form
	$show_met = ($CONFIG['iscroll_cfg_meta']);
	$show_wid = ($CONFIG['iscroll_cfg_width']);
	$show_hei = ($CONFIG['iscroll_cfg_height']);
	$show_num = ($CONFIG['iscroll_cfg_count']);	
	$show_swf = ($CONFIG['iscroll_cfg_swf']);
	$show_home = ($CONFIG['iscroll_cfg_home']);	
	
			$chk_radlast = '';
		   if ($show_met  == '1') {
	   		$chk_radlast = 'selected="selected"';
	}
			$chk_radhit = '';
		   if ($show_met  == '2') {
	   		$chk_radhit = 'selected="selected"';
	}
			$chk_radrate = '';	
		   if ($show_met  == '3') {
	   		$chk_radrate = 'selected="selected"';
	}
			$chk_radran = '';	
			if ($show_met  == '4') {
	   		$chk_radran = 'selected="selected"';
	}
			$chk_swfa = '';	
			if ($show_swf  == '1') {
	   		$chk_swfa = 'selected="selected"';
	}
			$chk_swfb = '';	
			if ($show_swf  == '2') {
	   		$chk_swfb = 'selected="selected"';
	}
			$chk_home = '';
			if ($show_home  == '1') {
	   		$chk_home = 'selected="selected"';
	}
			$chk_homeb = '';	
			if ($show_home  == '2') {
	   		$chk_homeb = 'selected="selected"';
	}		
	
	if ($CONFIG['iscroll_cfg_cpg_table'] == '1') {
		$option_output['iscroll_cfg_cpg_table'] = 'checked="checked"';
	} else { 
		$option_output['iscroll_cfg_cpg_table'] = '';
	}			
			
// +++++++++++++++++++
	// start form
	$superCage = Inspekt::makeSuperCage();
	echo <<< EOT
	<form name="cpgform" id="cpgform" action="{$_SERVER['REQUEST_URI']}" method="post">
EOT;
	
	starttable('100%',  sprintf($iscroll_lang['configure_plugin_x'], $iscroll_lang['display_name']), 2, 'cpg_zebra');	
	
	// reply with success to changes or no changes made
	if ($superCage->post->keyExists('submit')) {
    echo <<< EOT
	<tr>
		<td class="tableh2" colspan="2">
EOT;
    if ($config_changes_counter > 0) {
        msg_box('', $iscroll_lang['update_success'], '', '', 'success');
    } else {
        msg_box('', $iscroll_lang['no_changes'], '', '', 'validation');
    }
echo <<< EOT
		</td>
	</tr>
EOT;
}

	// complete form
echo <<< EOT
			<tr>
			<td><br><b>{$iscroll_lang['page_head']}</b></td>
			</tr>
			<tr>
			<td></td>
			</tr>
			<tr>
			<td> 
			<hr> {$iscroll_lang['update_meta']} <a href="plugins/iscroll/docs/{$documentation_file}.htm#set_meta" class="greybox" title="{{$iscroll_lang['update_meta']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
			</td>
			<td>
			<br />
			<select name="iscroll_cfg_meta" id="iscroll_cfg_meta">
                 <option value="1" $chk_radlast>{$iscroll_lang['last_up']}</option>
                 <option value="2" $chk_radhit>{$iscroll_lang['most_view']}</option>
                 <option value="3" $chk_radrate>{$iscroll_lang['last_comm']}</option>
				 <option value="4" $chk_radran>{$iscroll_lang['random']}</option>
            </select>
			</td>
			</tr> 
			<tr>
			<td>
			<hr> {$iscroll_lang['update_size']}<a href="plugins/iscroll/docs/{$documentation_file}.htm#set_size" class="greybox" title="{{$iscroll_lang['update_size']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
			</td>
			</tr> 
			<tr>
			<td class="tableb" align="right">{$iscroll_lang['update_width_table']}</td>
            <td>
            <input type="checkbox" name="iscroll_cfg_cpg_table" id="iscroll_cfg_cpg_table" class="checkbox" value="1" {$option_output['iscroll_cfg_cpg_table']} />
            <label for="recapt_caption" class="clickable_option">{$lang_common['yes']}</label>
            </td>
            </tr>
			<tr>		
			<td class="tableb" align="right">{$iscroll_lang['update_width']}</td>
            <td>
            <input type="text" name="iscroll_cfg_width" id="iscroll_cfg_width" class="textinput" size="3" value="$show_wid" />{$iscroll_lang['update_pixels']}
            </td>
            </tr>
            <tr>
            <td class="tableb" align="right">{$iscroll_lang['update_height']}</td>
            <td>
            <input type="text" name="iscroll_cfg_height" id="iscroll_cfg_height" class="textinput" size="3" value="$show_hei" />{$iscroll_lang['update_pixels']}
            </td>

            </tr>
            <tr>
            <td class="tableb" align="right">{$iscroll_lang['update_div']}</td>
            <td>
            <input type="text" name="iscroll_cfg_div" id="iscroll_cfg_div" class="textinput" size="3" value="{$CONFIG['iscroll_cfg_div']}" />{$iscroll_lang['update_pixels']}
            </td>
            </tr>
			<tr>
			<td> <hr> {$iscroll_lang['update_count']}<a href="plugins/iscroll/docs/{$documentation_file}.htm#set_count" class="greybox" title="{$iscroll_lang['update_count']}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
			</td>
			</tr> 
			<tr>
			<td class="tableb" align="right">{$iscroll_lang['update_desc_count']}
            </td>
            <td>
            <input type="text" name="iscroll_cfg_count" id="iscroll_cfg_count" class="textinput" size="2" value="$show_num" />{$iscroll_lang['update_thumbs']}
            </td>
            </tr>	
			<tr>
			<td class="tableb" align="right"><br /></td>
            </tr>
            <tr>
            <td class="tableb">
			<hr>
			{$iscroll_lang['update_location']}<a href="plugins/iscroll/docs/{$documentation_file}.htm#set_loc" class="greybox" title="{{$iscroll_lang['update_location']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
            </td>
            <td>
			<br />
            <input type="text" size="50" maxlength="250" class="textinput" style="width:90%" name="main_page_layout" id="main_page_layout"  value="{$CONFIG['main_page_layout']}" />
            </td>
			</tr>
			<tr>
			<td class="tableb"> <hr>{$iscroll_lang['update_swf']}<a href="plugins/iscroll/docs/{$documentation_file}.htm#set_swf" class="greybox" title="{{$iscroll_lang['update_swf']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
			</td>
			<td>
			<br />
         	<select name="iscroll_cfg_swf" id="iscroll_cfg_swf">
            <option value="1" $chk_swfa>{$iscroll_lang['update_seventeen']}</option>
            <option value="2" $chk_swfb>{$iscroll_lang['update_five']}</option>
            </select> 			
			</td>
			</tr>
			<tr>
			<td class="tableb"> <hr> {$iscroll_lang['update_index']}<a href="plugins/iscroll/docs/{$documentation_file}.htm#set_index" class="greybox" title="{{$iscroll_lang['update_index']}}"><img src="images/help.gif" width="13" height="11" border="0" alt="" /></a>
			</td>
			<td>
			<br />
         	<select name="iscroll_cfg_home" id="iscroll_cfg_home">
            <option value="1" $chk_home>{$iscroll_lang['update_all']}</option>
            <option value="2" $chk_homeb>{$iscroll_lang['update_home']}</option>
            </select> 			
			</td>
			</tr>
			<tr>			
	       <td class="tableb" align="right"><br /><br />
			<span>
			<input type="hidden" name="form_token" value="{$form_token}" />
    		<input type="hidden" name="timestamp" value="{$timestamp}" />
			<input type="submit" name="submit" value="{$iscroll_lang['submit_change']}" /> 
		</span>
		</td>
		</tr>
		</td>		
EOT;

	endtable();
	echo <<< EOT
	</form>
EOT;

	pagefooter();
	ob_end_flush();

?>