/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Color;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JTextArea;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadTextArea
extends JTextArea {
    private static int DURATION_BETWEEN_TWO_LOOPS = 100;
    public static final int MAX_LOG_WINDOW_LENGTH = 800000;
    UploadPolicy uploadPolicy;
    Queue<String> messages = null;
    private static final long serialVersionUID = -6037767344615468632L;
    LogMessageThread logMessageThread = null;

    public JUploadTextArea(int rows, int columns, UploadPolicy uploadPolicy) {
        super(rows, columns);
        this.uploadPolicy = uploadPolicy;
        this.setBackground(new Color(255, 255, 203));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.messages = new ConcurrentLinkedQueue<String>();
        this.logMessageThread = new LogMessageThread(this.messages, this);
        this.logMessageThread.start();
    }

    public final void displayMsg(String str) {
        this.messages.add(str);
    }

    protected void finalize() {
        this.logMessageThread.interrupt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LogMessageThread
    extends Thread {
        private Queue<String> messages;
        private JUploadTextArea textArea;

        LogMessageThread(Queue<String> messages, JUploadTextArea textArea) {
            this.messages = messages;
            this.textArea = textArea;
        }

        @Override
        public void run() {
            boolean someTextHasBeenAdded = false;
            String nextMessage = null;
            StringBuffer sbLogContent = new StringBuffer(this.textArea.getText());
            String newLogContent = null;
            try {
                while (!this.isInterrupted()) {
                    while ((nextMessage = this.messages.poll()) != null) {
                        someTextHasBeenAdded = true;
                        sbLogContent.append(nextMessage);
                    }
                    if (someTextHasBeenAdded) {
                        newLogContent = sbLogContent.toString();
                        int len = newLogContent.length();
                        if (len > 800000) {
                            newLogContent = newLogContent.substring(len - 800000);
                            len = 800000;
                        }
                        this.textArea.setText(newLogContent);
                        if (len > 0) {
                            this.textArea.setCaretPosition(len - 1);
                        }
                    }
                    LogMessageThread.sleep(DURATION_BETWEEN_TWO_LOOPS);
                }
            }
            catch (InterruptedException ie) {
                this.textArea.uploadPolicy.displayDebug("sleep interrupted", 101);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

