<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://etienne.sf.free.fr/wiki/doku.php?id=jupload_coppermine_download_gb
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

/*
 * This include is meant to add additional functions, for script that need to manage pictures.
 * 
 * It is based on the folowing facts:
 * 1) A lot of scripts have specific internal functions to manage the incoming file. 
 *   At least these scripts: db_input, upload, jupload, addpic, xp_publish.
 * 2) Each are slightly different, which means: it's not possible to directly reuse them in another script
 * 3) As these scripts also do input (mix between code that produce output and code that should be included), it's
 *   not possible to include them in another one to reuse code.
 * 4) If a bug exists (especially if it involve security), it's possible that several correction have to be done.
 * 5) Changing anything in the picture management system may become difficult, because many functions can have to be
 * modified.
 * 
 * 
 * This j_picmgmt.inc.php script contains two _new_ functions, taken from picmgmt.inc.php:
 * a) jupload_add_picture. Used in all other script.
 *   It contains :
 *    - Filetype checks. The xp_publish script also tests this. But, for sure, there must be differences between
 *     these two scripts. 
 *    - Quota management: to insure that the user respects his quota.
 *    - Big, thumb and normal picture calculation (by calls to jupload_resize_image)
 *    - Insert into the database  
 *   But, as I understand it, it lacks :
 *    - Right management. This function assumes that the caller checks if the current user may upload into this
 *     album.
 *    - Moving file to the right directory
 *    - Characters filename control. It also assumes that the file contains only valid characters. For instance, 
 *     filename containing '/', '\' or '.' characters should be carefully managed (also done in xp_publish). Also, 
 *     from
 *     my test, coppermine seems to badly managed spaces, and non-ascii characters (like accents).
 *   
 * b) jupload_resize_image. No trouble: it allows construction of target file, thumn and normal pictures, of the good size, 
 * according to the current gallery configuration. This function should only be called by the add_picture function.
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}


logDebug("Using Coppermine 1.5 add_picture() and resize_image() functions.");

require_once("include/picmgmt.inc.php");



// Add a picture to an album
//
// For cpg 1.4, there was a need to create clone of add_picture and resize_picture. It's now useless: good !
//
// Let's use the up-to-date code.
// 
function jupload_add_picture($aid, $filepath, $filename, $position = 0, $title = '', $caption = '', $keywords = '', $user1 = '', $user2 = '', $user3 = '', $user4 = '', $category = 0, $raw_ip = '', $hdr_ip = '', $iwidth = 0, $iheight = 0)
{
	//Let's read the given parameters.	
	$title = addslashes(getSuperCageString('title'));
	$caption = addslashes(getSuperCageString('caption'));
	$keywords = addslashes(getSuperCageString('keywords'));
	$user1 = addslashes(getSuperCageString('user1'));
	$user2 = addslashes(getSuperCageString('user2'));
	$user3 = addslashes(getSuperCageString('user3'));
	$user4 = addslashes(getSuperCageString('user4'));
	// Capture movie or audio width and height if sent.
	$movie_wd = getSuperCageInt('movie_wd', 320);
	$movie_ht = getSuperCageInt('movie_ht', 240);
	
	logDebug("[jupload_add_picture] Calling CPG add_picture('$aid', '$filepath', '$filename', $position, $title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $iwidth, $iheight)");
	return add_picture($aid, $filepath, $filename, $position, $title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $iwidth, $iheight);
}

