<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2007-2008 Florian Staudacher <florian_staudacher(at)yahoo(dot)de>
  originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.4.18
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.4.x/themes/water_drop/theme.php $
  $Revision: 4380 $
  $Author: gaugau $
  $Date: 2008-04-12 12:00:19 +0200 (Sa, 12 Apr 2008) $
**********************************************/

/**
 * unfortunately this theme requires 4 colums for album and thumbnail view
 */
$CONFIG['album_list_cols'] = 4;
$CONFIG['thumbcols'] = 4;

define('THEME_IS_XHTML10_TRANSITIONAL',1); // Remove this if you edit this template until
                                           // you have validated it. See docs/theme.htm.

// HTML template for template sys_menu spacer
//$template_sys_menu_spacer ='<img src="themes/water_drop/images/orange_carret.gif" width="8" height="8" border="0" alt="" />';
$template_sys_menu_spacer ='';
$template_thumb_view_title_row = '';

function theme_display_cat_list($breadcrumb, &$cat_data, $statistics)
{
    global $template_cat_list, $lang_cat_list, $lang_gallery_admin_menu;
    if (count($cat_data) > 0) {
        starttable('100%');
        $template = template_extract_block($template_cat_list, 'header');
        $params = array('{CATEGORY}' => $lang_gallery_admin_menu['categories_lnk'], //$lang_cat_list['category'], - need plural
            '{ALBUMS}' => $lang_cat_list['albums'],
            '{PICTURES}' => $lang_cat_list['pictures'],
            );
        echo template_eval($template, $params);
    }

    $template_noabl = template_extract_block($template_cat_list, 'catrow_noalb');
    $template = template_extract_block($template_cat_list, 'catrow');
    foreach($cat_data as $category) {
    	if (!isset($category['cat_thumb'])) {
    		$category['cat_thumb'] = ''; 
    	}
    	else {
    		if (strstr($category['cat_thumb'], "img")) {
    			$array = explode("<td>", $category['cat_thumb']);
    			$num = ((round(count($array)/2))*15)-15;
    			$category['cat_thumb'] = "margin-left: ".$num."px;";
    		}
    	}
        if (count($category) == 3) {
            $params = array('{CAT_TITLE}' => $category[0],
                    '{CAT_THUMB}' => $category['cat_thumb'],
		    '{CAT_DESC}' => $category[1],
		    '{ALBUMS}' => $lang_cat_list['albums'],
		    '{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template_noabl, $params);
        } elseif (isset($category['cat_albums']) && ($category['cat_albums'] != '')) {
            $params = array('{CAT_TITLE}' => $category[0],
                '{CAT_THUMB}' => $category['cat_thumb'],
                '{CAT_DESC}' => $category[1],
                '{CAT_ALBUMS}' => $category['cat_albums'],
                '{ALB_COUNT}' => $category[2],
                '{PIC_COUNT}' => $category[3],
		'{ALBUMS}' => $lang_cat_list['albums'],
		'{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template, $params);
        } else {
            $params = array('{CAT_TITLE}' => $category[0],
                '{CAT_THUMB}' => $category['cat_thumb'],
                '{CAT_DESC}' => $category[1],
                '{CAT_ALBUMS}' => '',
                '{ALB_COUNT}' => $category[2],
                '{PIC_COUNT}' => $category[3],
		'{ALBUMS}' => $lang_cat_list['albums'],
		'{PICTURES}' => $lang_cat_list['pictures'],
                );
            echo template_eval($template, $params);
        }
    }

    if ($statistics && count($cat_data) > 0) {
        $template = template_extract_block($template_cat_list, 'footer');
        $params = array('{STATISTICS}' => $statistics);
        echo template_eval($template, $params);
    }


    if (count($cat_data) > 0)
          endtable();
        echo template_extract_block($template_cat_list, 'spacer');
}
function theme_display_album_list(&$alb_list, $nbAlb, $cat, $page, $total_pages)
{

    global $CONFIG, $STATS_IN_ALB_LIST, $statistics, $template_tab_display, $template_album_list, $lang_album_list;

    $theme_alb_list_tab_tmpl = $template_tab_display;

    $theme_alb_list_tab_tmpl['left_text'] = strtr($theme_alb_list_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_album_list['album_on_page']));
    $theme_alb_list_tab_tmpl['inactive_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    $theme_alb_list_tab_tmpl['inactive_next_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_next_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    $theme_alb_list_tab_tmpl['inactive_prev_tab'] = strtr($theme_alb_list_tab_tmpl['inactive_prev_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));

    $tabs = create_tabs($nbAlb, $page, $total_pages, $theme_alb_list_tab_tmpl);

    $album_cell = template_extract_block($template_album_list, 'album_cell');
    $empty_cell = template_extract_block($template_album_list, 'empty_cell');
    $tabs_row = template_extract_block($template_album_list, 'tabs');
    $stat_row = template_extract_block($template_album_list, 'stat_row');
    $spacer = template_extract_block($template_album_list, 'spacer');
    $header = template_extract_block($template_album_list, 'header');
    $footer = template_extract_block($template_album_list, 'footer');
    $rows_separator = template_extract_block($template_album_list, 'row_separator');

    $count = 0;

    $columns = $CONFIG['album_list_cols'];
    $column_width = ceil(100 / $columns);
    $thumb_cell_width = $CONFIG['alb_list_thumb_size'] + 2;

    starttable('100%');

    if ($STATS_IN_ALB_LIST) {
        $params = array('{STATISTICS}' => $statistics,
            '{COLUMNS}' => $columns,
            );
        echo template_eval($stat_row, $params);
    }

    echo $header;

    if (is_array($alb_list)) {
        foreach($alb_list as $album) {
            $count ++;

            $params = array('{COL_WIDTH}' => $column_width-1.5,
                '{ALBUM_TITLE}' => $album['album_title'],
                '{THUMB_CELL_WIDTH}' => $thumb_cell_width,
                '{ALB_LINK_TGT}' => "thumbnails.php?album={$album['aid']}",
                '{ALB_LINK_PIC}' => $album['thumb_pic'],
                '{ADMIN_MENU}' => $album['album_adm_menu'],
                '{ALB_DESC}' => $album['album_desc'],
                '{ALB_INFOS}' => $album['album_info'],
                );

            echo template_eval($album_cell, $params);

            if ($count % $columns == 0 && $count < count($alb_list)) {
                echo $rows_separator;
            }
        }
    }

    $params = array('{COL_WIDTH}' => $column_width,
          '{SPACER}' => $thumb_cell_width
          );
    $empty_cell = template_eval($empty_cell, $params);

    while ($count++ % $columns != 0) {
        echo $empty_cell;
    }

    echo $footer;
    // Tab display
    $params = array('{COLUMNS}' => $columns,
        '{TABS}' => $tabs,
        );
    echo template_eval($tabs_row, $params);

    endtable();

    echo $spacer;
}
function theme_display_thumbnails(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $page, $total_pages, $sort_options, $display_tabs, $mode = 'thumb')
{
    global $CONFIG;
    global $template_thumb_view_title_row,$template_fav_thumb_view_title_row, $lang_thumb_view, $template_tab_display, $template_thumbnail_view, $lang_album_list;

    static $header = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $row_separator = '';
    static $footer = '';
    static $tabs = '';
    static $spacer = '';

    if ($header == '') {
        $thumb_cell = template_extract_block($template_thumbnail_view, 'thumb_cell');
        $tabs = template_extract_block($template_thumbnail_view, 'tabs');
        $header = template_extract_block($template_thumbnail_view, 'header');
        $empty_cell = template_extract_block($template_thumbnail_view, 'empty_cell');
        $row_separator = template_extract_block($template_thumbnail_view, 'row_separator');
        $footer = template_extract_block($template_thumbnail_view, 'footer');
        $spacer = template_extract_block($template_thumbnail_view, 'spacer');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $uid_link = (isset($_GET['uid']) && is_numeric($_GET['uid'])) ? '&amp;uid=' . $_GET['uid'] : '';

    $theme_thumb_tab_tmpl = $template_tab_display;

    if ($mode == 'thumb') {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $aid == 'lastalb' ? $lang_album_list['album_on_page'] : $lang_thumb_view['pic_on_page']));
        $theme_thumb_tab_tmpl['inactive_tab'] = strtr($theme_thumb_tab_tmpl['inactive_tab'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $uid_link . '&amp;page=%d'));
        $theme_thumb_tab_tmpl['inactive_next_tab'] = strtr($theme_thumb_tab_tmpl['inactive_next_tab'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $uid_link . '&amp;page=%d'));
        $theme_thumb_tab_tmpl['inactive_prev_tab'] = strtr($theme_thumb_tab_tmpl['inactive_prev_tab'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $uid_link . '&amp;page=%d'));
    } else {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_thumb_view['user_on_page']));
        $theme_thumb_tab_tmpl['inactive_tab'] = strtr($theme_thumb_tab_tmpl['inactive_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
        $theme_thumb_tab_tmpl['inactive_next_tab'] = strtr($theme_thumb_tab_tmpl['inactive_next_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
        $theme_thumb_tab_tmpl['inactive_prev_tab'] = strtr($theme_thumb_tab_tmpl['inactive_prev_tab'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    }

	$thumbcols = $CONFIG['thumbcols'];
	$cell_width = ceil(100 / $CONFIG['thumbcols']) . '%';

    $tabs_html = $display_tabs ? create_tabs($nbThumb, $page, $total_pages, $theme_thumb_tab_tmpl) : '';
    // The sort order options are not available for meta albums
    if ($sort_options) {
        $param = array('{ALBUM_NAME}' => $album_name,
            '{AID}' => $aid,
            '{PAGE}' => $page,
            '{NAME}' => $lang_thumb_view['name'],
            '{TITLE}' => $lang_thumb_view['title'],
            '{DATE}' => $lang_thumb_view['date'],
            '{SORT_TA}' => $lang_thumb_view['sort_ta'],
            '{SORT_TD}' => $lang_thumb_view['sort_td'],
            '{SORT_NA}' => $lang_thumb_view['sort_na'],
            '{SORT_ND}' => $lang_thumb_view['sort_nd'],
            '{SORT_DA}' => $lang_thumb_view['sort_da'],
            '{SORT_DD}' => $lang_thumb_view['sort_dd'],
            '{POSITION}' => $lang_thumb_view['position'],
            '{SORT_PA}' => $lang_thumb_view['sort_pa'],
            '{SORT_PD}' => $lang_thumb_view['sort_pd'],
            );
        $title = template_eval($template_thumb_view_title_row, $param);
    } else if ($aid == 'favpics' && $CONFIG['enable_zipdownload'] == 1) { //Lots of stuff can be added here later
       $param = array('{ALBUM_NAME}' => $album_name,
                             '{DOWNLOAD_ZIP}'=>$lang_thumb_view['download_zip']
                               );
       $title = template_eval($template_fav_thumb_view_title_row, $param);
    }else{
        $title = $album_name;
    }


    if ($mode == 'thumb') {
        starttable('100%', $title, $thumbcols);
    } else {
        starttable('100%');
    }

    echo $header;

    $i = 0;
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            if ($aid == 'lastalb') {
                $params = array('{CELL_WIDTH}' => $cell_width-2,
                    '{LINK_TGT}' => "thumbnails.php?album={$thumb['aid']}",
                    '{THUMB}' => $thumb['image'],
                    '{CAPTION}' => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu']
                    );
            } else {
                $params = array('{CELL_WIDTH}' => $cell_width-2,
                    '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&amp;pos={$thumb['pos']}$uid_link",
                    '{THUMB}' => $thumb['image'],
                    '{CAPTION}' => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu']
                    );
            }
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width-2,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => $thumb['caption'],
                '{ADMIN_MENU}' => ''
                );
        }
        echo template_eval($thumb_cell, $params);

        if ((($i % $thumbcols) == 0) && ($i < count($thumb_list))) {
            echo $row_separator;
        }
    }
    for (;($i % $thumbcols); $i++) {
        echo $empty_cell;
    }
    echo $footer;

    if ($display_tabs) {
        $params = array('{THUMB_COLS}' => $thumbcols,
            '{TABS}' => $tabs_html
            );
        echo template_eval($tabs, $params);
    }

    endtable();
    echo $spacer;
}
function theme_html_picinfo(&$info)
{
	global $lang_picinfo;
	
	$html = '';
	
	$html .= '        <div class="img_description" align="center"><div><b>'.$lang_picinfo['title'].'</b></div>'."\n";
	$template = '        <div class="img_info">%s: <span class="img_info_val">%s</span></div>'."\n";
	foreach ($info as $key => $value) $html .= sprintf($template, $key, $value);
	$html .= '</div>';
	return $html;
}
// Function for writing a pageheader
function pageheader($section, $meta = '')
{
    global $CONFIG, $THEME_DIR;
    global $template_header, $lang_charset, $lang_text_dir;

    $custom_header = cpg_get_custom_include($CONFIG['custom_header_path']);

        $charset = ($CONFIG['charset'] == 'language file') ? $lang_charset : $CONFIG['charset'];

    header('P3P: CP="CAO DSP COR CURa ADMa DEVa OUR IND PHY ONL UNI COM NAV INT DEM PRE"');
        header("Content-Type: text/html; charset=$charset");
    user_save_profile();

    $template_vars = array('{LANG_DIR}' => $lang_text_dir,
        '{TITLE}' => $CONFIG['gallery_name'] . ' - ' . strip_tags(bb_decode($section)),
        '{CHARSET}' => $charset,
        '{META}' => $meta,
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_HEADER}' => $custom_header,
        );
    // MOD - add {HEADER_BREADCRUMB} processing to pageheader
    global $template_breadcrumb, $CURRENT_ALBUM_DATA, $cat;
    $breadcrumb = '';
    $breadcrumb_text = '';
    $breadcrumb_output = '';
    $actual_cat = (is_numeric($CURRENT_ALBUM_DATA['category']) ? $CURRENT_ALBUM_DATA['category'] : $cat);
    breadcrumb($actual_cat, $breadcrumb, $breadcrumb_text);
    if ($breadcrumb) {
        $template_breadcrumb_save = $template_breadcrumb;
        $template = template_extract_block($template_breadcrumb, 'breadcrumb');
        $params = array(
            '{BREADCRUMB}' => $breadcrumb,
        );
        $breadcrumb_output = template_eval($template, $params);
        $template_breadcrumb = $template_breadcrumb_save;
    }
    $template_vars['{HEADER_BREADCRUMB}'] = $breadcrumb_output;
    // MOD - end
    echo template_eval($template_header, $template_vars);
}
// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1')
{
    global $CONFIG;

    //if ($width == '-1') $width = $CONFIG['picture_table_width']."px";
    //if ($width == '100%') $width = $CONFIG['main_table_width'];
	$width = '100%';
	if ( strstr($_SERVER['SCRIPT_NAME'], 'index.php') || strstr($_SERVER['SCRIPT_NAME'], 'thumbnails.php') || strstr($_SERVER['SCRIPT_NAME'], 'displayimage.php')) {
	    	$starttable = '
			<!-- Start standard table -->
			<div style="width: '.$width.';" class="maintable">
			';
		if ($title) {
			$starttable .= '
				<div><h2>'.$title.'</h2></div>
				';
		}
	} else {
		$starttable = '<!-- Start standard table -->
			<table align="center" width="'.$width.'" cellspacing="1" cellpadding="0" class="maintable">
			';
		if ($title) {
			$starttable .= '<tr><td class="tableh1" colspan="'.$title_colspan.'"><h2>'.$title.'</h2></td></tr>';
		}
	}
	
	echo $starttable;
}

// Function to end a 'standard' table
function endtable()
{
	if ( strstr($_SERVER['SCRIPT_NAME'], 'index.php') || strstr($_SERVER['SCRIPT_NAME'], 'thumbnails.php') || strstr($_SERVER['SCRIPT_NAME'], 'displayimage.php')) {
		$endtable = '</div>
			<!-- End standard table -->';
	} else {
		$endtable = '</table>
			<!-- End standard table -->';
	}
	
	echo $endtable;
}

// HTML template for the category list
$template_cat_list = <<<EOT
<!-- BEGIN header -->
	<div><h2>{CATEGORY}</h2></div>
	<div class="list">
<!-- END header -->
<!-- BEGIN catrow -->
	<div class="catrow_noalb" style="{CAT_THUMB}">
	<div class="cat_info">{ALBUMS}: {ALB_COUNT} | {PICTURES}: {PIC_COUNT}</div>
		<div class="catlink"><b>{CAT_TITLE}</b></div>{CAT_DESC}
	</div>
<!-- END catrow -->
<!-- BEGIN catrow_noalb -->
	<div class="catrow_noalb" style="{CAT_THUMB}">
		<div class="catlink"><b>{CAT_TITLE}</b></div>{CAT_DESC}
	</div>
<!-- END catrow_noalb -->
<!-- BEGIN footer -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px;">
		<span class="statlink">{STATISTICS}</span>
	</div>
	</div>
<!-- END footer -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;
// Template used for tabbed display
$template_tab_display = array('left_text' => '<span class="tableh1_compact" style="white-space: nowrap"><b>{LEFT_TEXT}</b></span>' . "\n",
    'tab_header' => '<span style="position: absolute; right: 5px;">',
    'tab_trailer' => '</span>',
    'active_tab' => '<span class="active_page" ><b>%d</b></span>' . "\n",
    'inactive_tab' => '<span class="navmenu"><a href="{LINK}"><b>%d</b></a></span>' . "\n",
    'inactive_prev_tab' => '<span class="navmenu"><a href="{LINK}"><b>{PREV}</b></a></span>' . "\n",
    'inactive_next_tab' => '<span class="navmenu"><a href="{LINK}"><b>{NEXT}</b></a></span>' . "\n",
);
// HTML template for the album list
$template_album_list = <<<EOT

<!-- BEGIN stat_row -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px;">
		<span class="statlink">{STATISTICS}</span>
	</div>
<!-- END stat_row -->
<!-- BEGIN header -->
        <div><h2>Alben</h2></div>
	<div class="list">
<!-- END header -->
<!-- BEGIN album_cell -->
	<div class="album_thing" style="width: {COL_WIDTH}%">
		<div class="album_thing_header"><a href="{ALB_LINK_TGT}"><b>{ALBUM_TITLE}</b></a></div>
		<div class="album_thing_content"><a href="{ALB_LINK_TGT}" class="album_thing_image albums">{ALB_LINK_PIC}</a>
			{ADMIN_MENU}
			{ALB_DESC}
			<div class="album_thing_infos">{ALB_INFOS}</div></div>
		<div class="album_thing_content">
                </div>
        </div>
<!-- END album_cell -->
<!-- BEGIN empty_cell -->
	<div style="position: relative; min-height: 85px; padding: 5px; display: inline; width: {COL_WIDTH}%;"></div>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
	<hr style="clear: both; background: #FFF; border: 0; padding: 0; margin: 0; height: 0;" />
<!-- END row_separator -->
<!-- BEGIN footer -->
        </div>
<!-- END footer -->
<!-- BEGIN tabs -->
        <div>
		{TABS}
	</div>
<!-- END tabs -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;
// HTML template for filmstrip display
$template_film_strip = <<<EOT
<div class="filmstrip">
	<div style="background-image: url({TILE1}); width: 100%"><img src="{TILE1}" alt="" border="0" />&nbsp;</div>
        <div class="film_images">
          <table width="100%" cellspacing="0" cellpadding="3" border="0">
              <tr>
                 <td width="50%"></td>
                 {THUMB_STRIP}
                 <td width="50%"></td>
              </tr>
          </table>
        </div>
	<div style="background-image: url({TILE1}); width: 100%"><img src="{TILE1}" alt="" border="0" />&nbsp;</div>
</div>
<!-- BEGIN thumb_cell -->
                <td valign="top" align="center">
                                        <a href="{LINK_TGT}">{THUMB}</a>
                                        {CAPTION}
                                        {ADMIN_MENU}
                </td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center" >&nbsp;</td>
<!-- END empty_cell -->

EOT;
// HTML template for the thumbnail view when there is no picture to show
$template_no_img_to_display = <<<EOT
	<div class="tableb" height="200" align="center"><b>{TEXT}</b></div>
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->
// HTML template for the thumbnail view when there is no picture to show
EOT;
// HTML template for the USER info box in the user list view
$template_user_list_info_box = <<<EOT
        <table cellspacing="1" cellpadding="0" border="0" width="100%" class="user_thumb_infobox">
                <tr>
                        <th><a href="profile.php?uid={USER_ID}">{USER_NAME}</a></th>
                </tr>
                <tr>
                        <td>{ALBUMS}</td>
                </tr>
                <tr>
                        <td>{PICTURES}</td>
                </tr>
        </table>
EOT;
// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
<div class="list">
<!-- END header -->
<!-- BEGIN thumb_cell -->
        <div class="thumbnails" style="width:{CELL_WIDTH}%;" align="center">
		<div align="center">
                <a href="{LINK_TGT}">{THUMB}<br /></a>
		{CAPTION}
		{ADMIN_MENU}
                </div>
        </div>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
	<div style="position: relative; min-height: 85px; padding: 5px; display: inline; width: {CELL_WIDTH}%;"></div>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
	<hr style="clear: both; background: #FFF; border: 0; padding: 0; margin: 0; height: 0;" />
<!-- END row_separator -->
<!-- BEGIN footer -->
</div>
<!-- END footer -->
<!-- BEGIN tabs -->
	<div style="background: #E7E7E7; padding: 5px; -moz-border-radius: 5px; position: relative;">
		<span class="statlink">{TABS}</span>
	</div>
<!-- END tabs -->
<!-- BEGIN spacer -->
<br />
<!-- END spacer -->

EOT;
$template_breadcrumb = <<<EOT
<!-- BEGIN breadcrumb -->
{BREADCRUMB}
<!-- END breadcrumb -->
<!-- BEGIN breadcrumb_user_gal -->
<span class="statlink"><b>{BREADCRUMB}</b></span>
<span class="statlink">{STATISTICS}</span>
<!-- END breadcrumb_user_gal -->

EOT;
// HTML template for the image navigation bar
$template_img_navbar = <<<EOT
	<div class="img_navbar">
		<span class="navmenu" style="width:48px">
			<a href="{THUMB_TGT}" class="navmenu_pic" title="{THUMB_TITLE}"><img src="{LOCATION}images/thumbnails.gif" align="middle" border="0" alt="{THUMB_TITLE}" /></a>
                </span>
		<span class="navmenu" style="width:48px">
                        <a href="javascript:;" class="navmenu_pic" onclick="blocking('picinfo','yes', 'block'); return false;" title="{PIC_INFO_TITLE}"><img src="{LOCATION}images/info.gif" border="0" align="middle" alt="{PIC_INFO_TITLE}" /></a>
                </span>
		<span class="navmenu" style="width:48px">
                        <a href="{SLIDESHOW_TGT}" class="navmenu_pic" title="{SLIDESHOW_TITLE}"><img src="{LOCATION}images/slideshow.gif" border="0" align="middle" alt="{SLIDESHOW_TITLE}" /></a>
                </span>
		<span class="navmenu" style="width:100%">
                        {PIC_POS}
                </span>
<!-- BEGIN report_file_button -->
		<span class="navmenu" style="width:48px">
                        <a href="{REPORT_TGT}" class="navmenu_pic" title="{REPORT_TITLE}"><img src="{LOCATION}images/report.gif" border="0" align="middle" alt="{REPORT_TITLE}" /></a>
                </span>
<!-- END report_file_button -->
<!-- BEGIN ecard_button -->
		<span class="navmenu" style="width:48px">
                        <a href="{ECARD_TGT}" class="navmenu_pic" title="{ECARD_TITLE}"><img src="{LOCATION}images/ecard.gif"  border="0" align="middle" alt="{ECARD_TITLE}" /></a>
                </span>
<!-- END ecard_button -->
		<span class="navmenu" style="width:48px">
                        <a href="{PREV_TGT}" class="navmenu_pic" title="{PREV_TITLE}"><img src="{LOCATION}images/prev.gif"  border="0" align="middle" alt="{PREV_TITLE}" /></a>
                </span>
		<span class="navmenu" style="width:48px">
                        <a href="{NEXT_TGT}" class="navmenu_pic" title="{NEXT_TITLE}"><img src="{LOCATION}images/next.gif"  border="0" align="middle" alt="{NEXT_TITLE}" /></a>
                </span>
	</div>

EOT;

// HTML template for intermediate image display
$template_display_media = <<<EOT
	<div class="display_media">
		<div class="imageborder">
			{IMAGE}
		</div>
	</div>
	<div>
		<div class="img_admin_menu">
			{ADMIN_MENU}
		</div>
	</div>
<!-- BEGIN img_desc -->
	<div class="img_desc">
<!-- BEGIN title -->
		<span><center><b>{TITLE}</b></center></span>
<!-- END title -->
<!-- BEGIN caption -->
		<span><center>{CAPTION}</center></span>
<!-- END caption -->
	</div>
<!-- END img_desc -->
EOT;


// HTML template for the display of comments
$template_image_comments = <<<EOT
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">

        <tr>
                <td>
                        <table width="100%" cellpadding="0" cellspacing="0">
                           <tr>
                                <td class="tableh2_compact">
                                        <b>{MSG_AUTHOR}</b><a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                                                                                 ({IP})
<!-- END ipinfo -->
</td>


                                <td class="tableh2_compact" align="right" width="100%">
<!-- BEGIN report_comment_button -->
     <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}"><img src="images/report.gif" width="16" height="16" border="0" align="middle" alt="{REPORT_COMMENT_TITLE}" /></a>
<!-- END report_comment_button -->


<!-- BEGIN buttons -->
                                        <a href="javascript:;" onclick="blocking('cbody{MSG_ID}','', 'block'); blocking('cedit{MSG_ID}','', 'block'); return false;" title="{EDIT_TITLE}"><img src="images/edit.gif" border="0" align="middle" /></a>
                                        <a href="delete.php?msg_id={MSG_ID}&what=comment"  onclick="return confirm('{CONFIRM_DELETE}');"><img src="images/delete.gif" border="0" align="middle" /></a>
<!-- END buttons -->
                                </td>
                                <td class="tableh2_compact" align="right">
                                        <span class="comment_date">[{MSG_DATE}]</span>
                                </td></tr>
                        </table>
                </td>
        </tr>
        <tr>
                <td class="tableb_compact">
                        <div id="cbody{MSG_ID}" style="display:block">
                                {MSG_BODY}
                        </div>
                        <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">

                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <tr>
                                                <td>
                                                   <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td><td>
                                                </tr>
                                                <tr>
                                                <td width="80%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
                                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                                <table width="100%" cellpadding="0" cellspacing="0">
                                        <tr>
                                                <form name="f{MSG_ID}" method="POST" action="db_input.php">
                                                <input type="hidden" name="event" value="comment_update" />
                                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                                                <td>
                                                <input type="text" name="msg_author" value="{MSG_AUTHOR}" class="textinput" size="25" />
                                                </td>
                                        </tr>
                                        <tr>
                                                <td width="100%">
                                                        <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                                                </td>
                                                <td class="tableb_compact">
                                                </td>
                                                <td>
                                                        <input type="submit" class="comment_button" name="submit" value="{OK}" />
                                                </td>
                                                </form>
                                        </tr>
                                        <tr>
                                                <td colspan="3"><img src="images/spacer.gif" width="1" height="2" /><br /></td>
                                        </tr>
                                </table>
<!-- END edit_box_no_smilies -->
                        </div>
                </td>
        </tr>
</table>
EOT;

// HTML template for e-cards
$template_ecard = <<<EOT
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html dir="{LANG_DIR}">
<head>
<meta http-equiv="content-type" content="text/html; charset={CHARSET}" />
<title>{TITLE}</title>
<style type="text/css">
#e-card, #e-card * {
  color: #333;
}
</style>
</head>
<body bgcolor="#FFFFFF" text="#0F5475" link="#0F5475" vlink="#0F5475" alink="#0F5475">
<br />
<p align="center"><a href="{VIEW_ECARD_TGT}"><b>{VIEW_ECARD_LNK}</b></a></p>
<div id="e-card" style="border: 2px solid #666; background: #EEE; width: 80%; margin: auto; padding: 10px;">
  <div style="float: left; padding: 5px;">
    <a href="{VIEW_MORE_TGT}displayimage.php?pos=-{PID}">
      <img src="{PIC_URL}" border="1" alt="" />
    </a>
    <br />
    <div align="center">
      <h3>{PIC_TITLE}</h3>
    </div>
  </div>
  <div align="right"><img src="{URL_PREFIX}images/stamp.gif" border="0" alt="" /></div>
  <br />
  <div style="color: #333 !important;">
    <h2>{GREETINGS}</h2>
    {MESSAGE}
    <br /><br />
    <small>{SENDER_NAME}, (<a href="mailto:{SENDER_EMAIL}">{SENDER_EMAIL}</a>)</small>
  </div>
</div>
<p align="center"><a href="{VIEW_MORE_TGT}"><b>{VIEW_MORE_LNK}</b></a></p>
</body>
</html>
EOT;

// plain-text template for e-cards (as fallback for clients that can't display html-formatted mails)
$template_ecard_plaintext = <<<EOT
{TITLE}
=========================================

{VIEW_ECARD_LNK_PLAINTEXT}:
{VIEW_ECARD_TGT}

{GREETINGS}


{PLAINTEXT_MESSAGE}

{SENDER_NAME} ({SENDER_EMAIL})

-----------------------------------------
{VIEW_MORE_LNK}:
{VIEW_MORE_TGT}
EOT;


?>
