<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2012 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

**********************************************/

// HTML template for template  sub menu buttons
$template_sys_menu_button = $template_sub_menu_button = <<<EOT
<!-- BEGIN {BLOCK_ID} -->
    <li>
        <a href="{HREF_TGT}" title="{HREF_TITLE}" class="firstlevel"><span class="firstlevel nav">{HREF_LNK}</span></a>
    </li>
<!-- END {BLOCK_ID} -->
EOT;
if (USER_ID) { // visitor is logged in
$template_sys_menu = <<<EOT

<ul class="dropmenu" id="cpg_navigation">
<!-- BEGIN home -->
                <li>
                    <a href="{HOME_TGT}" title="{HOME_TITLE}" class="firstlevel"><span class="firstlevel nav">{HOME_LNK}<span class="arrow-down"></span></span></a>
                    <ul>
                    <!-- BEGIN contact -->
                                <li>
                                    <a href="{CONTACT_TGT}" title="{CONTACT_TITLE}">{CONTACT_LNK}</a>
                                </li>
                    <!-- END contact --> 
                    <!-- BEGIN sidebar -->
                                    <li>
                                        <a href="{SIDEBAR_TGT}" title="{SIDEBAR_TITLE}">{SIDEBAR_LNK}</a>
                                    </li>
                    <!-- END sidebar -->
                    <!-- BEGIN my_profile -->
                                    <li>
                                        <a href="{MY_PROF_TGT}" title="{MY_PROF_LNK}">{MY_PROF_LNK}</a>
                                    </li>
                    <!-- END my_profile -->
                    <!-- BEGIN allow_memberlist -->
                                    <li>
                                        <a href="{MEMBERLIST_TGT}" title="{MEMBERLIST_TITLE}">{MEMBERLIST_LNK}</a>
                                    </li>
                    <!-- END allow_memberlist -->
                    </ul>
                </li>
<!-- END home -->
EOT;
} else { // visitor is not logged in
$template_sys_menu = <<<EOT

<ul class="dropmenu" id="cpg_navigation">
<!-- BEGIN home -->
                <li>
                    <a href="{HOME_TGT}" title="{HOME_TITLE}" class="firstlevel"><span class="firstlevel nav nodown">{HOME_LNK}</span></a>
                    <!-- BEGIN sidebar -->
                    <!-- END sidebar -->
                    <!-- BEGIN my_profile -->
                    <!-- END my_profile -->
                    <!-- BEGIN allow_memberlist -->
                    <!-- END allow_memberlist -->
                </li>
<!-- BEGIN contact -->
                <li>
                    <a href="{CONTACT_TGT}" title="{CONTACT_TITLE}" class="firstlevel"><span class="firstlevel nav nodown">{CONTACT_LNK}</span></a>
                </li>
<!-- END contact -->
<!-- END home -->
EOT;
}
// HTML template for sys menu
$template_sys_menu .= <<<EOT


<!-- BEGIN my_gallery -->
                <li>
                    <a href="{MY_GAL_TGT}" title="{MY_GAL_TITLE}" class="firstlevel"><span class="firstlevel nav">{MY_GAL_LNK}<span class="arrow-down"></span></span></a>
                    <ul>
                    <!-- BEGIN enter_admin_mode -->
                                    <li>
                                    <a href="{ADM_MODE_TGT}" title="{ADM_MODE_TITLE}">{ADM_MODE_LNK}</a>
                                    </li>
                    <!-- END enter_admin_mode -->
                    <!-- BEGIN leave_admin_mode -->
                                    <li>
                                        <a href="{USR_MODE_TGT}" title="{USR_MODE_TITLE}">{USR_MODE_LNK}</a>
                                    </li>
                    <!-- END leave_admin_mode -->
                    </ul>
                </li>
<!-- END my_gallery -->
<!-- BEGIN upload_pic -->
                <li>
                    <a href="{UPL_PIC_TGT}" title="{UPL_PIC_TITLE}" class="firstlevel"><span class="firstlevel nav nodown">{UPL_PIC_LNK}</span></a>
                </li>
<!-- END upload_pic -->
<!-- BEGIN register -->
                <li>
                    <a href="{REGISTER_TGT}" title="{REGISTER_TITLE}" class="firstlevel"><span class="firstlevel nav nodown">{REGISTER_LNK}</span></a>
                </li>
<!-- END register -->
<!-- BEGIN login -->
                <li>
                    <a href="{LOGIN_TGT}" title="{LOGIN_LNK}" class="firstlevel"><span class="firstlevel nav nodown">{LOGIN_LNK}</span></a>
                </li>
<!-- END login -->
<!-- BEGIN logout -->
                <li>
                    <a href="{LOGOUT_TGT}" title="{LOGOUT_LNK}" class="firstlevel"><span class="firstlevel nav nodown">{LOGOUT_LNK}</span></a>
                </li>
<!-- END logout -->
</ul>

EOT;


// HTML template for sub menu
if ($CONFIG['browse_by_date'] != 0) {
    $browsebydatebutton = <<< EOT
                        <li>
                            <a href="{BROWSEBYDATE_TGT}" title="{BROWSEBYDATE_TITLE}" rel="nofollow" class="greybox"><span>{BROWSEBYDATE_LNK}</span></a>
                        </li>
EOT;
} else {
    $browsebydatebutton = '';
}
if (USER_ID) { // visitor is logged in
$template_sub_menu = <<<EOT

<ul class="dropmenu cpg_center_container cpg_menu_container">
<!-- BEGIN custom_link -->
                <li class="submenu">
                    <a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}" class="firstlevel"><span class="firstlevel  nav">{CUSTOM_LNK_LNK}</span></a>
                </li>
<!-- END custom_link -->
<!-- BEGIN album_list -->
                <li class="submenu">
                    <a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}" class="firstlevel"><span class="firstlevel nav">{ALB_LIST_LNK}</span></a>
                    <ul>
<!-- BEGIN lastup -->
                        <li>
                            <a href="{LASTUP_TGT}" title="{LASTUP_LNK}" rel="nofollow"><span>{LASTUP_LNK}</span></a>
                        </li>
<!-- END lastup -->
<!-- BEGIN lastcom -->
                        <li>
                            <a href="{LASTCOM_TGT}" title="{LASTCOM_LNK}" rel="nofollow" ><span>{LASTCOM_LNK}</span></a>
                        </li>
<!-- END lastcom -->
<!-- BEGIN topn -->
                        <li>
                            <a href="{TOPN_TGT}" title="{TOPN_LNK}" rel="nofollow"><span>{TOPN_LNK}</span></a>
                        </li>
<!-- END topn -->
<!-- BEGIN toprated -->
                        <li>
                            <a href="{TOPRATED_TGT}" title="{TOPRATED_LNK}" rel="nofollow"><span>{TOPRATED_LNK}</span></a>
                        </li>
<!-- END toprated -->
<!-- BEGIN favpics -->
                        <li>
                            <a href="{FAV_TGT}" title="{FAV_LNK}" rel="nofollow"><span>{FAV_LNK}</span></a>
                        </li>
<!-- END favpics -->
<!-- BEGIN browse_by_date -->
                        $browsebydatebutton
<!-- END browse_by_date -->
                    </ul>
                </li>
<!-- END album_list -->
<!-- BEGIN search -->
                <li class="submenu">
                    <a href="{SEARCH_TGT}" title="{SEARCH_LNK}" class="firstlevel"><span class="firstlevel nav">{SEARCH_LNK}</span></a>
                </li>
<!-- END search -->
<!--</ul>-->
EOT;
} else { // visitor is not logged in
$template_sub_menu = <<<EOT

<ul class="dropmenu cpg_center_container cpg_menu_container">
<!-- BEGIN custom_link -->
                <li class="submenu">
                    <a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}" class="firstlevel"><span class="firstlevel  nav">{CUSTOM_LNK_LNK}</span></a>
                </li>
<!-- END custom_link -->
<!-- BEGIN album_list -->
                <li class="submenu">
                    <a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}" class="firstlevel"><span class="firstlevel nav">{ALB_LIST_LNK}</span></a>
                    <ul>
<!-- BEGIN lastup -->
                        <li>
                            <a href="{LASTUP_TGT}" title="{LASTUP_LNK}" rel="nofollow"><span>{LASTUP_LNK}</span></a>
                        </li>
<!-- END lastup -->
<!-- BEGIN lastcom -->
                        <li>
                            <a href="{LASTCOM_TGT}" title="{LASTCOM_LNK}" rel="nofollow" ><span>{LASTCOM_LNK}</span></a>
                        </li>
<!-- END lastcom -->
<!-- BEGIN topn -->
                        <li>
                            <a href="{TOPN_TGT}" title="{TOPN_LNK}" rel="nofollow"><span>{TOPN_LNK}</span></a>
                        </li>
<!-- END topn -->
<!-- BEGIN toprated -->
                        <li>
                            <a href="{TOPRATED_TGT}" title="{TOPRATED_LNK}" rel="nofollow"><span>{TOPRATED_LNK}</span></a>
                        </li>
<!-- END toprated -->
<!-- BEGIN favpics -->
                        <li>
                            <a href="{FAV_TGT}" title="{FAV_LNK}" rel="nofollow"><span>{FAV_LNK}</span></a>
                        </li>
<!-- END favpics -->
<!-- BEGIN browse_by_date -->
                        $browsebydatebutton
<!-- END browse_by_date -->
                    </ul>
                </li>
<!-- END album_list -->
<!-- BEGIN search -->
                <li class="submenu">
                    <a href="{SEARCH_TGT}" title="{SEARCH_LNK}" class="firstlevel"><span class="firstlevel nav">{SEARCH_LNK}</span></a>
                </li>
<!-- END search -->
</ul>
EOT;
}
// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT
                            <!--<ul class="dropmenu cpg_center_container cpg_menu_container">-->
                                <li class="submenu">
                                    <a href="#" title="{FILES_TITLE}" class="firstlevel"><span class="firstlevel nav">{FILES_LNK}</span></a>
                                    <ul>
                                    <!-- BEGIN admin_approval -->
                                        <li><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}" class="admin_menu_anim"><span>{UPL_APP_LNK}</span></a></li>
                                    <!-- END admin_approval -->
                                    <!-- BEGIN catmgr -->
                                        <li><a href="catmgr.php" title="{CATEGORIES_TITLE}"><span>{CATEGORIES_LNK}</span></a></li>
                                    <!-- END catmgr -->
                                    <!-- BEGIN albmgr -->
                                        <li><a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}"><span>{ALBUMS_LNK}</span></a></li>
                                    <!-- END albmgr -->
                                    <!-- BEGIN picmgr -->
                                        <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_LNK}</span></a></li>
                                    <!-- end picmgr -->
                                    <!-- BEGIN batch_add -->
                                        <li><a href="searchnew.php" title="{SEARCHNEW_TITLE}"><span>{SEARCHNEW_LNK}</span></a></li>
                                    <!-- END batch_add -->
                                    <!-- BEGIN admin_tools -->
                                        <li><a href="util.php?t={TIME_STAMP}#admin_tools" title="{UTIL_TITLE}"><span>{UTIL_LNK}</span></a></li>
                                    <!-- END admin_tools -->
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="#" class="firstlevel" title="{INFO_TITLE}"><span class="firstlevel nav">{INFO_LNK}</span></a>
                                    <ul>
                                    <!-- BEGIN review_comments -->
                                        <li><a href="reviewcom.php" title="{COMMENTS_TITLE}"><span>{COMMENTS_LNK}</span></a></li>
                                    <!-- END review_comments -->
                                    <!-- BEGIN log_ecards -->
                                        <li><a href="db_ecard.php" title="{DB_ECARD_TITLE}"><span>{DB_ECARD_LNK}</span></a></li>
                                    <!-- END log_ecards -->
                                    <!-- BEGIN view_log_files -->
                                        <li><a href="viewlog.php" title="{VIEW_LOG_FILES_TITLE}"><span>{VIEW_LOG_FILES_LNK}</span></a></li>
                                    <!-- END view_log_files -->
                                    <!-- BEGIN overall_stats -->
                                        <li><a href="stat_details.php?type=hits&amp;sort=sdate&amp;dir=&amp;sdate=1&amp;ip=1&amp;search_phrase=0&amp;referer=0&amp;browser=1&amp;os=1&amp;mode=fullscreen&amp;page=1&amp;amount=50" title="{OVERALL_STATS_TITLE}" ><span>{OVERALL_STATS_LNK}</span></a></li>
                                    <!-- END overall_stats -->
                                    <!-- BEGIN check_versions -->
                                        <li><a href="versioncheck.php" title="{CHECK_VERSIONS_TITLE}"><span>{CHECK_VERSIONS_LNK}</span></a></li>
                                    <!-- END check_versions -->
                                    <!-- BEGIN php_info -->
                                        <li><a href="phpinfo.php" title="{PHPINFO_TITLE}"><span>{PHPINFO_LNK}</span></a></li>
                                    <!-- END php_info -->
                                    <!-- BEGIN show_news -->
                                        <li><a href="mode.php?what=news&amp;referer=$REFERER" title="{SHOWNEWS_TITLE}"><span>{SHOWNEWS_LNK}</span></a></li>
                                    <!-- END show_news -->
                                    <!-- BEGIN documentation -->
                                        <li><a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}"><span>{DOCUMENTATION_LNK}</span></a></li>
                                    <!-- END documentation -->
                                    </ul>
                                </li>
                            <!-- BEGIN config -->
                                <li class="submenu">
                                    <a href="admin.php" title="{ADMIN_TITLE}" class="firstlevel"><span class="firstlevel nav">{ADMIN_LNK}</span></a>
                                    <ul>
                                    <!-- BEGIN keyword_manager -->
                                        <li><a href="keywordmgr.php" title="{KEYWORDMGR_TITLE}"><span>{KEYWORDMGR_LNK}</span></a></li>
                                    <!-- END keyword_manager -->
                                    <!-- BEGIN exif_manager -->
                                        <li><a href="exifmgr.php" title="{EXIFMGR_TITLE}"><span>{EXIFMGR_LNK}</span></a></li>
                                    <!-- END exif_manager -->
                                    <!-- BEGIN plugin_manager -->
                                        <li><a href="pluginmgr.php" title="{PLUGINMGR_TITLE}"><span>{PLUGINMGR_LNK}</span></a></li>
                                    <!-- END plugin_manager -->
                                    <!-- BEGIN bridge_manager -->
                                        <li><a href="bridgemgr.php" title="{BRIDGEMGR_TITLE}"><span>{BRIDGEMGR_LNK}</span></a></li>
                                    <!-- END bridge_manager -->
                                    <!-- BEGIN update_database -->
                                        <li><a href="update.php" title="{UPDATE_DATABASE_TITLE}"><span>{UPDATE_DATABASE_LNK}</span></a></li>
                                    <!-- END update_database -->
                                    </ul>
                                </li>
                            <!-- END config -->
                            <!-- BEGIN usermgr -->
                                <li class="submenu">
                                    <a href="usermgr.php" title="{USERS_TITLE}" class="firstlevel"><span class="firstlevel nav">{USERS_LNK}</span></a>
                                    <ul>
                                    <!-- BEGIN banmgr -->
                                        <li><a href="banning.php" title="{BAN_TITLE}"><span>{BAN_LNK}</span></a></li>
                                    <!-- END banmgr -->
                                    <!-- BEGIN groupmgr -->
                                        <li><a href="groupmgr.php" title="{GROUPS_TITLE}"><span>{GROUPS_LNK}</span></a></li>
                                    <!-- END groupmgr -->
                                    <!-- BEGIN admin_profile -->
                                        <li><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}"><span>{MY_PROF_LNK}</span></a></li>
                                    <!-- END admin_profile -->
                                    </ul>
                                </li>
                            <!-- END usermgr -->
                            </ul>
                            
EOT;

// HTML template for user admin menu
$template_user_admin_menu = <<<EOT
                            <!-- <ul class="dropmenu"> -->
                                <li class="submenu">
                                    <a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}" class="firstlevel"><span class="firstlevel nav">{MY_PROF_LNK}</span></a>
                                    <ul>
                                        <li><a href="albmgr.php" title="{ALBMGR_TITLE}"><span>{ALBMGR_LNK}</span></a></li>
                                        <li><a href="modifyalb.php" title="{MODIFYALB_TITLE}"><span>{MODIFYALB_LNK}</span></a></li>
                                        <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_LNK}</span></a></li>
                                    </ul>
                                </li>
                            </ul>

EOT;










/******************************************************************************
** Section <<<starttable>>> - START
******************************************************************************/
// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1', $zebra_class = '', $return = false)
{
    global $CONFIG;

    if ($width == '-1') $width = $CONFIG['picture_table_width'];
    if ($width == '100%') $width = $CONFIG['main_table_width'];
    $text = <<<EOT

<!-- Start standard table -->
<div class="masonry_pin_div" style="margin: 0 auto;">
<div class="cpg_pin_cell cpg_pin_table_cell">
<table align="center" width="$width" cellspacing="1" cellpadding="0" class="maintable $zebra_class">

EOT;
    if ($title) {
        $text .= <<<EOT
        <tr>
                <td class="tableh1" colspan="$title_colspan">$title</td>
        </tr>

EOT;
    }
    if (!$return) {
        echo $text;
    } else {
        return $text;
    }
}

function start_pin_div()
{
    global $CONFIG;
    
    $text = <<<EOT

<!-- Start pin div -->
<div class="masonry_pin_div" style="margin: 0 auto;">

EOT;

        echo $text;
}
/******************************************************************************
** Section <<<starttable>>> - END
******************************************************************************/



/******************************************************************************
** Section <<<endtable>>> - START
******************************************************************************/
function endtable($return = false)
{
    $text = <<<EOT
</table>
</div>
</div>
<!-- End standard table -->

EOT;
    if (!$return) {
        echo $text;
    } else {
        return $text;
    }
}

function end_pin_div()
{
    $text = <<<EOT
</div>
<!-- End pin div -->

EOT;
echo $text;

}
/******************************************************************************
** Section <<<endtable>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_display_cat_list>>> - START
******************************************************************************/
function theme_display_cat_list($breadcrumb, &$cat_data, $statistics)
{
    global $template_cat_list, $lang_cat_list;
    if (count($cat_data) > 0) {
        /* starttable('100%');*/
        start_pin_div();
        $template = template_extract_block($template_cat_list, 'header');
        $params = array(
                '{CATEGORY}' => $lang_cat_list['category'],
                '{ALBUMS}' => $lang_cat_list['albums'],
                '{PICTURES}' => $lang_cat_list['pictures'],
        );
        echo template_eval($template, $params);
    }

    $template_noalb = template_extract_block($template_cat_list, 'catrow_noalb');
    $template = template_extract_block($template_cat_list, 'catrow');
    foreach($cat_data as $category) {
        if (!isset($category['cat_thumb'])) { $category['cat_thumb'] = ''; }
        if (count($category) == 3) {
            $params = array(
            	'{CATEGORY}' => $lang_cat_list['category'],
                    '{CAT_TITLE}' => $category[0],
                    '{CAT_THUMB}' => $category['cat_thumb'],
                    '{CAT_DESC}' => $category[1],
            );
            echo template_eval($template_noalb, $params);
        } elseif (isset($category['cat_albums']) && ($category['cat_albums'] != '')) {
            $params = array(
            	'{CATEGORY}' => $lang_cat_list['category'],
                    '{CAT_TITLE}' => $category[0],
                    '{CAT_THUMB}' => $category['cat_thumb'],
                    '{CAT_DESC}' => $category[1],
                    '{CAT_ALBUMS}' => $category['cat_albums'],
                    '{ALB_COUNT}' => cpg_float2decimal($category[2]),
                    '{PIC_COUNT}' => cpg_float2decimal($category[3]),
            );
            echo template_eval($template, $params);
        } else {
            $params = array(
            	'{CATEGORY}' => $lang_cat_list['category'],
                    '{CAT_TITLE}' => $category[0],
                    '{CAT_THUMB}' => $category['cat_thumb'],
                    '{CAT_DESC}' => $category[1],
                    '{CAT_ALBUMS}' => '',
                    '{ALB_COUNT}' => cpg_float2decimal($category[2]),
                    '{PIC_COUNT}' => cpg_float2decimal($category[3]),
            );
            echo template_eval($template, $params);
        }
    }

    if ($statistics && count($cat_data) > 0) {
        $template = template_extract_block($template_cat_list, 'footer');
        $params = array('{STATISTICS}' => $statistics);
        echo template_eval($template, $params);
    }


    if (count($cat_data) > 0)
          /* endtable();*/
          end_pin_div();
        /*echo template_extract_block($template_cat_list, 'spacer');*/
}
/******************************************************************************
** Section <<<theme_display_cat_list>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_display_album_list>>> - START
******************************************************************************/
function theme_display_album_list(&$alb_list, $nbAlb, $cat, $page, $total_pages)
{

    global $CONFIG, $STATS_IN_ALB_LIST, $statistics, $template_tab_display, $template_album_list, $lang_album_list, $lang_cat_list;

    $theme_alb_list_tab_tmpl = $template_tab_display;

    $theme_alb_list_tab_tmpl['left_text'] = strtr($theme_alb_list_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_album_list['album_on_page']));
    $theme_alb_list_tab_tmpl['page_link'] = strtr($theme_alb_list_tab_tmpl['page_link'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));

    $tabs = create_tabs($nbAlb, $page, $total_pages, $theme_alb_list_tab_tmpl);

    $album_cell = template_extract_block($template_album_list, 'album_cell');
    $empty_cell = template_extract_block($template_album_list, 'empty_cell');
    $tabs_row = template_extract_block($template_album_list, 'tabs');
    $stat_row = template_extract_block($template_album_list, 'stat_row');
    $spacer = template_extract_block($template_album_list, 'spacer');
    $header = template_extract_block($template_album_list, 'header');
    $footer = template_extract_block($template_album_list, 'footer');
    $rows_separator = template_extract_block($template_album_list, 'row_separator');

    $count = 0;

    $columns = $CONFIG['album_list_cols'];
    $column_width = ceil(100 / $columns);
    $thumb_cell_width = $CONFIG['alb_list_thumb_size'] + 2;

    /*starttable('100%');*/
    start_pin_div();

    if ($STATS_IN_ALB_LIST) {
        $params = array('{STATISTICS}' => $statistics,
            '{COLUMNS}' => $columns,
            );
        echo template_eval($stat_row, $params);
    }
$params = array('{ALBUMS}' => $lang_cat_list['albums']);
echo template_eval($header, $params);
    /*echo $header;*/

    if (is_array($alb_list)) {
        foreach($alb_list as $album) {
            $count ++;

            $params = array('{COL_WIDTH}' => $column_width,
            '{ALBUMS}' => $lang_cat_list['albums'],
                '{ALBUM_TITLE}' => $album['album_title'],
                '{THUMB_CELL_WIDTH}' => $thumb_cell_width,
                '{ALB_LINK_TGT}' => "thumbnails.php?album={$album['aid']}",
                '{ALB_LINK_PIC}' => $album['thumb_pic'],
                '{ADMIN_MENU}' => $album['album_adm_menu'],
                '{ALB_DESC}' => $album['album_desc'],
                '{ALB_INFOS}' => $album['album_info'],
                '{ALB_HITS}' => $album['alb_hits'],
                );

            echo template_eval($album_cell, $params);

            if ($count % $columns == 0 && $count < count($alb_list)) {
                echo $rows_separator;
            }
        }
    }

    $params = array('{COL_WIDTH}' => $column_width,
          '{SPACER}' => $thumb_cell_width
          );
    $empty_cell = template_eval($empty_cell, $params);

    while ($count++ % $columns != 0) {
        echo $empty_cell;
    }

    echo $footer;
    // Tab display
    $params = array('{COLUMNS}' => $columns,
        '{TABS}' => $tabs,
        );
    echo template_eval($tabs_row, $params);

    /* endtable(); */
    end_pin_div();

    echo $spacer;
}
/******************************************************************************
** Section <<<theme_display_album_list>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<theme_display_album_list_cat>>> - START
******************************************************************************/
// Function to display first level Albums of a category
function theme_display_album_list_cat(&$alb_list, $nbAlb, $cat, $page, $total_pages)
{
    global $CONFIG, $STATS_IN_ALB_LIST, $statistics, $template_tab_display, $template_album_list_cat, $lang_album_list;
    if (!$CONFIG['first_level']) {
        return;
    }

    $theme_alb_list_tab_tmpl = $template_tab_display;

    $theme_alb_list_tab_tmpl['left_text'] = strtr($theme_alb_list_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_album_list['album_on_page']));
    $theme_alb_list_tab_tmpl['page_link'] = strtr($theme_alb_list_tab_tmpl['page_link'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));

    $tabs = create_tabs($nbAlb, $page, $total_pages, $theme_alb_list_tab_tmpl);
    // echo $template_album_list_cat;
    $template_album_list_cat1 = $template_album_list_cat;
    $album_cell = template_extract_block($template_album_list_cat1, 'c_album_cell');
    $empty_cell = template_extract_block($template_album_list_cat1, 'c_empty_cell');
    $tabs_row = template_extract_block($template_album_list_cat1, 'c_tabs');
    $stat_row = template_extract_block($template_album_list_cat1, 'c_stat_row');
    $spacer = template_extract_block($template_album_list_cat1, 'c_spacer');
    $header = template_extract_block($template_album_list_cat1, 'c_header');
    $footer = template_extract_block($template_album_list_cat1, 'c_footer');
    $rows_separator = template_extract_block($template_album_list_cat1, 'c_row_separator');

    $count = 0;

    $columns = $CONFIG['album_list_cols'];
    $column_width = ceil(100 / $columns);
    $thumb_cell_width = $CONFIG['alb_list_thumb_size'] + 2;

    /*starttable('100%');*/
    /*start_pin_div();*/

    if ($STATS_IN_ALB_LIST) {
        $params = array('{STATISTICS}' => $statistics,
            '{COLUMNS}' => $columns,
            );
        echo template_eval($stat_row, $params);
    }

    echo $header;

    if (is_array($alb_list)) {
        foreach($alb_list as $album) {
            $count ++;

            $params = array('{COL_WIDTH}' => $column_width,
                '{ALBUM_TITLE}' => $album['album_title'],
                '{THUMB_CELL_WIDTH}' => $thumb_cell_width,
                '{ALB_LINK_TGT}' => "thumbnails.php?album={$album['aid']}",
                '{ALB_LINK_PIC}' => $album['thumb_pic'],
                '{ADMIN_MENU}' => $album['album_adm_menu'],
                '{ALB_DESC}' => $album['album_desc'],
                '{ALB_INFOS}' => $album['album_info'],
                '{ALB_HITS}' => $album['alb_hits'],
                );

            echo template_eval($album_cell, $params);

            if ($count % $columns == 0 && $count < count($alb_list)) {
                echo $rows_separator;
            }
        }
    }

    $params = array('{COL_WIDTH}' => $column_width,
          '{SPACER}' => $thumb_cell_width
          );
    $empty_cell = template_eval($empty_cell, $params);

    while ($count++ % $columns != 0) {
        echo $empty_cell;
    }

    echo $footer;
    // Tab display
    $params = array('{COLUMNS}' => $columns,
        '{TABS}' => $tabs,
        );
    echo template_eval($tabs_row, $params);

    /* endtable(); */
    /*end_pin_div();*/

    echo $spacer;
}
/******************************************************************************
** Section <<<theme_display_album_list_cat>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_display_thumbnails>>> - START
******************************************************************************/
function theme_display_thumbnails(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $page, $total_pages, $sort_options, $display_tabs, $mode = 'thumb', $date='')
{
    global $CONFIG, $CURRENT_ALBUM_DATA;
    global $template_thumb_view_title_row,$template_fav_thumb_view_title_row, $lang_thumb_view, $lang_common, $template_tab_display, $template_thumbnail_view, $lang_album_list, $lang_errors;

    $superCage = Inspekt::makeSuperCage();

    static $header = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $row_separator = '';
    static $footer = '';
    static $tabs = '';
    static $spacer = '';

    if ($header == '') {
        $thumb_cell =  template_extract_block($template_thumbnail_view, 'thumb_cell');
        $tabs = template_extract_block($template_thumbnail_view, 'tabs');
        $header = template_extract_block($template_thumbnail_view, 'header');
        $empty_cell = template_extract_block($template_thumbnail_view, 'empty_cell');
        $row_separator = template_extract_block($template_thumbnail_view, 'row_separator');
        $footer = template_extract_block($template_thumbnail_view, 'footer');
        $spacer = template_extract_block($template_thumbnail_view, 'spacer');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $date_link = $date=='' ? '' : '&amp;date=' . $date;
    if ($superCage->get->getInt('uid')) {
      $uid_link = '&amp;uid=' . $superCage->get->getInt('uid');
    } else {
      $uid_link = '';
    }

    $album_types = array(
        'albums' => array('lastalb')
    );
    $album_types = CPGPluginAPI::filter('theme_thumbnails_album_types', $album_types);

    $theme_thumb_tab_tmpl = $template_tab_display;

    if ($mode == 'thumb') {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => in_array($aid, $album_types['albums']) ? $lang_album_list['album_on_page'] : $lang_thumb_view['pic_on_page']));
        $theme_thumb_tab_tmpl['page_link'] = strtr($theme_thumb_tab_tmpl['page_link'], array('{LINK}' => 'thumbnails.php?album=' . $aid . $cat_link . $date_link . $uid_link . '&amp;page=%d'));
    } else {
        $theme_thumb_tab_tmpl['left_text'] = strtr($theme_thumb_tab_tmpl['left_text'], array('{LEFT_TEXT}' => $lang_thumb_view['user_on_page']));
        $theme_thumb_tab_tmpl['page_link'] = strtr($theme_thumb_tab_tmpl['page_link'], array('{LINK}' => 'index.php?cat=' . $cat . '&amp;page=%d'));
    }

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['thumbcols']) . '%';

    $tabs_html = $display_tabs ? create_tabs($nbThumb, $page, $total_pages, $theme_thumb_tab_tmpl) : '';

    if (!GALLERY_ADMIN_MODE && stripos($template_thumb_view_title_row, 'admin_buttons') !== false) {
        template_extract_block($template_thumb_view_title_row, 'admin_buttons');
    }
    // The sort order options are not available for meta albums
    if ($sort_options) {
        if (GALLERY_ADMIN_MODE) {
            $param = array(
                '{ALBUM_ID}'   => $aid,
                '{CAT_ID}'     => ($cat > 0 ? $cat : $CURRENT_ALBUM_DATA['category']),
                '{MODIFY_LNK}'     => $lang_common['album_properties'],
                '{MODIFY_ICO}'     => cpg_fetch_icon('modifyalb', 1),
                '{PARENT_CAT_LNK}' => $lang_common['parent_category'],
                '{PARENT_CAT_ICO}' => cpg_fetch_icon('category', 1),
                '{EDIT_PICS_LNK}'  => $lang_common['edit_files'],
                '{EDIT_PICS_ICO}'  => cpg_fetch_icon('edit', 1),
                '{ALBUM_MGR_LNK}'  => $lang_common['album_manager'],
                '{ALBUM_MGR_ICO}'  => cpg_fetch_icon('alb_mgr', 1),
            );
        } else {
            $param = array();
        }
        $param['{ALBUM_NAME}'] = $album_name;
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);
        $title = template_eval($template_thumb_view_title_row, $param);
    } elseif ($aid == 'favpics' && $CONFIG['enable_zipdownload'] > 0) { //Lots of stuff can be added here later
        $param = array(
            '{ALBUM_ID}'   => $aid,
            '{ALBUM_NAME}' => $album_name,
            '{DOWNLOAD_ZIP}' => cpg_fetch_icon ('zip', 2) . $lang_thumb_view['download_zip'],
        );
        // Plugin Filter: allow plugin to modify or add tags to process
        $param = CPGPluginAPI::filter('theme_thumbnails_title', $param);        
        $title = template_eval($template_fav_thumb_view_title_row, $param);
    } else {
        $title = $album_name;
    }

    CPGPluginAPI::action('theme_thumbnails_wrapper_start', null);

    /*if ($mode == 'thumb') {
        starttable('100%', $title, $thumbcols);
    } else {*/
        /*starttable('100%');*/
        start_pin_div();
    /*}*/

    /*echo $header;*/
    $params = array('{ALBUM_TYPE}' => $album_name);
    echo template_eval($header, $params);

    $i = 0;
    global $thumb;  // make $thumb accessible to plugins
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            if (in_array($aid, $album_types['albums'])) {
                $params = array(
                    '{CELL_WIDTH}' => $cell_width,
                    '{LINK_TGT}'   => "thumbnails.php?album={$thumb['aid']}",
                    '{THUMB}'      => $thumb['image'],
                    '{CAPTION}'    => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu'],
                );
            } else {
                // determine if thumbnail link targets should open in a pop-up
                if ($CONFIG['thumbnail_to_fullsize'] == 1) { // code for full-size pop-up
                    if (!USER_ID && $CONFIG['allow_unlogged_access'] <= 2) {
                       $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['login_needed'],'','','','').'\');';
                    } elseif (USER_ID && USER_ACCESS_LEVEL <= 2) {
                        $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['access_intermediate_only'],'','','','').'\');';
                    } else {
                       $target = 'javascript:;" onclick="MM_openBrWindow(\'displayimage.php?pid=' . $thumb['pid'] . '&fullsize=1\',\'' . uniqid(rand()) . '\',\'scrollbars=yes,toolbar=no,status=no,resizable=yes,width=' . ((int)$thumb['pwidth']+(int)$CONFIG['fullsize_padding_x']) .  ',height=' .   ((int)$thumb['pheight']+(int)$CONFIG['fullsize_padding_y']). '\');';
                    }
                } elseif ($aid == 'random') {
                    $target = "displayimage.php?pid={$thumb['pid']}$uid_link#top_display_media";
                } elseif ($aid == 'lastcom' || $aid == 'lastcomby') {
                    $page = cpg_get_comment_page_number($thumb['msg_id']);
                    $page = (is_numeric($page)) ? "&amp;page=$page" : '';
                    $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link&amp;msg_id={$thumb['msg_id']}$page#comment{$thumb['msg_id']}";
                } else {
                    $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link#top_display_media";
                }
                $params = array(
                    '{CELL_WIDTH}' => $cell_width,
                    '{LINK_TGT}'   => $target,
                    '{THUMB}'      => $thumb['image'],
                    '{CAPTION}'    => $thumb['caption'],
                    '{ADMIN_MENU}' => $thumb['admin_menu'],
                );
            }

        } else {  // mode != 'thumb'

            // Used for mode = 'user' from list_users() in index.php
            $params = array(
                '{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}'   => "index.php?cat={$thumb['cat']}",
                '{THUMB}'      => $thumb['image'],
                '{CAPTION}'    => $thumb['caption'],
                '{ADMIN_MENU}' => '',
            );

        }

        // Plugin Filter: allow plugin to modify or add tags to process
        $params = CPGPluginAPI::filter('theme_display_thumbnails_params', $params);
        echo template_eval($thumb_cell, $params);

        if ((($i % $thumbcols) == 0) && ($i < count($thumb_list))) {
            echo $row_separator;
        }
    } // foreach $thumb

    unset($thumb);  // unset $thumb to avoid conflicting with global

    for (;($i % $thumbcols); $i++) {
        echo $empty_cell;
    }
    $footer = CPGPluginAPI::filter('theme_thumbnails_footer', $footer); 
    echo $footer;
    end_pin_div();
    if ($display_tabs) {
        $params = array(
            '{THUMB_COLS}' => $thumbcols,
            '{TABS}'       => $tabs_html,
        );
        echo template_eval($tabs, $params);
    }

    /*endtable();*/
    CPGPluginAPI::action('theme_thumbnails_wrapper_end', null);
    echo $spacer;
    
}
/******************************************************************************
** Section <<<theme_display_thumbnails>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<theme_display_breadcrumb>>> - START
******************************************************************************/
function theme_display_breadcrumb($breadcrumb, &$cat_data)
{
    /**
     * ** added breadcrumb as a seperate element
     */
    global $template_breadcrumb, $lang_breadcrumb;

    /*starttable('100%');*/
    start_pin_div();
    
    if ($breadcrumb) {
        $template = template_extract_block($template_breadcrumb, 'breadcrumb');
        $params = array(
                '{BREADCRUMB}' => $breadcrumb,
        );
        echo template_eval($template, $params);
    }
        /*endtable();*/
        end_pin_div();
}
/******************************************************************************
** Section <<<theme_display_breadcrumb>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_cat_list>>> - START
******************************************************************************/
// HTML template for the category list
$template_cat_list = <<<EOT
<!-- BEGIN header -->
<!-- END header -->
<!-- BEGIN catrow_noalb -->
<!-- END catrow_noalb -->
<!-- BEGIN catrow -->
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span style="display:inline;">{CATEGORY}: </span><span class="catlink" style="display:inline;">{CAT_TITLE}</span>{CAT_DESC}</td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_cat_list-->
{CAT_ALBUMS}
<!-- END catrow -->
<!-- BEGIN footer -->
<!-- END footer -->
<!-- BEGIN spacer -->
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_cat_list>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_album_list>>> - START
******************************************************************************/
// HTML template for the album list
$template_album_list = <<<EOT

<!-- BEGIN stat_row -->
<!-- END stat_row -->
<!-- BEGIN header -->
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span style="display:inline;">{ALBUMS}</span></td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_album_list-->
<!-- END header -->
<!-- BEGIN album_cell -->
<div class="cpg_pin_cell">
	<img src="images/spacer.gif" width="1" height="1" border="0" alt="" /><br />
	<a href="{ALB_LINK_TGT}" class="albums">{ALB_LINK_PIC}<br /></a>
	<div class="cpg_pin_dest">
		<span class="alblink"><a href="{ALB_LINK_TGT}">{ALBUM_TITLE}</a></span>
		<p>{ALB_DESC}</p>
		<p class="album_stat">{ALB_INFOS}<br />{ALB_HITS}</p>
	</div><!--cpg_pin_dest template_album_list-->
</div><!--cpg_pin_cell template_album_list-->
<!-- END album_cell -->
<!-- BEGIN empty_cell -->
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
<!-- END row_separator -->
<!-- BEGIN footer -->
<!-- END footer -->
<!-- BEGIN tabs -->
<!-- END tabs -->
<!-- BEGIN spacer -->
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_album_list>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<$template_album_list_cat>>> - START
******************************************************************************/
// HTML template for the album list
$template_album_list_cat = <<<EOT

<!-- BEGIN c_stat_row -->
<!-- END c_stat_row -->
<!-- BEGIN c_header -->
<!-- END c_header -->
<!-- BEGIN c_album_cell -->
	<div class="cpg_pin_cell">
		<img src="images/spacer.gif" width="1" height="1" border="0" alt="" /><br />
		<a href="{ALB_LINK_TGT}" class="albums">{ALB_LINK_PIC}<br /></a>
		<div class="cpg_pin_dest">
			<span class="alblink"><a href="{ALB_LINK_TGT}">{ALBUM_TITLE}</a></span>
			<p>{ALB_DESC}</p>
			<p class="album_stat">{ALB_INFOS}<br />{ALB_HITS}</p>
		</div><!--cpg_pin_dest template_album_list_cat-->
	</div><!--cpg_pin_cell template_album_list_cat-->
<!-- END c_album_cell -->
<!-- BEGIN c_empty_cell -->
<!-- END c_empty_cell -->
<!-- BEGIN c_row_separator -->
<!-- END c_row_separator -->
<!-- BEGIN c_footer -->
<!-- END c_footer -->
<!-- BEGIN c_tabs -->
<!-- END c_tabs -->
<!-- BEGIN c_spacer -->
<!-- END c_spacer -->

EOT;
/******************************************************************************
** Section <<<$template_album_list_cat>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<$template_thumbnail_view>>> - START
******************************************************************************/

// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span style="display:inline;">{ALBUM_TYPE}</span></td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_thumbnail_view-->
<!-- END header -->
<!-- BEGIN thumb_cell -->
	<div class="cpg_pin_cell">
		<img src="images/spacer.gif" width="1" height="1" border="0" alt="" /><br />
		<a href="{LINK_TGT}">{THUMB}<br /></a>
		<div class="cpg_pin_dest">
			{CAPTION}
		</div><!--cpg_pin_dest template_thumbnail_view-->
	</div><!--cpg_pin_cell template_thumbnail_view-->
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
<!-- END row_separator -->
<!-- BEGIN footer -->
<!-- END footer -->
<!-- BEGIN tabs -->
                <div class="tabDiv"colspan="{THUMB_COLS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0"> 
                                <tr>       
                                       {TABS}
                                </tr>
                        </table>
                </div>
<!-- END tabs -->
<!-- BEGIN spacer -->
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_thumbnail_view>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<$template_breadcrumb>>> - START
******************************************************************************/
// HTML template for the breadcrumb
$template_breadcrumb = <<<EOT
<!-- BEGIN breadcrumb -->
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span class="statlink" style="display:inline;">{BREADCRUMB}</span></td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_breadcrumb-->
<!-- END breadcrumb -->
<!-- BEGIN breadcrumb_user_gal -->
<!-- END breadcrumb_user_gal -->

EOT;
/******************************************************************************
** Section <<<$template_breadcrumb>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_fav_thumb_view_title_row>>> - START
******************************************************************************/
// HTML template for title row of the fav thumbnail view (album title + download)
$template_fav_thumb_view_title_row = <<<EOT
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span class="statlink" style="display:inline;">{ALBUM_NAME}</span></td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_fav_thumb_view_title_row-->
<div class="cpg_pin_cell">
	<img src="images/spacer.gif" width="1" height="1" border="0" alt="" /><br />
	<span class="statlink"><a href="zipdownload.php">{DOWNLOAD_ZIP}</a></span>
</div><!--cpg_pin_cell template_fav_thumb_view_title_row-->

EOT;
/******************************************************************************
** Section <<<$template_fav_thumb_view_title_row>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_no_img_to_display>>> - START
******************************************************************************/
function theme_no_img_to_display($album_name)
{
    global $lang_errors, $template_no_img_to_display;

    static $template = '';
    static $spacer;

    if ((!$template)) {
        $template = $template_no_img_to_display;
        $spacer = template_extract_block($template, 'spacer');
    }

    $params = array('{TEXT}' => $lang_errors['no_img_to_display'],
    '{ALBUM_NAME}' => $album_name);
    /*starttable('100%', $album_name);*/
    start_pin_div();
    echo template_eval($template, $params);
    end_pin_div();
    /*endtable();*/
}
/******************************************************************************
** Section <<<theme_no_img_to_display>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_no_img_to_display>>> - START
******************************************************************************/
// HTML template for the thumbnail view when there is no picture to show
$template_no_img_to_display = <<<EOT
<div class="cpg_pin_cell cpg_pin_table_cell">
	<table border="0" width="100%">
		<tr>
			<td><span class="statlink" style="display:inline;">{ALBUM_NAME}</span></td>
		</tr>
	</table>
</div><!--cpg_pin_cell cpg_pin_table_cell template_no_img_to_display-->
<div class="cpg_pin_cell cpg_pin_table_cell">
	<span class="cpg_user_message">{TEXT}</span>
</div><!--cpg_pin_cell cpg_pin_table_cell template_no_img_to_display-->
<!-- BEGIN spacer -->
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_no_img_to_display>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_image_rating>>> - START
******************************************************************************/
// HTML template for the image rating box
$template_image_rating = <<<EOT
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintableRate">
    <tr>
        <td colspan="6" class="tableh2" id="voting_title"><strong>{TITLE}</strong> {VOTES}</td>
    </tr>
    <tr id="rating_stars">
        <td class="tableb" id="star_rating"></td>
    </tr>
    <tr class="noscript">
      <td class="tableb" colspan="6" align="center">
        <noscript>
           {JS_WARNING}
        </noscript>
      </td>
    </tr>
</table>
EOT;
/******************************************************************************
** Section <<<$template_image_rating>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<$template_image_rating_oldstyle>>> - START
******************************************************************************/
// HTML template for the image rating box (old-style)
$template_image_rating_oldstyle = <<<EOT
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintableRate">
    <tr>
        <td colspan="6" class="tableh2" id="voting_title"><strong>{TITLE}</strong> {VOTES}</td>
    </tr>
    <tr id="rating_stars">
        <td class="tableb" id="star_rating">
            <table width="100%">
                <tr>
                    {RATING_IMAGES}
                </tr>
            </table>
        </td>
    </tr>
</table>
EOT;
/******************************************************************************
** Section <<<$template_image_rating_oldstyle>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_html_comments>>> - START
******************************************************************************/
// Displays comments for a specific picture
function theme_html_comments($pid)
{
    global $CONFIG, $USER, $CURRENT_ALBUM_DATA, $lang_date, $HTML_SUBST;
    global $template_image_comments, $template_add_your_comment, $lang_display_comments, $lang_common, $REFERER, $lang_bbcode_help_title, $lang_bbcode_help;

    $superCage = Inspekt::makeSuperCage();
    $template_add_your_comment = CPGPluginAPI::filter('theme_add_comment', $template_add_your_comment);
    $template_image_comments = CPGPluginAPI::filter('theme_edit_comment', $template_image_comments);

    list($timestamp, $form_token) = getFormToken();

    $html = '';

    //report to moderator buttons
    if (!(($CONFIG['report_post']==1) && (USER_CAN_SEND_ECARDS))) {
        template_extract_block($template_image_comments, 'report_comment_button');
    }

    if (!$CONFIG['enable_smilies']) {
        $tmpl_comment_edit_box = template_extract_block($template_image_comments, 'edit_box_no_smilies', '{EDIT}');
        template_extract_block($template_image_comments, 'edit_box_smilies');
        template_extract_block($template_add_your_comment, 'input_box_smilies');
    } else {
        $tmpl_comment_edit_box = template_extract_block($template_image_comments, 'edit_box_smilies', '{EDIT}');
        template_extract_block($template_image_comments, 'edit_box_no_smilies');
        template_extract_block($template_add_your_comment, 'input_box_no_smilies');
    }


    $tmpl_comments_buttons = template_extract_block($template_image_comments, 'buttons', '{BUTTONS}');
    $tmpl_comments_ipinfo = template_extract_block($template_image_comments, 'ipinfo', '{IPINFO}');

    if ($CONFIG['comments_sort_descending'] == 1) {
        $comment_sort_order = 'DESC';
    } else {
        $comment_sort_order = 'ASC';
    }

    $result = cpg_db_query("SELECT COUNT(msg_id) FROM {$CONFIG['TABLE_COMMENTS']} WHERE pid='$pid'");
    list($num) = mysql_fetch_row($result);

    if ($num) {

        $limit = $CONFIG['comments_per_page'];
        $max = ceil($num/$limit);

        if ($superCage->get->keyExists('page')) {
            $page = $superCage->get->getInt('page');
            $page = min($page, $max);
            $page = max(0, $page);
        } else if ($CONFIG['comments_sort_descending'] == 1) {
            $page = 1;
        } else {
            $page = $max;
        }

        $start = max(0, $num - (($max-($page-1))*$limit));

        ob_start();
        /*starttable();*/
        /*echo '<div class="cpg_pin_cell cpg_pin_table_cell">';*/

        
        echo '<div style="float: left">'.$lang_display_comments['comment'].' '.sprintf($lang_display_comments['comment_x_to_y_of_z'], ($start+1), min($num, $start+$limit), $num).'</div>';
        echo '<div style="float: right">'.$lang_display_comments['page'].': ';
        $links = array();

        for ($i = 1; $i <= $max; $i++){
            if ($i < 5 || ($i > $max - 5) || (($i > $page -5) && ($i < $page + 5))){
                $links[$i]= '<a href="displayimage.php?pid=' . $pid . '&amp;page='.$i.'#comments_top">'.$i.'</a>';
            }
        }

        $links[$page] = "<b>$page</b>";
        echo implode(' - ', $links);
        echo '</div>';
        /*echo '</div>';*/
        /*endtable();*/
        $html .= ($tabs = ob_get_clean());

        $result = cpg_db_query("SELECT msg_id, msg_author, msg_body, UNIX_TIMESTAMP(msg_date) AS msg_date, author_id, author_md5_id, msg_raw_ip, msg_hdr_ip, pid, approval FROM {$CONFIG['TABLE_COMMENTS']} WHERE pid='$pid' ORDER BY msg_id $comment_sort_order LIMIT $start, $limit");

        while ($row = mysql_fetch_assoc($result)) { // while-loop start
            $user_can_edit = (GALLERY_ADMIN_MODE) || (USER_ID && USER_ID == $row['author_id'] && USER_CAN_POST_COMMENTS) || (!USER_ID && USER_CAN_POST_COMMENTS && ($USER['ID'] == $row['author_md5_id']));
            if (($user_can_edit != '' && $CONFIG['comment_user_edit'] != 0) || (GALLERY_ADMIN_MODE)) {
                $comment_buttons = $tmpl_comments_buttons;
                $comment_edit_box = $tmpl_comment_edit_box;
            } else {
                $comment_buttons = '';
                $comment_edit_box = '';
            }
            $comment_ipinfo = ($row['msg_raw_ip'] && GALLERY_ADMIN_MODE)?$tmpl_comments_ipinfo : '';
            $hide_comment = 0;

            // comment approval
            $pending_approval = '';
            if (USER_IS_ADMIN) {
                //display the selector approve/disapprove
                if ($row['approval'] == 'NO') {
                    $pending_approval = cpg_fetch_icon('comment_disapprove_disabled', 0) . '<a href="reviewcom.php?pos=-{PID}&amp;msg_id={MSG_ID}&amp;form_token={FORM_TOKEN}&amp;timestamp={TIMESTAMP}&amp;what=approve" title="' . $lang_display_comments['approve'] . '">' . cpg_fetch_icon('comment_approve', 0) . '</a>';
                } else {
                    $pending_approval = '<a href="reviewcom.php?pos=-{PID}&amp;msg_id={MSG_ID}&amp;form_token={FORM_TOKEN}&amp;timestamp={TIMESTAMP}&amp;what=disapprove" title="' . $lang_display_comments['disapprove'] . '">' . cpg_fetch_icon('comment_disapprove', 0) . '</a>' . cpg_fetch_icon('comment_approve_disabled', 0);
                }
            } else { // user or guest is logged in - start
                if ($row['approval'] == 'NO') { // the comment is not approved - start
                    if ($user_can_edit) { // the comment comes from the current visitor, display it with a warning that it needs admin approval
                        $pending_approval = cpg_fetch_icon('comment_approval', 0, $lang_display_comments['pending_approval']);
                    } else { // the comment comes from someone else - don't display it at all
                        if ($CONFIG['comment_placeholder'] == 0) {
                            $hide_comment = 1;
                        } else {
                            $row['msg_author'] = $lang_display_comments['unapproved_comment'];
                            $row['msg_body'] = $lang_display_comments['pending_approval_message'];
                            $row['author_id'] = 0;
                        }
                    }
                } // the comment is not approved - end
            } // user or guest is logged in - end

            if ($CONFIG['enable_smilies']) {
                $comment_body = process_smilies(make_clickable($row['msg_body']));
                $smilies = generate_smilies("f{$row['msg_id']}", 'msg_body');
            } else {
                $comment_body = make_clickable($row['msg_body']);
                $smilies = '';
            }

            // wrap the comment into italics if it isn't approved
            if ($row['approval'] == 'NO') {
                $comment_body = '<em>'.$comment_body.'</em>';
                $row['msg_author'] = $row['msg_author'];
            }

            list($row['ip_detail']) = CPGPluginAPI::filter('ip_information', array('', $row['msg_hdr_ip']));
            $ip = $row['msg_hdr_ip']. $row['ip_detail'];
            if ($row['msg_hdr_ip'] != $row['msg_raw_ip']) {
                list($row['ip_detail']) = CPGPluginAPI::filter('ip_information', array('', $row['msg_raw_ip']));
                $ip .= ' [' . $row['msg_raw_ip'] . $row['ip_detail'] . ']';
            }

            list($timestamp, $form_token) = getFormToken();
            $params = array('{EDIT}' => &$comment_edit_box,
                '{BUTTONS}' => &$comment_buttons,
                '{IPINFO}' => &$comment_ipinfo,
                '{PENDING_APPROVAL}' => &$pending_approval,
                '{FORM_TOKEN}' => $form_token,
                '{TIMESTAMP}' => $timestamp,
                );

            $template = template_eval($template_image_comments, $params);

            if ($row['author_id'] == 0) {
                $profile_lnk = stripslashes($row['msg_author']);
            } else {
                $profile_lnk = '<a href="profile.php?uid='.$row['author_id'].'">'.stripslashes($row['msg_author']).'</a>';
            }

            $params = array('{MSG_AUTHOR_LNK}' => $profile_lnk,
                '{MSG_AUTHOR}' => $row['msg_author'],
                '{MSG_ID}' => $row['msg_id'],
                '{PID}' => $row['pid'],
                '{EDIT_TITLE}' => &$lang_display_comments['edit_title'],
                '{DELETE_TITLE}' => &$lang_display_comments['delete_title'],
                '{DELETE_ICON}' => cpg_fetch_icon('delete', 0),
                '{EDIT_ICON}' => cpg_fetch_icon('edit', 0),
                '{CONFIRM_DELETE}' => &$lang_display_comments['confirm_delete'],
                '{MSG_DATE}' => localised_date($row['msg_date'], $lang_date['comment']),
                '{MSG_BODY}' => bb_decode($comment_body),
                '{MSG_BODY_RAW}' => $row['msg_body'],
                '{OK}' => &$lang_common['ok'],
                '{SMILIES}' => $smilies,
                '{IP}' => $ip,
                '{REPORT_COMMENT_TITLE}' => &$lang_display_comments['report_comment_title'],
                '{REPORT_COMMENT_ICON}' => cpg_fetch_icon('report', 0),
                '{WIDTH}' => $CONFIG['picture_table_width'],
                '{FORM_TOKEN}' => $form_token,
                '{TIMESTAMP}' => $timestamp,
                );

            if ($hide_comment != 1) {
                $html .= template_eval($template, $params);
            }
        } // while-loop end

        $html .= $tabs;
    }
    if (USER_CAN_POST_COMMENTS && $CURRENT_ALBUM_DATA['comments'] == 'YES') {
        if (USER_ID) {
            $user_name_input = '<tr><td colspan="2"><input type="hidden" name="msg_author" value="' . stripslashes(USER_NAME) . '" /></td>';
            template_extract_block($template_add_your_comment, 'user_name_input', $user_name_input);
            $user_name = '';
        } else {
            if (isset($USER['name'])) {
              $user_name = strtr($USER['name'], $HTML_SUBST);
            } else {
              $user_name = $lang_display_comments['your_name'];
            }
        }

        if (($CONFIG['comment_captcha'] == 0) || ($CONFIG['comment_captcha'] == 2 && USER_ID)) {
            template_extract_block($template_add_your_comment, 'comment_captcha');
        } else {
            $template_add_your_comment = CPGPluginAPI::filter('captcha_comment_print', $template_add_your_comment);
        }

        if ($CONFIG['show_bbcode_help']) {
            $captionLabel = '&nbsp;'. cpg_display_help('f=empty.htm&amp;base=64&amp;h='.urlencode(base64_encode(serialize($lang_bbcode_help_title))).'&amp;t='.urlencode(base64_encode(serialize($lang_bbcode_help))),470,245);
        }

        list($timestamp, $form_token) = getFormToken();
        $params = array('{ADD_YOUR_COMMENT}' => $lang_display_comments['add_your_comment'],
            // Modified Name and comment field
            '{NAME}' => $lang_display_comments['name'],
            '{COMMENT}' => $lang_display_comments['comment'],
            '{CONFIRM}' => $lang_common['confirm'].'&nbsp;'. cpg_display_help('f=empty.htm&amp;base=64&amp;h='.urlencode(base64_encode(serialize($lang_common['captcha_help_title']))).'&amp;t='.urlencode(base64_encode(serialize($lang_common['captcha_help']))),470,245),
            '{PIC_ID}' => $pid,
            '{USER_NAME}' => $user_name,
            '{MAX_COM_LENGTH}' => $CONFIG['max_com_size'],
            '{OK}' => $lang_common['ok'],
            '{OK_ICON}' => cpg_fetch_icon('ok', 1),
            '{DEFAULT_USERNAME}' => $lang_display_comments['your_name'],
            '{DEFAULT_USERNAME_MESSAGE}' => $lang_display_comments['default_username_message'],
            '{SMILIES}' => '',
            '{WIDTH}' => $CONFIG['picture_table_width'],
            '{HELP_ICON}' => $captionLabel,
            '{FORM_TOKEN}' => $form_token,
            '{TIMESTAMP}' => $timestamp,
            );

        if ($CONFIG['enable_smilies']) {
            $params['{SMILIES}'] = generate_smilies();
        } else {
            template_extract_block($template_add_your_comment, 'smilies');
        }

        template_extract_block($template_add_your_comment, 'login_to_comment');
        if ($CONFIG['comments_sort_descending'] == 1) {
            $html = '<br />'.template_eval($template_add_your_comment, $params).$html;
        } else {
            $html .= template_eval($template_add_your_comment, $params);
        }
    } else { // user can not post comments
        if ($CONFIG['comment_promote_registration'] == 1 && $CURRENT_ALBUM_DATA['comments'] == 'YES') {
            template_extract_block($template_add_your_comment, 'user_name_input');
            if ($CONFIG['enable_smilies'] == 1) {
                template_extract_block($template_add_your_comment, 'input_box_smilies');
            } else {
                template_extract_block($template_add_your_comment, 'input_box_no_smilies');
            }
            template_extract_block($template_add_your_comment, 'comment_captcha');
            template_extract_block($template_add_your_comment, 'smilies');
            template_extract_block($template_add_your_comment, 'submit');
            $params = array('{ADD_YOUR_COMMENT}' => $lang_display_comments['add_your_comment'],
                '{WIDTH}' => $CONFIG['picture_table_width'],
                '{LOGIN_TO_COMMENT}' => sprintf($lang_display_comments['log_in_to_comment'], '<a href="login.php?referer='.$REFERER.'">', '</a>'),
                '{HELP_ICON}' => '',
                );
            if ($CONFIG['comments_sort_descending'] == 1) {
                $html = '<br />'.template_eval($template_add_your_comment, $params).$html;
            } else {
                $html .= template_eval($template_add_your_comment, $params);
            }
        }
    }

    return $html;
}
/******************************************************************************
** Section <<<theme_html_comments>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_image_comments>>> - START
******************************************************************************/
// HTML template for the display of comments
$template_image_comments = <<<EOT
<!--<div class="cpg_pin_cell cpg_pin_table_cell">-->
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable" border="0">
    <tr>
        <td>
            <table width="100%" cellpadding="0" cellspacing="0">
                <tr>
                    <td class="tableh2" nowrap="nowrap">
                        <strong>{MSG_AUTHOR_LNK}</strong>
                        <a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                        ({IP})
<!-- END ipinfo -->
                    </td>
                    <td class="tableh2" align="right" width="100%">
<!-- BEGIN report_comment_button -->
                        <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}">{REPORT_COMMENT_ICON}</a>
<!-- END report_comment_button -->
<!-- BEGIN pending approval -->
                        {PENDING_APPROVAL}
<!-- END pending approval -->
<!-- BEGIN buttons -->
                        <script type="text/javascript">
                            document.write('<a href="javascript:;" onclick="blocking(\'cbody{MSG_ID}\',\'\', \'block\'); blocking(\'cedit{MSG_ID}\',\'\', \'block\'); return false;" title="{EDIT_TITLE}">{EDIT_ICON}</a>');
                        </script>
                        <a href="delete.php?msg_id={MSG_ID}&amp;what=comment&amp;form_token={FORM_TOKEN}&amp;timestamp={TIMESTAMP}" onclick="return confirm('{CONFIRM_DELETE}');" title="{DELETE_TITLE}">{DELETE_ICON}</a>
<!-- END buttons -->
                    </td>
                    <td class="tableh2" align="right" nowrap="nowrap">
                        <span class="comment_date">[{MSG_DATE}]</span>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="tableb tableb_alternate">
            <div id="cbody{MSG_ID}" style="display:block">
                {MSG_BODY}
            </div>
            <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                <form name="f{MSG_ID}" id="f{MSG_ID}" method="post" action="db_input.php">
                    <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td valign="top">
                                <input type="hidden" name="event" value="comment_update" />
                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                            </td>
                        </tr>
                        <tr>
                            <td width="80%">
                                <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                            </td>
                            <td class="tableb tableb_alternate"></td>
                            <td>
                                <input type="submit" class="button" name="submit" value="{OK}" />
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                <br />
                            </td>
                        </tr>
                    </table>
                </form>
                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                <form name="f{MSG_ID}" id="f{MSG_ID}" method="POST" action="db_input.php">
                    <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>    
                                <input type="hidden" name="event" value="comment_update" />
                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                            </td>
                        </tr>
                        <tr>
                            <td width="100%">
                                <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                            </td>
                            <td class="tableb tableb_alternate"></td>
                            <td>
                                <input type="submit" class="button" name="submit" value="{OK}" />
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                <br />
                            </td>
                        </tr>
                    </table>
                </form>
<!-- END edit_box_no_smilies -->
            </div>
        </td>
    </tr>
</table>
<!--</div>--><!--cpg_pin_cell cpg_pin_table_cell template_image_comments-->
EOT;
/******************************************************************************
** Section <<<$template_image_comments>>> - END
******************************************************************************/
/******************************************************************************
** Section <<<$template_add_your_comment>>> - START
******************************************************************************/
$template_add_your_comment = <<<EOT
<!--<div class="cpg_pin_cell cpg_pin_table_cell">-->
        <form method="post" name="post" id="post" action="db_input.php">
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
                        <tr>
                                        <td width="100%" class="tableh2">{ADD_YOUR_COMMENT}{HELP_ICON}</td>
                        </tr>
                        <tr>
                <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                               <td class="tableb tableb_alternate">
                                        {NAME}
                                </td>
                                <td class="tableb tableb_alternate">
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" onclick="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" onkeyup="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td class="tableb tableb_alternate">
                                {COMMENT}
                                </td>
                                <td width="100%" class="tableb tableb_alternate">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
<!-- BEGIN submit -->
                                <td class="tableb tableb_alternate">
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <button type="submit" class="button" name="submit" value="{OK}"  onclick="return notDefaultUsername(this.form, '{DEFAULT_USERNAME}', '{DEFAULT_USERNAME_MESSAGE}');">{OK_ICON}{OK}</button>
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                                </td>
<!-- END submit -->
                                                        </tr>
<!-- BEGIN comment_captcha -->
                                                        <tr>
                                <td class="tableb tableb_alternate" colspan="3">
                                  {CONFIRM}
                                </td>
                                <td class="tableb tableb_alternate" colspan="2">
                                  <input type="text" name="confirmCode" size="5" maxlength="5" class="textinput" />
                                  <img src="captcha.php" align="middle" border="0" alt="" />
                                </td>
                                                        </tr>
<!-- END comment_captcha -->
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%" class="tableb tableb_alternate">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
<!-- BEGIN login_to_comment -->
        <tr>
                                <td class="tableb tableb_alternate" colspan="2">
                                  {LOGIN_TO_COMMENT}
                                </td>
        </tr>
<!-- END login_to_comment -->
                </table>
        </form>
<!--</div>--><!--cpg_pin_cell cpg_pin_table_cell template_add_your_comment-->
EOT;
/******************************************************************************
** Section <<<$template_add_your_comment>>> - END
******************************************************************************/

/******************************************************************************
** Section <<<theme_credits>>> - START
******************************************************************************/
/******************************************************************************
// Function for the credits-section
In previous versions of Coppermine the "Powered by Coppermine" used to be
obfuscated to make it hard for non-coders to remove the tag. The reason behind
this was an additional license add-on that disallowed users to change the line.
The dev team has reviewed this policy for cpg1.5.x and decided that end users
ARE allowed to change or remove the line in legal terms.
HOWEVER: We have a forum policy for the support board instead: support will
only be given for galleries that show the "Powered by Coppermine" tag
unobfuscated.
Before removing the credits, please consider this as well:
Coppermine is free software, the dev team ASKS you to keep the footer intact.
We're convinced that you should give credit where credit is due. So please think
twice before you decide to remove the tag.
******************************************************************************/
function theme_credits() {
    $return = <<< EOT

<div class="footer" align="center" style="padding:10px;display:block;visibility:visible; font-family: Verdana,Arial,sans-serif;">Powered by <a href="http://coppermine-gallery.net/" title="Coppermine Photo Gallery" rel="external">Coppermine Photo Gallery</a><br /><span>Theme by Jeff Bailey | Based on <a href="http://pinterest.com/">Pinterest</a></span></div>
EOT;
    return $return;
}
/******************************************************************************
** Section <<<theme_credits>>> - END
******************************************************************************/


?>