/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ClasspathForm"
 * non viene creato nel metodo main().
 */
public class ClasspathForm extends Form
{
	public ClasspathForm()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		

		String sb="";
		//StringBuffer sb = new StringBuffer(1024*32);
		//GetEnvironmentVariable("classpath",sb,1024*32);
		
		com.ms.wfc.app.RegistryKey  ks =  com.ms.wfc.app.Registry.LOCAL_MACHINE;
		ks = ks.getSubKey("Software\\Microsoft\\Java VM");
		String[] vals = ks.getValueNames();
		sb = (String)ks.getValue("Classpath");
	
		java.util.StringTokenizer st = new java.util.StringTokenizer(sb+"",";",false);
		while (st.hasMoreTokens())
		{
			listBox1.addItem(st.nextToken());
		}
		
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}
	
	/** @dll.import("KERNEL32") */
	public static native int GetEnvironmentVariable(String name, 
                              StringBuffer value, int ccbValue);
	/** @dll.import("KERNEL32") */
	public static native int SetEnvironmentVariable(String name, 
                              String value);

	/**
	 * ClasspathForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button3_click(Object source, Event e)
	{
		this.dispose();
	}

	private void button1_click(Object source, Event e)
	{
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setFilter("Java archive (JAR)|*.jar|Zip|*.zip");
		
		if (ofd.showDialog() == DialogResult.OK)
		{
			this.listBox1.addItem( ofd.getFileName());
			updateClasspath();
		}
	}
	
	public void updateClasspath()
	{
		String val ="";
		for (int i=0; i<listBox1.getItemCount(); ++i)
		{
			if (i>0) val += ";";
			val += listBox1.getItem(i);
		}
		//SetEnvironmentVariable("CLASSPATH",val);
		//HKEY_LOCAL_MACHINE\Software\Microsoft\Java VM\Classpath
		com.ms.wfc.app.RegistryKey ks =  com.ms.wfc.app.Registry.LOCAL_MACHINE;
		ks = ks.getSubKey("SOFTWARE",false);
		ks = ks.getSubKey("Microsoft",false);
		ks = ks.getSubKey("Java VM",false);
		if (ks != null)
		{
			ks.setValue("Classpath",val);
		}
		MessageBox.show("You must restart iReport for the changes to take effect.","",MessageBox.ICONWARNING); 
	}

	private void button2_click(Object source, Event e)
	{
		com.businesslogic.ireport.ui.directorydialog.FileExplorer fe = new com.businesslogic.ireport.ui.directorydialog.FileExplorer();
		if (fe.showDialog() == DialogResult.OK)
		{
			this.listBox1.addItem( fe.getDirectory() );
			updateClasspath();
		}
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	ListBox listBox1 = new ListBox();
	Label label1 = new Label();
	Button button1 = new Button();
	Button button2 = new Button();
	Button button3 = new Button();

	private void initForm()
	{
		this.setText("ClasspathForm");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(420, 228));

		listBox1.setLocation(new Point(4, 20));
		listBox1.setSize(new Point(408, 173));
		listBox1.setTabIndex(0);
		listBox1.setText("listBox1");
		listBox1.setUseTabStops(true);

		label1.setLocation(new Point(4, 4));
		label1.setSize(new Point(124, 16));
		label1.setTabIndex(1);
		label1.setTabStop(false);
		label1.setText("Classpath");

		button1.setLocation(new Point(4, 200));
		button1.setSize(new Point(96, 24));
		button1.setTabIndex(2);
		button1.setText("Add JAR file");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(104, 200));
		button2.setSize(new Point(80, 24));
		button2.setTabIndex(3);
		button2.setText("Add directory");
		button2.addOnClick(new EventHandler(this.button2_click));

		button3.setLocation(new Point(332, 200));
		button3.setSize(new Point(80, 24));
		button3.setTabIndex(4);
		button3.setText("Close");
		button3.addOnClick(new EventHandler(this.button3_click));

		this.setNewControls(new Control[] {
							button3, 
							button2, 
							button1, 
							label1, 
							listBox1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ClasspathForm());
	}
}
