/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import java.util.*;

public class SubReportElement extends ReportElement 
{
	public boolean  isUsingCache = true;
	public Vector  subreportParameters=null;
	public String  subreportExpression="";
	public String  subreportExpressionClass="";
	public String  connectionExpression="";
	public String  dataSourceExpression="";
	public String  parametersMapExpression="";
	public boolean useConnection = false;
	
	public Image img = null;
	
	public SubReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x, y, width, height, hached);
		subreportParameters = new Vector();
		subreportExpressionClass = "java.lang.String";
		useConnection = false;
	}
	
	public void drawObject(Graphics g, double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		position.x -= 10;
		position.y -= 10;
		x_shift_origin -= 10;
		y_shift_origin -= 10;
		
		this.zoom_factor = zoom_factor;
		g.fill( getZoomedDim(position.x)-x_shift_origin,
				getZoomedDim(position.y)-y_shift_origin,
				getZoomedDim(width),
				getZoomedDim(height), new Brush(Color.LIGHTGRAY, BrushStyle.SOLID));
		
		x_shift_origin += 10;
		y_shift_origin += 10;
		if (img != null)
		{
			
			//g.drawImage( img, new Rectangle(0,0,Math.min( 32, getZoomedDim(width)), Math.min( 32, getZoomedDim(height))  ), 
			/*
			g.drawImage( img, new Rectangle(0,0,getZoomedDim(width), getZoomedDim(height)  ), 
						 new Rectangle(getZoomedDim(position.x)-x_shift_origin,
										getZoomedDim(position.y)-y_shift_origin,getZoomedDim(width), getZoomedDim(height)),false);
			*/
			if (img.getSize().x <= width && img.getSize().y<= height)
				{
					Rectangle paintrect = new Rectangle(-x_shift_origin+ getZoomedDim( position.x)+10 ,-y_shift_origin+getZoomedDim(position.y)+10, getZoomedDim( img.getSize().x), getZoomedDim( img.getSize().y));
					g.drawImage( img, new Rectangle(0,0,img.getSize().x,img.getSize().y), paintrect,true);
				}
				else if (width>0 && height>0)// Resize based on minor x/WIDTH... e y/HEIGHT
				{
					if ((double)((double)img.getSize().x/(double)width)> (double)((double)img.getSize().y/(double)height))
					{
						Rectangle source = new Rectangle(0,0,img.getSize().x,img.getSize().y);
						Rectangle destination = new Rectangle(-x_shift_origin+ getZoomedDim( position.x)+10 ,-y_shift_origin+getZoomedDim(position.y)+10,getZoomedDim(width) ,getZoomedDim(Math.min( (img.getSize().y*width)/img.getSize().x, height)) );
						g.drawImage( img,source,destination, true );
					}
					else
					{
						Rectangle source = new Rectangle(0,0,img.getSize().x,img.getSize().y);
						Rectangle destination = new Rectangle(-x_shift_origin+ getZoomedDim( position.x)+10 ,-y_shift_origin+getZoomedDim(position.y)+10, getZoomedDim( Math.min( (img.getSize().x*height)/img.getSize().y, width)) ,getZoomedDim( height) );
						g.drawImage( img,source,destination, true );
					}
				}	
		}
		x_shift_origin -= 10;
		y_shift_origin -= 10;
				g.drawLines(new Point[]{new Point(getZoomedDim(position.x)-x_shift_origin, getZoomedDim(position.y)-y_shift_origin),
								new Point(getZoomedDim(position.x+width)-1-x_shift_origin,getZoomedDim(position.y)-y_shift_origin),
								new Point(getZoomedDim(position.x+width)-1-x_shift_origin,getZoomedDim(position.y+height)-1-y_shift_origin),
								new Point(getZoomedDim(position.x)-x_shift_origin,getZoomedDim(position.y+height)-1-y_shift_origin),
								new Point(getZoomedDim(position.x)-x_shift_origin,getZoomedDim(position.y)-y_shift_origin)});
		position.x += 10;
		position.y += 10;
		x_shift_origin += 10;
		y_shift_origin += 10;
	}
	
	public ReportElement cloneMe()
	{
		SubReportElement newReportElement = new SubReportElement(position.x, position.y, width, height, hached);
		newReportElement.name = new String(name);
		newReportElement.bgcolor = bgcolor;
		newReportElement.fgcolor = fgcolor;
	
		
		newReportElement.isUsingCache = isUsingCache;
		newReportElement.subreportExpression = new String(subreportExpression);
		newReportElement.subreportExpressionClass = new String(subreportExpressionClass);
		newReportElement.connectionExpression = new String(connectionExpression);
		newReportElement.dataSourceExpression = new String(dataSourceExpression);
		newReportElement.parametersMapExpression = new String(parametersMapExpression);
		newReportElement.useConnection = useConnection;
		Enumeration enum = subreportParameters.elements();
		while (enum.hasMoreElements())
		{
			JRParameter jp = (JRParameter)enum.nextElement();
			newReportElement.subreportParameters.addElement(jp.cloneMe());
		}	
		
		return newReportElement;
	}
}
