/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ValueReferencePtg
extends Ptg {
    private static final int SIZE = 5;
    public static final byte sid = 68;
    private short field_1_row;
    private short field_2_col;
    private BitField rowRelative = new BitField(32768);
    private BitField colRelative = new BitField(16384);

    public ValueReferencePtg() {
    }

    public ValueReferencePtg(byte[] data, int offset) {
        this.field_1_row = LittleEndian.getShort(data, ++offset + 0);
        this.field_2_col = LittleEndian.getShort(data, offset + 2);
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[ValueReferencePtg]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumnRaw()).append("\n");
        buffer.append("rowrelative = ").append(this.isRowRelative()).append("\n");
        buffer.append("colrelative = ").append(this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public short getRow() {
        return this.field_1_row;
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_2_col);
    }

    public boolean isColRelative() {
        return this.rowRelative.isSet(this.field_2_col);
    }

    public void setColumnRaw(short col) {
        this.field_2_col = col;
    }

    public short getColumnRaw() {
        return this.field_2_col;
    }

    public void setColumn(short col) {
        this.field_2_col = col;
    }

    public short getColumn() {
        return this.field_2_col;
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString() {
        return "NO IDEA YET VALUE REF";
    }
}

