/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.ElementTags;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Phrase;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.markup.MarkupParser;
import java.util.Hashtable;
import java.util.Properties;

public class Paragraph
extends Phrase
implements TextElementArray,
MarkupAttributes {
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    protected boolean keeptogether = false;

    public Paragraph() {
    }

    public Paragraph(float f) {
        super(f);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float f, Chunk chunk) {
        super(f, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float f, String string) {
        super(f, string);
    }

    public Paragraph(float f, String string, Font font) {
        super(f, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase.leading, "", phrase.font());
        super.add(phrase);
    }

    public Paragraph(Properties properties) {
        this("", FontFactory.getFont(properties));
        String string = (String)((Hashtable)properties).remove("itext");
        if (string != null) {
            Chunk chunk = new Chunk(string);
            string = (String)((Hashtable)properties).remove(ElementTags.GENERICTAG);
            if (string != null) {
                chunk.setGenericTag(string);
            }
            this.add(chunk);
        }
        if ((string = (String)((Hashtable)properties).remove("align")) != null) {
            this.setAlignment(string);
        }
        if ((string = (String)((Hashtable)properties).remove("leading")) != null) {
            this.setLeading(Float.valueOf(string + "f").floatValue());
        } else {
            string = (String)((Hashtable)properties).remove("line-height");
            if (string != null) {
                this.setLeading(MarkupParser.parseLength(string));
            } else {
                this.setLeading(16.0f);
            }
        }
        string = (String)((Hashtable)properties).remove("indentationleft");
        if (string != null) {
            this.setIndentationLeft(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(string + "f").floatValue());
        }
        if ((string = (String)((Hashtable)properties).remove("keeptogether")) != null) {
            this.keeptogether = new Boolean(string);
        }
        if (((Hashtable)properties).size() > 0) {
            this.setMarkupAttributes(properties);
        }
    }

    public int type() {
        return 12;
    }

    public boolean add(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            list.setIndentationLeft(list.indentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (object instanceof Image) {
            super.addSpecial((Image)object);
            return true;
        }
        if (object instanceof Paragraph) {
            super.add(object);
            super.add(Chunk.NEWLINE);
            return true;
        }
        return super.add(object);
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final void setAlignment(String string) {
        if ("Center".equalsIgnoreCase(string)) {
            this.alignment = 1;
            return;
        }
        if ("Right".equalsIgnoreCase(string)) {
            this.alignment = 2;
            return;
        }
        if ("Justify".equalsIgnoreCase(string)) {
            this.alignment = 3;
            return;
        }
        this.alignment = 0;
    }

    public final void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public final void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public final void setKeepTogether(boolean bl) {
        this.keeptogether = bl;
    }

    public final boolean getKeepTogether() {
        return this.keeptogether;
    }

    public final int alignment() {
        return this.alignment;
    }

    public final float indentationLeft() {
        return this.indentationLeft;
    }

    public final float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isTag(String string) {
        return "paragraph".equals(string);
    }
}

