/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PRObject;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class PRArray
extends PRObject {
    protected ArrayList arrayList;

    PRArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    PRArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    PRArray(PRArray pRArray) {
        super(5);
        this.arrayList = new ArrayList(pRArray.getArrayList());
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        try {
            PdfObject pdfObject;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(91);
            Iterator iterator = ((AbstractList)this.arrayList).iterator();
            if (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(pdfObject.toPdf(pdfWriter));
            }
            while (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(32);
                byteArrayOutputStream.write(pdfObject.toPdf(pdfWriter));
            }
            byteArrayOutputStream.write(93);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    final ArrayList getArrayList() {
        return this.arrayList;
    }

    public final int size() {
        return this.arrayList.size();
    }

    boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    void addFirst(PRObject pRObject) {
        this.arrayList.add(0, pRObject);
    }

    final boolean contains(PRObject pRObject) {
        return this.arrayList.contains(pRObject);
    }

    final Object[] toArray() {
        return this.arrayList.toArray();
    }
}

