/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfFormField
extends PdfAnnotation {
    public static final int FF_READ_ONLY = 1;
    public static final int FF_REQUIRED = 2;
    public static final int FF_NO_EXPORT = 4;
    public static final int FF_NO_TOGGLE_TO_OFF = 16384;
    public static final int FF_RADIO = 32768;
    public static final int FF_PUSHBUTTON = 65536;
    public static final int FF_MULTILINE = 4096;
    public static final int FF_PASSWORD = 8192;
    public static final int FF_COMBO = 131072;
    public static final int FF_EDIT = 262144;
    public static final int Q_LEFT = 0;
    public static final int Q_CENTER = 1;
    public static final int Q_RIGHT = 2;
    public static final int MK_NO_ICON = 0;
    public static final int MK_NO_CAPTION = 1;
    public static final int MK_CAPTION_BELOW = 2;
    public static final int MK_CAPTION_ABOVE = 3;
    public static final int MK_CAPTION_RIGHT = 4;
    public static final int MK_CAPTION_LEFT = 5;
    public static final int MK_CAPTION_OVERLAID = 6;
    public static final PdfName IF_SCALE_ALWAYS = PdfName.A;
    public static final PdfName IF_SCALE_BIGGER = PdfName.B;
    public static final PdfName IF_SCALE_SMALLER = PdfName.S;
    public static final PdfName IF_SCALE_NEVER = PdfName.N;
    public static final PdfName IF_SCALE_ANAMORPHIC = PdfName.A;
    public static final PdfName IF_SCALE_PROPORTIONAL = PdfName.P;
    public static final boolean MULTILINE = true;
    public static final boolean SINGLELINE = false;
    public static final boolean PLAINTEXT = false;
    public static final boolean PASSWORD = true;
    static PdfName[] mergeTarget = new PdfName[]{PdfName.FONT, PdfName.XOBJECT, PdfName.COLORSPACE, PdfName.PATTERN};
    protected PdfFormField parent;
    protected ArrayList kids;

    public PdfFormField(PdfWriter pdfWriter, float f, float f2, float f3, float f4, PdfAction pdfAction) {
        super(pdfWriter, f, f2, f3, f4, pdfAction);
        this.put(PdfName.TYPE, PdfName.ANNOT);
        this.put(PdfName.SUBTYPE, PdfName.WIDGET);
        this.annotation = true;
    }

    protected PdfFormField(PdfWriter pdfWriter) {
        super(pdfWriter, null);
        this.form = true;
        this.annotation = false;
    }

    public void setWidget(Rectangle rectangle, PdfName pdfName) {
        this.put(PdfName.TYPE, PdfName.ANNOT);
        this.put(PdfName.SUBTYPE, PdfName.WIDGET);
        this.put(PdfName.RECT, new PdfRectangle(rectangle));
        this.annotation = true;
        if (!pdfName.equals(PdfAnnotation.HIGHLIGHT_INVERT)) {
            this.put(PdfName.H, pdfName);
        }
    }

    public static PdfFormField createEmpty(PdfWriter pdfWriter) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        return pdfFormField;
    }

    public void setButton(int n) {
        this.put(PdfName.FT, PdfName.BTN);
        if (n != 0) {
            this.put(PdfName.FF, new PdfNumber(n));
        }
    }

    protected static PdfFormField createButton(PdfWriter pdfWriter, int n) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.setButton(n);
        return pdfFormField;
    }

    public static PdfFormField createPushButton(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 65536);
    }

    public static PdfFormField createCheckBox(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 0);
    }

    public static PdfFormField createRadioButton(PdfWriter pdfWriter, boolean bl) {
        return PdfFormField.createButton(pdfWriter, 32768 + (bl ? 16384 : 0));
    }

    public static PdfFormField createTextField(PdfWriter pdfWriter, boolean bl, boolean bl2, int n) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.TX);
        int n2 = bl ? 4096 : 0;
        pdfFormField.put(PdfName.FF, new PdfNumber(n2 += bl2 ? 8192 : 0));
        if (n > 0) {
            pdfFormField.put(PdfName.MAXLEN, new PdfNumber(n));
        }
        return pdfFormField;
    }

    protected static PdfFormField createChoice(PdfWriter pdfWriter, int n, PdfArray pdfArray, int n2) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.CH);
        pdfFormField.put(PdfName.FF, new PdfNumber(n));
        pdfFormField.put(PdfName.OPT, pdfArray);
        if (n2 > 0) {
            pdfFormField.put(PdfName.TI, new PdfNumber(n2));
        }
        return pdfFormField;
    }

    public static PdfFormField createList(PdfWriter pdfWriter, String[] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n);
    }

    public static PdfFormField createList(PdfWriter pdfWriter, String[][] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n);
    }

    public static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl, String[] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl ? 262144 : 0), PdfFormField.processOptions(stringArray), n);
    }

    public static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl, String[][] stringArray, int n) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl ? 262144 : 0), PdfFormField.processOptions(stringArray), n);
    }

    protected static PdfArray processOptions(String[] stringArray) {
        PdfArray pdfArray = new PdfArray();
        int n = 0;
        while (n < stringArray.length) {
            pdfArray.add(new PdfString(stringArray[n], "UnicodeBig"));
            ++n;
        }
        return pdfArray;
    }

    protected static PdfArray processOptions(String[][] stringArray) {
        PdfArray pdfArray = new PdfArray();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n];
            PdfArray pdfArray2 = new PdfArray(new PdfString(stringArray2[0], "UnicodeBig"));
            pdfArray2.add(new PdfString(stringArray2[1], "UnicodeBig"));
            pdfArray.add(pdfArray2);
            ++n;
        }
        return pdfArray;
    }

    public static PdfFormField createSignature(PdfWriter pdfWriter) {
        PdfFormField pdfFormField = new PdfFormField(pdfWriter);
        pdfFormField.put(PdfName.FT, PdfName.SIG);
        pdfFormField.put(PdfName.FF, new PdfNumber(0));
        pdfWriter.setSigFlags(1);
        return pdfFormField;
    }

    public PdfFormField getParent() {
        return this.parent;
    }

    public void addKid(PdfFormField pdfFormField) {
        pdfFormField.parent = this;
        if (this.kids == null) {
            this.kids = new ArrayList();
        }
        this.kids.add(pdfFormField);
    }

    ArrayList getKids() {
        return this.kids;
    }

    public int setFieldFlags(int n) {
        PdfNumber pdfNumber = (PdfNumber)this.get(PdfName.FF);
        int n2 = pdfNumber == null ? 0 : pdfNumber.intValue();
        int n3 = n2 | n;
        this.put(PdfName.FF, new PdfNumber(n3));
        return n2;
    }

    public void setValueAsStringUnicode(String string) {
        this.put(PdfName.V, new PdfString(string, "UnicodeBig"));
    }

    public void setValueAsString(String string) {
        this.put(PdfName.V, new PdfString(string));
    }

    public void setValueAsName(String string) {
        this.put(PdfName.V, new PdfName(string));
    }

    public void setValue(PdfSignature pdfSignature) {
        this.put(PdfName.V, pdfSignature);
    }

    public void setDefaultValueAsString(String string) {
        this.put(PdfName.DV, new PdfString(string));
    }

    public void setDefaultValueAsStringUnicode(String string) {
        this.put(PdfName.DV, new PdfString(string, "UnicodeBig"));
    }

    public void setDefaultValueAsName(String string) {
        this.put(PdfName.DV, new PdfName(string));
    }

    public void setFieldName(String string) {
        this.put(PdfName.T, new PdfString(string));
    }

    public void setUserName(String string) {
        this.put(PdfName.TU, new PdfString(string));
    }

    public void setMappingName(String string) {
        this.put(PdfName.TM, new PdfString(string));
    }

    public void setQuadding(int n) {
        this.put(PdfName.Q, new PdfNumber(n));
    }

    static void mergeResources(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        PdfDictionary pdfDictionary3 = null;
        PdfDictionary pdfDictionary4 = null;
        PdfName pdfName = null;
        int n = 0;
        while (n < mergeTarget.length) {
            pdfName = mergeTarget[n];
            pdfDictionary3 = (PdfDictionary)pdfDictionary2.get(pdfName);
            if (pdfDictionary3 != null) {
                pdfDictionary4 = (PdfDictionary)pdfDictionary.get(pdfName);
                if (pdfDictionary4 == null) {
                    pdfDictionary4 = new PdfDictionary();
                }
                pdfDictionary4.merge(pdfDictionary3);
                pdfDictionary.put(pdfName, pdfDictionary4);
            }
            ++n;
        }
    }

    void setUsed() {
        PdfObject pdfObject;
        this.used = true;
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.getIndirectReference());
        }
        if (this.kids != null) {
            pdfObject = new PdfArray();
            int n = 0;
            while (n < this.kids.size()) {
                ((PdfArray)pdfObject).add(((PdfFormField)this.kids.get(n)).getIndirectReference());
                ++n;
            }
            this.put(PdfName.KIDS, pdfObject);
        }
        if (this.templates == null) {
            return;
        }
        pdfObject = new PdfDictionary();
        Iterator iterator = this.templates.keySet().iterator();
        while (iterator.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)iterator.next();
            PdfFormField.mergeResources((PdfDictionary)pdfObject, (PdfDictionary)pdfTemplate.getResources());
        }
        this.put(PdfName.DR, pdfObject);
    }

    PdfDictionary getMK() {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.MK);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.MK, pdfDictionary);
        }
        return pdfDictionary;
    }

    public void setMKRotation(int n) {
        this.getMK().put(PdfName.R, new PdfNumber(n));
    }

    PdfArray getMKColor(Color color) {
        PdfArray pdfArray = new PdfArray();
        int n = ExtendedColor.getType(color);
        switch (n) {
            case 1: {
                pdfArray.add(new PdfNumber(((GrayColor)color).getGray()));
                break;
            }
            case 2: {
                CMYKColor cMYKColor = (CMYKColor)color;
                pdfArray.add(new PdfNumber(cMYKColor.getCyan()));
                pdfArray.add(new PdfNumber(cMYKColor.getMagenta()));
                pdfArray.add(new PdfNumber(cMYKColor.getYellow()));
                pdfArray.add(new PdfNumber(cMYKColor.getBlack()));
                break;
            }
            case 3: 
            case 4: {
                throw new RuntimeException("Separations and patterns not allowed in MK dictionary.");
            }
            default: {
                pdfArray.add(new PdfNumber((float)color.getRed() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getGreen() / 255.0f));
                pdfArray.add(new PdfNumber((float)color.getBlue() / 255.0f));
            }
        }
        return pdfArray;
    }

    public void setMKBorderColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BC);
        } else {
            this.getMK().put(PdfName.BC, this.getMKColor(color));
        }
    }

    public void setMKBackgroundColor(Color color) {
        if (color == null) {
            this.getMK().remove(PdfName.BG);
        } else {
            this.getMK().put(PdfName.BG, this.getMKColor(color));
        }
    }

    public void setMKNormalCaption(String string) {
        this.getMK().put(PdfName.CA, new PdfString(string, "UnicodeBig"));
    }

    public void setMKRolloverCaption(String string) {
        this.getMK().put(PdfName.RC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKAlternateCaption(String string) {
        this.getMK().put(PdfName.AC, new PdfString(string, "UnicodeBig"));
    }

    public void setMKNormalIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.I, pdfTemplate.getIndirectReference());
    }

    public void setMKRolloverIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.RI, pdfTemplate.getIndirectReference());
    }

    public void setMKAlternateIcon(PdfTemplate pdfTemplate) {
        this.getMK().put(PdfName.IX, pdfTemplate.getIndirectReference());
    }

    public void setMKIconFit(PdfName pdfName, PdfName pdfName2, float f, float f2) {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (!pdfName.equals(PdfName.A)) {
            pdfDictionary.put(PdfName.SW, pdfName);
        }
        if (!pdfName2.equals(PdfName.P)) {
            pdfDictionary.put(PdfName.S, pdfName2);
        }
        if (f != 0.5f || f2 != 0.5f) {
            PdfArray pdfArray = new PdfArray(new PdfNumber(f));
            pdfArray.add(new PdfNumber(f2));
            pdfDictionary.put(PdfName.A, pdfArray);
        }
        this.getMK().put(PdfName.IF, pdfDictionary);
    }

    public void setMKTextPosition(int n) {
        this.getMK().put(PdfName.TP, new PdfNumber(n));
    }

    public static PdfAnnotation shallowDuplicate(PdfAnnotation pdfAnnotation) {
        PdfAnnotation pdfAnnotation2;
        if (pdfAnnotation.isForm()) {
            pdfAnnotation2 = new PdfFormField(pdfAnnotation.writer);
            PdfFormField pdfFormField = pdfAnnotation2;
            PdfFormField pdfFormField2 = (PdfFormField)pdfAnnotation;
            pdfFormField.parent = pdfFormField2.parent;
            pdfFormField.kids = pdfFormField2.kids;
        } else {
            pdfAnnotation2 = new PdfAnnotation(pdfAnnotation.writer, null);
        }
        pdfAnnotation2.merge(pdfAnnotation);
        pdfAnnotation2.form = pdfAnnotation.form;
        pdfAnnotation2.annotation = pdfAnnotation.annotation;
        pdfAnnotation2.templates = pdfAnnotation.templates;
        return pdfAnnotation2;
    }
}

