/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate pdfTemplate) {
        this.dictionary.put(PdfName.TYPE, PdfName.XOBJECT);
        this.dictionary.put(PdfName.SUBTYPE, PdfName.FORM);
        this.dictionary.put(PdfName.RESOURCES, pdfTemplate.getResources());
        this.dictionary.put(PdfName.BBOX, new PdfRectangle(pdfTemplate.getBoundingBox()));
        this.dictionary.put(PdfName.FORMTYPE, ONE);
        PdfArray pdfArray = pdfTemplate.getMatrix();
        if (pdfArray == null) {
            this.dictionary.put(PdfName.MATRIX, MATRIX);
        } else {
            this.dictionary.put(PdfName.MATRIX, pdfArray);
        }
        this.bytes = pdfTemplate.toPdf(null);
        this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        try {
            this.flateCompress();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

