/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

class PdfStream
extends PdfObject {
    protected PdfDictionary dictionary;
    protected boolean compressed = false;
    protected ByteArrayOutputStream streamBytes = null;
    protected byte[] dicBytes = null;
    static final byte[] STARTSTREAM = DocWriter.getISOBytes("\nstream\n");
    static final byte[] ENDSTREAM = DocWriter.getISOBytes("\nendstream");
    static final int SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;

    PdfStream(PdfDictionary pdfDictionary, String string) {
        super(7);
        this.dictionary = pdfDictionary;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(10, n) + 1;
            int n4 = n3 - n;
            if (n4 < 250 && n4 > 0) {
                stringBuffer.append(string.substring(n, n3));
                n = n3;
                continue;
            }
            try {
                stringBuffer.append(string.substring(n, n + 250) + "\n");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                stringBuffer.append(string.substring(n) + "\n");
            }
            n += 250;
        }
        this.setContent(stringBuffer.toString());
        pdfDictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
    }

    PdfStream(byte[] byArray) {
        super(7);
        this.dictionary = new PdfDictionary();
        this.bytes = byArray;
        this.dictionary.put(PdfName.LENGTH, new PdfNumber(byArray.length));
    }

    PdfStream(String string) {
        this(new PdfDictionary(), string);
    }

    protected PdfStream() {
        super(7);
        this.dictionary = new PdfDictionary();
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        this.dicBytes = this.dictionary.toPdf(pdfWriter);
        return null;
    }

    final synchronized void flateCompress() throws PdfException {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        PdfObject pdfObject = this.dictionary.get(PdfName.FILTER);
        if (pdfObject != null) {
            if (pdfObject.isName() && ((PdfName)pdfObject).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (pdfObject.isArray() && ((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new PdfException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(deflaterOutputStream);
            } else {
                deflaterOutputStream.write(this.bytes);
            }
            deflaterOutputStream.close();
            this.streamBytes = byteArrayOutputStream;
            this.bytes = null;
            this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (pdfObject == null) {
                this.dictionary.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray pdfArray = new PdfArray(pdfObject);
                pdfArray.add(PdfName.FLATEDECODE);
                this.dictionary.put(PdfName.FILTER, pdfArray);
            }
            this.compressed = true;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    int getStreamLength(PdfWriter pdfWriter) {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        if (this.streamBytes != null) {
            return this.streamBytes.size() + this.dicBytes.length + SIZESTREAM;
        }
        return this.bytes.length + this.dicBytes.length + SIZESTREAM;
    }

    void writeTo(OutputStream outputStream, PdfWriter pdfWriter) throws IOException {
        if (this.dicBytes == null) {
            this.toPdf(pdfWriter);
        }
        outputStream.write(this.dicBytes);
        outputStream.write(STARTSTREAM);
        PdfEncryption pdfEncryption = pdfWriter.getEncryption();
        if (pdfEncryption == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(outputStream);
            } else {
                outputStream.write(this.bytes);
            }
        } else {
            byte[] byArray;
            pdfEncryption.prepareKey();
            if (this.streamBytes != null) {
                byArray = this.streamBytes.toByteArray();
                pdfEncryption.encryptRC4(byArray);
            } else {
                byArray = new byte[this.bytes.length];
                pdfEncryption.encryptRC4(this.bytes, byArray);
            }
            outputStream.write(byArray);
        }
        outputStream.write(ENDSTREAM);
    }
}

