/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.afm.Courier;
import com.lowagie.text.pdf.afm.CourierBold;
import com.lowagie.text.pdf.afm.CourierBoldOblique;
import com.lowagie.text.pdf.afm.CourierOblique;
import com.lowagie.text.pdf.afm.Helvetica1;
import com.lowagie.text.pdf.afm.Helvetica2;
import com.lowagie.text.pdf.afm.HelveticaBold1;
import com.lowagie.text.pdf.afm.HelveticaBold2;
import com.lowagie.text.pdf.afm.HelveticaBoldOblique1;
import com.lowagie.text.pdf.afm.HelveticaBoldOblique2;
import com.lowagie.text.pdf.afm.HelveticaOblique1;
import com.lowagie.text.pdf.afm.HelveticaOblique2;
import com.lowagie.text.pdf.afm.Symbol;
import com.lowagie.text.pdf.afm.TimesBold;
import com.lowagie.text.pdf.afm.TimesBoldItalic;
import com.lowagie.text.pdf.afm.TimesItalic1;
import com.lowagie.text.pdf.afm.TimesItalic2;
import com.lowagie.text.pdf.afm.TimesRoman;
import com.lowagie.text.pdf.afm.ZapfDingbats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class Type1Font
extends BaseFont {
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight;
    private float ItalicAngle;
    private boolean IsFixedPitch;
    private String CharacterSet;
    private int llx;
    private int lly;
    private int urx;
    private int ury;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private String EncodingScheme;
    private int CapHeight;
    private int XHeight;
    private int Ascender;
    private int Descender;
    private int StdHW;
    private int StdVW;
    private ArrayList CharMetrics;
    private HashMap KernPairs;
    private String fileName;
    private boolean builtinFont;
    private static final int[] pfbTypes = new int[]{1, 2, 1};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Type1Font(String string, String string2, boolean bl, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        block43: {
            this.Weight = "";
            this.ItalicAngle = 0.0f;
            this.IsFixedPitch = false;
            this.llx = -50;
            this.lly = -200;
            this.urx = 1000;
            this.ury = 900;
            this.UnderlinePosition = -100;
            this.UnderlineThickness = 50;
            this.EncodingScheme = "FontSpecific";
            this.CapHeight = 700;
            this.XHeight = 480;
            this.Ascender = 800;
            this.Descender = -200;
            this.StdVW = 80;
            this.CharMetrics = new ArrayList();
            this.KernPairs = new HashMap();
            this.builtinFont = false;
            if (bl && byArray != null && byArray2 == null) {
                throw new DocumentException("Two byte arrays are needed if the Type1 font is embedded.");
            }
            if (bl && byArray != null) {
                this.pfb = byArray2;
            }
            this.encoding = string2;
            this.embedded = bl;
            this.fileName = string;
            this.fontType = 0;
            RandomAccessFileOrArray randomAccessFileOrArray = null;
            if (BaseFont.BuiltinFonts14.containsKey(string)) {
                this.embedded = false;
                this.builtinFont = true;
                try {
                    String string3 = null;
                    if (string.equals("Courier")) {
                        string3 = Courier.afm;
                    } else if (string.equals("Courier-Bold")) {
                        string3 = CourierBold.afm;
                    } else if (string.equals("Courier-BoldOblique")) {
                        string3 = CourierBoldOblique.afm;
                    } else if (string.equals("Courier-Oblique")) {
                        string3 = CourierOblique.afm;
                    } else if (string.equals("Helvetica-Bold")) {
                        string3 = HelveticaBold1.afm;
                        string3 = string3 + HelveticaBold2.afm;
                    } else if (string.equals("Helvetica-BoldOblique")) {
                        string3 = HelveticaBoldOblique1.afm;
                        string3 = string3 + HelveticaBoldOblique2.afm;
                    } else if (string.equals("Helvetica-Oblique")) {
                        string3 = HelveticaOblique1.afm;
                        string3 = string3 + HelveticaOblique2.afm;
                    } else if (string.equals("Symbol")) {
                        string3 = Symbol.afm;
                    } else if (string.equals("Times-Roman")) {
                        string3 = TimesRoman.afm;
                    } else if (string.equals("Times-Bold")) {
                        string3 = TimesBold.afm;
                    } else if (string.equals("Times-BoldItalic")) {
                        string3 = TimesBoldItalic.afm;
                    } else if (string.equals("Times-Italic")) {
                        string3 = TimesItalic1.afm;
                        string3 = string3 + TimesItalic2.afm;
                    } else if (string.equals("ZapfDingbats")) {
                        string3 = ZapfDingbats.afm;
                    } else {
                        string3 = Helvetica1.afm;
                        string3 = string3 + Helvetica2.afm;
                    }
                    randomAccessFileOrArray = new RandomAccessFileOrArray(string3.getBytes("ISO-8859-1"));
                    this.process(randomAccessFileOrArray);
                    Object var9_8 = null;
                    if (randomAccessFileOrArray == null) break block43;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (randomAccessFileOrArray == null) throw throwable;
                    try {
                        randomAccessFileOrArray.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                randomAccessFileOrArray.close();
            } else {
                if (!string.toLowerCase().endsWith(".afm")) throw new DocumentException(string + " is not an AFM font file.");
                try {
                    randomAccessFileOrArray = byArray == null ? new RandomAccessFileOrArray(string) : new RandomAccessFileOrArray(byArray);
                    this.process(randomAccessFileOrArray);
                    Object var12_13 = null;
                    if (randomAccessFileOrArray == null) break block43;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (randomAccessFileOrArray == null) throw throwable;
                    try {
                        randomAccessFileOrArray.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                randomAccessFileOrArray.close();
            }
        }
        try {
            this.EncodingScheme = this.EncodingScheme.trim();
            if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
                this.fontSpecific = false;
            }
            " ".getBytes(string2);
            this.createEncoding();
            return;
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    protected int getRawWidth(int n, String string) {
        try {
            if (string == null) {
                int n2 = 0;
                while (n2 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n2);
                    if ((Integer)objectArray[0] == n) {
                        return (Integer)objectArray[1];
                    }
                    ++n2;
                }
            } else {
                if (string.equals(".notdef")) {
                    return 0;
                }
                int n3 = 0;
                while (n3 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n3);
                    if (string.equals(objectArray[2])) {
                        return (Integer)objectArray[1];
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return 0;
    }

    public int getKerning(char c, char c2) {
        String string = GlyphList.unicodeToName(c);
        if (string == null) {
            return 0;
        }
        String string2 = GlyphList.unicodeToName(c2);
        if (string2 == null) {
            return 0;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (string2.equals(objectArray[n])) {
                return (Integer)objectArray[n + 1];
            }
            n += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void process(RandomAccessFileOrArray var1_1) throws DocumentException, IOException {
        var3_2 = false;
        while ((var2_3 = var1_1.readLine()) != null) {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("FontName")) {
                this.FontName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FullName")) {
                this.FullName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FamilyName")) {
                this.FamilyName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("Weight")) {
                this.Weight = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("ItalicAngle")) {
                this.ItalicAngle = Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("IsFixedPitch")) {
                this.IsFixedPitch = var4_4.nextToken().equals("true");
                continue;
            }
            if (var5_5.equals("CharacterSet")) {
                this.CharacterSet = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FontBBox")) {
                this.llx = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.lly = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.urx = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.ury = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("EncodingScheme")) {
                this.EncodingScheme = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("CapHeight")) {
                this.CapHeight = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("XHeight")) {
                this.XHeight = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("Ascender")) {
                this.Ascender = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("Descender")) {
                this.Descender = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("StdHW")) {
                this.StdHW = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("StdVW")) {
                this.StdVW = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (!var5_5.equals("StartCharMetrics")) continue;
            var3_2 = true;
            break;
        }
        if (var3_2) ** GOTO lbl90
        throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("EndCharMetrics")) {
                var3_2 = false;
                break;
            }
            var6_6 = new Integer(-1);
            var7_7 = new Integer(250);
            var8_8 = "";
            var4_4 = new StringTokenizer(var2_3, ";");
            while (var4_4.hasMoreTokens()) {
                var9_9 = new StringTokenizer(var4_4.nextToken());
                if (!var9_9.hasMoreTokens()) continue;
                var5_5 = var9_9.nextToken();
                if (var5_5.equals("C")) {
                    var6_6 = Integer.valueOf(var9_9.nextToken());
                    continue;
                }
                if (var5_5.equals("WX")) {
                    var7_7 = Integer.valueOf(var9_9.nextToken());
                    continue;
                }
                if (!var5_5.equals("N")) continue;
                var8_8 = var9_9.nextToken();
            }
            this.CharMetrics.add(new Object[]{var6_6, var7_7, var8_8});
lbl90:
            // 3 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl91:
        // 2 sources

        if (!var3_2) ** GOTO lbl101
        throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("EndFontMetrics")) {
                return;
            }
            if (!var5_5.equals("StartKernPairs")) continue;
            var3_2 = true;
            break;
lbl101:
            // 3 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl102:
        // 2 sources

        if (var3_2) ** GOTO lbl127
        throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("KPX")) {
                var6_6 = var4_4.nextToken();
                var7_7 = var4_4.nextToken();
                var8_8 = new Integer((int)Float.valueOf(var4_4.nextToken()).floatValue());
                var9_9 = (Object[])this.KernPairs.get(var6_6);
                if (var9_9 == null) {
                    this.KernPairs.put(var6_6, new Object[]{var7_7, var8_8});
                    continue;
                }
                var10_10 = var9_9.length;
                var11_11 = new Object[var10_10 + 2];
                System.arraycopy(var9_9, 0, var11_11, 0, var10_10);
                var11_11[var10_10] = var7_7;
                var11_11[var10_10 + 1] = var8_8;
                this.KernPairs.put(var6_6, var11_11);
                continue;
            }
            if (!var5_5.equals("EndKernPairs")) continue;
            var3_2 = false;
            break;
lbl127:
            // 5 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl128:
        // 2 sources

        if (var3_2) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        var1_1.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        if (this.builtinFont) return null;
        if (!this.embedded) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        try {
            try {
                String string = this.fileName.substring(0, this.fileName.length() - 3) + "pfb";
                randomAccessFileOrArray = this.pfb == null ? new RandomAccessFileOrArray(string) : new RandomAccessFileOrArray(this.pfb);
                int n = randomAccessFileOrArray.length();
                byte[] byArray = new byte[n - 18];
                int[] nArray = new int[3];
                int n2 = 0;
                int n3 = 0;
                block7: while (true) {
                    if (n3 >= 3) break;
                    if (randomAccessFileOrArray.read() != 128) {
                        throw new DocumentException("Start marker missing in " + string);
                    }
                    if (randomAccessFileOrArray.read() != pfbTypes[n3]) {
                        throw new DocumentException("Incorrect segment type in " + string);
                    }
                    int n4 = randomAccessFileOrArray.read();
                    n4 += randomAccessFileOrArray.read() << 8;
                    n4 += randomAccessFileOrArray.read() << 16;
                    nArray[n3] = n4 += randomAccessFileOrArray.read() << 24;
                    while (true) {
                        if (n4 == 0) {
                            ++n3;
                            continue block7;
                        }
                        int n5 = randomAccessFileOrArray.read(byArray, n2, n4);
                        if (n5 < 0) {
                            throw new DocumentException("Premature end in " + string);
                        }
                        n2 += n5;
                        n4 -= n5;
                    }
                    break;
                }
                BaseFont.StreamFont streamFont = new BaseFont.StreamFont(byArray, nArray);
                Object var11_12 = null;
                if (randomAccessFileOrArray == null) return streamFont;
                try {
                    randomAccessFileOrArray.close();
                    return streamFont;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return streamFont;
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (randomAccessFileOrArray == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            randomAccessFileOrArray.close();
            throw throwable;
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference) throws DocumentException {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfNumber(this.Ascender));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfNumber(this.CapHeight));
        pdfDictionary.put(new PdfName("Descent"), new PdfNumber(this.Descender));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(this.FontName));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfNumber(this.ItalicAngle));
        pdfDictionary.put(new PdfName("StemV"), new PdfNumber(this.StdVW));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontFile"), pdfIndirectReference);
        }
        int n = 0;
        if (this.IsFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            n |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            n |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            n |= 0x40000;
        }
        pdfDictionary.put(new PdfName("Flags"), new PdfNumber(n));
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, int n, int n2, byte[] byArray) throws DocumentException {
        boolean bl;
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl2 = bl = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific) {
            int n3 = n;
            while (n3 <= n2) {
                if (!this.differences[n3].equals(".notdef")) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (bl) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(new PdfName("Encoding"));
                PdfArray pdfArray = new PdfArray();
                boolean bl3 = true;
                int n4 = n;
                while (n4 <= n2) {
                    if (byArray[n4] != 0) {
                        if (bl3) {
                            pdfArray.add(new PdfNumber(n4));
                            bl3 = false;
                        }
                        pdfArray.add(new PdfName(this.differences[n4]));
                    } else {
                        bl3 = true;
                    }
                    ++n4;
                }
                pdfDictionary2.put(new PdfName("Differences"), pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        if (this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !bl) {
            pdfDictionary.put(new PdfName("FirstChar"), new PdfNumber(n));
            pdfDictionary.put(new PdfName("LastChar"), new PdfNumber(n2));
            PdfArray pdfArray = new PdfArray();
            int n5 = n;
            while (n5 <= n2) {
                if (byArray[n5] == 0) {
                    pdfArray.add(new PdfNumber(0));
                } else {
                    pdfArray.add(new PdfNumber(this.widths[n5]));
                }
                ++n5;
            }
            pdfDictionary.put(new PdfName("Widths"), pdfArray);
        }
        if (!this.builtinFont && pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        }
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        if (!this.subset) {
            n = 0;
            n2 = byArray.length - 1;
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = 1;
                ++n3;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfObject pdfObject = null;
        PdfIndirectObject pdfIndirectObject = null;
        pdfObject = this.getFontStream();
        if (pdfObject != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfObject);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfObject = this.getFontDescriptor(pdfIndirectReference2)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfObject);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfObject = this.getFontBaseType(pdfIndirectReference2, n, n2, byArray);
        pdfWriter.addToBody(pdfObject, pdfIndirectReference);
    }

    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: 
            case 9: {
                return (float)this.Ascender * f / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * f / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * f / 1000.0f;
            }
            case 6: {
                return (float)this.lly * f / 1000.0f;
            }
            case 7: {
                return (float)this.urx * f / 1000.0f;
            }
            case 8: {
                return (float)this.ury * f / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * f / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.FontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }
}

