/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.wmf.InputMeta;
import com.lowagie.text.pdf.wmf.MetaBrush;
import com.lowagie.text.pdf.wmf.MetaFont;
import com.lowagie.text.pdf.wmf.MetaObject;
import com.lowagie.text.pdf.wmf.MetaPen;
import com.lowagie.text.pdf.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    int left;
    int top;
    int right;
    int bottom;
    int inch;
    MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n = this.in.getLength();
            int n2 = this.in.readInt();
            if (n2 < 3) break;
            int n3 = this.in.readWord();
            switch (n3) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n4 = this.in.readWord();
                    this.state.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    int n5 = this.in.readWord();
                    this.state.deleteMetaObject(n5);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n6 = this.in.readShort();
                    this.state.restoreState(n6, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n7 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n7);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n9), this.state.transformY(n8));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n9, n8));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n10 = this.in.readWord();
                    int n11 = this.in.readShort();
                    int n12 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n11), this.state.transformY(n12));
                    int n13 = 1;
                    while (n13 < n10) {
                        n11 = this.in.readShort();
                        n12 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n11), this.state.transformY(n12));
                        ++n13;
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    int n14;
                    int n15;
                    if (this.isNullStrokeFill(false)) break;
                    int n16 = this.in.readWord();
                    int n17 = this.in.readShort();
                    int n18 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n17), this.state.transformY(n18));
                    int n19 = 1;
                    while (n19 < n16) {
                        n15 = this.in.readShort();
                        n14 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n15), this.state.transformY(n14));
                        ++n19;
                    }
                    this.cb.lineTo(this.state.transformX(n17), this.state.transformY(n18));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n20;
                    int n21;
                    int n22;
                    int n14;
                    int n15;
                    if (this.isNullStrokeFill(false)) break;
                    int n23 = this.in.readWord();
                    int[] nArray = new int[n23];
                    int n24 = 0;
                    while (n24 < nArray.length) {
                        nArray[n24] = this.in.readWord();
                        ++n24;
                    }
                    int n25 = 0;
                    while (n25 < nArray.length) {
                        n15 = nArray[n25];
                        n14 = this.in.readShort();
                        n22 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n14), this.state.transformY(n22));
                        n21 = 1;
                        while (n21 < n15) {
                            int n26 = this.in.readShort();
                            n20 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n26), this.state.transformY(n20));
                            ++n21;
                        }
                        this.cb.lineTo(this.state.transformX(n14), this.state.transformY(n22));
                        ++n25;
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n27 = this.in.readShort();
                    int n28 = this.in.readShort();
                    int n29 = this.in.readShort();
                    int n30 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n30), this.state.transformY(n27), this.state.transformX(n28), this.state.transformY(n29), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f = this.state.transformY(this.in.readShort());
                    float f2 = this.state.transformX(this.in.readShort());
                    float f3 = this.state.transformY(this.in.readShort());
                    float f4 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f4, f, f2 - f4, f3 - f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f = this.state.transformY(this.in.readShort());
                    float f5 = this.state.transformX(this.in.readShort());
                    float f6 = this.state.transformY(this.in.readShort());
                    float f7 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f7, f, f5 - f7, f6 - f);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    int n31 = this.in.readShort();
                    int n32 = this.in.readShort();
                    int n33 = this.in.readWord();
                    int n34 = this.in.readWord();
                    int n15 = 0;
                    int n14 = 0;
                    int n22 = 0;
                    int n21 = 0;
                    if ((n34 & 6) != 0) {
                        n15 = this.in.readShort();
                        n14 = this.in.readShort();
                        n22 = this.in.readShort();
                        n21 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n33];
                    int n20 = 0;
                    while (n20 < n33) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n20] = by;
                        ++n20;
                    }
                    try {
                        string = new String(byArray, 0, n20, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n20);
                    }
                    this.outputText(n32, n31, n34, n15, n14, n22, n21, string);
                    break;
                }
                case 1313: {
                    String string;
                    int n35 = this.in.readWord();
                    byte[] byArray = new byte[n35];
                    int n36 = 0;
                    while (n36 < n35) {
                        byte by = (byte)this.in.readByte();
                        if (by == 0) break;
                        byArray[n36] = by;
                        ++n36;
                    }
                    try {
                        string = new String(byArray, 0, n36, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n36);
                    }
                    n35 = n35 + 1 & 0xFFFE;
                    this.in.skip(n35 - n36);
                    int n15 = this.in.readShort();
                    int n14 = this.in.readShort();
                    this.outputText(n14, n15, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n37 = this.in.readShort();
                    int n38 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n38), this.state.transformY(n37), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                }
            }
            this.in.skip(n2 * 2 - (this.in.getLength() - n));
        }
    }

    public void outputText(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) throws IOException {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f = this.state.transformX(n);
        float f2 = this.state.transformY(n2);
        float f3 = (float)Math.sin(metaFont.getAngle());
        float f4 = (float)Math.cos(metaFont.getAngle());
        float f5 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n8 = this.state.getTextAlign();
        float f6 = baseFont.getWidthPoint(string, f5);
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = baseFont.getFontDescriptor(3, f5);
        float f10 = baseFont.getFontDescriptor(8, f5);
        this.cb.saveState();
        this.cb.concatCTM(f4, f3, -f3, f4, f, f2);
        if ((n8 & 6) == 6) {
            f7 = -f6 / 2.0f;
        } else if ((n8 & 2) == 2) {
            f7 = -f6;
        }
        f8 = (n8 & 0x18) == 24 ? 0.0f : ((n8 & 8) == 8 ? -f9 : -f10);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f7, f8 + f9, f6, f10 - f9);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f5);
        this.cb.setTextMatrix(f7, f8);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f7, f8 - f5 / 4.0f, f6, f5 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f7, f8 + f5 / 3.0f, f6, f5 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n = metaBrush.getStyle();
        boolean bl4 = n == 0 || n == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n = metaPen.getStyle();
        int n2 = metaBrush.getStyle();
        if (n == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }
}

