/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.rtf.RtfRow;
import com.lowagie.text.rtf.RtfTable;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class RtfCell {
    private static final int MERGE_HORIZ_FIRST = 1;
    private static final int MERGE_VERT_FIRST = 2;
    private static final int MERGE_BOTH_FIRST = 3;
    private static final int MERGE_HORIZ_PREV = 4;
    private static final int MERGE_VERT_PREV = 5;
    private static final int MERGE_BOTH_PREV = 6;
    private static final byte[] cellMergeFirst = "clmgf".getBytes();
    private static final byte[] cellVMergeFirst = "clvmgf".getBytes();
    private static final byte[] cellMergePrev = "clmrg".getBytes();
    private static final byte[] cellVMergePrev = "clvmrg".getBytes();
    private static final byte[] cellHorizontalAlignLeft = "ql".getBytes();
    private static final byte[] cellHorizontalAlignCenter = "qc".getBytes();
    private static final byte[] cellHorizontalAlignRight = "qr".getBytes();
    private static final byte[] cellHorizontalAlignJustified = "qj".getBytes();
    private static final byte[] cellVerticalAlignBottom = "clvertalb".getBytes();
    private static final byte[] cellVerticalAlignCenter = "clvertalc".getBytes();
    private static final byte[] cellVerticalAlignTop = "clvertalt".getBytes();
    private static final byte[] cellBorderLeft = "clbrdrl".getBytes();
    private static final byte[] cellBorderRight = "clbrdrr".getBytes();
    private static final byte[] cellBorderTop = "clbrdrt".getBytes();
    private static final byte[] cellBorderBottom = "clbrdrb".getBytes();
    private static final byte[] cellBackgroundColor = "clcbpat".getBytes();
    private static final byte[] cellWidthStyle = "clftsWidth3".getBytes();
    private static final byte[] cellWidthTag = "clwWidth".getBytes();
    private static final byte[] cellRightBorder = "cellx".getBytes();
    private static final byte[] cellInTable = "intbl".getBytes();
    private static final byte[] cellEnd = "cell".getBytes();
    private static final byte[] cellPaddingTop = "clpadt".getBytes();
    private static final byte[] cellPaddingTopUnit = "clpadft3".getBytes();
    private static final byte[] cellPaddingBottom = "clpadb".getBytes();
    private static final byte[] cellPaddingBottomUnit = "clpadfb3".getBytes();
    private static final byte[] cellPaddingLeft = "clpadl".getBytes();
    private static final byte[] cellPaddingLeftUnit = "clpadfl3".getBytes();
    private static final byte[] cellPaddingRight = "clpadr".getBytes();
    private static final byte[] cellPaddingRightUnit = "clpadfr3".getBytes();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int cellWidth = 0;
    private int cellRight = 0;
    private Cell store = null;
    private boolean emptyCell = true;
    private int mergeType = 0;
    private int cellpadding = 0;

    public RtfCell(RtfWriter rtfWriter, RtfTable rtfTable) {
        this.writer = rtfWriter;
        this.mainTable = rtfTable;
    }

    public int importCell(Cell cell, int n, int n2, int n3, int n4, int n5) {
        block10: {
            block9: {
                this.cellpadding = n5;
                this.cellWidth = n2;
                if (cell == null) {
                    this.cellRight = n + n2;
                    return this.cellRight;
                }
                if (cell.cellWidth() != null && !cell.cellWidth().equals("")) {
                    this.cellWidth = (int)((double)Integer.parseInt(cell.cellWidth()) * 20.5714);
                }
                this.cellRight = n + this.cellWidth;
                this.store = cell;
                this.emptyCell = false;
                if (cell.colspan() <= 1) break block9;
                if (cell.rowspan() > 1) {
                    this.mergeType = 3;
                    int n6 = n4;
                    while (n6 < n4 + cell.rowspan()) {
                        if (n6 > n4) {
                            this.mainTable.setMerge(n3, n6, 5, this);
                        }
                        int n7 = n3 + 1;
                        while (n7 < n3 + cell.colspan()) {
                            this.mainTable.setMerge(n7, n6, 6, this);
                            ++n7;
                        }
                        ++n6;
                    }
                } else {
                    this.mergeType = 1;
                    int n8 = n3 + 1;
                    while (n8 < n3 + cell.colspan()) {
                        this.mainTable.setMerge(n8, n4, 4, this);
                        ++n8;
                    }
                }
                break block10;
            }
            if (cell.rowspan() <= 1) break block10;
            this.mergeType = 2;
            int n9 = n4 + 1;
            while (n9 < n4 + cell.rowspan()) {
                this.mainTable.setMerge(n3, n9, 5, this);
                ++n9;
            }
        }
        return this.cellRight;
    }

    public boolean writeCellSettings(OutputStream outputStream) throws DocumentException {
        try {
            if (this.mergeType == 4 || this.mergeType == 6) {
                return true;
            }
            switch (this.mergeType) {
                case 2: {
                    outputStream.write(92);
                    outputStream.write(cellVMergeFirst);
                    break;
                }
                case 3: {
                    outputStream.write(92);
                    outputStream.write(cellVMergeFirst);
                    break;
                }
                case 4: {
                    outputStream.write(92);
                    outputStream.write(cellMergePrev);
                    break;
                }
                case 5: {
                    outputStream.write(92);
                    outputStream.write(cellVMergePrev);
                    break;
                }
                case 6: {
                    outputStream.write(92);
                    outputStream.write(cellMergeFirst);
                }
            }
            switch (this.store.verticalAlignment()) {
                case 6: {
                    outputStream.write(92);
                    outputStream.write(cellVerticalAlignBottom);
                    break;
                }
                case 1: {
                    outputStream.write(92);
                    outputStream.write(cellVerticalAlignCenter);
                    break;
                }
                case 4: {
                    outputStream.write(92);
                    outputStream.write(cellVerticalAlignTop);
                }
            }
            if ((this.store.border() & 4) == 4 && this.store.borderWidth() > 0.0f) {
                outputStream.write(92);
                outputStream.write(cellBorderLeft);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorder);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderWidth);
                this.writeInt(outputStream, (int)((double)this.store.borderWidth() * 20.5714));
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderColor);
                if (this.store.borderColor() == null) {
                    this.writeInt(outputStream, this.writer.addColor(new Color(0, 0, 0)));
                } else {
                    this.writeInt(outputStream, this.writer.addColor(this.store.borderColor()));
                }
                outputStream.write(10);
            }
            if ((this.store.border() & 1) == 1 && this.store.borderWidth() > 0.0f) {
                outputStream.write(92);
                outputStream.write(cellBorderTop);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorder);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderWidth);
                this.writeInt(outputStream, (int)((double)this.store.borderWidth() * 20.5714));
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderColor);
                if (this.store.borderColor() == null) {
                    this.writeInt(outputStream, this.writer.addColor(new Color(0, 0, 0)));
                } else {
                    this.writeInt(outputStream, this.writer.addColor(this.store.borderColor()));
                }
                outputStream.write(10);
            }
            if ((this.store.border() & 2) == 2 && this.store.borderWidth() > 0.0f) {
                outputStream.write(92);
                outputStream.write(cellBorderBottom);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorder);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderWidth);
                this.writeInt(outputStream, (int)((double)this.store.borderWidth() * 20.5714));
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderColor);
                if (this.store.borderColor() == null) {
                    this.writeInt(outputStream, this.writer.addColor(new Color(0, 0, 0)));
                } else {
                    this.writeInt(outputStream, this.writer.addColor(this.store.borderColor()));
                }
                outputStream.write(10);
            }
            if ((this.store.border() & 8) == 8 && this.store.borderWidth() > 0.0f) {
                outputStream.write(92);
                outputStream.write(cellBorderRight);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorder);
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderWidth);
                this.writeInt(outputStream, (int)((double)this.store.borderWidth() * 20.5714));
                outputStream.write(92);
                outputStream.write(RtfRow.tableBorderColor);
                if (this.store.borderColor() == null) {
                    this.writeInt(outputStream, this.writer.addColor(new Color(0, 0, 0)));
                } else {
                    this.writeInt(outputStream, this.writer.addColor(this.store.borderColor()));
                }
                outputStream.write(10);
            }
            outputStream.write(92);
            outputStream.write(cellBackgroundColor);
            if (this.store.backgroundColor() == null) {
                this.writeInt(outputStream, this.writer.addColor(new Color(255, 255, 255)));
            } else {
                this.writeInt(outputStream, this.writer.addColor(this.store.backgroundColor()));
            }
            outputStream.write(10);
            outputStream.write(92);
            outputStream.write(cellWidthStyle);
            outputStream.write(10);
            outputStream.write(92);
            outputStream.write(cellWidthTag);
            this.writeInt(outputStream, this.cellWidth);
            outputStream.write(10);
            if (this.cellpadding > 0) {
                outputStream.write(92);
                outputStream.write(cellPaddingLeft);
                this.writeInt(outputStream, this.cellpadding / 2);
                outputStream.write(92);
                outputStream.write(cellPaddingTop);
                this.writeInt(outputStream, this.cellpadding / 2);
                outputStream.write(92);
                outputStream.write(cellPaddingRight);
                this.writeInt(outputStream, this.cellpadding / 2);
                outputStream.write(92);
                outputStream.write(cellPaddingBottom);
                this.writeInt(outputStream, this.cellpadding / 2);
                outputStream.write(92);
                outputStream.write(cellPaddingLeftUnit);
                outputStream.write(92);
                outputStream.write(cellPaddingTopUnit);
                outputStream.write(92);
                outputStream.write(cellPaddingRightUnit);
                outputStream.write(92);
                outputStream.write(cellPaddingBottomUnit);
            }
            outputStream.write(92);
            outputStream.write(cellRightBorder);
            this.writeInt(outputStream, this.cellRight);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean writeCellContent(OutputStream outputStream) throws DocumentException {
        try {
            if (this.mergeType == 4 || this.mergeType == 6) {
                return true;
            }
            switch (this.store.horizontalAlignment()) {
                case 0: {
                    outputStream.write(92);
                    outputStream.write(cellHorizontalAlignLeft);
                    break;
                }
                case 1: {
                    outputStream.write(92);
                    outputStream.write(cellHorizontalAlignCenter);
                    break;
                }
                case 2: {
                    outputStream.write(92);
                    outputStream.write(cellHorizontalAlignRight);
                    break;
                }
                case 3: {
                    outputStream.write(92);
                    outputStream.write(cellHorizontalAlignJustified);
                }
            }
            outputStream.write(92);
            outputStream.write(cellInTable);
            if (!this.emptyCell) {
                Iterator iterator = this.store.getElements();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    element.process(this.writer);
                    if (element.type() != 12 || !iterator.hasNext()) continue;
                    outputStream.write(92);
                    outputStream.write(RtfWriter.paragraph);
                }
            }
            outputStream.write(92);
            outputStream.write(cellEnd);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void setMerge(int n, RtfCell rtfCell) {
        this.mergeType = n;
        this.store = rtfCell.getStore();
    }

    public Cell getStore() {
        return this.store;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public int getCellRight() {
        return this.cellRight;
    }

    public void setCellRight(int n) {
        this.cellRight = n;
    }

    private void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }
}

