/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Row;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfCell;
import com.lowagie.text.rtf.RtfTable;
import com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfRow {
    public static final byte[] tableBorder = "brdrs".getBytes();
    public static final byte[] tableBorderWidth = "brdrw".getBytes();
    public static final byte[] tableBorderColor = "brdrcf".getBytes();
    private static final byte[] rowBegin = "trowd".getBytes();
    private static final byte[] rowEnd = "row".getBytes();
    private static final byte[] rowAutofit = "trautofit1".getBytes();
    private static final byte[] graphLeft = "trgraph".getBytes();
    private static final byte[] rowBorderLeft = "trbrdrl".getBytes();
    private static final byte[] rowBorderRight = "trbrdrr".getBytes();
    private static final byte[] rowBorderTop = "trbrdrt".getBytes();
    private static final byte[] rowBorderBottom = "trbrdrb".getBytes();
    private static final byte[] rowBorderInlineHorizontal = "trbrdrh".getBytes();
    private static final byte[] rowBorderInlineVertical = "trbrdrv".getBytes();
    private static final byte[] rowSpacingLeft = "trspdl".getBytes();
    private static final byte[] rowSpacingRight = "trspdr".getBytes();
    private static final byte[] rowSpacingTop = "trspdt".getBytes();
    private static final byte[] rowSpacingBottom = "trspdb".getBytes();
    private static final byte[] rowSpacingLeftStyle = "trspdfl3".getBytes();
    private static final byte[] rowSpacingRightStyle = "trspdfr3".getBytes();
    private static final byte[] rowSpacingTopStyle = "trspdft3".getBytes();
    private static final byte[] rowSpacingBottomStyle = "trspdfb3".getBytes();
    private static final byte[] rowPaddingLeft = "trpaddl".getBytes();
    private static final byte[] rowPaddingRight = "trpaddr".getBytes();
    private static final byte[] rowPaddingLeftStyle = "trpaddfl3".getBytes();
    private static final byte[] rowPaddingRightStyle = "trpaddfr3".getBytes();
    private static final byte[] rowHeader = "trhdr".getBytes();
    private static final byte[] rowKeep = "trkeep".getBytes();
    private ArrayList cells = new ArrayList();
    private RtfWriter writer = null;
    private RtfTable mainTable = null;
    private int width = 100;
    private int cellpadding = 115;
    private int cellspacing = 14;
    private int borders = 0;
    private Color borderColor = null;
    private float borderWidth = 0.0f;

    public RtfRow(RtfWriter rtfWriter, RtfTable rtfTable) {
        this.writer = rtfWriter;
        this.mainTable = rtfTable;
    }

    public void pregenerateRows(int n) {
        int n2 = 0;
        while (n2 < n) {
            RtfCell rtfCell = new RtfCell(this.writer, this.mainTable);
            this.cells.add(rtfCell);
            ++n2;
        }
    }

    public boolean importRow(Row row, float[] fArray, int n, int n2, int n3, int n4, int n5, Color color, float f, int n6) {
        RtfCell rtfCell;
        int n7;
        this.width = n2 / 100 * n;
        this.cellpadding = n3;
        this.cellspacing = n4;
        this.borders = n5;
        this.borderColor = color;
        this.borderWidth = f;
        if (this.borderWidth > 2.0f) {
            this.borderWidth = 2.0f;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < row.columns()) {
            Element element = (Element)row.getCell(n9);
            n7 = (int)((float)(this.width / 100) * fArray[n9]);
            if (element != null) {
                if (element.type() == 20) {
                    rtfCell = (RtfCell)this.cells.get(n9);
                    n8 = rtfCell.importCell((Cell)element, n8, n7, n9, n6, n3);
                }
            } else {
                rtfCell = (RtfCell)this.cells.get(n9);
                n8 = rtfCell.importCell(null, n8, n7, n9, n6, n3);
            }
            ++n9;
        }
        int n10 = row.columns();
        n7 = 0;
        while (n7 < n10) {
            rtfCell = (RtfCell)this.cells.get(n7);
            Cell cell = rtfCell.getStore();
            int n11 = cell.colspan();
            if (n11 > 1) {
                RtfCell rtfCell2 = (RtfCell)this.cells.get(n7 + n11 - 1);
                rtfCell.setCellRight(rtfCell2.getCellRight());
                int n12 = rtfCell.getCellWidth();
                int n13 = n7 + 1;
                while (n13 < n7 + n11) {
                    RtfCell rtfCell3 = (RtfCell)this.cells.get(n13);
                    n12 += rtfCell3.getCellWidth();
                    ++n13;
                }
                rtfCell.setCellWidth(n12);
                n7 += n11 - 1;
            }
            ++n7;
        }
        return true;
    }

    public boolean writeRow(OutputStream outputStream, int n, Table table) throws DocumentException, IOException {
        RtfCell rtfCell;
        outputStream.write(92);
        outputStream.write(RtfWriter.paragraphDefaults);
        outputStream.write(92);
        outputStream.write(rowBegin);
        outputStream.write(10);
        outputStream.write(92);
        outputStream.write(rowAutofit);
        outputStream.write(92);
        outputStream.write(rowKeep);
        if (n < table.firstDataRow()) {
            outputStream.write(92);
            outputStream.write(rowHeader);
        }
        outputStream.write(92);
        outputStream.write(graphLeft);
        this.writeInt(outputStream, 10);
        if ((this.borders & 4) == 4 && this.borderWidth > 0.0f) {
            this.writeBorder(outputStream, rowBorderLeft);
        }
        if ((this.borders & 1) == 1 && this.borderWidth > 0.0f) {
            this.writeBorder(outputStream, rowBorderTop);
        }
        if ((this.borders & 2) == 2 && this.borderWidth > 0.0f) {
            this.writeBorder(outputStream, rowBorderBottom);
        }
        if ((this.borders & 8) == 8 && this.borderWidth > 0.0f) {
            this.writeBorder(outputStream, rowBorderRight);
        }
        if ((this.borders & 0xF) == 15 && this.borderWidth > 0.0f) {
            this.writeBorder(outputStream, rowBorderInlineHorizontal);
            this.writeBorder(outputStream, rowBorderInlineVertical);
        }
        if (this.cellspacing > 0) {
            outputStream.write(92);
            outputStream.write(rowSpacingLeft);
            this.writeInt(outputStream, this.cellspacing / 2);
            outputStream.write(92);
            outputStream.write(rowSpacingLeftStyle);
            outputStream.write(92);
            outputStream.write(rowSpacingTop);
            this.writeInt(outputStream, this.cellspacing / 2);
            outputStream.write(92);
            outputStream.write(rowSpacingTopStyle);
            outputStream.write(92);
            outputStream.write(rowSpacingBottom);
            this.writeInt(outputStream, this.cellspacing / 2);
            outputStream.write(92);
            outputStream.write(rowSpacingBottomStyle);
            outputStream.write(92);
            outputStream.write(rowSpacingRight);
            this.writeInt(outputStream, this.cellspacing / 2);
            outputStream.write(92);
            outputStream.write(rowSpacingRightStyle);
        }
        outputStream.write(92);
        outputStream.write(rowPaddingLeft);
        this.writeInt(outputStream, this.cellpadding / 2);
        outputStream.write(92);
        outputStream.write(rowPaddingRight);
        this.writeInt(outputStream, this.cellpadding / 2);
        outputStream.write(92);
        outputStream.write(rowPaddingLeftStyle);
        outputStream.write(92);
        outputStream.write(rowPaddingRightStyle);
        outputStream.write(10);
        Iterator iterator = ((AbstractList)this.cells).iterator();
        while (iterator.hasNext()) {
            rtfCell = (RtfCell)iterator.next();
            rtfCell.writeCellSettings(outputStream);
        }
        iterator = ((AbstractList)this.cells).iterator();
        while (iterator.hasNext()) {
            rtfCell = (RtfCell)iterator.next();
            rtfCell.writeCellContent(outputStream);
        }
        outputStream.write(92);
        outputStream.write(rowEnd);
        return true;
    }

    private void writeBorder(OutputStream outputStream, byte[] byArray) throws IOException {
        outputStream.write(92);
        outputStream.write(byArray);
        outputStream.write(92);
        outputStream.write(tableBorder);
        outputStream.write(92);
        outputStream.write(tableBorderWidth);
        this.writeInt(outputStream, (int)((double)this.borderWidth * 20.5714));
        outputStream.write(92);
        outputStream.write(tableBorderColor);
        if (this.borderColor == null) {
            this.writeInt(outputStream, this.writer.addColor(new Color(0, 0, 0)));
        } else {
            this.writeInt(outputStream, this.writer.addColor(this.borderColor));
        }
        outputStream.write(10);
    }

    public void setMerge(int n, int n2, RtfCell rtfCell) {
        RtfCell rtfCell2 = (RtfCell)this.cells.get(n);
        rtfCell2.setMerge(n2, rtfCell);
    }

    private void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }
}

