/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CDATASectionImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.CommentImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentFragmentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.ProcessingInstructionImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom.TreeWalkerImpl;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.range.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DocumentImpl
extends ParentNode
implements Document,
DocumentTraversal,
DocumentEvent {
    static final long serialVersionUID = 515687835542616694L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    protected Hashtable identifiers;
    protected Vector iterators;
    protected Vector ranges;
    protected static int[] kidOK = new int[13];
    protected Hashtable userData;
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;

    static {
        DocumentImpl.kidOK[9] = 1410;
        DocumentImpl.kidOK[1] = 442;
        DocumentImpl.kidOK[5] = 442;
        DocumentImpl.kidOK[6] = 442;
        DocumentImpl.kidOK[11] = 442;
        DocumentImpl.kidOK[2] = 40;
        DocumentImpl.kidOK[12] = 0;
        DocumentImpl.kidOK[4] = 0;
        DocumentImpl.kidOK[3] = 0;
        DocumentImpl.kidOK[8] = 0;
        DocumentImpl.kidOK[7] = 0;
        DocumentImpl.kidOK[10] = 0;
    }

    public DocumentImpl() {
        this(false);
    }

    public DocumentImpl(DocumentType documentType) {
        this(documentType, false);
    }

    public DocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        this.docType = (DocumentTypeImpl)documentType;
        if (this.docType != null) {
            this.docType.ownerDocument = this;
        }
    }

    public DocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
    }

    public void adoptNode(Node node) {
        if (!(node instanceof NodeImpl)) {
            throw new DOMExceptionImpl(9, "cannot move a node in from another DOM implementation");
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            node2.removeChild(node);
        }
        ((NodeImpl)node).setOwnerDocument(this);
    }

    protected void changed() {
        ++this.changes;
    }

    protected int changes() {
        return this.changes;
    }

    public Object clone() throws CloneNotSupportedException {
        DocumentImpl documentImpl = (DocumentImpl)super.clone();
        documentImpl.docType = null;
        documentImpl.docElement = null;
        return documentImpl;
    }

    public Node cloneNode(boolean bl) {
        DocumentImpl documentImpl = new DocumentImpl();
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                documentImpl.appendChild(documentImpl.importNode(childNode, true));
                childNode = childNode.nextSibling;
            }
        }
        documentImpl.identifiers = null;
        documentImpl.iterators = null;
        documentImpl.ranges = null;
        documentImpl.userData = null;
        documentImpl.allowGrammarAccess = this.allowGrammarAccess;
        documentImpl.errorChecking = this.errorChecking;
        return documentImpl;
    }

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new AttrImpl(this, string);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return new AttrNSImpl(this, string, string2);
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new ElementImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        return new ElementDefinitionImpl(this, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return new ElementNSImpl(this, string, string2);
    }

    public Entity createEntity(String string) throws DOMException {
        return new EntityImpl(this, string);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new EntityReferenceImpl(this, string);
    }

    public Event createEvent(String string) throws DOMException {
        if ("Event".equals(string)) {
            return new EventImpl();
        }
        if ("MutationEvent".equals(string)) {
            return new MutationEventImpl();
        }
        throw new DOMExceptionImpl(101, "DOM007 Not supported");
    }

    public NodeIterator createNodeIterator(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        NodeIteratorImpl nodeIteratorImpl = new NodeIteratorImpl(this, node, n, nodeFilter, bl);
        if (this.iterators == null) {
            this.iterators = new Vector();
        }
        this.iterators.addElement(nodeIteratorImpl);
        return nodeIteratorImpl;
    }

    public NodeIterator createNodeIterator(Node node, short s, NodeFilter nodeFilter) {
        return this.createNodeIterator(node, s, nodeFilter, true);
    }

    public Notation createNotation(String string) throws DOMException {
        return new NotationImpl(this, string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !DocumentImpl.isXMLName(string)) {
            throw new DOMExceptionImpl(5, "DOM002 Illegal character");
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    public Range createRange() {
        if (this.ranges == null) {
            this.ranges = new Vector();
        }
        RangeImpl rangeImpl = new RangeImpl(this);
        this.ranges.addElement(rangeImpl);
        return rangeImpl;
    }

    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    public TreeWalker createTreeWalker(Node node, int n, NodeFilter nodeFilter, boolean bl) {
        if (node == null) {
            throw new DOMExceptionImpl(9, "DOM007 Not supported");
        }
        TreeWalkerImpl treeWalkerImpl = new TreeWalkerImpl(node, n, nodeFilter, bl);
        return treeWalkerImpl;
    }

    public TreeWalker createTreeWalker(Node node, short s, NodeFilter nodeFilter) {
        return this.createTreeWalker(node, s, nodeFilter, true);
    }

    void deletedText(Node node, int n, int n2) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveDeletedText(node, n, n2);
            }
        }
    }

    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    public Element getIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        return (Element)this.identifiers.get(string);
    }

    public Enumeration getIdentifiers() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        return this.identifiers.keys();
    }

    public DOMImplementation getImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public final Document getOwnerDocument() {
        return null;
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(nodeImpl);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2;
        Object object = null;
        DOMImplementation dOMImplementation = node.getOwnerDocument().getImplementation();
        boolean bl2 = dOMImplementation.hasFeature("XML", "2.0");
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object object2;
                node2 = bl2 ? (node.getLocalName() == null ? this.createElement(node.getNodeName()) : this.createElementNS(node.getNamespaceURI(), node.getNodeName())) : this.createElement(node.getNodeName());
                Object object3 = node.getAttributes();
                if (object3 != null) {
                    int n = 0;
                    while (n < object3.getLength()) {
                        object2 = (Attr)object3.item(n);
                        if (object2.getSpecified()) {
                            Attr attr = (Attr)this.importNode((Node)object2, true);
                            if (bl2) {
                                if (object2.getLocalName() == null) {
                                    node2.setAttributeNode(attr);
                                } else {
                                    node2.setAttributeNodeNS(attr);
                                }
                            } else {
                                node2.setAttributeNode(attr);
                            }
                        }
                        ++n;
                    }
                }
                object = node2;
                break;
            }
            case 2: {
                object = bl2 ? (node.getLocalName() == null ? this.createAttribute(node.getNodeName()) : this.createAttributeNS(node.getNamespaceURI(), node.getNodeName())) : this.createAttribute(node.getNodeName());
                bl = true;
                break;
            }
            case 3: {
                object = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                object = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 5: {
                object = this.createEntityReference(node.getNodeName());
                ((EntityReferenceImpl)object).isReadOnly(false);
                break;
            }
            case 6: {
                node2 = (Entity)node;
                Object object3 = (EntityImpl)this.createEntity(node.getNodeName());
                ((EntityImpl)object3).setPublicId(node2.getPublicId());
                ((EntityImpl)object3).setSystemId(node2.getSystemId());
                ((EntityImpl)object3).setNotationName(node2.getNotationName());
                ((NodeImpl)object3).isReadOnly(false);
                object = object3;
                break;
            }
            case 7: {
                object = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                object = this.createComment(node.getNodeValue());
                break;
            }
            case 10: {
                int n;
                node2 = (DocumentType)node;
                Object object3 = (DocumentTypeImpl)this.createDocumentType(node2.getNodeName(), node2.getPublicId(), node2.getSystemId());
                NamedNodeMap namedNodeMap = node2.getEntities();
                Object object2 = ((DocumentTypeImpl)object3).getEntities();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object2.setNamedItem(this.importNode(namedNodeMap.item(n), true));
                        ++n;
                    }
                }
                namedNodeMap = node2.getNotations();
                object2 = ((DocumentTypeImpl)object3).getNotations();
                if (namedNodeMap != null) {
                    n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object2.setNamedItem(this.importNode(namedNodeMap.item(n), true));
                        ++n;
                    }
                }
                object = object3;
                break;
            }
            case 11: {
                object = this.createDocumentFragment();
                break;
            }
            case 12: {
                node2 = (Notation)node;
                Object object3 = (NotationImpl)this.createNotation(node.getNodeName());
                ((NotationImpl)object3).setPublicId(node2.getPublicId());
                ((NotationImpl)object3).setSystemId(node2.getSystemId());
                object = object3;
                break;
            }
            default: {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
        }
        if (bl) {
            node2 = node.getFirstChild();
            while (node2 != null) {
                object.appendChild(this.importNode(node2, true));
                node2 = node2.getNextSibling();
            }
        }
        if (object.getNodeType() == 5 || object.getNodeType() == 6) {
            ((NodeImpl)object).setReadOnly(true, true);
        }
        return object;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    void insertedText(Node node, int n, int n2) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveInsertedText(node, n, n2);
            }
        }
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return (kidOK[node.getNodeType()] & 1 << node2.getNodeType()) != 0;
    }

    public static boolean isXMLName(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        if (!Character.isLetter(cArray[0]) && "_:".indexOf(cArray[0]) == -1) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            char c = cArray[n];
            int n2 = Character.getType(c);
            if (!Character.isLetterOrDigit(c) && ".-_:".indexOf(c) == -1 && (n2 < 6 || n2 > 8 || c >= '\u06dd' && c <= '\u06de' || c >= '\u20dd' && c <= '\u20e0' || c >= '\u309b') && (n2 != 4 || c >= '\u02d0' && c <= '\u0559' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u309b' && c <= '\u309c') && c != '\u00b7' && c != '\u0387') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new Hashtable();
        }
        this.identifiers.put(string, element);
    }

    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    public void removeIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    void removeNodeIterator(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return;
        }
        if (this.iterators == null) {
            return;
        }
        this.iterators.removeElement(nodeIterator);
    }

    void removeRange(Range range) {
        if (range == null) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        this.ranges.removeElement(range);
    }

    void removedChildNode(Node node) {
        Enumeration enumeration;
        if (this.iterators != null) {
            enumeration = this.iterators.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration.nextElement()).removeNode(node);
            }
        }
        if (this.ranges != null) {
            enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).removeNode(node);
            }
        }
    }

    void replacedText(Node node) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveReplacedText(node);
            }
        }
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        if (object == null) {
            this.userData.remove(nodeImpl);
        } else {
            this.userData.put(nodeImpl, object);
        }
    }

    void splitData(Node node, Node node2, int n) {
        if (this.ranges != null) {
            Enumeration enumeration = this.ranges.elements();
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).receiveSplitData(node, node2, n);
            }
        }
    }
}

