/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.dtd.DTDGrammar;
import org.apache.xerces.validators.schema.EquivClassComparator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.TraverseSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class XMLValidator
implements DefaultEntityHandler.EventHandler,
XMLEntityHandler.CharDataHandler,
XMLDocumentScanner.EventHandler,
NamespacesScope.NamespacesHandler {
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;
    private static final boolean DEBUG_SCHEMA_VALIDATION = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private Hashtable fIdDefs = null;
    private Hashtable fIdRefs = null;
    private Object fNullValue = null;
    private AttributeValidator fAttValidatorCDATA = null;
    private AttributeValidator fAttValidatorID = new AttValidatorID();
    private AttributeValidator fAttValidatorIDREF = new AttValidatorIDREF();
    private AttributeValidator fAttValidatorIDREFS = new AttValidatorIDREFS();
    private AttributeValidator fAttValidatorENTITY = new AttValidatorENTITY();
    private AttributeValidator fAttValidatorENTITIES = new AttValidatorENTITIES();
    private AttributeValidator fAttValidatorNMTOKEN = new AttValidatorNMTOKEN();
    private AttributeValidator fAttValidatorNMTOKENS = new AttValidatorNMTOKENS();
    private AttributeValidator fAttValidatorNOTATION = new AttValidatorNOTATION();
    private AttributeValidator fAttValidatorENUMERATION = new AttValidatorENUMERATION();
    private AttributeValidator fAttValidatorDATATYPE = null;
    StringPool fStringPool = null;
    boolean fValidating = false;
    boolean fInElementContent = false;
    int fStandaloneReader = -1;
    private boolean fValidationEnabled = false;
    private boolean fDynamicValidation = false;
    private boolean fSchemaValidation = true;
    private boolean fValidationEnabledByDynamic = false;
    private boolean fDynamicDisabledByValidation = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fWarningOnUndeclaredElements = false;
    private int[] fDeclaration;
    private XMLErrorReporter fErrorReporter = null;
    private DefaultEntityHandler fEntityHandler = null;
    private QName fCurrentElement = new QName();
    private int[] fScopeStack = new int[8];
    private int[] fGrammarNameSpaceIndexStack = new int[8];
    private int[] fElementTypeStack = new int[8];
    private int[] fElementEntityStack = new int[8];
    private int[] fElementIndexStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private int[] fElementLocalPartStack = new int[8];
    private QName[] fElementChildren = new QName[32];
    private int fElementChildrenLength = 0;
    private int[] fElementChildrenOffsetStack = new int[32];
    private int fElementDepth = -1;
    private boolean fNamespacesEnabled = false;
    private NamespacesScope fNamespacesScope = null;
    private int fNamespacesPrefix = -1;
    private QName fRootElement = new QName();
    private int fAttrListHandle = -1;
    private int fCurrentElementEntity = -1;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean fSeenDoctypeDecl = false;
    private final int TOP_LEVEL_SCOPE = -1;
    private int fCurrentScope = -1;
    private int fCurrentSchemaURI = -1;
    private int fEmptyURI = -1;
    private int fXsiPrefix = -1;
    private int fXsiURI = -2;
    private int fXsiTypeAttValue = -1;
    private Grammar fGrammar = null;
    private int fGrammarNameSpaceIndex = -1;
    private GrammarResolver fGrammarResolver = null;
    private boolean fScanningDTD = false;
    private XMLDocumentScanner fDocumentScanner = null;
    private boolean fCalledStartDocument = false;
    private XMLDocumentHandler fDocumentHandler = null;
    private XMLDocumentHandler.DTDHandler fDTDHandler = null;
    private boolean fSeenRootElement = false;
    private XMLAttrList fAttrList = null;
    private int fXMLLang = -1;
    private LocatorImpl fAttrNameLocator = null;
    private boolean fCheckedForSchema = false;
    private boolean fDeclsAreExternal = false;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    private char[] fCharRefData = null;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fBufferDatatype = false;
    private StringBuffer fDatatypeBuffer = new StringBuffer();
    private QName fTempQName = new QName();
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private boolean fGrammarIsDTDGrammar = false;
    private boolean fGrammarIsSchemaGrammar = false;
    private int fEMPTYSymbol = -1;
    private int fANYSymbol = -1;
    private int fMIXEDSymbol = -1;
    private int fCHILDRENSymbol = -1;
    private int fCDATASymbol = -1;
    private int fIDSymbol = -1;
    private int fIDREFSymbol = -1;
    private int fIDREFSSymbol = -1;
    private int fENTITYSymbol = -1;
    private int fENTITIESSymbol = -1;
    private int fNMTOKENSymbol = -1;
    private int fNMTOKENSSymbol = -1;
    private int fNOTATIONSymbol = -1;
    private int fENUMERATIONSymbol = -1;
    private int fREQUIREDSymbol = -1;
    private int fFIXEDSymbol = -1;
    private int fDATATYPESymbol = -1;
    private int fEpsilonIndex = -1;

    public XMLValidator(StringPool stringPool, XMLErrorReporter xMLErrorReporter, DefaultEntityHandler defaultEntityHandler, XMLDocumentScanner xMLDocumentScanner) {
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
        this.fEntityHandler = defaultEntityHandler;
        this.fDocumentScanner = xMLDocumentScanner;
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/1999/XMLSchema-instance");
        this.fAttrList = new XMLAttrList(this.fStringPool);
        defaultEntityHandler.setEventHandler(this);
        defaultEntityHandler.setCharDataHandler(this);
        this.fDocumentScanner.setEventHandler(this);
        this.init();
    }

    private int addDefaultAttributes(int n, XMLAttrList xMLAttrList, int n2, boolean bl, boolean bl2) throws Exception {
        this.fGrammar.getElementDecl(n, this.fTempElementDecl);
        int n3 = this.fTempElementDecl.name.localpart;
        int n4 = this.fGrammar.getFirstAttributeDeclIndex(n);
        int n5 = n2;
        int n6 = -1;
        while (n4 != -1) {
            int n7;
            boolean bl3;
            this.fGrammar.getAttributeDecl(n4, this.fTempAttDecl);
            int n8 = this.fTempAttDecl.name.prefix;
            int n9 = this.fTempAttDecl.name.localpart;
            int n10 = this.attributeTypeName(this.fTempAttDecl);
            int n11 = this.fTempAttDecl.defaultType;
            int n12 = -1;
            if (this.fTempAttDecl.defaultValue != null) {
                n12 = this.fStringPool.addSymbol(this.fTempAttDecl.defaultValue);
            }
            boolean bl4 = false;
            boolean bl5 = bl3 = n11 == 2;
            if (n5 != -1) {
                int n13 = n7 = n10 != this.fCDATASymbol ? 0 : 1;
                if (n7 == 0 || bl3 || n12 != -1) {
                    int n14 = xMLAttrList.getFirstAttr(n5);
                    while (n14 != -1 && (n6 == -1 || n14 <= n6)) {
                        if (this.fGrammarIsDTDGrammar && xMLAttrList.getAttrName(n14) == this.fTempAttDecl.name.rawname || this.fStringPool.equalNames(xMLAttrList.getAttrLocalpart(n14), n9) && this.fStringPool.equalNames(xMLAttrList.getAttrURI(n14), this.fTempAttDecl.name.uri)) {
                            int n15;
                            if (bl && n11 == 1 && (n15 = xMLAttrList.getAttValue(n14)) != n12 && !this.fStringPool.toString(n15).equals(this.fStringPool.toString(n12))) {
                                Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9), this.fStringPool.toString(n15), this.fStringPool.toString(n12)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, objectArray, 1);
                            }
                            bl4 = true;
                            break;
                        }
                        n14 = xMLAttrList.getNextAttr(n14);
                    }
                }
            }
            if (!bl4) {
                if (bl3) {
                    if (bl) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, objectArray, 1);
                    }
                } else if (n12 != -1) {
                    if (bl && bl2 && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(n4)) {
                        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n9)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, objectArray, 1);
                    }
                    if (n10 == this.fIDREFSymbol) {
                        this.addIdRef(n12);
                    } else if (n10 == this.fIDREFSSymbol) {
                        StringTokenizer stringTokenizer = new StringTokenizer(this.fStringPool.toString(n12));
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            this.addIdRef(this.fStringPool.addSymbol(string));
                        }
                    }
                    if (n2 == -1) {
                        n2 = xMLAttrList.startAttrList();
                    }
                    this.fTempQName.setValues(n8, n9, n9, this.fTempAttDecl.name.uri);
                    n7 = xMLAttrList.addAttr(this.fTempQName, n12, n10, false, false);
                    if (n6 == -1) {
                        n6 = n7;
                    }
                }
            }
            n4 = this.fGrammar.getNextAttributeDeclIndex(n4);
        }
        return n2;
    }

    protected boolean addId(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs == null) {
            this.fIdDefs = new Hashtable();
        } else if (this.fIdDefs.containsKey(n2)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdDefs.put(n2, this.fNullValue);
        return true;
    }

    protected void addIdRef(int n) {
        Integer n2 = new Integer(n);
        if (this.fIdDefs != null && this.fIdDefs.containsKey(n2)) {
            return;
        }
        if (this.fIdRefs == null) {
            this.fIdRefs = new Hashtable();
        } else if (this.fIdRefs.containsKey(n2)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdRefs.put(n2, this.fNullValue);
    }

    public boolean attribute(QName qName, QName qName2, int n) throws Exception {
        if (this.fAttrListHandle == -1) {
            this.fAttrListHandle = this.fAttrList.startAttrList();
        }
        return this.fAttrList.addAttr(qName2, n, this.fCDATASymbol, true, true) == -1;
    }

    private int attributeTypeName(XMLAttributeDecl xMLAttributeDecl) {
        switch (xMLAttributeDecl.type) {
            case 1: {
                return xMLAttributeDecl.list ? this.fENTITIESSymbol : this.fENTITYSymbol;
            }
            case 2: {
                String string = this.fStringPool.stringListAsString(xMLAttributeDecl.enumeration);
                return this.fStringPool.addString(string);
            }
            case 3: {
                return this.fIDSymbol;
            }
            case 4: {
                return xMLAttributeDecl.list ? this.fIDREFSSymbol : this.fIDREFSymbol;
            }
            case 5: {
                return xMLAttributeDecl.list ? this.fNMTOKENSSymbol : this.fNMTOKENSSymbol;
            }
            case 6: {
                return this.fNOTATIONSymbol;
            }
        }
        return this.fCDATASymbol;
    }

    private void bindNamespacesToElementAndAttributes(QName qName, XMLAttrList xMLAttrList) throws Exception {
        Object[] objectArray;
        int n;
        int n2;
        int n3;
        this.fNamespacesScope.increaseDepth();
        Hashtable<String, String> hashtable = null;
        if (this.fAttrListHandle != -1) {
            int n4;
            int n5;
            int n6;
            n3 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n3 != -1) {
                n6 = xMLAttrList.getAttrName(n3);
                n5 = xMLAttrList.getAttrPrefix(n3);
                if (!this.fStringPool.equalNames(n6, this.fXMLLang)) {
                    if (this.fStringPool.equalNames(n6, this.fNamespacesPrefix)) {
                        n4 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n3));
                        this.fNamespacesScope.setNamespaceForPrefix(0, n4);
                    } else if (n5 == this.fNamespacesPrefix) {
                        n4 = xMLAttrList.getAttrLocalpart(n3);
                        n2 = this.fStringPool.addSymbol(xMLAttrList.getAttValue(n3));
                        this.fNamespacesScope.setNamespaceForPrefix(n4, n2);
                        if (this.fValidating && this.fSchemaValidation) {
                            n = 0;
                            objectArray = this.fStringPool.toString(xMLAttrList.getAttValue(n3));
                            if (objectArray.equals("http://www.w3.org/1999/XMLSchema-instance")) {
                                this.fXsiPrefix = n4;
                                n = 1;
                            }
                        }
                    }
                }
                n3 = xMLAttrList.getNextAttr(n3);
            }
            if (this.fValidating && this.fSchemaValidation) {
                this.fXsiTypeAttValue = -1;
                n3 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
                while (n3 != -1) {
                    n6 = xMLAttrList.getAttrName(n3);
                    n5 = xMLAttrList.getAttrPrefix(n3);
                    if (!this.fStringPool.equalNames(n6, this.fNamespacesPrefix) && this.fXsiPrefix != -1 && n5 == this.fXsiPrefix) {
                        n4 = xMLAttrList.getAttrLocalpart(n3);
                        if (n4 == this.fStringPool.addSymbol("schemaLocation")) {
                            if (hashtable == null) {
                                hashtable = new Hashtable<String, String>();
                            }
                            this.parseSchemaLocation(this.fStringPool.toString(xMLAttrList.getAttValue(n3)), hashtable);
                        } else if (n4 == this.fStringPool.addSymbol("noNamespaceSchemaLocation")) {
                            if (hashtable == null) {
                                hashtable = new Hashtable();
                            }
                            hashtable.put(this.fStringPool.toString(xMLAttrList.getAttValue(n3)), "");
                            if (this.fNamespacesScope != null) {
                                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
                            }
                        } else if (n4 == this.fStringPool.addSymbol("type")) {
                            this.fXsiTypeAttValue = xMLAttrList.getAttValue(n3);
                        }
                    }
                    n3 = xMLAttrList.getNextAttr(n3);
                }
                if (hashtable != null) {
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)hashtable.get(string);
                        this.resolveSchemaGrammar(string, string2);
                    }
                }
            }
        }
        n3 = qName.prefix != -1 ? qName.prefix : 0;
        int n7 = this.fNamespacesScope.getNamespaceForPrefix(n3);
        if (qName.prefix != -1 || n7 != -1) {
            qName.uri = n7;
            if (qName.uri == -1) {
                Object[] objectArray2 = new Object[]{this.fStringPool.toString(qName.prefix)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray2, 1);
            }
        }
        if (this.fValidating && qName.uri != this.fGrammarNameSpaceIndex && qName.uri != -1) {
            this.fGrammarNameSpaceIndex = qName.uri;
            this.switchGrammar(this.fGrammarNameSpaceIndex);
        }
        if (this.fAttrListHandle != -1) {
            int n8 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n8 != -1) {
                int n9 = xMLAttrList.getAttrName(n8);
                if (!this.fStringPool.equalNames(n9, this.fNamespacesPrefix) && (n2 = xMLAttrList.getAttrPrefix(n8)) != this.fNamespacesPrefix && n2 != -1) {
                    n = this.fNamespacesScope.getNamespaceForPrefix(n2);
                    if (n == -1) {
                        objectArray = new Object[]{this.fStringPool.toString(n2)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray, 1);
                    }
                    xMLAttrList.setAttrURI(n8, n);
                }
                n8 = xMLAttrList.getNextAttr(n8);
            }
        }
    }

    public void callCharacters(int n) throws Exception {
        int n2;
        if (this.fCharRefData == null) {
            this.fCharRefData = new char[2];
        }
        int n3 = n2 = n < 65536 ? 1 : 2;
        if (n2 == 1) {
            this.fCharRefData[0] = (char)n;
        } else {
            this.fCharRefData[0] = (char)((n - 65536 >> 10) + 55296);
            this.fCharRefData[1] = (char)((n - 65536 & 0x3FF) + 56320);
        }
        if (this.fValidating && (this.fInElementContent || this.fCurrentContentSpecType == 0)) {
            this.charDataInContent();
        }
        if (this.fSendCharDataAsCharArray) {
            this.fDocumentHandler.characters(this.fCharRefData, 0, n2);
        } else {
            int n4 = this.fStringPool.addString(new String(this.fCharRefData, 0, n2));
            this.fDocumentHandler.characters(n4);
        }
    }

    public void callComment(int n) throws Exception {
        this.fDocumentHandler.comment(n);
    }

    public void callEndCDATA() throws Exception {
        this.fDocumentHandler.endCDATA();
    }

    public void callEndDocument() throws Exception {
        if (this.fCalledStartDocument) {
            this.fDocumentHandler.endDocument();
        }
    }

    public void callEndElement(int n) throws Exception {
        int n2 = this.fCurrentElement.prefix;
        int n3 = this.fCurrentElement.rawname;
        if (this.fCurrentElementEntity != n) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 68, 68, new Object[]{this.fStringPool.toString(n3)}, 2);
        }
        --this.fElementDepth;
        if (this.fValidating) {
            int n4;
            int n5;
            QName[] qNameArray;
            int n6;
            int n7 = this.fCurrentElementIndex;
            if (n7 != -1 && this.fCurrentContentSpecType != -1 && (n6 = this.checkContent(n7, qNameArray = this.fElementChildren, n5 = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1, n4 = this.fElementChildrenLength - n5)) != -1) {
                int n8 = n6 != n4 ? 87 : 88;
                this.fGrammar.getElementDecl(n7, this.fTempElementDecl);
                if (this.fTempElementDecl.type == 0) {
                    this.reportRecoverableXMLError(n8, 0, this.fStringPool.toString(n3), "EMPTY");
                } else {
                    this.reportRecoverableXMLError(n8, 0, this.fStringPool.toString(n3), XMLContentSpec.toString(this.fGrammar, this.fStringPool, this.fTempElementDecl.contentSpecIndex));
                }
            }
            this.fElementChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
        }
        this.fDocumentHandler.endElement(this.fCurrentElement);
        if (this.fNamespacesEnabled) {
            this.fNamespacesScope.decreaseDepth();
        }
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElement.clear();
            this.fCurrentElementEntity = -1;
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fValidating && this.fIdRefs != null) {
                this.checkIdRefs();
            }
            return;
        }
        this.fCurrentElement.prefix = -1;
        this.fCurrentElement.localpart = this.fNamespacesEnabled ? this.fElementLocalPartStack[this.fElementDepth] : this.fElementTypeStack[this.fElementDepth];
        this.fCurrentElement.rawname = this.fElementTypeStack[this.fElementDepth];
        this.fCurrentElementEntity = this.fElementEntityStack[this.fElementDepth];
        this.fCurrentElementIndex = this.fElementIndexStack[this.fElementDepth];
        this.fCurrentContentSpecType = this.fContentSpecTypeStack[this.fElementDepth];
        this.fCurrentScope = this.fScopeStack[this.fElementDepth];
        if (this.fGrammarNameSpaceIndex != this.fGrammarNameSpaceIndexStack[this.fElementDepth]) {
            this.fGrammarNameSpaceIndex = this.fGrammarNameSpaceIndexStack[this.fElementDepth];
            this.switchGrammar(this.fGrammarNameSpaceIndex);
        }
        if (this.fValidating) {
            this.fBufferDatatype = false;
        }
        this.fInElementContent = this.fCurrentContentSpecType == 3;
    }

    public void callProcessingInstruction(int n, int n2) throws Exception {
        this.fDocumentHandler.processingInstruction(n, n2);
    }

    public void callStandaloneIsYes() throws Exception {
        this.fStandaloneReader = this.fEntityHandler.getReaderId();
    }

    public void callStartCDATA() throws Exception {
        this.fDocumentHandler.startCDATA();
    }

    public void callStartDocument() throws Exception {
        if (!this.fCalledStartDocument) {
            this.fDocumentHandler.startDocument();
            this.fCalledStartDocument = true;
        }
    }

    public void callStartElement(QName qName) throws Exception {
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            this.rootElementSpecified(qName);
            this.fStringPool.resetShuffleCount();
        }
        this.fCheckedForSchema = true;
        if (this.fNamespacesEnabled) {
            this.bindNamespacesToElementAndAttributes(qName, this.fAttrList);
        }
        this.validateElementAndAttributes(qName, this.fAttrList);
        if (this.fAttrListHandle != -1) {
            this.fAttrList.endAttrList();
        }
        this.fDocumentHandler.startElement(qName, this.fAttrList, this.fAttrListHandle);
        this.fAttrListHandle = -1;
        ++this.fElementDepth;
        if (this.fValidating) {
            Object object;
            if (this.fElementChildrenOffsetStack.length < this.fElementDepth) {
                object = new int[this.fElementChildrenOffsetStack.length * 2];
                System.arraycopy(this.fElementChildrenOffsetStack, 0, object, 0, this.fElementChildrenOffsetStack.length);
                this.fElementChildrenOffsetStack = object;
            }
            this.fElementChildrenOffsetStack[this.fElementDepth] = this.fElementChildrenLength;
            if (this.fElementChildren.length <= this.fElementChildrenLength) {
                object = new QName[this.fElementChildrenLength * 2];
                System.arraycopy(this.fElementChildren, 0, object, 0, this.fElementChildren.length);
                this.fElementChildren = object;
            }
            if ((object = (Object)this.fElementChildren[this.fElementChildrenLength]) == null) {
                int n = this.fElementChildrenLength;
                while (n < this.fElementChildren.length) {
                    this.fElementChildren[n] = new QName();
                    ++n;
                }
                object = this.fElementChildren[this.fElementChildrenLength];
            }
            ((QName)object).setValues(qName);
            ++this.fElementChildrenLength;
        }
        this.ensureStackCapacity(this.fElementDepth);
        this.fCurrentElement.setValues(qName);
        this.fCurrentElementEntity = this.fEntityHandler.getReaderId();
        this.fElementTypeStack[this.fElementDepth] = this.fCurrentElement.rawname;
        this.fElementLocalPartStack[this.fElementDepth] = this.fCurrentElement.localpart;
        this.fElementEntityStack[this.fElementDepth] = this.fCurrentElementEntity;
        this.fElementIndexStack[this.fElementDepth] = this.fCurrentElementIndex;
        this.fContentSpecTypeStack[this.fElementDepth] = this.fCurrentContentSpecType;
        this.fScopeStack[this.fElementDepth] = this.fCurrentScope;
        this.fGrammarNameSpaceIndexStack[this.fElementDepth] = this.fGrammarNameSpaceIndex;
    }

    public void callTextDecl(int n, int n2) throws Exception {
        this.fDocumentHandler.textDecl(n, n2);
    }

    public void callXMLDecl(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.xmlDecl(n, n2, n3);
    }

    private void charDataInContent() {
        Object object;
        if (this.fElementChildren.length <= this.fElementChildrenLength) {
            object = new QName[this.fElementChildren.length * 2];
            System.arraycopy(this.fElementChildren, 0, object, 0, this.fElementChildren.length);
            this.fElementChildren = object;
        }
        if ((object = this.fElementChildren[this.fElementChildrenLength]) == null) {
            int n = this.fElementChildrenLength;
            while (n < this.fElementChildren.length) {
                this.fElementChildren[n] = new QName();
                ++n;
            }
            object = this.fElementChildren[this.fElementChildrenLength];
        }
        object.clear();
        ++this.fElementChildrenLength;
    }

    private int checkContent(int n, QName[] qNameArray, int n2, int n3) throws Exception {
        block16: {
            int n4 = this.fCurrentElement.rawname;
            int n5 = this.fCurrentContentSpecType;
            if (n5 == 0) {
                if (n3 != 0) {
                    return 0;
                }
            } else if (n5 != 1) {
                if (n5 == 2 || n5 == 3) {
                    XMLContentModel xMLContentModel = null;
                    try {
                        xMLContentModel = this.getElementContentModel(n);
                        int n6 = xMLContentModel.validateContent(qNameArray, n2, n3);
                        if (n6 != -1 && this.fGrammarIsSchemaGrammar) {
                            EquivClassComparator equivClassComparator = new EquivClassComparator(this.fGrammarResolver, this.fStringPool);
                            xMLContentModel.setEquivClassComparator(equivClassComparator);
                            n6 = xMLContentModel.validateContentSpecial(qNameArray, n2, n3);
                        }
                        return n6;
                    }
                    catch (CMException cMException) {
                        int n7 = cMException.getErrorCode();
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n7, 0, null, 2);
                    }
                } else if (n5 == -1) {
                    this.reportRecoverableXMLError(83, 79, n4);
                } else if (n5 == 4) {
                    Object var7_8 = null;
                    try {
                        this.fGrammar.getElementDecl(n, this.fTempElementDecl);
                        DatatypeValidator datatypeValidator = this.fTempElementDecl.datatypeValidator;
                        if (datatypeValidator == null) {
                            System.out.println("Internal Error: this element have a simpletype but no datatypevalidator was found, element " + this.fTempElementDecl.name + ",locapart: " + this.fStringPool.toString(this.fTempElementDecl.name.localpart));
                            break block16;
                        }
                        datatypeValidator.validate(this.fDatatypeBuffer.toString(), null);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{invalidDatatypeValueException.getMessage()}, 1);
                    }
                } else {
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 8, 0, null, 2);
                }
            }
        }
        return -1;
    }

    private void checkIdRefs() throws Exception {
        if (this.fIdRefs == null) {
            return;
        }
        Enumeration enumeration = this.fIdRefs.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.fIdDefs != null && this.fIdDefs.containsKey(n)) continue;
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 81, 2, objectArray, 1);
        }
    }

    public void element(QName qName) throws Exception {
        this.fAttrListHandle = -1;
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.endEntityReference(n, n2, n3);
    }

    public void endNamespaceDeclScope(int n) throws Exception {
        this.fDocumentHandler.endNamespaceDeclScope(n);
    }

    private void ensureStackCapacity(int n) {
        if (n == this.fElementTypeStack.length) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.fScopeStack, 0, nArray, 0, n);
            this.fScopeStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fGrammarNameSpaceIndexStack, 0, nArray, 0, n);
            this.fGrammarNameSpaceIndexStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, n);
            this.fElementTypeStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fElementLocalPartStack, 0, nArray, 0, n);
            this.fElementLocalPartStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fElementEntityStack, 0, nArray, 0, n);
            this.fElementEntityStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fElementIndexStack, 0, nArray, 0, n);
            this.fElementIndexStack = nArray;
            nArray = new int[n * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, nArray, 0, n);
            this.fContentSpecTypeStack = nArray;
        }
    }

    public boolean externalEntityStandaloneCheck() {
        return this.fStandaloneReader != -1 && this.fValidating;
    }

    private int getAttDef(QName qName, QName qName2) {
        if (this.fGrammar != null) {
            int n;
            int n2 = this.fCurrentScope;
            if (qName.uri > -1) {
                n2 = -1;
            }
            if ((n = this.fGrammar.getElementDeclIndex(qName, n2)) == -1) {
                return -1;
            }
            int n3 = this.fGrammar.getFirstAttributeDeclIndex(n);
            while (n3 != -1) {
                this.fGrammar.getAttributeDecl(n3, this.fTempAttDecl);
                if (this.fTempAttDecl.name.localpart == qName2.localpart && this.fTempAttDecl.name.uri == qName2.uri) {
                    return n3;
                }
                n3 = this.fGrammar.getNextAttributeDeclIndex(n3);
            }
        }
        return -1;
    }

    private int getAttDefByElementIndex(int n, QName qName) {
        if (this.fGrammar != null && n > -1) {
            if (n == -1) {
                return -1;
            }
            int n2 = this.fGrammar.getFirstAttributeDeclIndex(n);
            while (n2 != -1) {
                this.fGrammar.getAttributeDecl(n2, this.fTempAttDecl);
                if (this.fGrammarIsDTDGrammar ? this.fTempAttDecl.name.rawname == qName.rawname : this.fTempAttDecl.name.localpart == qName.localpart && this.fTempAttDecl.name.uri == qName.uri) {
                    return n2;
                }
                if (this.fGrammarIsSchemaGrammar) {
                    if (this.fTempAttDecl.type == 8) {
                        return n2;
                    }
                    if (this.fTempAttDecl.type == 10 ? qName.uri == -1 : (this.fTempAttDecl.type == 9 ? qName.uri != this.fTempAttDecl.name.uri : this.fTempAttDecl.type == 11 && this.fStringPool.stringInList(this.fTempAttDecl.enumeration, qName.uri))) {
                        return n2;
                    }
                }
                n2 = this.fGrammar.getNextAttributeDeclIndex(n2);
            }
        }
        return -1;
    }

    protected boolean getAttDefIsExternal(QName qName, QName qName2) {
        int n = this.getAttDef(qName, qName2);
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(n);
        }
        return false;
    }

    public int getContentSpecHandle(int n) {
        int n2 = -1;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            n2 = this.fTempElementDecl.contentSpecIndex;
        }
        return n2;
    }

    public int getContentSpecType(int n) {
        int n2 = -1;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            n2 = this.fTempElementDecl.type;
        }
        return n2;
    }

    public boolean getDynamicValidationEnabled() {
        return this.fDynamicValidation;
    }

    private XMLContentModel getElementContentModel(int n) throws CMException {
        XMLContentModel xMLContentModel = null;
        if (n > -1 && this.fGrammar.getElementDecl(n, this.fTempElementDecl)) {
            xMLContentModel = this.fGrammar.getElementContentModel(n);
        }
        return xMLContentModel;
    }

    private boolean getElementDeclIsExternal(int n) {
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getElementDeclIsExternal(n);
        }
        return false;
    }

    private LocatorImpl getLocatorImpl(LocatorImpl locatorImpl) {
        Locator locator = this.fErrorReporter.getLocator();
        if (locatorImpl == null) {
            return new LocatorImpl(locator);
        }
        locatorImpl.setPublicId(locator.getPublicId());
        locatorImpl.setSystemId(locator.getSystemId());
        locatorImpl.setLineNumber(locator.getLineNumber());
        locatorImpl.setColumnNumber(locator.getColumnNumber());
        return locatorImpl;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public boolean getSchemaValidationEnabled() {
        return this.fSchemaValidation;
    }

    public boolean getValidating() {
        return this.fValidating;
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    private AttributeValidator getValidatorForAttType(int n, boolean bl) {
        if (n == 0) {
            if (this.fAttValidatorCDATA == null) {
                this.fAttValidatorCDATA = new AttValidatorCDATA();
            }
            return this.fAttValidatorCDATA;
        }
        if (n == 3) {
            if (this.fAttValidatorID == null) {
                this.fAttValidatorID = new AttValidatorID();
            }
            return this.fAttValidatorID;
        }
        if (n == 4) {
            if (!bl) {
                if (this.fAttValidatorIDREF == null) {
                    this.fAttValidatorIDREF = new AttValidatorIDREF();
                }
                return this.fAttValidatorIDREF;
            }
            if (this.fAttValidatorIDREFS == null) {
                this.fAttValidatorIDREFS = new AttValidatorIDREFS();
            }
            return this.fAttValidatorIDREFS;
        }
        if (n == 1) {
            if (!bl) {
                if (this.fAttValidatorENTITY == null) {
                    this.fAttValidatorENTITY = new AttValidatorENTITY();
                }
                return this.fAttValidatorENTITY;
            }
            if (this.fAttValidatorENTITIES == null) {
                this.fAttValidatorENTITIES = new AttValidatorENTITIES();
            }
            return this.fAttValidatorENTITIES;
        }
        if (n == 5) {
            if (!bl) {
                if (this.fAttValidatorNMTOKEN == null) {
                    this.fAttValidatorNMTOKEN = new AttValidatorNMTOKEN();
                }
                return this.fAttValidatorNMTOKEN;
            }
            if (this.fAttValidatorNMTOKENS == null) {
                this.fAttValidatorNMTOKENS = new AttValidatorNMTOKENS();
            }
            return this.fAttValidatorNMTOKENS;
        }
        if (n == 6) {
            if (this.fAttValidatorNOTATION == null) {
                this.fAttValidatorNOTATION = new AttValidatorNOTATION();
            }
            return this.fAttValidatorNOTATION;
        }
        if (n == 2) {
            if (this.fAttValidatorENUMERATION == null) {
                this.fAttValidatorENUMERATION = new AttValidatorENUMERATION();
            }
            return this.fAttValidatorENUMERATION;
        }
        if (n == 7 && this.fAttValidatorDATATYPE == null) {
            this.fAttValidatorDATATYPE = null;
        }
        return null;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public boolean getWarningOnUndeclaredElements() {
        return this.fWarningOnUndeclaredElements;
    }

    private void init() {
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/1999/XMLSchema-instance");
        this.fEMPTYSymbol = this.fStringPool.addSymbol("EMPTY");
        this.fANYSymbol = this.fStringPool.addSymbol("ANY");
        this.fMIXEDSymbol = this.fStringPool.addSymbol("MIXED");
        this.fCHILDRENSymbol = this.fStringPool.addSymbol("CHILDREN");
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fIDSymbol = this.fStringPool.addSymbol("ID");
        this.fIDREFSymbol = this.fStringPool.addSymbol("IDREF");
        this.fIDREFSSymbol = this.fStringPool.addSymbol("IDREFS");
        this.fENTITYSymbol = this.fStringPool.addSymbol("ENTITY");
        this.fENTITIESSymbol = this.fStringPool.addSymbol("ENTITIES");
        this.fNMTOKENSymbol = this.fStringPool.addSymbol("NMTOKEN");
        this.fNMTOKENSSymbol = this.fStringPool.addSymbol("NMTOKENS");
        this.fNOTATIONSymbol = this.fStringPool.addSymbol("NOTATION");
        this.fENUMERATIONSymbol = this.fStringPool.addSymbol("ENUMERATION");
        this.fREQUIREDSymbol = this.fStringPool.addSymbol("#REQUIRED");
        this.fFIXEDSymbol = this.fStringPool.addSymbol("#FIXED");
        this.fDATATYPESymbol = this.fStringPool.addSymbol("<<datatype>>");
        this.fEpsilonIndex = this.fStringPool.addSymbol("<<CMNODE_EPSILON>>");
        this.fXMLLang = this.fStringPool.addSymbol("xml:lang");
    }

    public void initHandlers(boolean bl, XMLDocumentHandler xMLDocumentHandler, XMLDocumentHandler.DTDHandler dTDHandler) {
        this.fSendCharDataAsCharArray = bl;
        this.fEntityHandler.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
        this.fDocumentHandler = xMLDocumentHandler;
        this.fDTDHandler = dTDHandler;
    }

    public int normalizeAttValue(QName qName, QName qName2, int n, int n2, boolean bl, int n3) throws Exception {
        AttributeValidator attributeValidator = this.getValidatorForAttType(n2, bl);
        if (attributeValidator != null) {
            return attributeValidator.normalize(qName, qName2, n, n2, n3);
        }
        return -1;
    }

    void parseSchemaLocation(String string, Hashtable hashtable) {
        StringTokenizer stringTokenizer;
        int n;
        if (hashtable != null && (n = (stringTokenizer = new StringTokenizer(string, " \n\t\r", false)).countTokens()) % 2 == 0) {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                hashtable.put(string3, string2);
            }
        }
    }

    private void poolReset() {
        if (this.fIdDefs != null) {
            this.fIdDefs.clear();
        }
        if (this.fIdRefs != null) {
            this.fIdRefs.clear();
        }
    }

    private void printChildren() {
    }

    private void printStack() {
    }

    public void processCharacters(int n) throws Exception {
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                this.fDatatypeBuffer.append(this.fStringPool.toString(n));
            }
        }
        this.fDocumentHandler.characters(n);
    }

    public void processCharacters(char[] cArray, int n, int n2) throws Exception {
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                this.fDatatypeBuffer.append(cArray, n, n2);
            }
        }
        this.fDocumentHandler.characters(cArray, n, n2);
    }

    public void processWhitespace(int n) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(n);
        } else {
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            this.fDocumentHandler.characters(n);
        }
    }

    public void processWhitespace(char[] cArray, int n, int n2) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(cArray, n, n2);
        } else {
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            this.fDocumentHandler.characters(cArray, n, n2);
        }
    }

    protected void reportRecoverableXMLError(int n, int n2) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, null, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray = new Object[]{this.fStringPool.toString(n3), this.fStringPool.toString(n4)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string) throws Exception {
        Object[] objectArray = new Object[]{string};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2) throws Exception {
        Object[] objectArray = new Object[]{string, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    protected void reportRecoverableXMLError(int n, int n2, String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[]{string, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n, n2, objectArray, 1);
    }

    public void reset(StringPool stringPool) throws Exception {
        this.fAttrList.reset(stringPool);
        this.resetCommon(stringPool);
    }

    private void resetCommon(StringPool stringPool) throws Exception {
        this.fStringPool = stringPool;
        this.fValidating = this.fValidationEnabled;
        this.fValidationEnabledByDynamic = false;
        this.fDynamicDisabledByValidation = false;
        this.poolReset();
        this.fCalledStartDocument = false;
        this.fStandaloneReader = -1;
        this.fElementChildrenLength = 0;
        this.fElementDepth = -1;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fNamespacesScope = null;
        this.fNamespacesPrefix = -1;
        this.fRootElement.clear();
        this.fAttrListHandle = -1;
        this.fCheckedForSchema = false;
        this.fCurrentScope = -1;
        this.fCurrentSchemaURI = -1;
        this.fEmptyURI = -1;
        this.fXsiPrefix = -1;
        this.fGrammar = null;
        this.fGrammarNameSpaceIndex = -1;
        this.fGrammarResolver = null;
        this.fGrammarIsDTDGrammar = false;
        this.fGrammarIsSchemaGrammar = false;
        this.init();
    }

    public void resetOrCopy(StringPool stringPool) throws Exception {
        this.fAttrList = new XMLAttrList(stringPool);
        this.resetCommon(stringPool);
    }

    private void resolveSchemaGrammar(String string) throws Exception {
        this.resolveSchemaGrammar(string, string);
    }

    private void resolveSchemaGrammar(String string, String string2) throws Exception {
        block12: {
            SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
            if (schemaGrammar != null) break block12;
            DOMParser dOMParser = new DOMParser();
            dOMParser.setEntityResolver(new Resolver(this.fEntityHandler));
            dOMParser.setErrorHandler(new ErrorHandler());
            try {
                dOMParser.setFeature("http://xml.org/sax/features/validation", false);
                dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
                dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                sAXNotRecognizedException.printStackTrace();
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                sAXNotSupportedException.printStackTrace();
            }
            InputSource inputSource = null;
            EntityResolver entityResolver = dOMParser.getEntityResolver();
            if (entityResolver != null) {
                inputSource = entityResolver.resolveEntity("", string);
            }
            if (inputSource == null) {
                string = this.fEntityHandler.expandSystemId(string);
                inputSource = new InputSource(string);
            }
            try {
                dOMParser.parse(inputSource);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                this.reportRecoverableXMLError(169, 146, sAXException.getMessage());
            }
            Document document = dOMParser.getDocument();
            TraverseSchema traverseSchema = null;
            try {
                Element element = document.getDocumentElement();
                if (element == null) {
                    this.reportRecoverableXMLError(169, 146, "Can't get back Schema document's root element :" + string);
                    break block12;
                }
                if (string2 == null || !string2.equals(element.getAttribute("targetNamespace"))) {
                    this.reportRecoverableXMLError(169, 146, "Schema in " + string + " has a different target namespace " + "from the one specified in the instance document :" + string2);
                }
                schemaGrammar = new SchemaGrammar();
                schemaGrammar.setGrammarDocument(document);
                traverseSchema = new TraverseSchema(element, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, inputSource.getSystemId());
                this.fGrammarResolver.putGrammar(document.getDocumentElement().getAttribute("targetNamespace"), schemaGrammar);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    private void rootElementSpecified(QName qName) throws Exception {
        if (this.fValidating) {
            String string;
            String string2;
            if (this.fGrammar == null) {
                this.fGrammar = this.fGrammarResolver.getGrammar("");
                boolean bl = this.fGrammar == null;
                if (false) {
                    System.out.println("Oops! no grammar is found for validation");
                }
                if (this.fDynamicValidation && this.fGrammar == null) {
                    this.fValidating = false;
                }
                if (this.fGrammar != null) {
                    if (this.fGrammar instanceof DTDGrammar) {
                        this.fGrammarIsDTDGrammar = true;
                        this.fGrammarIsSchemaGrammar = false;
                    } else if (this.fGrammar instanceof SchemaGrammar) {
                        this.fGrammarIsSchemaGrammar = true;
                        this.fGrammarIsDTDGrammar = false;
                    }
                    this.fGrammarNameSpaceIndex = this.fEmptyURI;
                }
            }
            if (this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getRootElementQName(this.fRootElement) && !(string2 = this.fStringPool.toString(this.fRootElement.rawname)).equals(string = this.fStringPool.toString(qName.rawname))) {
                this.reportRecoverableXMLError(3, 1, this.fRootElement.rawname, qName.rawname);
            }
        }
        if (this.fNamespacesEnabled && this.fNamespacesScope == null) {
            this.fNamespacesScope = new NamespacesScope(this);
            this.fNamespacesPrefix = this.fStringPool.addSymbol("xmlns");
            this.fNamespacesScope.setNamespaceForPrefix(this.fNamespacesPrefix, -1);
            int n = this.fStringPool.addSymbol("xml");
            int n2 = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
            this.fNamespacesScope.setNamespaceForPrefix(n, n2);
        }
    }

    public void scanAttributeName(XMLEntityHandler.EntityReader entityReader, QName qName, QName qName2) throws Exception {
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            this.rootElementSpecified(qName);
            this.fStringPool.resetShuffleCount();
        }
        if (!this.fNamespacesEnabled) {
            qName2.clear();
            qName2.rawname = qName2.localpart = entityReader.scanName('=');
        } else {
            entityReader.scanQName('=', qName2);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public void scanElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (!this.fNamespacesEnabled) {
            qName.clear();
            qName.rawname = qName.localpart = entityReader.scanName(c);
        } else {
            entityReader.scanQName(c, qName);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char c, QName qName) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(this.fCurrentElement.rawname, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(c, this.fCurrentElementCharArrayRange);
    }

    public void sendEndOfInputNotifications(int n, boolean bl) throws Exception {
        this.fDocumentScanner.endOfInput(n, bl);
    }

    public void sendReaderChangeNotifications(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        this.fDocumentScanner.readerChange(entityReader, n);
    }

    public void setDynamicValidationEnabled(boolean bl) throws Exception {
        this.fDynamicValidation = bl;
        this.fDynamicDisabledByValidation = false;
        if (!this.fDynamicValidation) {
            if (this.fValidationEnabledByDynamic) {
                this.fValidationEnabled = false;
                this.fValidationEnabledByDynamic = false;
            }
        } else if (!this.fValidationEnabled) {
            this.fValidationEnabled = true;
            this.fValidationEnabledByDynamic = true;
        }
        this.fValidating = this.fValidationEnabled;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void setNamespacesEnabled(boolean bl) {
        this.fNamespacesEnabled = bl;
    }

    public void setRootElementType(QName qName) {
        this.fRootElement.setValues(qName);
    }

    public void setSchemaValidationEnabled(boolean bl) {
        this.fSchemaValidation = bl;
    }

    public void setValidationEnabled(boolean bl) throws Exception {
        this.fValidationEnabled = bl;
        this.fValidationEnabledByDynamic = false;
        if (this.fValidationEnabled) {
            if (this.fDynamicDisabledByValidation) {
                this.fDynamicValidation = true;
                this.fDynamicDisabledByValidation = false;
            }
        } else if (this.fDynamicValidation) {
            this.fDynamicValidation = false;
            this.fDynamicDisabledByValidation = true;
        }
        this.fValidating = this.fValidationEnabled;
    }

    public void setWarningOnDuplicateAttDef(boolean bl) {
        this.fWarningOnDuplicateAttDef = bl;
    }

    public void setWarningOnUndeclaredElements(boolean bl) {
        this.fWarningOnUndeclaredElements = bl;
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        this.fDocumentHandler.startEntityReference(n, n2, n3);
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
        this.fDocumentHandler.startNamespaceDeclScope(n, n2);
    }

    private void switchGrammar(int n) {
        Grammar grammar = this.fGrammarResolver.getGrammar(this.fStringPool.toString(n));
        if (grammar == null) {
            grammar = this.fGrammarResolver.getGrammar("");
        }
        if (grammar == null) {
            System.out.println(String.valueOf(this.fStringPool.toString(n)) + " grammar not found");
        } else {
            this.fGrammar = grammar;
            if (this.fGrammar instanceof DTDGrammar) {
                this.fGrammarIsDTDGrammar = true;
                this.fGrammarIsSchemaGrammar = false;
            } else if (this.fGrammar instanceof SchemaGrammar) {
                this.fGrammarIsSchemaGrammar = true;
                this.fGrammarIsDTDGrammar = false;
            }
        }
    }

    private boolean usingStandaloneReader() {
        return this.fStandaloneReader == -1 || this.fEntityHandler.getReaderId() == this.fStandaloneReader;
    }

    private void validateDTDattribute(QName qName, int n, XMLAttributeDecl xMLAttributeDecl) throws Exception {
        AttributeValidator attributeValidator = null;
        switch (xMLAttributeDecl.type) {
            case 1: {
                if (xMLAttributeDecl.list) {
                    attributeValidator = this.fAttValidatorENTITIES;
                    break;
                }
                attributeValidator = this.fAttValidatorENTITY;
                break;
            }
            case 2: {
                attributeValidator = this.fAttValidatorENUMERATION;
                break;
            }
            case 3: {
                attributeValidator = this.fAttValidatorID;
                break;
            }
            case 4: {
                if (xMLAttributeDecl.list) {
                    attributeValidator = this.fAttValidatorIDREFS;
                    break;
                }
                attributeValidator = this.fAttValidatorIDREF;
                break;
            }
            case 6: {
                attributeValidator = this.fAttValidatorNOTATION;
                break;
            }
            case 5: {
                if (xMLAttributeDecl.list) {
                    attributeValidator = this.fAttValidatorNMTOKENS;
                    break;
                }
                attributeValidator = this.fAttValidatorNMTOKEN;
                break;
            }
        }
        attributeValidator.normalize(qName, xMLAttributeDecl.name, n, xMLAttributeDecl.type, xMLAttributeDecl.enumeration);
    }

    private void validateElementAndAttributes(QName qName, XMLAttrList xMLAttrList) throws Exception {
        int n;
        Object[] objectArray;
        int n2;
        Object object;
        if (this.fGrammar == null && !this.fValidating && !this.fNamespacesEnabled) {
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fAttrListHandle != -1) {
                this.fAttrList.endAttrList();
                int n3 = this.fAttrList.getFirstAttr(this.fAttrListHandle);
                while (n3 != -1) {
                    if (this.fStringPool.equalNames(this.fAttrList.getAttrName(n3), this.fXMLLang)) {
                        this.fDocumentScanner.checkXMLLangAttributeValue(this.fAttrList.getAttValue(n3));
                        break;
                    }
                    n3 = this.fAttrList.getNextAttr(n3);
                }
            }
            return;
        }
        int n4 = -1;
        if (this.fGrammar != null) {
            n4 = this.fGrammar.getElementDeclIndex(qName, this.fCurrentScope);
            if (n4 == -1) {
                n4 = this.fGrammar.getElementDeclIndex(qName, -1);
            }
            if (n4 == -1 && this.fGrammarIsSchemaGrammar && this.fCurrentElementIndex != -1) {
                object = null;
                object = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(this.fCurrentElementIndex);
                while (object != null) {
                    n4 = this.fGrammar.getElementDeclIndex(qName, ((TraverseSchema.ComplexTypeInfo)object).scopeDefined);
                    if (n4 > -1) break;
                    object = ((TraverseSchema.ComplexTypeInfo)object).baseComplexTypeInfo;
                }
            }
        }
        if (this.fGrammarIsSchemaGrammar && n4 != -1) {
            if (this.fXsiTypeAttValue > -1) {
                object = this.fStringPool.toString(this.fXsiTypeAttValue);
                n2 = ((String)object).indexOf(":");
                String string = "";
                String string2 = object;
                if (n2 > -1) {
                    string = ((String)object).substring(0, n2);
                    string2 = ((String)object).substring(n2 + 1);
                }
                String string3 = "";
                int n5 = -1;
                if (this.fNamespacesScope != null && (n5 = this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string))) > -1) {
                    string3 = this.fStringPool.toString(n5);
                    if (n5 != this.fGrammarNameSpaceIndex) {
                        this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = n5;
                        this.switchGrammar(this.fCurrentSchemaURI);
                    }
                }
                if ((objectArray = ((SchemaGrammar)this.fGrammar).getComplexTypeRegistry()) == null) {
                    this.reportRecoverableXMLError(169, 146, String.valueOf(this.fErrorReporter.getLocator().getSystemId()) + " line" + this.fErrorReporter.getLocator().getLineNumber() + ", canot resolve xsi:type = " + (String)object + "  ---2");
                } else {
                    TraverseSchema.ComplexTypeInfo complexTypeInfo = (TraverseSchema.ComplexTypeInfo)objectArray.get(String.valueOf(string3) + "," + string2);
                    if (complexTypeInfo == null) {
                        this.reportRecoverableXMLError(169, 146, "unsupported case in xsi:type handling");
                    } else {
                        n4 = complexTypeInfo.templateElementIndex;
                    }
                }
                this.fXsiTypeAttValue = -1;
            }
            this.fCurrentScope = ((SchemaGrammar)this.fGrammar).getElementDefinedScope(n4);
            object = ((SchemaGrammar)this.fGrammar).getElementFromAnotherSchemaURI(n4);
            if (object != null) {
                this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = this.fStringPool.addSymbol((String)object);
                this.switchGrammar(this.fCurrentSchemaURI);
            }
        }
        if ((n = this.getContentSpecType(n4)) == -1 && this.fValidating) {
            this.reportRecoverableXMLError(83, 79, qName.rawname);
        }
        if (this.fGrammar != null && n4 != -1) {
            this.fAttrListHandle = this.addDefaultAttributes(n4, xMLAttrList, this.fAttrListHandle, this.fValidating, this.fStandaloneReader != -1);
        }
        if (this.fAttrListHandle != -1) {
            this.fAttrList.endAttrList();
        }
        if (this.fAttrListHandle != -1) {
            n2 = this.fAttrList.getFirstAttr(this.fAttrListHandle);
            while (n2 != -1) {
                int n6;
                int n7 = xMLAttrList.getAttrName(n2);
                if (this.fStringPool.equalNames(n7, this.fXMLLang)) {
                    this.fDocumentScanner.checkXMLLangAttributeValue(xMLAttrList.getAttValue(n2));
                }
                if (n7 != (n6 = this.fStringPool.addSymbol("xmlns")) && xMLAttrList.getAttrPrefix(n2) != n6 && this.fValidating) {
                    this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                    this.fTempQName.setValues(xMLAttrList.getAttrPrefix(n2), xMLAttrList.getAttrLocalpart(n2), xMLAttrList.getAttrName(n2), xMLAttrList.getAttrURI(n2));
                    int n8 = this.getAttDefByElementIndex(n4, this.fTempQName);
                    if (this.fTempQName.uri != this.fXsiURI) {
                        if (n8 == -1) {
                            Object[] objectArray2 = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(xMLAttrList.getAttrName(n2))};
                            this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray2, 1);
                        } else {
                            this.fGrammar.getAttributeDecl(n8, this.fTempAttDecl);
                            int n9 = this.attributeTypeName(this.fTempAttDecl);
                            xMLAttrList.setAttType(n2, n9);
                            if (this.fGrammarIsDTDGrammar && (this.fTempAttDecl.type == 1 || this.fTempAttDecl.type == 2 || this.fTempAttDecl.type == 3 || this.fTempAttDecl.type == 4 || this.fTempAttDecl.type == 5 || this.fTempAttDecl.type == 6)) {
                                this.validateDTDattribute(qName, xMLAttrList.getAttValue(n2), this.fTempAttDecl);
                            }
                            if (this.fGrammarIsSchemaGrammar && (this.fTempAttDecl.type == 3 || this.fTempAttDecl.type == 4)) {
                                this.validateDTDattribute(qName, xMLAttrList.getAttValue(n2), this.fTempAttDecl);
                            }
                            if (this.fGrammarIsSchemaGrammar && (this.fTempAttDecl.type == 8 || this.fTempAttDecl.type == 11 || this.fTempAttDecl.type == 10 || this.fTempAttDecl.type == 9)) {
                                if (this.fTempAttDecl.defaultType != 6 && (this.fTempAttDecl.defaultType == 4 || this.fTempAttDecl.defaultType == 5)) {
                                    Object[] objectArray3;
                                    boolean bl;
                                    boolean bl2 = false;
                                    boolean bl3 = bl = this.fTempAttDecl.defaultType == 4;
                                    if (this.fTempQName.uri == -1) {
                                        if (bl) {
                                            bl2 = true;
                                        }
                                    } else {
                                        objectArray3 = this.fGrammarResolver.getGrammar(this.fStringPool.toString(this.fTempQName.uri));
                                        if (objectArray3 == null || !(objectArray3 instanceof SchemaGrammar)) {
                                            if (bl) {
                                                bl2 = true;
                                            }
                                        } else {
                                            SchemaGrammar schemaGrammar = (SchemaGrammar)objectArray3;
                                            Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
                                            if (hashtable == null) {
                                                if (bl) {
                                                    bl2 = true;
                                                }
                                            } else {
                                                XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(this.fStringPool.toString(this.fTempQName.localpart));
                                                if (xMLAttributeDecl == null) {
                                                    if (bl) {
                                                        bl2 = true;
                                                    }
                                                } else {
                                                    DatatypeValidator datatypeValidator = xMLAttributeDecl.datatypeValidator;
                                                    if (datatypeValidator == null) {
                                                        if (bl) {
                                                            bl2 = true;
                                                        }
                                                    } else {
                                                        try {
                                                            datatypeValidator.validate(this.fStringPool.toString(xMLAttrList.getAttValue(n2)), null);
                                                        }
                                                        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                                                            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{invalidDatatypeValueException.getMessage()}, 1);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (bl2) {
                                        objectArray3 = new Object[]{this.fStringPool.toString(qName.rawname), "ANY---" + this.fStringPool.toString(xMLAttrList.getAttrName(n2))};
                                        this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray3, 1);
                                    }
                                }
                            } else if (this.fTempAttDecl.datatypeValidator == null) {
                                objectArray = new Object[]{this.fStringPool.toString(qName.rawname), this.fStringPool.toString(xMLAttrList.getAttrName(n2))};
                                System.out.println("[Error] Datatypevalidator for attribute " + this.fStringPool.toString(xMLAttrList.getAttrName(n2)) + " not found in element type " + this.fStringPool.toString(qName.rawname));
                                this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, objectArray, 1);
                            } else {
                                try {
                                    this.fTempAttDecl.datatypeValidator.validate(this.fStringPool.toString(xMLAttrList.getAttValue(n2)), null);
                                }
                                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{invalidDatatypeValueException.getMessage()}, 1);
                                }
                            }
                        }
                    }
                }
                n2 = this.fAttrList.getNextAttr(n2);
            }
        }
        if (this.fAttrListHandle != -1) {
            n2 = xMLAttrList.getFirstAttr(this.fAttrListHandle);
            while (n2 != -1) {
                int n10;
                int n11 = xMLAttrList.getAttrName(n2);
                if (!this.fStringPool.equalNames(n11, this.fNamespacesPrefix) && (n10 = xMLAttrList.getAttrPrefix(n2)) != this.fNamespacesPrefix && n10 != -1) {
                    int n12 = this.fNamespacesScope.getNamespaceForPrefix(n10);
                    if (n12 == -1) {
                        Object[] objectArray4 = new Object[]{this.fStringPool.toString(n10)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, objectArray4, 1);
                    }
                    xMLAttrList.setAttrURI(n2, n12);
                }
                n2 = xMLAttrList.getNextAttr(n2);
            }
        }
        this.fCurrentElementIndex = n4;
        this.fCurrentContentSpecType = n;
        if (this.fValidating && n == 4) {
            this.fBufferDatatype = true;
            this.fDatatypeBuffer.setLength(0);
        }
        this.fInElementContent = n == 3;
    }

    protected int whatCanGoHere(int n, boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        if (insertableElementsInfo.insertAt > insertableElementsInfo.childCount || insertableElementsInfo.curChildren == null || insertableElementsInfo.childCount < 1 || insertableElementsInfo.childCount > insertableElementsInfo.curChildren.length) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 13, 0, null, 2);
        }
        int n2 = 0;
        try {
            XMLContentModel xMLContentModel = this.getElementContentModel(n);
            n2 = xMLContentModel.whatCanGoHere(bl, insertableElementsInfo);
        }
        catch (CMException cMException) {
            int n3 = cMException.getErrorCode();
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", n3, 0, null, 2);
            throw cMException;
        }
        return n2;
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};
        private DefaultEntityHandler fEntityHandler;

        public Resolver(DefaultEntityHandler defaultEntityHandler) {
            this.fEntityHandler = defaultEntityHandler;
        }

        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            InputSource inputSource;
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource2 = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource2.setPublicId(string);
                    inputSource2.setSystemId(string2);
                    return inputSource2;
                }
                ++n;
            }
            EntityResolver entityResolver = this.fEntityHandler.getEntityResolver();
            if (entityResolver != null && (inputSource = entityResolver.resolveEntity(string, string2)) != null) {
                return inputSource;
            }
            return new InputSource(this.fEntityHandler.expandSystemId(string2));
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    public static interface AttributeValidator {
        public int normalize(QName var1, QName var2, int var3, int var4, int var5) throws Exception;
    }

    final class AttValidatorCDATA
    implements AttributeValidator {
        AttValidatorCDATA() {
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            return n;
        }
    }

    final class AttValidatorID
    implements AttributeValidator {
        AttValidatorID() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLCharacterProperties.validName(string2)) {
                    XMLValidator.this.reportRecoverableXMLError(75, 76, XMLValidator.this.fStringPool.toString(qName2.rawname), string2);
                }
                if (qName.rawname != -1 && !XMLValidator.this.addId(n)) {
                    XMLValidator.this.reportRecoverableXMLError(76, 76, XMLValidator.this.fStringPool.toString(qName2.rawname), string2);
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }

    final class AttValidatorIDREF
    implements AttributeValidator {
        AttValidatorIDREF() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLCharacterProperties.validName(string2)) {
                    XMLValidator.this.reportRecoverableXMLError(77, 2, XMLValidator.this.fStringPool.toString(qName2.rawname), string2);
                }
                if (qName.rawname != -1) {
                    XMLValidator.this.addIdRef(n);
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }

    final class AttValidatorIDREFS
    implements AttributeValidator {
        AttValidatorIDREFS() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string;
            String string2 = XMLValidator.this.fStringPool.toString(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string = stringTokenizer.nextToken();
                    if (XMLValidator.this.fValidating) {
                        if (!XMLCharacterProperties.validName(string)) {
                            bl = false;
                        }
                        if (qName.rawname != -1) {
                            XMLValidator.this.addIdRef(XMLValidator.this.fStringPool.addSymbol(string));
                        }
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (XMLValidator.this.fValidating && (!bl || string.length() == 0)) {
                XMLValidator.this.reportRecoverableXMLError(4, 2, XMLValidator.this.fStringPool.toString(qName2.rawname), string);
            }
            if (!string.equals(string2)) {
                n = XMLValidator.this.fStringPool.addString(string);
                if (XMLValidator.this.fValidating && this.invalidStandaloneAttDef(qName, qName2)) {
                    XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, string);
                }
            }
            return n;
        }
    }

    final class AttValidatorENTITY
    implements AttributeValidator {
        AttValidatorENTITY() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLValidator.this.fEntityHandler.isUnparsedEntity(n)) {
                    XMLValidator.this.reportRecoverableXMLError(79, 77, XMLValidator.this.fStringPool.toString(qName2.rawname), string2);
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }

    final class AttValidatorENTITIES
    implements AttributeValidator {
        AttValidatorENTITIES() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string;
            String string2 = XMLValidator.this.fStringPool.toString(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string = stringTokenizer.nextToken();
                    if (XMLValidator.this.fValidating && !XMLValidator.this.fEntityHandler.isUnparsedEntity(XMLValidator.this.fStringPool.addSymbol(string))) {
                        bl = false;
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (XMLValidator.this.fValidating && (!bl || string.length() == 0)) {
                XMLValidator.this.reportRecoverableXMLError(80, 77, XMLValidator.this.fStringPool.toString(qName2.rawname), string);
            }
            if (!string.equals(string2)) {
                n = XMLValidator.this.fStringPool.addString(string);
                if (XMLValidator.this.fValidating && this.invalidStandaloneAttDef(qName, qName2)) {
                    XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, string);
                }
            }
            return n;
        }
    }

    final class AttValidatorNMTOKEN
    implements AttributeValidator {
        AttValidatorNMTOKEN() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLCharacterProperties.validNmtoken(string2)) {
                    XMLValidator.this.reportRecoverableXMLError(78, 3, XMLValidator.this.fStringPool.toString(qName2.rawname), string2);
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }

    final class AttValidatorNMTOKENS
    implements AttributeValidator {
        AttValidatorNMTOKENS() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string;
            String string2 = XMLValidator.this.fStringPool.toString(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            boolean bl = true;
            if (stringTokenizer.hasMoreTokens()) {
                while (true) {
                    string = stringTokenizer.nextToken();
                    if (XMLValidator.this.fValidating && !XMLCharacterProperties.validNmtoken(string)) {
                        bl = false;
                    }
                    stringBuffer.append(string);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    stringBuffer.append(' ');
                }
            }
            string = stringBuffer.toString();
            if (XMLValidator.this.fValidating && (!bl || string.length() == 0)) {
                XMLValidator.this.reportRecoverableXMLError(5, 3, XMLValidator.this.fStringPool.toString(qName2.rawname), string);
            }
            if (!string.equals(string2)) {
                n = XMLValidator.this.fStringPool.addString(string);
                if (XMLValidator.this.fValidating && this.invalidStandaloneAttDef(qName, qName2)) {
                    XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, string);
                }
            }
            return n;
        }
    }

    final class AttValidatorNOTATION
    implements AttributeValidator {
        AttValidatorNOTATION() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLValidator.this.fStringPool.stringInList(n3, n)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 84, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, XMLValidator.this.fStringPool.stringListAsString(n3));
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }

    final class AttValidatorENUMERATION
    implements AttributeValidator {
        AttValidatorENUMERATION() {
        }

        boolean invalidStandaloneAttDef(QName qName, QName qName2) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (qName.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(qName, qName2);
        }

        public int normalize(QName qName, QName qName2, int n, int n2, int n3) throws Exception {
            String string = XMLValidator.this.fStringPool.toString(n);
            String string2 = string.trim();
            if (XMLValidator.this.fValidating) {
                if (string2 != string) {
                    if (this.invalidStandaloneAttDef(qName, qName2)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(qName2.rawname), string, string2);
                    }
                    n = XMLValidator.this.fStringPool.addSymbol(string2);
                } else {
                    n = XMLValidator.this.fStringPool.addSymbol(n);
                }
                if (!XMLValidator.this.fStringPool.stringInList(n3, n)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 86, XMLValidator.this.fStringPool.toString(qName2.rawname), string2, XMLValidator.this.fStringPool.stringListAsString(n3));
                }
            } else if (string2 != string) {
                n = XMLValidator.this.fStringPool.addSymbol(string2);
            }
            return n;
        }
    }
}

