/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRPrintAnchor;
import dori.jasper.engine.JRPrintAnchorIndex;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRReportFont;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JasperPrint
implements Serializable {
    private static final long serialVersionUID = 402L;
    private String name = null;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private byte orientation = 1;
    private JRReportFont defaultFont = null;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private List pages = new ArrayList();
    private Map anchorIndexes = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte orientation) {
        this.orientation = orientation;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(JRReportFont font) {
        this.defaultFont = font;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] fontsArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(fontsArray);
        return fontsArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public void addFont(JRReportFont reportFont) throws JRException {
        if (this.fontsMap.containsKey(reportFont.getName())) {
            throw new JRException("Duplicate declaration of report font : " + reportFont.getName());
        }
        this.fontsList.add(reportFont);
        this.fontsMap.put(reportFont.getName(), reportFont);
        if (reportFont.isDefault()) {
            this.setDefaultFont(reportFont);
        }
    }

    public void removeFont(String name) {
        this.removeFont((JRReportFont)this.fontsMap.get(name));
    }

    public void removeFont(JRReportFont reportFont) {
        if (reportFont != null) {
            if (reportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(reportFont);
            this.fontsMap.remove(reportFont.getName());
        }
    }

    public List getPages() {
        return this.pages;
    }

    public void addPage(JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(page);
    }

    public void addPage(int index, JRPrintPage page) {
        this.anchorIndexes = null;
        this.pages.add(index, page);
    }

    public JRPrintPage removePage(int index) {
        this.anchorIndexes = null;
        return (JRPrintPage)this.pages.remove(index);
    }

    public Map getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap();
            JRPrintPage page = null;
            int i = 0;
            Iterator itp = this.pages.iterator();
            while (itp.hasNext()) {
                page = (JRPrintPage)itp.next();
                Collection elements = page.getElements();
                if (elements != null && elements.size() > 0) {
                    JRPrintElement element = null;
                    Iterator it = elements.iterator();
                    while (it.hasNext()) {
                        element = (JRPrintElement)it.next();
                        if (!(element instanceof JRPrintAnchor)) continue;
                        this.anchorIndexes.put(((JRPrintAnchor)((Object)element)).getAnchorName(), new JRPrintAnchorIndex(i, element));
                    }
                }
                ++i;
            }
        }
        return this.anchorIndexes;
    }

    static {
        serialVersionUID = 402L;
    }
}

