/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.print.JRPrinterAWT;
import dori.jasper.engine.print.JRPrinterPDF;
import dori.jasper.engine.print.JRPrinterXML;
import dori.jasper.engine.util.JRLoader;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JasperPrintManager {
    public static String printReportToPdfFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperPrintManager.printReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void printReportToPdfFile(String sourceFileName, String destFileName) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperPrintManager.printReportToPdfFile(jasperPrint, destFileName);
    }

    public static void printReportToPdfFile(JasperPrint jasperPrint, String destFileName) throws JRException {
        byte[] bytes = JRPrinterPDF.printReport(jasperPrint);
        try {
            FileOutputStream fos = new FileOutputStream(destFileName);
            fos.write(bytes, 0, bytes.length);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, e);
        }
    }

    public static void printReportToPdfStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperPrintManager.printReportToPdfStream(jasperPrint, outputStream);
    }

    public static void printReportToPdfStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        byte[] bytes = JRPrinterPDF.printReport(jasperPrint);
        try {
            outputStream.write(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new JRException("Error writing to OutputStream : " + jasperPrint.getName(), e);
        }
    }

    public static byte[] printReportToPdf(JasperPrint jasperPrint) throws JRException {
        return JRPrinterPDF.printReport(jasperPrint);
    }

    public static String printReportToXmlFile(String sourceFileName, boolean isEmbeddingImages) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".jrpxml");
        String destFileName = destFile.toString();
        JasperPrintManager.printReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
        return destFileName;
    }

    public static void printReportToXmlFile(String sourceFileName, String destFileName, boolean isEmbeddingImages) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperPrintManager.printReportToXmlFile(jasperPrint, destFileName, isEmbeddingImages);
    }

    public static void printReportToXmlFile(JasperPrint jasperPrint, String destFileName, boolean isEmbeddingImages) throws JRException {
        JRPrinterXML.printReport(jasperPrint, destFileName, isEmbeddingImages);
    }

    public static void printReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperPrintManager.printReportToXmlStream(jasperPrint, outputStream);
    }

    public static void printReportToXmlStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPrinterXML.printReport(jasperPrint, outputStream);
    }

    public static String printReportToXml(JasperPrint jasperPrint) throws JRException {
        return JRPrinterXML.printReport(jasperPrint);
    }

    public static void printReport(String sourceFileName, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static void printReport(InputStream inputStream, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperPrintManager.printReport(jasperPrint, withPrintDialog);
    }

    public static void printReport(JasperPrint jasperPrint, boolean withPrintDialog) throws JRException {
        JasperPrintManager.printPages(jasperPrint, 0, jasperPrint.getPages().size() - 1, withPrintDialog);
    }

    public static void printPage(String sourceFileName, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static void printPage(InputStream inputStream, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperPrintManager.printPage(jasperPrint, pageIndex, withPrintDialog);
    }

    public static void printPage(JasperPrint jasperPrint, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrintManager.printPages(jasperPrint, pageIndex, pageIndex, withPrintDialog);
    }

    public static void printPages(String sourceFileName, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static void printPages(InputStream inputStream, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        JasperPrintManager.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static void printPages(JasperPrint jasperPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JRPrinterAWT.printPages(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(String sourceFileName, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(sourceFileName);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(InputStream inputStream, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return JasperPrintManager.printPageToImage(jasperPrint, pageIndex, zoom);
    }

    public static Image printPageToImage(JasperPrint jasperPrint, int pageIndex, float zoom) throws JRException {
        return JRPrinterAWT.printPageToImage(jasperPrint, pageIndex, zoom);
    }
}

