/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.design;

import dori.jasper.engine.JRAnchor;
import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRElement;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRExpressionChunk;
import dori.jasper.engine.JRField;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRHyperlink;
import dori.jasper.engine.JRImage;
import dori.jasper.engine.JRParameter;
import dori.jasper.engine.JRQuery;
import dori.jasper.engine.JRQueryChunk;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JRSubreport;
import dori.jasper.engine.JRSubreportParameter;
import dori.jasper.engine.JRTextElement;
import dori.jasper.engine.JRTextField;
import dori.jasper.engine.JRVariable;
import dori.jasper.engine.design.JasperDesign;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JRVerifier {
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$dori$jasper$engine$JasperReport;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$dori$jasper$engine$JRDataSource;

    protected JRVerifier(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        this.brokenRules = new ArrayList();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) throws JRException {
        JRVerifier verifier = new JRVerifier(jasperDesign);
        return verifier.verifyDesign();
    }

    protected Collection verifyDesign() throws JRException {
        this.verifyDesignAttributes();
        this.verifyExpressions();
        this.verifyReportFonts();
        this.verifyParameters();
        this.verifyQuery();
        this.verifyFields();
        this.verifyVariables();
        this.verifyGroups();
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifyBand(this.jasperDesign.getDetail());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        return this.brokenRules;
    }

    private void verifyDesignAttributes() throws JRException {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.brokenRules.add("Report name is missing.");
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.brokenRules.add("Column count must be greater than zero.");
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.brokenRules.add("Page width must be positive.");
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.brokenRules.add("Page height must be positive.");
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.brokenRules.add("Column width must be positive.");
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.brokenRules.add("Column spacing must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.brokenRules.add("Left margin must be positive.");
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.brokenRules.add("Right margin must be positive.");
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.brokenRules.add("Top margin must be positive.");
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.brokenRules.add("Bottom margin must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.brokenRules.add("The columns and the margins do not fit the page width.");
        }
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The title section and the margins do not fit the page height.");
            }
        } else if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The title section, the page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getSummary() != null ? this.jasperDesign.getSummary().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The summary section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getDetail() != null ? this.jasperDesign.getDetail().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The detail section, the page and column headers and footers and the margins do not fit the page height.");
        }
    }

    private void verifyQuery() throws JRException {
        JRQueryChunk[] chunks;
        JRQuery query = this.jasperDesign.getQuery();
        if (query != null && (chunks = query.getChunks()) != null && chunks.length > 0) {
            JRQueryChunk queryChunk = null;
            Map parametersMap = this.jasperDesign.getParametersMap();
            JRParameter parameter = null;
            Class clazz = null;
            int j = 0;
            while (j < chunks.length) {
                queryChunk = chunks[j];
                switch (queryChunk.getType()) {
                    case 2: {
                        parameter = (JRParameter)parametersMap.get(queryChunk.getText());
                        if (parameter == null) {
                            this.brokenRules.add("Query parameter not found : " + queryChunk.getText());
                            break;
                        }
                        clazz = parameter.getValueClass();
                        if (clazz.equals(class$java$lang$Object == null ? JRVerifier.class$("java.lang.Object") : class$java$lang$Object) || clazz.equals(class$java$lang$Boolean == null ? JRVerifier.class$("java.lang.Boolean") : class$java$lang$Boolean) || clazz.equals(class$java$lang$Byte == null ? JRVerifier.class$("java.lang.Byte") : class$java$lang$Byte) || clazz.equals(class$java$lang$Double == null ? JRVerifier.class$("java.lang.Double") : class$java$lang$Double) || clazz.equals(class$java$lang$Float == null ? JRVerifier.class$("java.lang.Float") : class$java$lang$Float) || clazz.equals(class$java$lang$Integer == null ? JRVerifier.class$("java.lang.Integer") : class$java$lang$Integer) || clazz.equals(class$java$lang$Long == null ? JRVerifier.class$("java.lang.Long") : class$java$lang$Long) || clazz.equals(class$java$lang$Short == null ? JRVerifier.class$("java.lang.Short") : class$java$lang$Short) || clazz.equals(class$java$lang$String == null ? JRVerifier.class$("java.lang.String") : class$java$lang$String) || clazz.equals(class$java$util$Date == null ? JRVerifier.class$("java.util.Date") : class$java$util$Date) || clazz.equals(class$java$sql$Timestamp == null ? JRVerifier.class$("java.sql.Timestamp") : class$java$sql$Timestamp)) break;
                        this.brokenRules.add("Parameter type not supported in query : " + queryChunk.getText() + " class " + clazz.getName());
                        break;
                    }
                }
                ++j;
            }
        }
    }

    private void verifyExpressions() throws JRException {
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            Map parametersMap = this.jasperDesign.getParametersMap();
            Map fieldsMap = this.jasperDesign.getFieldsMap();
            Map variablesMap = this.jasperDesign.getVariablesMap();
            JRExpression expression = null;
            JRExpressionChunk[] chunks = null;
            JRExpressionChunk expressionChunk = null;
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                expression = (JRExpression)it.next();
                chunks = expression.getChunks();
                if (chunks == null || chunks.length <= 0) continue;
                int j = 0;
                while (j < chunks.length) {
                    expressionChunk = chunks[j];
                    switch (expressionChunk.getType()) {
                        case 4: {
                            if (variablesMap.containsKey(expressionChunk.getText())) break;
                            this.brokenRules.add("Variable not found : " + expressionChunk.getText());
                            break;
                        }
                        case 3: {
                            if (fieldsMap.containsKey(expressionChunk.getText())) break;
                            this.brokenRules.add("Field not found : " + expressionChunk.getText());
                            break;
                        }
                        case 2: {
                            if (parametersMap.containsKey(expressionChunk.getText())) break;
                            this.brokenRules.add("Parameter not found : " + expressionChunk.getText());
                            break;
                        }
                    }
                    ++j;
                }
            }
        }
    }

    private void verifyReportFonts() throws JRException {
        JRReportFont[] fonts = this.jasperDesign.getFonts();
        if (fonts != null && fonts.length > 0) {
            JRReportFont font = null;
            int index = 0;
            while (index < fonts.length) {
                font = fonts[index];
                if (font.getName() == null || font.getName().trim().length() == 0) {
                    this.brokenRules.add("Report font name missing.");
                }
                ++index;
            }
        }
    }

    private void verifyParameters() throws JRException {
        JRParameter[] parameters = this.jasperDesign.getParameters();
        if (parameters != null && parameters.length > 0) {
            JRParameter parameter = null;
            JRExpression expression = null;
            Class valueClass = null;
            int index = 0;
            while (index < parameters.length) {
                parameter = parameters[index];
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                    this.brokenRules.add("Parameter name missing.");
                }
                if ((valueClass = parameter.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for parameter : " + parameter.getName());
                } else {
                    expression = parameter.getDefaultValueExpression();
                    if (expression != null && !valueClass.isAssignableFrom(expression.getValueClass())) {
                        this.brokenRules.add("The parameter default value expression class is not compatible with the parameter's class : " + parameter.getName());
                    }
                }
                ++index;
            }
        }
    }

    private void verifyFields() throws JRException {
        JRField[] fields = this.jasperDesign.getFields();
        if (fields != null && fields.length > 0) {
            JRField field = null;
            Class clazz = null;
            int index = 0;
            while (index < fields.length) {
                field = fields[index];
                if (field.getName() == null || field.getName().trim().length() == 0) {
                    this.brokenRules.add("Field name missing.");
                }
                if ((clazz = field.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for field : " + field.getName());
                } else if (!(clazz.equals(class$java$lang$Object == null ? JRVerifier.class$("java.lang.Object") : class$java$lang$Object) || clazz.equals(class$java$lang$Boolean == null ? JRVerifier.class$("java.lang.Boolean") : class$java$lang$Boolean) || clazz.equals(class$java$lang$Byte == null ? JRVerifier.class$("java.lang.Byte") : class$java$lang$Byte) || clazz.equals(class$java$util$Date == null ? JRVerifier.class$("java.util.Date") : class$java$util$Date) || clazz.equals(class$java$sql$Timestamp == null ? JRVerifier.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || clazz.equals(class$java$lang$Double == null ? JRVerifier.class$("java.lang.Double") : class$java$lang$Double) || clazz.equals(class$java$lang$Float == null ? JRVerifier.class$("java.lang.Float") : class$java$lang$Float) || clazz.equals(class$java$lang$Integer == null ? JRVerifier.class$("java.lang.Integer") : class$java$lang$Integer) || clazz.equals(class$java$io$InputStream == null ? JRVerifier.class$("java.io.InputStream") : class$java$io$InputStream) || clazz.equals(class$java$lang$Long == null ? JRVerifier.class$("java.lang.Long") : class$java$lang$Long) || clazz.equals(class$java$lang$Short == null ? JRVerifier.class$("java.lang.Short") : class$java$lang$Short) || clazz.equals(class$java$math$BigDecimal == null ? JRVerifier.class$("java.math.BigDecimal") : class$java$math$BigDecimal) || clazz.equals(class$java$lang$String == null ? JRVerifier.class$("java.lang.String") : class$java$lang$String))) {
                    this.brokenRules.add("Class " + clazz + " not supported for field : " + field.getName() + ". Use java.lang.Object instead.");
                }
                ++index;
            }
        }
    }

    private void verifyVariables() throws JRException {
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            JRVariable variable = null;
            JRExpression expression = null;
            Object chunks = null;
            Object itChunks = null;
            Object expressionChunk = null;
            Class valueClass = null;
            int index = 0;
            while (index < variables.length) {
                variable = variables[index];
                if (variable.getName() == null || variable.getName().trim().length() == 0) {
                    this.brokenRules.add("Variable name missing.");
                }
                if ((valueClass = variable.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for variable : " + variable.getName());
                } else {
                    expression = variable.getExpression();
                    if (expression != null && variable.getCalculation() != 1 && !valueClass.isAssignableFrom(expression.getValueClass())) {
                        this.brokenRules.add("The variable expression class is not compatible with the variable's class : " + variable.getName());
                    }
                    if (variable.getInitialValueExpression() != null && !valueClass.isAssignableFrom(variable.getInitialValueExpression().getValueClass())) {
                        this.brokenRules.add("The initial value class is not compatible with the variable's class : " + variable.getName());
                    }
                    switch (variable.getCalculation()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: {
                            if ((class$java$lang$Number == null ? JRVerifier.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(valueClass)) break;
                            this.brokenRules.add("Only variables that hold java.lang.Number compatible values can be used to calculate the Count, Sum, Average, Standard Deviation or Variance.");
                            break;
                        }
                        case 4: 
                        case 5: {
                            if ((class$java$lang$Comparable == null ? JRVerifier.class$("java.lang.Comparable") : class$java$lang$Comparable).isAssignableFrom(valueClass)) break;
                            this.brokenRules.add("Only variables that hold java.lang.Comparable compatible values can be used to calculate the Highest or Lowest.");
                            break;
                        }
                    }
                }
                if (variable.getResetType() == 4) {
                    if (variable.getResetGroup() == null) {
                        this.brokenRules.add("Reset group missing for variable : " + variable.getName());
                    } else {
                        Map groupsMap = this.jasperDesign.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getResetGroup().getName())) {
                            this.brokenRules.add("Reset group \"" + variable.getResetGroup().getName() + "\" not found for variable : " + variable.getName());
                        }
                    }
                }
                ++index;
            }
        }
    }

    private void verifyGroups() throws JRException {
        JRGroup[] groups = this.jasperDesign.getGroups();
        if (groups != null && groups.length > 0) {
            JRGroup group = null;
            JRExpression expression = null;
            Class clazz = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                if (group.getName() == null || group.getName().trim().length() == 0) {
                    this.brokenRules.add("Group name missing.");
                }
                if (this.jasperDesign.isTitleNewPage()) {
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.");
                    }
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.");
                    }
                } else {
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.");
                    }
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.");
                    }
                }
                if ((expression = group.getExpression()) != null && (clazz = expression.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for group expression : " + group.getName());
                }
                this.verifyBand(group.getGroupHeader());
                this.verifyBand(group.getGroupFooter());
                ++index;
            }
        }
    }

    private void verifyBand(JRBand band) throws JRException {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null && elements.length > 0) {
            JRExpression expression = band.getPrintWhenExpression();
            Class clazz = null;
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for band \"print when\" expression.");
                } else if (!(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.");
                }
            }
            JRElement element = null;
            int index = 0;
            while (index < elements.length) {
                element = elements[index];
                expression = element.getPrintWhenExpression();
                if (expression != null) {
                    clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.brokenRules.add("Class not set for element \"print when\" expression.");
                    } else if (!(class$java$lang$Boolean == null ? JRVerifier.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                        this.brokenRules.add("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.");
                    }
                }
                if (element.getY() < 0) {
                    System.out.println("Warning : Element placed outside band area : y=" + element.getY());
                } else if (element.getY() + element.getHeight() > band.getHeight()) {
                    System.out.println("Warning : Element placed outside band area : y=" + element.getY() + " height=" + element.getHeight() + " band-height=" + band.getHeight());
                }
                if (element instanceof JRTextField) {
                    this.verifyTextField((JRTextField)element);
                } else if (element instanceof JRImage) {
                    this.verifyImage((JRImage)element);
                } else if (element instanceof JRSubreport) {
                    this.verifySubreport((JRSubreport)element);
                }
                ++index;
            }
        }
    }

    private void verifyTextField(JRTextField textField) throws JRException {
        JRExpression expression;
        this.verifyTextElement(textField);
        this.verifyAnchor(textField);
        this.verifyHyperlink(textField);
        if (textField != null && (expression = textField.getExpression()) != null) {
            Class clazz = expression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for text field expression.");
            } else if (!(clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRVerifier.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz.equals(class$java$util$Date == null ? (class$java$util$Date = JRVerifier.class$("java.util.Date")) : class$java$util$Date) || clazz.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRVerifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) || clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRVerifier.class$("java.lang.Double")) : class$java$lang$Double) || clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRVerifier.class$("java.lang.Float")) : class$java$lang$Float) || clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRVerifier.class$("java.lang.Long")) : class$java$lang$Long) || clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRVerifier.class$("java.lang.Short")) : class$java$lang$Short) || clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String))) {
                this.brokenRules.add("Class " + clazz + " not supported for text field expression.");
            }
        }
    }

    private void verifyTextElement(JRTextElement textElement) throws JRException {
        Map fontsMap;
        JRReportFont reportFont;
        JRFont font;
        if (textElement != null && (font = textElement.getFont()) != null && (reportFont = font.getReportFont()) != null && reportFont.getName() != null && !(fontsMap = this.jasperDesign.getFontsMap()).containsKey(reportFont.getName())) {
            this.brokenRules.add("Report font not found : " + reportFont.getName());
        }
    }

    private void verifyAnchor(JRAnchor anchor) throws JRException {
        if (anchor != null) {
            JRExpression expression = anchor.getAnchorNameExpression();
            Class clazz = null;
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for anchor name expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.");
                }
            }
        }
    }

    private void verifyHyperlink(JRHyperlink hyperlink) throws JRException {
        if (hyperlink != null) {
            JRExpression expression = hyperlink.getHyperlinkReferenceExpression();
            Class clazz = null;
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink reference expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink reference expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkAnchorExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink anchor expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink anchor expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkPageExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink page expression.");
                } else if (!(class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink page expression. Use java.lang.Integer instead.");
                }
            }
        }
    }

    private void verifyImage(JRImage image) throws JRException {
        JRExpression expression;
        this.verifyAnchor(image);
        this.verifyHyperlink(image);
        if (image != null && (expression = image.getExpression()) != null) {
            Class clazz = expression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for image expression.");
            } else if (!(clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File) || clazz.equals(class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL) || clazz.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream) || clazz.equals(class$java$awt$Image == null ? (class$java$awt$Image = JRVerifier.class$("java.awt.Image")) : class$java$awt$Image))) {
                this.brokenRules.add("Class " + clazz + " not supported for image expression.");
            }
        }
    }

    private void verifySubreport(JRSubreport subreport) throws JRException {
        if (subreport != null) {
            JRSubreportParameter[] parameters;
            JRExpression expression = subreport.getExpression();
            Class clazz = null;
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport expression.");
                } else if (!(clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String) || clazz.equals(class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File) || clazz.equals(class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL) || clazz.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream) || clazz.equals(class$dori$jasper$engine$JasperReport == null ? (class$dori$jasper$engine$JasperReport = JRVerifier.class$("dori.jasper.engine.JasperReport")) : class$dori$jasper$engine$JasperReport))) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport expression.");
                }
            }
            if ((expression = subreport.getParametersMapExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport parameters map expression.");
                } else if (!(class$java$util$Map == null ? (class$java$util$Map = JRVerifier.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport parameters map expression. Use java.util.Map instead.");
                }
            }
            if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
                JRSubreportParameter parameter = null;
                int index = 0;
                while (index < parameters.length) {
                    parameter = parameters[index];
                    if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                        this.brokenRules.add("Subreport parameter name missing.");
                    }
                    if ((expression = parameter.getExpression()) != null && (clazz = expression.getValueClass()) == null) {
                        this.brokenRules.add("Class not set for subreport parameter expression : " + parameter.getName() + ". Use java.lang.Object class.");
                    }
                    ++index;
                }
            }
            if (subreport.getConnectionExpression() != null && subreport.getDataSourceExpression() != null) {
                this.brokenRules.add("Subreport cannot have both connection expresion and data source expression.");
            }
            if ((expression = subreport.getConnectionExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport connection expression.");
                } else if (!(class$java$sql$Connection == null ? (class$java$sql$Connection = JRVerifier.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.");
                }
            }
            if ((expression = subreport.getDataSourceExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport data source expression.");
                } else if (!(class$dori$jasper$engine$JRDataSource == null ? (class$dori$jasper$engine$JRDataSource = JRVerifier.class$("dori.jasper.engine.JRDataSource")) : class$dori$jasper$engine$JRDataSource).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport data source expression. Use dori.jasper.engine.JRDataSource instead.");
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

