/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.fill;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRImage;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.fill.JRBaseFiller;
import dori.jasper.engine.fill.JRFillGraphicElement;
import dori.jasper.engine.fill.JRFillObjectFactory;
import dori.jasper.engine.fill.JRTemplateImage;
import dori.jasper.engine.fill.JRTemplatePrintImage;
import dori.jasper.engine.util.JRImageLoader;
import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup = null;
    private byte[] imageData = null;
    private boolean isValueRepeating = false;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    protected JRFillImage(JRBaseFiller filler, JRImage image, Map fillObjectsMap) {
        super(filler, image, fillObjectsMap);
        this.evaluationGroup = JRFillObjectFactory.getGroup(filler, image.getEvaluationGroup(), fillObjectsMap);
    }

    public byte getScaleImage() {
        return ((JRImage)this.parent).getScaleImage();
    }

    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    public byte getEvaluationTime() {
        return ((JRImage)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public byte getHyperlinkType() {
        return ((JRImage)this.parent).getHyperlinkType();
    }

    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected byte[] getImageData() {
        return this.imageData;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected JRTemplateImage getJRTemplateImage() {
        if (this.template == null) {
            this.template = new JRTemplateImage((JRImage)this.parent);
        }
        return (JRTemplateImage)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        JRExpression expression = this.getExpression();
        byte[] newImageData = null;
        Object source = this.filler.calculator.evaluate(expression, evaluation);
        if (source != null) {
            Class expressionClass = expression.getValueClass();
            if (expressionClass.equals(class$java$awt$Image == null ? (class$java$awt$Image = JRFillImage.class$("java.awt.Image")) : class$java$awt$Image)) {
                Image img = (Image)source;
                newImageData = JRImageLoader.loadImageDataFromAWTImage(img);
            } else if (expressionClass.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRFillImage.class$("java.io.InputStream")) : class$java$io$InputStream)) {
                InputStream is = (InputStream)source;
                newImageData = JRImageLoader.loadImageDataFromInputStream(is);
            } else if (expressionClass.equals(class$java$net$URL == null ? (class$java$net$URL = JRFillImage.class$("java.net.URL")) : class$java$net$URL)) {
                URL url = (URL)source;
                newImageData = JRImageLoader.loadImageDataFromURL(url);
            } else if (expressionClass.equals(class$java$io$File == null ? (class$java$io$File = JRFillImage.class$("java.io.File")) : class$java$io$File)) {
                File file = (File)source;
                newImageData = JRImageLoader.loadImageDataFromFile(file);
            } else if (expressionClass.equals(class$java$lang$String == null ? (class$java$lang$String = JRFillImage.class$("java.lang.String")) : class$java$lang$String)) {
                String location = (String)source;
                if (this.isUsingCache()) {
                    if (this.filler.loadedImages.containsKey(location)) {
                        newImageData = ((JRPrintImage)this.filler.loadedImages.get(location)).getImageData();
                    } else {
                        newImageData = JRImageLoader.loadImageDataFromLocation(location);
                        JRTemplatePrintImage img = new JRTemplatePrintImage(this.getJRTemplateImage());
                        img.setImageData(newImageData);
                        this.filler.loadedImages.put(location, img);
                    }
                } else {
                    newImageData = JRImageLoader.loadImageDataFromLocation(location);
                }
            }
        }
        this.isValueRepeating = this.imageData == newImageData;
        this.imageData = newImageData;
        this.anchorName = (String)this.filler.calculator.evaluate(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.filler.calculator.evaluate(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.filler.calculator.evaluate(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.filler.calculator.evaluate(this.getHyperlinkPageExpression(), evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating || this.isPrintInFirstWholeBand() && this.getBand().isNewPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && (this.getImageData() == null || this.getImageData().length == 0)) {
                isToPrint = false;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage printImage = null;
        printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setHeight(this.getStretchHeight());
        switch (this.getEvaluationTime()) {
            case 2: {
                this.filler.reportBoundImages.put(printImage, this);
                break;
            }
            case 3: {
                this.filler.pageBoundImages.put(printImage, this);
                break;
            }
            case 4: {
                this.filler.columnBoundImages.put(printImage, this);
                break;
            }
            case 5: {
                Map specificGroupBoundImages = (Map)this.filler.groupBoundImages.get(this.getEvaluationGroup().getName());
                specificGroupBoundImages.put(printImage, this);
                break;
            }
            default: {
                printImage.setImageData(this.getImageData());
                printImage.setAnchorName(this.getAnchorName());
                printImage.setHyperlinkReference(this.getHyperlinkReference());
                printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
                printImage.setHyperlinkPage(this.getHyperlinkPage());
            }
        }
        return printImage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

