/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;


import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class ImageReportElement extends GraphicReportElement 
{
	public Image img=null;
	public Image defimg=null;
	public String imageExpression;
	public String imageClass;
	public String scaleImage;
	public String hyperlinkType="None";
	public String evaluationTime="Now";
	public String evaluationGroup="";
	
	public String anchorNameExpression="";
	public String hyperlinkReferenceExpression="";
	public String hyperlinkAnchorExpression="";
	public String hyperlinkPageExpression="";
	
	public boolean isUsingCache;
	
	public ImageReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x,y,width,height,hached);
		img = null;
		isUsingCache=false;
		imageExpression="";
		imageClass="java.lang.String";
		scaleImage="RetainShape";
		graphicElementPen = "None";
	}
	
	public void drawObject(Graphics g, double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		Image imgx = img;
		if (imgx==null) imgx=defimg;
			
		if (imgx != null)
		{
			if (imgx instanceof Bitmap)
			{
				((Bitmap)imgx).setTransparent(true);
			}
			
			// 
			
			if (scaleImage.equalsIgnoreCase("RetainShape"))
			{
				if (imgx.getSize().x <= width && imgx.getSize().y<= height)
				{
					Rectangle paintrect = new Rectangle(-x_shift_origin+ getZoomedDim( position.x-10)+10 ,-y_shift_origin+getZoomedDim(position.y-10)+10, getZoomedDim( imgx.getSize().x), getZoomedDim( imgx.getSize().y));
					g.drawImage( imgx, new Rectangle(0,0,imgx.getSize().x,imgx.getSize().y), paintrect,true);
				}
				else if (width>0 && height>0)// Resize based on minor x/WIDTH... e y/HEIGHT
				{
					if ((double)((double)imgx.getSize().x/(double)width)> (double)((double)imgx.getSize().y/(double)height))
					{
						Rectangle source = new Rectangle(0,0,imgx.getSize().x,imgx.getSize().y);
						Rectangle destination = new Rectangle(-x_shift_origin+ getZoomedDim( position.x-10)+10 ,-y_shift_origin+getZoomedDim(position.y-10)+10,getZoomedDim(width) ,getZoomedDim(Math.min( (imgx.getSize().y*width)/imgx.getSize().x, height)) );
						g.drawImage( imgx,source,destination, true );
					}
					else
					{
						Rectangle source = new Rectangle(0,0,imgx.getSize().x,imgx.getSize().y);
						Rectangle destination = new Rectangle(-x_shift_origin+ getZoomedDim( position.x-10)+10 ,-y_shift_origin+getZoomedDim(position.y-10)+10, getZoomedDim( Math.min( (imgx.getSize().x*height)/imgx.getSize().y, width)) ,getZoomedDim( height) );
						g.drawImage( imgx,source,destination, true );
					}
				}
				
			}
			else if (scaleImage.equalsIgnoreCase("FillFrame"))
			{
				Rectangle paintrect = new Rectangle(-x_shift_origin+ getZoomedDim( position.x-10)+10 ,-y_shift_origin+getZoomedDim(position.y-10)+10, getZoomedDim( this.width), getZoomedDim( this.height));
				g.drawImage( imgx, new Rectangle(0,0,imgx.getSize().x,imgx.getSize().y), paintrect, true );
			}
			else
			{
				g.drawImage( imgx, new Rectangle(0,0,Math.min( imgx.getSize().x, width) ,Math.min( imgx.getSize().y,  height)), new Rectangle(-x_shift_origin+ getZoomedDim( position.x-10)+10 ,-y_shift_origin+getZoomedDim(position.y-10)+10,getZoomedDim( Math.min(imgx.getSize().x, width)),getZoomedDim( Math.min(imgx.getSize().y, height))), true );
			}
		}
		
		super.drawGraphicsElement(g,graphicElementPen,zoom_factor, x_shift_origin, y_shift_origin);
	}
	
	public ReportElement cloneMe()
	{
		ImageReportElement newReportElement = new ImageReportElement(position.x, position.y, width, height, hached);
		newReportElement.name = new String(name);
		newReportElement.img = img;
		newReportElement.defimg = defimg;
		newReportElement.imageExpression = imageExpression;
		newReportElement.imageClass = imageClass;
		newReportElement.isUsingCache = isUsingCache;
		newReportElement.scaleImage = scaleImage;
		newReportElement.bgcolor = bgcolor;
		newReportElement.fgcolor = fgcolor;
		newReportElement.graphicElementPen = graphicElementPen;
		return newReportElement;
	}
}
