/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintGraphicElement;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignFont;
import dori.jasper.engine.export.JRXmlExporterParameter;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.xml.JRXmlConstants;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    private static JRFont baseFont = new JRDesignFont();
    private JasperPrint jasperPrint = null;
    private StringBuffer sbuffer = null;
    private Map loadedImagesMap = null;
    private Map fontsMap = new HashMap();
    private boolean isEmbeddingImages = true;
    private File destFile = null;
    private File imagesDir = null;
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);

    public void exportReport() throws JRException {
        StringBuffer sb;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        if ((sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            sb.append(this.exportReportToBuffer().toString());
        } else {
            OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (os != null) {
                String xmlString = this.exportReportToBuffer().toString();
                try {
                    byte[] bytes = xmlString.getBytes("UTF-8");
                    os.write(bytes, 0, bytes.length);
                }
                catch (Exception e) {
                    throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                }
            } else {
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getPath() + "_files");
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                this.exportReportToFile();
            }
        }
    }

    private void exportReportToFile() throws JRException {
        Set imageKeys;
        if (!this.isEmbeddingImages) {
            this.loadedImagesMap = new HashMap();
        }
        String xmlString = this.exportReportToBuffer().toString();
        try {
            byte[] bytes = xmlString.getBytes("UTF-8");
            FileOutputStream fos = new FileOutputStream(this.destFile);
            fos.write(bytes, 0, bytes.length);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new JRException("Error writing to file : " + this.destFile, e);
        }
        if (!this.isEmbeddingImages && (imageKeys = this.loadedImagesMap.keySet()) != null && imageKeys.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            byte[] imageData = null;
            File imageFile = null;
            FileOutputStream fos = null;
            Iterator it = imageKeys.iterator();
            while (it.hasNext()) {
                imageData = (byte[])it.next();
                imageFile = new File(this.imagesDir, (String)this.loadedImagesMap.get(imageData));
                try {
                    fos = new FileOutputStream(imageFile);
                    fos.write(imageData, 0, imageData.length);
                    fos.close();
                }
                catch (Exception e) {
                    throw new JRException("Error writing to image file : " + imageFile, e);
                }
            }
        }
    }

    private StringBuffer exportReportToBuffer() throws JRException {
        List pages;
        this.sbuffer = new StringBuffer();
        this.sbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.sbuffer.append("<!DOCTYPE jasperPrint PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperprint.dtd\">\n");
        this.sbuffer.append("\n");
        this.sbuffer.append("<jasperPrint name=\"");
        this.sbuffer.append(this.jasperPrint.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pageWidth=\"");
        this.sbuffer.append(this.jasperPrint.getPageWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pageHeight=\"");
        this.sbuffer.append(this.jasperPrint.getPageHeight());
        this.sbuffer.append("\"");
        if (this.jasperPrint.getOrientation() != 1) {
            this.sbuffer.append(" orientation=\"");
            this.sbuffer.append((String)JRXmlConstants.getOrientationMap().get(new Byte(this.jasperPrint.getOrientation())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        JRReportFont[] fonts = this.jasperPrint.getFonts();
        if (fonts != null && fonts.length > 0) {
            int i = 0;
            while (i < fonts.length) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.exportReportFont(fonts[i]);
                ++i;
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            Iterator it = pages.iterator();
            while (it.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)it.next();
                this.exportPage(page);
            }
        }
        this.sbuffer.append("</jasperPrint>\n");
        return this.sbuffer;
    }

    private void exportReportFont(JRReportFont font) {
        this.sbuffer.append("\t<reportFont");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(font.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isDefault=\"");
        this.sbuffer.append(font.isDefault());
        this.sbuffer.append("\"");
        this.sbuffer.append(" fontName=\"");
        this.sbuffer.append(font.getFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" size=\"");
        this.sbuffer.append(font.getSize());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isBold=\"");
        this.sbuffer.append(font.isBold());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isItalic=\"");
        this.sbuffer.append(font.isItalic());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isUnderline=\"");
        this.sbuffer.append(font.isUnderline());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isStrikeThrough=\"");
        this.sbuffer.append(font.isStrikeThrough());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfFontName=\"");
        this.sbuffer.append(font.getPdfFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfEncoding=\"");
        this.sbuffer.append(font.getPdfEncoding());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isPdfEmbedded=\"");
        this.sbuffer.append(font.isPdfEmbedded());
        this.sbuffer.append("\"");
        this.sbuffer.append("/>\n");
    }

    private void exportPage(JRPrintPage page) throws JRException {
        this.sbuffer.append("\t<page>\n");
        JRPrintElement element = null;
        Collection elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        this.sbuffer.append("\t</page>\n");
    }

    private void exportLine(JRPrintLine line) {
        this.sbuffer.append("\t\t<line");
        if (line.getDirection() != 1) {
            this.sbuffer.append(" direction=\"");
            this.sbuffer.append((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.sbuffer.append("\t\t</line>\n");
    }

    private void exportReportElement(JRPrintElement element) {
        String hexa;
        this.sbuffer.append("\t\t\t<reportElement");
        if (element instanceof JRPrintLine && element.getMode() != 1 || element instanceof JRPrintRectangle && element.getMode() != 1 || element instanceof JRPrintEllipse && element.getMode() != 1 || element instanceof JRPrintImage && element.getMode() != 2 || element instanceof JRPrintText && element.getMode() != 2) {
            this.sbuffer.append(" mode=\"");
            this.sbuffer.append((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" x=\"");
        this.sbuffer.append(element.getX());
        this.sbuffer.append("\"");
        this.sbuffer.append(" y=\"");
        this.sbuffer.append(element.getY());
        this.sbuffer.append("\"");
        this.sbuffer.append(" width=\"");
        this.sbuffer.append(element.getWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" height=\"");
        this.sbuffer.append(element.getHeight());
        this.sbuffer.append("\"");
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.sbuffer.append(" forecolor=\"#");
            hexa = Integer.toHexString(element.getForecolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.sbuffer.append(hexa);
            this.sbuffer.append("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.sbuffer.append(" backcolor=\"#");
            hexa = Integer.toHexString(element.getBackcolor().getRGB() & colorMask).toUpperCase();
            hexa = ("000000" + hexa).substring(hexa.length());
            this.sbuffer.append(hexa);
            this.sbuffer.append("\"");
        }
        this.sbuffer.append("/>\n");
    }

    private void exportGraphicElement(JRPrintGraphicElement element) {
        this.sbuffer.append("\t\t\t<graphicElement");
        if (element instanceof JRPrintLine && element.getPen() != 1 || element instanceof JRPrintRectangle && element.getPen() != 1 || element instanceof JRPrintEllipse && element.getPen() != 1 || element instanceof JRPrintImage && element.getPen() != 0) {
            this.sbuffer.append(" pen=\"");
            this.sbuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.sbuffer.append("\"");
        }
        if (element.getFill() != 1) {
            this.sbuffer.append(" fill=\"");
            this.sbuffer.append((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append("/>\n");
    }

    private void exportRectangle(JRPrintRectangle rectangle) {
        this.sbuffer.append("\t\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.sbuffer.append(" radius=\"");
            this.sbuffer.append(rectangle.getRadius());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.sbuffer.append("\t\t</rectangle>\n");
    }

    private void exportEllipse(JRPrintEllipse ellipse) {
        this.sbuffer.append("\t\t\t<ellipse>\n");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.sbuffer.append("\t\t</ellipse>\n");
    }

    private void exportImage(JRPrintImage image) throws JRException {
        this.sbuffer.append("\t\t<image");
        if (image.getScaleImage() != 3) {
            this.sbuffer.append(" scaleImage=\"");
            this.sbuffer.append((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        if (image.getAnchorName() != null) {
            this.sbuffer.append(" anchorName=\"");
            this.sbuffer.append(image.getAnchorName());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkReference() != null) {
            this.sbuffer.append(" hyperlinkReference=\"");
            this.sbuffer.append(image.getHyperlinkReference());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkAnchor() != null) {
            this.sbuffer.append(" hyperlinkAnchor=\"");
            this.sbuffer.append(image.getHyperlinkAnchor());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkPage() != null) {
            this.sbuffer.append(" hyperlinkPage=\"");
            this.sbuffer.append(image.getHyperlinkPage());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(image);
        this.exportGraphicElement(image);
        if (image.getImageData() != null) {
            this.sbuffer.append("\t\t\t<imageSource");
            if (this.isEmbeddingImages) {
                this.sbuffer.append(" isEmbedded=\"");
                this.sbuffer.append(this.isEmbeddingImages);
                this.sbuffer.append("\"");
            }
            this.sbuffer.append("><![CDATA[");
            String imageSource = "";
            if (this.isEmbeddingImages) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(image.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), "UTF-8");
                }
                catch (Exception e) {
                    throw new JRException("Error embedding image into XML.", e);
                }
            } else {
                byte[] imageData = image.getImageData();
                if (this.loadedImagesMap.containsKey(imageData)) {
                    imageSource = new File(new File(this.imagesDir.getName()), (String)this.loadedImagesMap.get(imageData)).getPath();
                } else {
                    imageSource = "img_" + String.valueOf(this.loadedImagesMap.size());
                    this.loadedImagesMap.put(imageData, imageSource);
                    imageSource = new File(new File(this.imagesDir.getName()), imageSource).getPath();
                }
            }
            this.sbuffer.append(imageSource);
            this.sbuffer.append("]]></imageSource>\n");
        }
        this.sbuffer.append("\t\t</image>\n");
    }

    private void exportText(JRPrintText text) {
        this.sbuffer.append("\t\t<text");
        if (text.getTextAlignment() != 1) {
            this.sbuffer.append(" textAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getTextAlignMap().get(new Byte(text.getTextAlignment())));
            this.sbuffer.append("\"");
        }
        if (text.getVerticalAlignment() != 1) {
            this.sbuffer.append(" verticalAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(text.getVerticalAlignment())));
            this.sbuffer.append("\"");
            this.sbuffer.append(" textHeight=\"");
            this.sbuffer.append(text.getTextHeight());
            this.sbuffer.append("\"");
        }
        if (text.getLineSpacing() != 0) {
            this.sbuffer.append(" lineSpacing=\"");
            this.sbuffer.append((String)JRXmlConstants.getLineSpacingMap().get(new Byte(text.getLineSpacing())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" absoluteLineSpacing=\"");
        this.sbuffer.append(text.getAbsoluteLineSpacing());
        this.sbuffer.append("\"");
        this.sbuffer.append(" absoluteLeading=\"");
        this.sbuffer.append(text.getAbsoluteLeading());
        this.sbuffer.append("\"");
        if (text.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(text.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        if (text.getAnchorName() != null) {
            this.sbuffer.append(" anchorName=\"");
            this.sbuffer.append(text.getAnchorName());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkReference() != null) {
            this.sbuffer.append(" hyperlinkReference=\"");
            this.sbuffer.append(text.getHyperlinkReference());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkAnchor() != null) {
            this.sbuffer.append(" hyperlinkAnchor=\"");
            this.sbuffer.append(text.getHyperlinkAnchor());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkPage() != null) {
            this.sbuffer.append(" hyperlinkPage=\"");
            this.sbuffer.append(text.getHyperlinkPage());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(text);
        String font = this.exportFont(text.getFont());
        if (font != null) {
            this.sbuffer.append("\t\t\t" + font + "\n");
        }
        if (text.getText() != null) {
            this.sbuffer.append("\t\t\t<textContent><![CDATA[");
            this.sbuffer.append(text.getText());
            this.sbuffer.append("]]></textContent>\n");
        }
        this.sbuffer.append("\t\t</text>\n");
    }

    private String exportFont(JRFont font) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (font == null) {
            font = this.jasperPrint.getDefaultFont();
        }
        if (font == null) {
            font = new JRDesignFont();
        }
        JRFont baseFont = null;
        if (font.getReportFont() == null) {
            baseFont = this.jasperPrint.getDefaultFont();
        } else {
            baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
            if (baseFont != null) {
                tmpBuffer.append(" reportFont=\"");
                tmpBuffer.append(font.getReportFont().getName());
                tmpBuffer.append("\"");
            } else {
                baseFont = this.jasperPrint.getDefaultFont();
            }
        }
        if (baseFont == null) {
            baseFont = new JRDesignFont();
        }
        if (!baseFont.getFontName().equals(font.getFontName())) {
            tmpBuffer.append(" fontName=\"");
            tmpBuffer.append(font.getFontName());
            tmpBuffer.append("\"");
        }
        if (font.getSize() != baseFont.getSize()) {
            tmpBuffer.append(" size=\"");
            tmpBuffer.append(font.getSize());
            tmpBuffer.append("\"");
        }
        if (font.isBold() != baseFont.isBold()) {
            tmpBuffer.append(" isBold=\"");
            tmpBuffer.append(font.isBold());
            tmpBuffer.append("\"");
        }
        if (font.isItalic() != baseFont.isItalic()) {
            tmpBuffer.append(" isItalic=\"");
            tmpBuffer.append(font.isItalic());
            tmpBuffer.append("\"");
        }
        if (font.isUnderline() != baseFont.isUnderline()) {
            tmpBuffer.append(" isUnderline=\"");
            tmpBuffer.append(font.isUnderline());
            tmpBuffer.append("\"");
        }
        if (font.isStrikeThrough() != baseFont.isStrikeThrough()) {
            tmpBuffer.append(" isStrikeThrough=\"");
            tmpBuffer.append(font.isStrikeThrough());
            tmpBuffer.append("\"");
        }
        if (!baseFont.getPdfFontName().equals(font.getPdfFontName())) {
            tmpBuffer.append(" pdfFontName=\"");
            tmpBuffer.append(font.getPdfFontName());
            tmpBuffer.append("\"");
        }
        if (!baseFont.getPdfEncoding().equals(font.getPdfEncoding())) {
            tmpBuffer.append(" pdfEncoding=\"");
            tmpBuffer.append(font.getPdfEncoding());
            tmpBuffer.append("\"");
        }
        if (font.isPdfEmbedded() != baseFont.isPdfEmbedded()) {
            tmpBuffer.append(" isPdfEmbedded=\"");
            tmpBuffer.append(font.isPdfEmbedded());
            tmpBuffer.append("\"");
        }
        if (tmpBuffer.length() > 0) {
            return "<font" + tmpBuffer.toString() + "/>";
        }
        return null;
    }
}

