/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.view;

import dori.jasper.engine.JRBand;
import dori.jasper.engine.JRElement;
import dori.jasper.engine.JREllipse;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.JRExpressionChunk;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRGroup;
import dori.jasper.engine.JRImage;
import dori.jasper.engine.JRLine;
import dori.jasper.engine.JRRectangle;
import dori.jasper.engine.JRReport;
import dori.jasper.engine.JRStaticText;
import dori.jasper.engine.JRSubreport;
import dori.jasper.engine.JRTextElement;
import dori.jasper.engine.JRTextField;
import dori.jasper.engine.JasperCompileManager;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.design.JRDesignFont;
import dori.jasper.engine.design.JasperDesign;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.util.JRStringUtil;
import dori.jasper.engine.xml.JRXmlLoader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class JRDesignViewer
extends JPanel {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_DESIGN = 3;
    private static final int[] zooms;
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JRReport report = null;
    private float zoom = 1.0f;
    private int offsetY = 0;
    private int upColumns = 0;
    private int downColumns = 0;
    private int downX = 0;
    private int downY = 0;
    private JScrollBar hBar = null;
    private JScrollBar vBar = null;
    private JToolBar tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlMain;
    private JPanel pnlSep02;
    private JButton btnReload;
    private JPanel jPanel5;
    private JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    private JButton btnZoomIn;
    private JPanel jPanel7;
    private JPanel pnlSep01;
    private JPanel jPanel6;
    private JComboBox cmbZoom;
    private JPanel jPanel9;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(JRReport report) throws JRException {
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(report);
        this.cmbZoom.setSelectedIndex(2);
    }

    private void initComponents() {
        this.tlbToolBar = new JToolBar();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        int i = 0;
        while (i < zooms.length) {
            model.addElement("" + zooms[i] + "%");
            ++i;
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setFloatable(false);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnReloadActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomInActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/dori/jasper/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.cmbZoomActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        this.lblPage.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRDesignViewer.this.lblPageMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseReleased(evt);
            }
        });
        this.lblPage.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.refreshDesign();
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(index + 1);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index > 0) {
            this.cmbZoom.setSelectedIndex(index - 1);
        }
    }

    private void lblPageMousePressed(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    private void lblPageMouseReleased(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(0));
    }

    private void lblPageMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        this.zoom = (float)zooms[index] / 100.0f;
        this.btnZoomIn.setEnabled(index < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(index > 0);
        this.refreshDesign();
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report definition not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
    }

    private void loadReport(String fileName, boolean isXML) throws JRException {
        if (isXML) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.verifyDesign(jasperDesign);
            this.report = jasperDesign;
        } else {
            this.report = (JasperReport)JRLoader.loadObject(fileName);
        }
        this.type = 1;
        this.isXML = isXML;
        this.reportFileName = fileName;
        this.setOffsetY();
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream is, boolean isXML) throws JRException {
        if (isXML) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.verifyDesign(jasperDesign);
            this.report = jasperDesign;
        } else {
            this.report = (JasperReport)JRLoader.loadObject(is);
        }
        this.type = 2;
        this.isXML = isXML;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JRReport report) throws JRException {
        this.report = report;
        this.type = 3;
        this.isXML = false;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    public void setOffsetY() {
        int i;
        this.offsetY = this.report.getTopMargin();
        this.offsetY += this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0;
        this.offsetY += this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0;
        this.upColumns = this.offsetY;
        this.offsetY += this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0;
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            i = 0;
            while (i < groups.length) {
                group = groups[i];
                this.offsetY += group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0;
                ++i;
            }
        }
        this.offsetY += this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0;
        if (groups != null && groups.length > 0) {
            i = groups.length - 1;
            while (i >= 0) {
                group = groups[i];
                this.offsetY += group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0;
                --i;
            }
        }
        this.offsetY += this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0;
        this.downColumns = this.offsetY;
        this.offsetY += this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0;
        this.offsetY += this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0;
        this.offsetY += this.report.getBottomMargin();
    }

    private void refreshDesign() {
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dim = new Dimension((int)((float)this.report.getPageWidth() * this.zoom) + 8, (int)((float)this.offsetY * this.zoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = this.printDesignToImage();
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblPage.setIcon(imageIcon);
    }

    private Image printDesignToImage() {
        BufferedImage designImage = new BufferedImage((int)((float)this.report.getPageWidth() * this.zoom) + 1, (int)((float)this.offsetY * this.zoom) + 1, 1);
        Graphics2D grx = (Graphics2D)((Image)designImage).getGraphics();
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.zoom, this.zoom);
        grx.transform(atrans);
        this.printDesign(grx);
        return designImage;
    }

    private void printDesign(Graphics2D grx) {
        int i;
        BasicStroke dashedStroke = new BasicStroke(1.0f / this.zoom, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        Color dashedColor = new Color(170, 170, 255);
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.report.getPageWidth() + 1, this.offsetY + 1);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(this.report.getLeftMargin(), 0, this.report.getLeftMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getPageWidth() - this.report.getRightMargin(), 0, this.report.getPageWidth() - this.report.getRightMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth(), this.downColumns);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.downColumns);
        grx.translate(this.report.getLeftMargin(), this.report.getTopMargin());
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getTitle(), grx);
        grx.translate(0, this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageHeader(), grx);
        grx.translate(0, this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnHeader(), grx);
        grx.translate(0, this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0);
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            i = 0;
            while (i < groups.length) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupHeader(), grx);
                grx.translate(0, group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0);
                ++i;
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getDetail(), grx);
        grx.translate(0, this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0);
        if (groups != null && groups.length > 0) {
            i = groups.length - 1;
            while (i >= 0) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupFooter(), grx);
                grx.translate(0, group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0);
                --i;
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnFooter(), grx);
        grx.translate(0, this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageFooter(), grx);
        grx.translate(0, this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getSummary(), grx);
        grx.translate(0, this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
    }

    private void printBand(JRBand band, Graphics2D grx) {
        if (band != null) {
            JRElement element = null;
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                int i = 0;
                while (i < elements.length) {
                    element = elements[i];
                    if (element instanceof JRLine) {
                        this.printLine((JRLine)element, grx);
                    } else if (element instanceof JRRectangle) {
                        this.printRectangle((JRRectangle)element, grx);
                    } else if (element instanceof JREllipse) {
                        this.printEllipse((JREllipse)element, grx);
                    } else if (element instanceof JRImage) {
                        this.printImage((JRImage)element, grx);
                    } else if (element instanceof JRStaticText) {
                        this.printText((JRTextElement)element, grx);
                    } else if (element instanceof JRTextField) {
                        this.printText((JRTextElement)element, grx);
                    } else if (element instanceof JRSubreport) {
                        this.printSubreport((JRSubreport)element, grx);
                    }
                    ++i;
                }
            }
        }
    }

    private void printLine(JRLine line, Graphics2D grx) {
        grx.setColor(line.getForecolor());
        BasicStroke stroke = null;
        switch (line.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f * this.zoom, 0, 2, 0.0f, new float[]{5.0f * this.zoom, 3.0f * this.zoom}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            grx.setStroke(stroke);
            if (line.getDirection() == 1) {
                grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
        }
    }

    private void printRectangle(JRRectangle rectangle, Graphics2D grx) {
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
        grx.setColor(rectangle.getForecolor());
        BasicStroke stroke = null;
        switch (rectangle.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.drawRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
    }

    private void printEllipse(JREllipse ellipse, Graphics2D grx) {
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getForecolor());
        BasicStroke stroke = null;
        switch (ellipse.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.drawOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
    }

    private void printImage(JRImage jrImage, Graphics2D grx) {
        if (jrImage.getMode() == 1) {
            grx.setColor(jrImage.getBackcolor());
            grx.fillRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth(), jrImage.getHeight());
        }
        int borderOffset = 0;
        BasicStroke stroke = null;
        switch (jrImage.getPen()) {
            case 4: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                borderOffset = 2;
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                borderOffset = 1;
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                borderOffset = 0;
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 5: {
                borderOffset = 0;
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f);
            }
        }
        int availableImageWidth = jrImage.getWidth() - 2 * borderOffset;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = jrImage.getHeight() - 2 * borderOffset;
        int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        if (availableImageWidth > 0 && availableImageHeight > 0) {
            String location;
            JRExpressionChunk firstChunk;
            Image awtImage = null;
            JRExpression jrExpression = jrImage.getExpression();
            if (jrExpression != null && jrExpression.getChunks().length == 1 && (firstChunk = jrExpression.getChunks()[0]).getType() == 1 && (location = firstChunk.getText().trim()).startsWith("\"") && location.endsWith("\"")) {
                location = location.substring(1, location.length() - 1);
                try {
                    awtImage = JRImageLoader.loadImage(JRImageLoader.loadImageDataFromLocation(location));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            if (awtImage != null) {
                int awtWidth = awtImage.getWidth(null);
                int awtHeight = awtImage.getHeight(null);
                float xalignFactor = 0.0f;
                switch (jrImage.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (jrImage.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                switch (jrImage.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                        grx.setClip(jrImage.getX() + borderOffset, jrImage.getY() + borderOffset, availableImageWidth, availableImageHeight);
                        grx.drawImage(awtImage, jrImage.getX() + xoffset + borderOffset, jrImage.getY() + yoffset + borderOffset, awtWidth, awtHeight, this);
                        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
                        break;
                    }
                    case 2: {
                        grx.drawImage(awtImage, jrImage.getX() + borderOffset, jrImage.getY() + borderOffset, availableImageWidth, availableImageHeight, this);
                        break;
                    }
                    default: {
                        if (jrImage.getHeight() > 0) {
                            double ratio = (double)awtWidth / (double)awtHeight;
                            if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                                awtWidth = availableImageWidth;
                                awtHeight = (int)((double)availableImageWidth / ratio);
                            } else {
                                awtWidth = (int)((double)availableImageHeight * ratio);
                                awtHeight = availableImageHeight;
                            }
                            int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                            int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                            grx.drawImage(awtImage, jrImage.getX() + xoffset + borderOffset, jrImage.getY() + yoffset + borderOffset, awtWidth, awtHeight, this);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    awtImage = JRImageLoader.getImage((byte)1);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                grx.setClip(jrImage.getX() + borderOffset, jrImage.getY() + borderOffset, availableImageWidth, availableImageHeight);
                grx.drawImage(awtImage, jrImage.getX() + borderOffset + 2, jrImage.getY() + borderOffset + 2, awtImage.getWidth(null), awtImage.getHeight(null), this);
                grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
            }
        }
        if (stroke != null) {
            grx.setColor(jrImage.getForecolor());
            grx.setStroke(stroke);
            grx.drawRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth(), jrImage.getHeight());
        }
    }

    private void printText(JRTextElement text, Graphics2D grx) {
        LineBreakMeasurer lineMeasurer;
        int paragraphEnd;
        int paragraphStart;
        AttributedCharacterIterator paragraph;
        AttributedString atext;
        String allText = null;
        if (text instanceof JRStaticText) {
            allText = ((JRStaticText)text).getText();
        } else if (text instanceof JRTextField && ((JRTextField)text).getExpression() != null) {
            allText = ((JRTextField)text).getExpression().getText();
        }
        if (allText == null || allText.length() == 0) {
            return;
        }
        allText = JRStringUtil.treatNewLineChars(allText);
        if (text.getMode() == 1) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(text.getX(), text.getY(), text.getWidth(), text.getHeight());
        }
        grx.setColor(text.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.zoom));
        grx.drawRect(text.getX(), text.getY(), text.getWidth(), text.getHeight());
        float formatWidth = text.getWidth();
        float lineSpacing = 1.0f;
        switch (text.getLineSpacing()) {
            case 0: {
                lineSpacing = 1.0f;
                break;
            }
            case 1: {
                lineSpacing = 1.5f;
                break;
            }
            case 2: {
                lineSpacing = 2.0f;
                break;
            }
            default: {
                lineSpacing = 1.0f;
            }
        }
        int maxHeight = text.getHeight();
        FontRenderContext fontRenderContext = grx.getFontRenderContext();
        JRFont font = text.getFont();
        if (font == null && (font = this.report.getDefaultFont()) == null) {
            font = new JRDesignFont();
        }
        Map fontAttributes = font.getAttributes();
        TextLayout layout = null;
        float drawPosY = 0.0f;
        float drawPosX = 0.0f;
        String paragr_text = "";
        boolean isMaxHeightReached = false;
        StringTokenizer tkzer = new StringTokenizer(allText, "\n");
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            paragr_text = tkzer.nextToken();
            atext = new AttributedString(paragr_text, fontAttributes);
            paragraph = atext.getIterator();
            paragraphStart = paragraph.getBeginIndex();
            paragraphEnd = paragraph.getEndIndex();
            lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            lineMeasurer.setPosition(paragraphStart);
            layout = null;
            while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                layout = lineMeasurer.nextLayout(formatWidth);
                if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
        }
        float textHeight = drawPosY + 1.0f;
        float verticalOffset = 0.0f;
        switch (text.getVerticalAlignment()) {
            case 1: {
                verticalOffset = 0.0f;
                break;
            }
            case 2: {
                verticalOffset = ((float)text.getHeight() - textHeight) / 2.0f;
                break;
            }
            case 3: {
                verticalOffset = (float)text.getHeight() - textHeight;
                break;
            }
            default: {
                verticalOffset = 0.0f;
            }
        }
        drawPosY = 0.0f;
        drawPosX = 0.0f;
        paragr_text = "";
        isMaxHeightReached = false;
        tkzer = new StringTokenizer(allText, "\n");
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            paragr_text = tkzer.nextToken();
            atext = new AttributedString(paragr_text, fontAttributes);
            paragraph = atext.getIterator();
            paragraphStart = paragraph.getBeginIndex();
            paragraphEnd = paragraph.getEndIndex();
            lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            lineMeasurer.setPosition(paragraphStart);
            layout = null;
            while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                layout = lineMeasurer.nextLayout(formatWidth);
                if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    switch (text.getTextAlignment()) {
                        case 4: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() >= paragraphEnd) break;
                            layout = layout.getJustifiedLayout(formatWidth);
                            break;
                        }
                        case 3: {
                            if (layout.isLeftToRight()) {
                                drawPosX = formatWidth - layout.getAdvance();
                                break;
                            }
                            drawPosX = formatWidth;
                            break;
                        }
                        case 2: {
                            drawPosX = (formatWidth - layout.getAdvance()) / 2.0f;
                            break;
                        }
                        default: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                        }
                    }
                    layout.draw(grx, drawPosX + (float)text.getX(), drawPosY + (float)text.getY() + verticalOffset);
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
        }
    }

    private void printSubreport(JRSubreport subreport, Graphics2D grx) {
        if (subreport.getMode() == 1) {
            grx.setColor(subreport.getBackcolor());
            grx.fillRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)2);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        grx.setClip(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        grx.drawImage(image, subreport.getX() + 2, subreport.getY() + 2, image.getWidth(null), image.getHeight(null), this);
        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
        grx.setColor(subreport.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.zoom));
        grx.drawRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
    }

    static {
        TYPE_FILE_NAME = 1;
        TYPE_INPUT_STREAM = 2;
        TYPE_JASPER_DESIGN = 3;
        zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = gEnv.getAvailableFontFamilyNames();
    }
}

