/******************************************************************************
 * JasperReport <-> PHP Connector (c) 2003 by Giulio Toffoli
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 * APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 * DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 * ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 * (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
********************************************************************************/
import dori.jasper.engine.*;
import dori.jasper.view.*;

public class PHPJRConnector
{

	public static String run(String srcFileName, String dstFileName)
	{
		try {
			dori.jasper.engine.JasperPrint print=null;
			dori.jasper.engine.JRExporter exporter=null;
			print = dori.jasper.engine.JasperFillManager.fillReport(
					srcFileName, 
					null,new JREmptyDataSource());
			exporter = new dori.jasper.engine.export.JRPdfExporter();
			exporter.setParameter(
				JRExporterParameter.OUTPUT_FILE_NAME,dstFileName);
			exporter.setParameter(
				JRExporterParameter.JASPER_PRINT,print);
			exporter.exportReport();
			
			return "YES";
		} catch (Exception ex)
		{
			return "ERROR!";
		}	
	}
}


