package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "FontForm"
 * non viene creato nel metodo main().
 */
public class FontForm extends Form
{
	IFont font;
	MainForm mf;
	public FontForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();	
		font = new IFont();
		setFonts(mf.fonts);
		this.mf = mf;
		
		numberComboBoxFontSize.addItem(new NumberComboValue("8", 8));
		numberComboBoxFontSize.addItem(new NumberComboValue("9", 9));
		numberComboBoxFontSize.addItem(new NumberComboValue("10", 10));
		numberComboBoxFontSize.addItem(new NumberComboValue("11", 11));
		numberComboBoxFontSize.addItem(new NumberComboValue("12", 12));
		numberComboBoxFontSize.addItem(new NumberComboValue("14", 14));
		numberComboBoxFontSize.addItem(new NumberComboValue("16", 16));
		numberComboBoxFontSize.addItem(new NumberComboValue("18", 18));
		numberComboBoxFontSize.addItem(new NumberComboValue("20", 20));
		numberComboBoxFontSize.addItem(new NumberComboValue("22", 22));
		numberComboBoxFontSize.addItem(new NumberComboValue("24", 24));
		numberComboBoxFontSize.addItem(new NumberComboValue("26", 26));
		numberComboBoxFontSize.addItem(new NumberComboValue("28", 28));
		numberComboBoxFontSize.addItem(new NumberComboValue("36", 36));
		numberComboBoxFontSize.addItem(new NumberComboValue("48", 48));
		numberComboBoxFontSize.addItem(new NumberComboValue("72", 72));
	}
	
	public void setFonts(Vector fonts)
	{
		Enumeration enum = fonts.elements();
		comboBoxTTF.addItem("");
		while (enum.hasMoreElements())
		{
			FontFile f = (FontFile)enum.nextElement();
			comboBoxTTF.addItem(f);
		}
	}
	
	public void setIFont(IFont f)
	{
		font.fontName = f.fontName;
		font.isBold = f.isBold;
		font.isItalic = f.isItalic;
		font.isPdfEmbedded = f.isPdfEmbedded;
		font.isStrikeThrough = f.isStrikeThrough;
		font.isUnderline = f.isUnderline;
		font.name = f.name;
		font.pdfEncoding = f.pdfEncoding;
		font.pdfFontName = f.pdfFontName;
		font.size = f.size;
		
		this.edit2.setText(f.name);
		this.edit1.setText(f.fontName);
		
		if (isBuiltinFont(f.pdfFontName))
		{
			this.editFont.setSelectedItem(f.pdfFontName);
			this.comboBoxTTF.setEnabled(false);			
		}	
		else
		{
			this.editFont.setSelectedItem("External TTF font");
			this.comboBoxTTF.setEnabled(true);	
			for (int i=0; i<this.comboBoxTTF.getItemCount(); ++i)
			{
				Object obj = this.comboBoxTTF.getItem(i);
				if (obj instanceof FontFile)
				{
					FontFile ff = (FontFile)obj;
					if (ff.filename.equals(f.pdfFontName))
					{
						this.comboBoxTTF.setSelectedIndex(i);
						break;
					}
				}
			}
		}
		
		
		
		for (int i=0; i< comboBoxPdfEncoding.getItemCount(); ++i)
		{
			if ( ((String)comboBoxPdfEncoding.getItem(i)).toUpperCase().startsWith(font.pdfEncoding.toUpperCase()))
			{
				comboBoxPdfEncoding.setSelectedIndex(i);
				break;
			}
		}
		this.checkBoxBold.setChecked( font.isBold);
		this.checkBoxIsPdfEmbedded.setChecked(font.isPdfEmbedded);
		this.checkBoxItalic.setChecked(font.isItalic);
		this.checkBoxStrike.setChecked(font.isStrikeThrough);
		this.checkBoxUnderline.setChecked(font.isUnderline);
		this.numberComboBoxFontSize.setValue(font.size);
	}

	/**
	 * FontForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void FontForm_click(Object source, Event e)
	{
		
	}

	private void edit2_textChanged(Object source, Event e)
	{
		font.name = edit2.getText();
	}

	private void editFont_textChanged(Object source, Event e)
	{
		font.pdfFontName = (String)editFont.getSelectedItem();
	}

	private void edit1_textChanged(Object source, Event e)
	{
		font.fontName = edit1.getText();
	}

	private void numberComboBoxFontSize_valueChanged(Object source, Event e)
	{
		font.size = (int)numberComboBoxFontSize.getValue();
	}

	private void checkBoxBold_click(Object source, Event e)
	{
		font.isBold = checkBoxBold.getChecked();
		String pdfFont =(String)editFont.getSelectedItem();
		if (FontForm.isBuiltinFont ( pdfFont ))
			updatePdfFont(pdfFont);
	}

	private void checkBoxItalic_click(Object source, Event e)
	{
		font.isItalic  = checkBoxItalic.getChecked();
		String pdfFont =(String)editFont.getSelectedItem();
		if (FontForm.isBuiltinFont ( pdfFont ))
			updatePdfFont(pdfFont);
		
	}

	private void checkBoxUnderline_click(Object source, Event e)
	{
		font.isUnderline = checkBoxUnderline.getChecked();
	}

	private void checkBoxStrike_click(Object source, Event e)
	{
		font.isStrikeThrough = checkBoxStrike.getChecked();
	}


	private void checkBoxIsPdfEmbedded_click(Object source, Event e)
	{
		font.isPdfEmbedded = checkBoxIsPdfEmbedded.getChecked();
	}


	private void comboBoxPdfEncoding_selectedIndexChanged(Object source, Event e)
	{
		String enc = (String)comboBoxPdfEncoding.getSelectedItem();
		font.pdfEncoding = 	enc.substring(0,enc.indexOf(" "));
	}

	private void comboBoxTTF_textChanged(Object source, Event e)
	{
		
	}

	private void button2_click(Object source, Event e)
	{
		if (this.edit2.getText().trim().length() ==0)
		{
			MessageBox.show("Please insert a name for thi font!");
			return;
		}
		
		this.setDialogResult( DialogResult.OK);
		this.dispose();
	}

	private void editFont_selectedIndexChanged(Object source, Event e)
	{
		if (this.editFont.getSelectedItem().equals("External TTF font"))
		{
			comboBoxTTF.setEnabled(true);
			font.pdfFontName = (String)comboBoxTTF.getSelectedItem();
		}
		else
		{
			comboBoxTTF.setEnabled(false);
			String pdfFont =(String)editFont.getSelectedItem();
			if (FontForm.isBuiltinFont ( pdfFont ))
			updatePdfFont(pdfFont);
			font.pdfFontName = (String)editFont.getSelectedItem();
			
		}
	}

	public void updatePdfFont(String pdfFont)
	{
		if  (!FontForm.isBuiltinFont( pdfFont )) return;
		if (pdfFont.startsWith("Courier") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Courier-BoldOblique";
		else if (pdfFont.startsWith("Courier") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Courier-Bold"; 
		else if (pdfFont.startsWith("Courier") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Courier-Oblique";
		else if (pdfFont.startsWith("Courier") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Courier";
		
		else if (pdfFont.startsWith("Helvetica") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Helvetica-BoldOblique";
		else if (pdfFont.startsWith("Helvetica") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Helvetica-Bold"; 
		else if (pdfFont.startsWith("Helvetica") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Helvetica-Oblique";
		else if (pdfFont.startsWith("Helvetica") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Helvetica";
		
		else if (pdfFont.startsWith("Times") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Times-BoldItalic";
		else if (pdfFont.startsWith("Times") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Times-Bold"; 
		else if (pdfFont.startsWith("Times") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Times-Italic";
		else if (pdfFont.startsWith("Times") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Times-Roman";
		
		editFont.setSelectedItem(pdfFont);
	}

	private void button1_click(Object source, Event e)
	{
		this.setDialogResult(DialogResult.CANCEL);
		dispose();
	}

	private void comboBoxTTF_selectedIndexChanged(Object source, Event e)
	{
		if (comboBoxTTF.getSelectedIndex() != -1)
			font.pdfFontName = ((FontFile)comboBoxTTF.getSelectedItem()).filename;		
		else
			font.pdfFontName = "";
	}

	private void FontForm_deactivate(Object source, Event e)
	{
		if (mf != null)
		mf.focus();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Label label10 = new Label();
	ComboBox editFont = new ComboBox();
	CheckBox checkBoxBold = new CheckBox();
	CheckBox checkBoxItalic = new CheckBox();
	CheckBox checkBoxUnderline = new CheckBox();
	CheckBox checkBoxStrike = new CheckBox();
	NumberComboBox numberComboBoxFontSize = new NumberComboBox();
	Label label26 = new Label();
	ComboBox comboBoxTTF = new ComboBox();
	Label label28 = new Label();
	CheckBox checkBoxIsPdfEmbedded = new CheckBox();
	GroupBox groupBox2 = new GroupBox();
	Label label29 = new Label();
	ComboBox comboBoxPdfEncoding = new ComboBox();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label1 = new Label();
	Edit edit1 = new Edit();
	Label label2 = new Label();
	Edit edit2 = new Edit();

	private void initForm()
	{
		this.setText("Font");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_SINGLE);
		this.setClientSize(new Point(291, 275));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.addOnClick(new EventHandler(this.FontForm_click));
		this.addOnDeactivate(new EventHandler(this.FontForm_deactivate));

		label10.setLocation(new Point(8, 40));
		label10.setSize(new Point(100, 16));
		label10.setTabIndex(14);
		label10.setTabStop(false);
		label10.setText("PDF Font name");

		editFont.setLocation(new Point(8, 56));
		editFont.setSize(new Point(224, 21));
		editFont.setTabIndex(2);
		editFont.setText("");
		editFont.setStyle(ComboBoxStyle.DROPDOWNLIST);
		editFont.setItems(new Object[] {
						  "Helvetica", 
						  "Helvetica-Bold", 
						  "Helvetica-BoldOblique", 
						  "Helvetica-Oblique", 
						  "Courier", 
						  "Courier-Bold", 
						  "Courier-BoldOblique", 
						  "Courier-Oblique", 
						  "Symbol", 
						  "Times-Roman", 
						  "Times-Bold", 
						  "Times-BoldItalic", 
						  "Times-Italic", 
						  "ZapfDingbats", 
						  "External TTF font"});
		editFont.addOnSelectedIndexChanged(new EventHandler(this.editFont_selectedIndexChanged));
		editFont.addOnTextChanged(new EventHandler(this.editFont_textChanged));

		checkBoxBold.setLocation(new Point(12, 132));
		checkBoxBold.setSize(new Point(48, 20));
		checkBoxBold.setTabIndex(5);
		checkBoxBold.setText("Bold");
		checkBoxBold.addOnClick(new EventHandler(this.checkBoxBold_click));

		checkBoxItalic.setLocation(new Point(12, 152));
		checkBoxItalic.setSize(new Point(52, 20));
		checkBoxItalic.setTabIndex(7);
		checkBoxItalic.setText("Italic");
		checkBoxItalic.addOnClick(new EventHandler(this.checkBoxItalic_click));

		checkBoxUnderline.setLocation(new Point(128, 132));
		checkBoxUnderline.setSize(new Point(68, 20));
		checkBoxUnderline.setTabIndex(6);
		checkBoxUnderline.setText("Underline");
		checkBoxUnderline.addOnClick(new EventHandler(this.checkBoxUnderline_click));

		checkBoxStrike.setLocation(new Point(128, 152));
		checkBoxStrike.setSize(new Point(92, 20));
		checkBoxStrike.setTabIndex(8);
		checkBoxStrike.setText("Strike Through");
		checkBoxStrike.addOnClick(new EventHandler(this.checkBoxStrike_click));

		numberComboBoxFontSize.setCursor(Cursor.DEFAULT);
		numberComboBoxFontSize.setLocation(new Point(236, 56));
		numberComboBoxFontSize.setSize(new Point(52, 21));
		numberComboBoxFontSize.setTabIndex(3);
		numberComboBoxFontSize.setText("0");
		numberComboBoxFontSize.setIsDouble(false);
		numberComboBoxFontSize.setDecimals(0);
		numberComboBoxFontSize.setValue(0.0d);
		numberComboBoxFontSize.setViewPlus(false);
		numberComboBoxFontSize.setSeparatoreMigliaia(false);
		numberComboBoxFontSize.addOnValueChanged(new EventHandler(this.numberComboBoxFontSize_valueChanged));

		label26.setLocation(new Point(236, 40));
		label26.setSize(new Point(52, 16));
		label26.setTabIndex(13);
		label26.setTabStop(false);
		label26.setText("Size");

		comboBoxTTF.setEnabled(false);
		comboBoxTTF.setLocation(new Point(8, 100));
		comboBoxTTF.setSize(new Point(280, 21));
		comboBoxTTF.setTabIndex(4);
		comboBoxTTF.setText("");
		comboBoxTTF.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxTTF.addOnSelectedIndexChanged(new EventHandler(this.comboBoxTTF_selectedIndexChanged));
		comboBoxTTF.addOnTextChanged(new EventHandler(this.comboBoxTTF_textChanged));

		label28.setLocation(new Point(8, 84));
		label28.setSize(new Point(144, 16));
		label28.setTabIndex(15);
		label28.setTabStop(false);
		label28.setText("Use this TrueType font");

		checkBoxIsPdfEmbedded.setLocation(new Point(8, 196));
		checkBoxIsPdfEmbedded.setSize(new Point(108, 23));
		checkBoxIsPdfEmbedded.setTabIndex(9);
		checkBoxIsPdfEmbedded.setText("Pdf Embedded");
		checkBoxIsPdfEmbedded.addOnClick(new EventHandler(this.checkBoxIsPdfEmbedded_click));

		groupBox2.setLocation(new Point(8, 176));
		groupBox2.setSize(new Point(280, 4));
		groupBox2.setTabIndex(16);
		groupBox2.setTabStop(false);
		groupBox2.setText("");

		label29.setLocation(new Point(116, 184));
		label29.setSize(new Point(148, 16));
		label29.setTabIndex(17);
		label29.setTabStop(false);
		label29.setText("Pdf encoding");

		comboBoxPdfEncoding.setLocation(new Point(116, 200));
		comboBoxPdfEncoding.setSize(new Point(168, 21));
		comboBoxPdfEncoding.setTabIndex(10);
		comboBoxPdfEncoding.setText("");
		comboBoxPdfEncoding.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPdfEncoding.setItems(new Object[] {
									 "Cp1250 (Central European)", 
									 "Cp1251 (Cyrillic)", 
									 "Cp1252 (Western European ANSI)", 
									 "Cp1253 (Greek)", 
									 "Cp1254 (Turkish)", 
									 "Cp1255 (Hebrew)", 
									 "Cp1256 (Arabic)", 
									 "Cp1257 (Baltic)", 
									 "Cp1258 (Vietnamese)"});
		comboBoxPdfEncoding.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPdfEncoding_selectedIndexChanged));

		groupBox1.setLocation(new Point(12, 232));
		groupBox1.setSize(new Point(272, 4));
		groupBox1.setTabIndex(18);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(212, 244));
		button1.setSize(new Point(72, 24));
		button1.setTabIndex(12);
		button1.setText("Close");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(132, 244));
		button2.setSize(new Point(72, 24));
		button2.setTabIndex(11);
		button2.setText("OK");
		button2.addOnClick(new EventHandler(this.button2_click));

		label1.setLocation(new Point(140, 0));
		label1.setSize(new Point(100, 16));
		label1.setTabIndex(20);
		label1.setTabStop(false);
		label1.setText("Font name");

		edit1.setLocation(new Point(140, 16));
		edit1.setSize(new Point(148, 20));
		edit1.setTabIndex(1);
		edit1.setText("");
		edit1.addOnTextChanged(new EventHandler(this.edit1_textChanged));

		label2.setLocation(new Point(8, 0));
		label2.setSize(new Point(100, 16));
		label2.setTabIndex(19);
		label2.setTabStop(false);
		label2.setText("Report font name");

		edit2.setLocation(new Point(8, 16));
		edit2.setSize(new Point(128, 20));
		edit2.setTabIndex(0);
		edit2.setText("");
		edit2.addOnTextChanged(new EventHandler(this.edit2_textChanged));

		this.setNewControls(new Control[] {
							edit2, 
							label2, 
							edit1, 
							label1, 
							button2, 
							button1, 
							groupBox1, 
							comboBoxPdfEncoding, 
							label29, 
							groupBox2, 
							checkBoxIsPdfEmbedded, 
							label28, 
							comboBoxTTF, 
							label26, 
							numberComboBoxFontSize, 
							checkBoxStrike, 
							checkBoxUnderline, 
							checkBoxItalic, 
							checkBoxBold, 
							editFont, 
							label10});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new FontForm(null));
	}
	
	public static boolean isBuiltinFont(String fontname)
	{
		if (fontname == null) return false;
		if (fontname.equals("Helvetica"))				return true;
		if (fontname.equals("Helvetica-Bold"))			return true;
		if (fontname.equals("Helvetica-BoldOblique"))	return true;
		if (fontname.equals("Helvetica-Oblique"))		return true;
		if (fontname.equals("Courier"))					return true;
		if (fontname.equals("Courier-Bold"))			return true;
		if (fontname.equals("Courier-BoldOblique"))		return true;
		if (fontname.equals("Courier-Oblique"))			return true;
		if (fontname.equals("Symbol"))					return true;
		if (fontname.equals("Times-Roman"))				return true;
		if (fontname.equals("Times-Bold"))				return true;
		if (fontname.equals("Times-BoldItalic"))		return true;
		if (fontname.equals("Times-Italic"))			return true;
		if (fontname.equals("ZapfDingbats"))			return true;

		return false;
	}
}
