/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.castor.persist.ProposedObject;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.proxy.CollectionProxy;
import org.castor.persist.proxy.RelationCollection;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.ClassMolderHelper;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;

public abstract class ManyRelationResolver
implements ResolverStrategy {
    protected ClassMolder _classMolder;
    protected FieldMolder _fieldMolder;

    public ManyRelationResolver(ClassMolder classMolder, FieldMolder fieldMolder, boolean debug) {
        this._classMolder = classMolder;
        this._fieldMolder = fieldMolder;
    }

    public final Object create(TransactionContext tx, Object object) {
        ArrayList field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (o != null) {
            ArrayList fids;
            field = fids = ClassMolderHelper.extractIdentityList(tx, fieldClassMolder, o);
        }
        return field;
    }

    public abstract boolean markCreate(TransactionContext var1, OID var2, Object var3) throws PersistenceException;

    public abstract UpdateFlags preStore(TransactionContext var1, OID var2, Object var3, int var4, Object var5) throws PersistenceException;

    public final Object store(TransactionContext tx, Object object, Object field) {
        return null;
    }

    public abstract void update(TransactionContext var1, OID var2, Object var3, AccessMode var4, Object var5) throws PersistenceException;

    public final Object updateCache(TransactionContext tx, OID oid, Object object) {
        ArrayList field = null;
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        Object value = this._fieldMolder.getValue(object, tx.getClassLoader());
        if (value != null) {
            ArrayList fids;
            if (!(value instanceof Lazy)) {
                fids = ClassMolderHelper.extractIdentityList(tx, fieldClassMolder, value);
            } else {
                RelationCollection lazy = (RelationCollection)value;
                fids = (ArrayList)lazy.getIdentitiesList().clone();
            }
            field = fids;
        }
        return field;
    }

    public abstract void markDelete(TransactionContext var1, Object var2, Object var3) throws PersistenceException;

    public final void revertObject(TransactionContext tx, OID oid, Object object, Object field) throws PersistenceException {
        Object o = field;
        if (o == null) {
            this._fieldMolder.setValue(object, null, tx.getClassLoader());
        } else if (!this._fieldMolder.isLazy()) {
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            Class collectionType = this._fieldMolder.getCollectionType();
            ArrayList v = (ArrayList)field;
            if (v != null) {
                if (collectionType.isArray()) {
                    Object[] arrayValue = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                    int l = v.size();
                    for (int j = 0; j < l; ++j) {
                        arrayValue[j] = tx.fetch(oid.getLockEngine(), fieldClassMolder, v.get(j), null);
                    }
                    this._fieldMolder.setValue(object, arrayValue, tx.getClassLoader());
                } else {
                    CollectionProxy cp = CollectionProxy.create(this._fieldMolder, object, tx.getClassLoader());
                    this._fieldMolder.setValue(object, cp.getCollection(), tx.getClassLoader());
                    int l = v.size();
                    for (int j = 0; j < l; ++j) {
                        Object obj = tx.fetch(oid.getLockEngine(), fieldClassMolder, v.get(j), null);
                        if (obj == null) continue;
                        cp.add(v.get(j), obj);
                    }
                    cp.close();
                }
            } else {
                this._fieldMolder.setValue(object, null, tx.getClassLoader());
            }
        } else {
            ArrayList list = (ArrayList)field;
            ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
            LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
            RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, null, list);
            this._fieldMolder.setValue(object, relcol, tx.getClassLoader());
        }
    }

    public final void expireCache(TransactionContext tx, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        ArrayList v = (ArrayList)field;
        if (v != null) {
            int l = v.size();
            for (int j = 0; j < l; ++j) {
                tx.expireCache(fieldEngine, fieldClassMolder, v.get(j));
            }
        }
    }

    public final void load(TransactionContext tx, OID oid, ProposedObject proposedObject, AccessMode suggestedAccessMode, Object field) throws PersistenceException {
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        LockEngine fieldEngine = this._fieldMolder.getFieldLockEngine();
        if (!this._fieldMolder.isLazy()) {
            ArrayList v = (ArrayList)field;
            if (v != null) {
                Class collectionType = this._fieldMolder.getCollectionType();
                if (collectionType.isArray()) {
                    Object[] value = (Object[])Array.newInstance(collectionType.getComponentType(), v.size());
                    int l = v.size();
                    for (int j = 0; j < l; ++j) {
                        ProposedObject proposedValue = new ProposedObject();
                        value[j] = tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), proposedValue, suggestedAccessMode);
                    }
                    this._fieldMolder.setValue(proposedObject.getObject(), value, tx.getClassLoader());
                } else {
                    CollectionProxy cp = CollectionProxy.create(this._fieldMolder, proposedObject.getObject(), tx.getClassLoader());
                    int l = v.size();
                    for (int j = 0; j < l; ++j) {
                        ProposedObject proposedValue = new ProposedObject();
                        cp.add(v.get(j), tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), proposedValue, suggestedAccessMode));
                    }
                    cp.close();
                }
            } else {
                this._fieldMolder.setValue(proposedObject.getObject(), null, tx.getClassLoader());
            }
        } else {
            ArrayList list = (ArrayList)field;
            RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, suggestedAccessMode, list);
            this._fieldMolder.setValue(proposedObject.getObject(), relcol, tx.getClassLoader());
        }
    }

    public abstract Object postCreate(TransactionContext var1, OID var2, Object var3, Object var4, Object var5) throws PersistenceException;

    public final UpdateAndRemovedFlags removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        ClassMolder relatedBaseMolder;
        UpdateAndRemovedFlags flags = new UpdateAndRemovedFlags();
        ClassMolder fieldClassMolder = this._fieldMolder.getFieldClassMolder();
        for (relatedBaseMolder = relatedMolder; fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null; relatedBaseMolder = relatedBaseMolder.getExtends()) {
        }
        if (fieldClassMolder == relatedBaseMolder) {
            boolean changed = false;
            Object related = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (related instanceof RelationCollection) {
                RelationCollection lazy = (RelationCollection)related;
                changed = lazy.remove(relatedObject);
            } else {
                Iterator itor = ClassMolderHelper.getIterator(related);
                while (itor.hasNext()) {
                    Object o = itor.next();
                    if (o != relatedObject) continue;
                    changed = true;
                    itor.remove();
                }
            }
            if (changed) {
                flags.setUpdateCache(true);
                flags.setUpdatePersist(false);
                flags.setRemoved(true);
            }
        }
        return flags;
    }
}

