/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.FactoryState;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.MemberFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.TypeConversion;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class SourceFactory {
    private static final String ENUM_ACCESS_INTERFACE = "org.exolab.castor.types.EnumeratedTypeAccess";
    private static final short BASE_TYPE_ENUMERATION = 0;
    private static final short OBJECT_TYPE_ENUMERATION = 1;
    private static final String CLASS_METHOD_SUFFIX = "Class";
    private static final String CLASS_KEYWORD = "class";
    private static final String ITEM_NAME = "Item";
    private FieldInfoFactory infoFactory = null;
    private ExtendedBinding _binding = null;
    private MemberFactory memberFactory = null;
    private short enumerationType = 1;
    private boolean _createMarshalMethods = true;
    private boolean _testable = false;
    private boolean _sax1 = false;
    private boolean _caseInsensitive = false;
    private BuilderConfiguration _config = null;
    private TypeConversion _typeConversion = null;

    public SourceFactory(BuilderConfiguration config) {
        this(config, null);
    }

    public SourceFactory(BuilderConfiguration config, FieldInfoFactory infoFactory) {
        if (config == null) {
            String error = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(error);
        }
        this._config = config;
        this.infoFactory = infoFactory == null ? new FieldInfoFactory() : infoFactory;
        infoFactory.setBoundProperties(config.boundPropertiesEnabled());
        this.memberFactory = new MemberFactory(config, infoFactory);
        this._typeConversion = new TypeConversion(this._config);
    }

    public void setCreateMarshalMethods(boolean createMarshalMethods) {
        this._createMarshalMethods = createMarshalMethods;
    }

    public void setCreateExtraMethods(boolean extraMethods) {
        this.infoFactory.setCreateExtraMethods(extraMethods);
    }

    public void setReferenceMethodSuffix(String suffix) {
        this.infoFactory.setReferenceMethodSuffix(suffix);
    }

    public void setTestable(boolean testable) {
        this._testable = testable;
    }

    public void setSAX1(boolean sax1) {
        this._sax1 = sax1;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JClass[] createSourceCode(XMLBindingComponent component, SGStateInfo sgState) {
        String comment;
        String[] implemented;
        String baseClass;
        boolean createGroupItem;
        String className;
        if (component == null) {
            throw new IllegalStateException("XMLBindingComponent may not be null.");
        }
        if (sgState == null) {
            throw new IllegalStateException("SGStateInfo may not be null.");
        }
        JClass[] classes = sgState.getSourceCode(component.getAnnotated());
        if (classes != null) {
            return classes;
        }
        this._binding = component.getBinding();
        if (sgState.verbose()) {
            String name = component.getXMLName();
            if (name == null) {
                name = component.getJavaClassName();
            }
            String msg = "Creating classes for: " + name;
            sgState.getDialog().notify(msg);
        }
        FactoryState state = null;
        String packageName = component.getJavaPackage();
        if (packageName == null || packageName.length() == 0) {
            packageName = sgState.packageName;
        }
        if ((className = component.getQualifiedName()).indexOf(46) == -1) {
            className = JavaNaming.toJavaClassName(className);
            className = this.resolveClassName(className, packageName);
        }
        if (createGroupItem = component.createGroupItem()) {
            className = className + ITEM_NAME;
            classes = new JClass[2];
        } else {
            classes = new JClass[1];
        }
        state = new FactoryState(className, sgState, packageName);
        state.setCreateGroupItem(createGroupItem);
        if (sgState.getCurrentFactoryState() == null) {
            sgState.setCurrentFactoryState(state);
        } else {
            state.setParent(sgState.getCurrentFactoryState());
            sgState.setCurrentFactoryState(state);
        }
        if (state.processed(component.getAnnotated())) {
            return new JClass[0];
        }
        state.markAsProcessed(component.getAnnotated());
        ClassInfo classInfo = state.classInfo;
        JClass jClass = state.jClass;
        this.initialize(jClass);
        classInfo.setNodeName(component.getXMLName());
        classInfo.setNamespaceURI(component.getTargetNamespace());
        XMLType type = component.getXMLType();
        boolean createForSingleGroup = false;
        boolean creatingForAnElement = component.getAnnotated().getStructureType() == 8;
        classInfo.setElementDefinition(creatingForAnElement);
        if (type != null) {
            if (type.isComplexType()) {
                Annotated saved;
                ComplexType complexType = (ComplexType)type;
                if (complexType.isTopLevel() && creatingForAnElement) {
                    saved = component.getAnnotated();
                    String previousPackage = component.getJavaPackage();
                    XMLBindingComponent baseComponent = new XMLBindingComponent(this._config);
                    baseComponent.setBinding(component.getBinding());
                    baseComponent.setView(complexType);
                    this.createSourceCode(baseComponent, sgState);
                    String baseClassName = null;
                    String basePackage = baseComponent.getJavaPackage();
                    if (basePackage != null && !basePackage.equals(previousPackage)) {
                        baseClassName = baseComponent.getQualifiedName();
                        if (baseClassName.indexOf(46) == -1) {
                            baseClassName = JavaNaming.toJavaClassName(baseClassName);
                        }
                    } else {
                        baseClassName = baseComponent.getJavaClassName();
                    }
                    jClass.setSuperClass(baseClassName);
                    basePackage = null;
                    baseClassName = null;
                    component.setView(saved);
                    saved = null;
                } else if (complexType.isTopLevel() || creatingForAnElement) {
                    Group group;
                    Particle particle;
                    if (complexType.getParticleCount() == 1 && (particle = complexType.getParticle(0)).getStructureType() == 10 && (group = (Group)particle).getOrder() == Order.choice) {
                        classInfo.getGroupInfo().setAsChoice();
                    }
                    saved = component.getAnnotated();
                    this.processComplexType(complexType, state);
                    component.setView(saved);
                    saved = null;
                }
            } else if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                if (!simpleType.hasFacet("enumeration")) return new JClass[0];
                String tns = simpleType.getSchema().getTargetNamespace();
                boolean create = false;
                create = tns == null ? component.getTargetNamespace() == null : tns.equals(component.getTargetNamespace());
                if (create) {
                    ClassInfo tmpInfo = sgState.resolve(simpleType);
                    JClass tmpClass = null;
                    tmpClass = tmpInfo != null ? tmpInfo.getJClass() : this.createSourceCode(simpleType, sgState);
                    classInfo.setSchemaType(new XSClass(tmpClass));
                }
            } else if (type.isAnyType()) {
                classInfo.setSchemaType(new XSClass(SGTypes.Object));
                return new JClass[0];
            }
        } else {
            try {
                Group group = (Group)component.getAnnotated();
                createForSingleGroup = group.getMaxOccurs() == 1;
                this.processContentModel(group, state);
                component.setView(group);
                Order order = group.getOrder();
                if (order == Order.choice) {
                    classInfo.getGroupInfo().setAsChoice();
                } else if (order == Order.seq) {
                    classInfo.getGroupInfo().setAsSequence();
                } else {
                    classInfo.getGroupInfo().setAsAll();
                }
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("Illegal binding component:" + ce.getMessage());
            }
        }
        if (createGroupItem) {
            ComplexType complexType;
            if (component.hasBoundProperties()) {
                this.createPropertyChangeMethods(jClass);
            }
            sgState.bindReference(jClass, classInfo);
            classes[1] = jClass;
            String fname = component.getJavaClassName() + ITEM_NAME;
            fname = JavaNaming.toJavaMemberName(fname, false);
            FieldInfo fInfo = null;
            fInfo = createForSingleGroup ? this.infoFactory.createFieldInfo(new XSClass(jClass), fname) : this.infoFactory.createCollection(new XSClass(jClass), "_items", fname);
            fInfo.setContainer(true);
            className = className.substring(0, className.length() - 4);
            state = new FactoryState(className, sgState, packageName);
            classInfo = state.classInfo;
            jClass = state.jClass;
            this.initialize(jClass);
            if (type != null && type.isComplexType() && (complexType = (ComplexType)type).isTopLevel() ^ creatingForAnElement) {
                Annotated saved = component.getAnnotated();
                this.processAttributes(complexType, state);
                component.setView(saved);
                if (complexType.getContentType() == ContentType.mixed) {
                    FieldInfo fieldInfo = this.memberFactory.createFieldInfoForContent(new XSString());
                    this.handleField(fieldInfo, state);
                } else if (complexType.getContentType().getType() == 4) {
                    SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                    SimpleType temp = simpleContent.getSimpleType();
                    XSType xsType = this._typeConversion.convertType(temp, packageName);
                    FieldInfo fieldInfo = this.memberFactory.createFieldInfoForContent(xsType);
                    this.handleField(fieldInfo, state);
                    temp = null;
                }
            }
            classInfo.addFieldInfo(fInfo);
            fInfo.createJavaField(jClass);
            fInfo.createAccessMethods(jClass);
            fInfo.generateInitializerCode(jClass.getConstructor(0).getSourceCode());
            classInfo.setNodeName(component.getXMLName());
            classInfo.setContainer(true);
            String actSuperClass = classes[1].getSuperClass();
            jClass.setSuperClass(actSuperClass);
            classes[1].setSuperClass(null);
        }
        if ((baseClass = component.getExtends()) != null && baseClass.length() > 0 && jClass.getSuperClass() == null) {
            jClass.setSuperClass(baseClass);
        }
        if ((implemented = component.getImplements()) != null) {
            for (int i = 0; i < implemented.length; ++i) {
                String interfaceName = implemented[i];
                if (interfaceName == null || interfaceName.length() <= 0) continue;
                jClass.addInterface(interfaceName);
            }
        }
        jClass.getModifiers().setFinal(component.isFinal());
        if (component.isAbstract()) {
            jClass.getModifiers().setAbstract(true);
            classInfo.setAbstract(true);
        }
        if ((comment = this.processAnnotations(component.getAnnotated())) != null) {
            jClass.getJDocComment().setComment(comment);
        }
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.io.Reader");
        if (this._createMarshalMethods) {
            this.createValidateMethods(jClass);
            if (!component.isAbstract()) {
                this.createMarshalMethods(jClass);
                this.createUnmarshalMethods(jClass, sgState);
            }
        }
        if (component.hasEquals()) {
            SourceFactory.createEqualsMethod(jClass);
        }
        if (this._testable) {
            SourceFactory.createTestableMethods(jClass, state);
        }
        boolean userDerived = false;
        if (jClass.getSuperClass() != null) {
            userDerived = jClass.getSuperClass().equals(baseClass);
            if (component.hasBoundProperties() && userDerived) {
                this.createPropertyChangeMethods(jClass);
            }
        } else if (component.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(component.getAnnotated(), classInfo);
        classes[0] = jClass;
        sgState.bindSourceCode(component.getAnnotated(), classes);
        return classes;
    }

    public JClass createSourceCode(SimpleType simpleType, SGStateInfo sgState) {
        if (SimpleTypesFactory.isBuiltInType(simpleType.getTypeCode())) {
            String err = "You cannot construct a ClassInfo for a built-in SimpleType.";
            throw new IllegalArgumentException(err);
        }
        if (sgState == null) {
            throw new IllegalArgumentException("SGStateInfo cannot be null.");
        }
        if (simpleType.getStructureType() == 22) {
            if (!sgState.getSuppressNonFatalWarnings()) {
                String message = "warning: support for unions is incomplete.";
                sgState.getDialog().notify(message);
            }
            return null;
        }
        ClassInfo cInfo = sgState.resolve(simpleType);
        if (cInfo != null) {
            return cInfo.getJClass();
        }
        boolean enumeration = false;
        String typeName = simpleType.getName();
        if (typeName == null) {
            Structure struct = simpleType.getParent();
            FactoryState fstate = null;
            switch (struct.getStructureType()) {
                case 3: {
                    typeName = ((AttributeDecl)struct).getName();
                    fstate = sgState.getCurrentFactoryState();
                    break;
                }
                case 8: {
                    typeName = ((ElementDecl)struct).getName();
                }
            }
            if (fstate != null) {
                typeName = JavaNaming.toJavaClassName(typeName);
                typeName = fstate.jClass.getLocalName() + typeName;
            }
            typeName = typeName + "Type";
        }
        String className = JavaNaming.toJavaClassName(typeName);
        XMLBindingComponent comp = new XMLBindingComponent(this._config);
        if (this._binding != null) {
            comp.setBinding(this._binding);
        }
        comp.setView(simpleType);
        String packageName = comp.getJavaPackage();
        if (packageName == null || packageName.length() == 0) {
            packageName = sgState.packageName;
        }
        if (simpleType.hasFacet("enumeration")) {
            enumeration = true;
            packageName = packageName != null && packageName.length() > 0 ? packageName + ".types" : "types";
        }
        className = this.resolveClassName(className, packageName);
        FactoryState state = new FactoryState(className, sgState, packageName);
        state.setParent(sgState.getCurrentFactoryState());
        ClassInfo classInfo = state.classInfo;
        JClass jClass = state.jClass;
        this.initialize(jClass);
        Schema schema = simpleType.getSchema();
        classInfo.setNamespaceURI(schema.getTargetNamespace());
        classInfo.setNodeName(typeName);
        String comment = this.processAnnotations(simpleType);
        if (comment != null) {
            jClass.getJDocComment().setComment(comment);
        }
        XSClass xsClass = new XSClass(jClass, typeName);
        classInfo.setSchemaType(xsClass);
        if (enumeration) {
            xsClass.setAsEnumerated(true);
            this.processEnumeration(simpleType, state);
        }
        if (state.hasBoundProperties()) {
            this.createPropertyChangeMethods(jClass);
        }
        sgState.bindReference(jClass, classInfo);
        sgState.bindReference(simpleType, classInfo);
        return jClass;
    }

    private void initialize(JClass jClass) {
        jClass.addInterface("java.io.Serializable");
        JConstructor con = jClass.createConstructor();
        jClass.addConstructor(con);
        con.getSourceCode().add("super();");
        if (this._createMarshalMethods) {
            jClass.addImport("org.exolab.castor.xml.Marshaller");
            jClass.addImport("org.exolab.castor.xml.Unmarshaller");
        }
        jClass.addImport("java.io.Serializable");
    }

    private void createPropertyChangeMethods(JClass parent) {
        parent.addImport("java.beans.PropertyChangeEvent");
        parent.addImport("java.beans.PropertyChangeListener");
        String vName = "propertyChangeSupport";
        JField field = new JField(SGTypes.PropertyChangeSupport, vName);
        field.getModifiers().makePrivate();
        parent.addField(field);
        JMethod jMethod = new JMethod(null, "notifyPropertyChangeListeners");
        jMethod.getModifiers().makeProtected();
        String desc = "Notifies all registered PropertyChangeListeners when a bound property's value changes.";
        JDocComment jdc = jMethod.getJDocComment();
        JDocDescriptor jdDesc = null;
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(SGTypes.String, "fieldName"));
        jdDesc = jdc.getParamDescriptor("fieldName");
        jdDesc.setDescription("the name of the property that has changed.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "oldValue"));
        jdDesc = jdc.getParamDescriptor("oldValue");
        jdDesc.setDescription("the old value of the property.");
        jMethod.addParameter(new JParameter(SGTypes.Object, "newValue"));
        jdDesc = jdc.getParamDescriptor("newValue");
        jdDesc.setDescription("the new value of the property.");
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return;");
        jsc.add(vName);
        jsc.append(".firePropertyChange(fieldName,oldValue,newValue);");
        JClass jType = new JClass("java.beans.PropertyChangeListener");
        jMethod = new JMethod(null, "addPropertyChangeListener");
        desc = "Registers a PropertyChangeListener with this class.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to register.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) {");
        jsc.addIndented(vName + " = new java.beans.PropertyChangeSupport(this);");
        jsc.add("}");
        jsc.add(vName);
        jsc.append(".addPropertyChangeListener(pcl);");
        jMethod = new JMethod(JType.Boolean, "removePropertyChangeListener");
        desc = "Removes the given PropertyChangeListener from this classes list of ProperyChangeListeners.";
        jdc = jMethod.getJDocComment();
        jdc.appendComment(desc);
        jMethod.addParameter(new JParameter(jType, "pcl"));
        desc = "The PropertyChangeListener to remove.";
        jdDesc = jdc.getParamDescriptor("pcl");
        jdDesc.setDescription(desc);
        parent.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("if (");
        jsc.append(vName);
        jsc.append(" == null) return false;");
        jsc.add(vName);
        jsc.append(".removePropertyChangeListener(pcl);");
        jsc.add("return true;");
    }

    private void createMarshalMethods(JClass parent) {
        this.createMarshalMethods(parent, false);
    }

    private void createMarshalMethods(JClass parent, boolean isAbstract) {
        JMethod jMethod = new JMethod(null, "marshal");
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Writer, "out"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc.add("");
            jsc.add("Marshaller.marshal(this, out);");
        }
        jMethod = new JMethod(null, "marshal");
        JClass jc = null;
        if (this._sax1) {
            jc = new JClass("org.xml.sax.DocumentHandler");
        } else {
            jc = new JClass("org.xml.sax.ContentHandler");
            jMethod.addException(SGTypes.IOException);
        }
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(jc, "handler"));
        parent.addMethod(jMethod);
        if (isAbstract) {
            jMethod.getModifiers().setAbstract(true);
        } else {
            JSourceCode jsc = jMethod.getSourceCode();
            jsc = jMethod.getSourceCode();
            jsc.add("");
            jsc.add("Marshaller.marshal(this, handler);");
        }
    }

    private void createUnmarshalMethods(JClass parent, SGStateInfo sgState) {
        String methodName = "unmarshal";
        if (sgState.getSourceGenerator().mappingSchemaType2Java()) {
            methodName = methodName + parent.getName(true);
        }
        JClass returnType = parent;
        while (returnType.getSuperClass() != null) {
            String pkgName;
            String superClassName = returnType.getSuperClass();
            JClass superClass = sgState.getSourceCode(superClassName);
            if (superClass == null && superClassName.indexOf(46) < 0 && (pkgName = returnType.getPackageName()) != null && pkgName.length() > 0) {
                superClassName = pkgName + "." + superClassName;
                superClass = sgState.getSourceCode(superClassName);
            }
            if (superClass == null) break;
            returnType = superClass;
        }
        JMethod jMethod = new JMethod(returnType, methodName);
        jMethod.getModifiers().setStatic(true);
        jMethod.addException(SGTypes.MarshalException);
        jMethod.addException(SGTypes.ValidationException);
        jMethod.addParameter(new JParameter(SGTypes.Reader, "reader"));
        parent.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("return (");
        jsc.append(returnType.getName());
        jsc.append(") Unmarshaller.unmarshal(");
        jsc.append(parent.getName());
        jsc.append(".class, reader);");
    }

    public static void createEqualsMethod(JClass jclass) {
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        JField[] fields = jclass.getFields();
        JMethod jMethod = new JMethod(JType.Boolean, "equals");
        jMethod.setComment("Override the java.lang.Object.equals method");
        jMethod.setComment("Note: hashCode() has not been overriden");
        jMethod.addParameter(new JParameter(SGTypes.Object, "obj"));
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        jsc.add("if ( this == obj )");
        jsc.indent();
        jsc.add("return true;");
        jsc.unindent();
        if (jclass.getSuperClass() != null) {
            jsc.add("");
            jsc.add("if (super.equals(obj)==false)");
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
        }
        jsc.add("");
        jsc.add("if (obj instanceof ");
        jsc.append(jclass.getName(true));
        jsc.append(") {");
        jsc.add("");
        jsc.indent();
        jsc.add(jclass.getName(true));
        jsc.append(" temp = (");
        jsc.append(jclass.getName(true));
        jsc.append(")obj;");
        for (int i = 0; i < fields.length; ++i) {
            JField temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive()) {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != temp.");
                jsc.append(name);
                jsc.append(")");
            } else {
                jsc.add("if (this.");
                jsc.append(name);
                jsc.append(" != null) {");
                jsc.indent();
                jsc.add("if (temp.");
                jsc.append(name);
                jsc.append(" == null) ");
                jsc.indent();
                jsc.append("return false;");
                jsc.unindent();
                jsc.add("else if (!(this.");
                jsc.append(name);
                jsc.append(".equals(temp.");
                jsc.append(name);
                jsc.append("))) ");
                jsc.indent();
                jsc.add("return false;");
                jsc.unindent();
                jsc.unindent();
                jsc.add("}");
                jsc.add("else if (temp.");
                jsc.append(name);
                jsc.append(" != null)");
            }
            jsc.indent();
            jsc.add("return false;");
            jsc.unindent();
        }
        jsc.add("return true;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return false;");
    }

    public static void createTestableMethods(JClass jclass, FactoryState state) {
        JField temp;
        int i;
        if (jclass == null) {
            throw new IllegalArgumentException("JClass must not be null");
        }
        jclass.addInterface("org.exolab.castor.tests.framework.CastorTestable");
        jclass.addImport("org.exolab.castor.tests.framework.CastorTestable");
        jclass.addImport("org.exolab.castor.tests.framework.RandomHelper");
        JMethod jMethod = new JMethod(null, "randomizeFields");
        jMethod.addException(new JClass("InstantiationException"));
        jMethod.addException(new JClass("IllegalAccessException"));
        jMethod.setComment("implementation of org.exolab.castor.tests.framework.CastorTestable");
        jclass.addMethod(jMethod);
        JSourceCode jsc = jMethod.getSourceCode();
        JField[] fields = jclass.getFields();
        for (i = 0; i < fields.length; ++i) {
            temp = fields[i];
            JType type = temp.getType();
            String name = temp.getName();
            if (state.fieldInfoForChoice != null && name.equals(state.fieldInfoForChoice.getName())) continue;
            name = name.startsWith("_") ? JavaNaming.toJavaClassName(name.substring(1)) : JavaNaming.toJavaClassName(name);
            String setName = "set" + name;
            String componentName = null;
            if (name.indexOf("Has") != -1) continue;
            if (type.getName().equals("java.util.Vector") || type.getName().equals("java.util.ArrayList")) {
                int listLocat = name.lastIndexOf("List");
                String tempName = name;
                if (listLocat != -1) {
                    tempName = tempName.substring(0, listLocat);
                }
                String methodName = JavaNaming.toJavaClassName(tempName);
                methodName = "get" + methodName;
                JMethod method = jclass.getMethod(methodName, 0);
                if (method == null) continue;
                componentName = method.getReturnType().getName();
                method = null;
                methodName = null;
                tempName = null;
                jsc.add(temp.getName());
                jsc.append(" = RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append(", ");
                jsc.append(componentName);
                jsc.append(".class);");
            } else if (type.isPrimitive()) {
                jsc.add(setName);
                jsc.append("(RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append("));");
            } else {
                jsc.add(setName);
                jsc.append("((");
                jsc.append(type.getName());
                jsc.append(")RandomHelper.getRandom(");
                jsc.append(temp.getName());
                jsc.append(", ");
                jsc.append(type.getName());
                jsc.append(".class));");
            }
            jsc.add("");
        }
        jMethod = new JMethod(SGTypes.String, "dumpFields");
        jMethod.setComment("implementation of org.exolab.castor.tests.framework.CastorTestable");
        jclass.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("String result = \"DumpFields() for element: ");
        jsc.append(jclass.getName());
        jsc.append("\\n\";");
        for (i = 0; i < fields.length; ++i) {
            temp = fields[i];
            String name = temp.getName();
            if (temp.getType().isPrimitive() || temp.getType().getName().startsWith("java.lang.")) {
                jsc.add("result += \"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\";");
            } else {
                jsc.add("if ( (");
                jsc.append(name);
                jsc.append(" != null) && (");
                jsc.append(name);
                jsc.append(".getClass().isAssignableFrom(CastorTestable.class)))");
                jsc.indent();
                jsc.add("result += ((CastorTestable)");
                jsc.append(name);
                jsc.append(").dumpFields();");
                jsc.unindent();
                jsc.add("else result += \"Field ");
                jsc.append(name);
                jsc.append(":\" +");
                jsc.append(name);
                jsc.append("+\"\\n\";");
            }
            jsc.add("");
        }
        jsc.add("");
        jsc.add("return result;");
    }

    private void createValidateMethods(JClass jClass) {
        JMethod jMethod = null;
        JSourceCode jsc = null;
        jMethod = new JMethod(null, "validate");
        jMethod.addException(SGTypes.ValidationException);
        jClass.addMethod(jMethod);
        jsc = jMethod.getSourceCode();
        jsc.add("org.exolab.castor.xml.Validator validator = new ");
        jsc.append("org.exolab.castor.xml.Validator();");
        jsc.add("validator.validate(this);");
        jMethod = new JMethod(JType.Boolean, "isValid");
        jsc = jMethod.getSourceCode();
        jsc.add("try {");
        jsc.indent();
        jsc.add("validate();");
        jsc.unindent();
        jsc.add("}");
        jsc.add("catch (org.exolab.castor.xml.ValidationException vex) {");
        jsc.indent();
        jsc.add("return false;");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return true;");
        jClass.addMethod(jMethod);
    }

    private String resolveClassName(String name, String packageName) {
        if (packageName != null && packageName.length() > 0) {
            return packageName + "." + name;
        }
        return name;
    }

    private String processAnnotations(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            StringBuffer comment = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Annotation ann = (Annotation)enumeration.nextElement();
                Enumeration documentations = ann.getDocumentation();
                while (documentations.hasMoreElements()) {
                    Documentation documentation = (Documentation)documentations.nextElement();
                    String content = documentation.getContent();
                    if (content == null) continue;
                    comment.append(content);
                }
            }
            return SourceFactory.normalize(comment.toString());
        }
        return null;
    }

    private void processAttributes(ComplexType complexType, FactoryState state) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        XMLBindingComponent component = new XMLBindingComponent(this._config);
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            AttributeDecl attr = (AttributeDecl)enumeration.nextElement();
            component.setView(attr);
            SimpleType sType = attr.getSimpleType();
            if (sType != null && !SimpleTypesFactory.isBuiltInType(sType.getTypeCode()) && sType.getSchema() == component.getSchema() && state.resolve(sType) == null && sType.hasFacet("enumeration")) {
                this.createSourceCode(sType, state.getSGStateInfo());
            }
            FieldInfo fieldInfo = this.memberFactory.createFieldInfo(component, state);
            this.handleField(fieldInfo, state);
        }
    }

    private void processComplexType(ComplexType complexType, FactoryState state) {
        XMLBindingComponent component = new XMLBindingComponent(this._config);
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        component.setView(complexType);
        String typeName = component.getXMLName();
        ClassInfo classInfo = state.classInfo;
        classInfo.setSchemaType(new XSClass(state.jClass, typeName));
        XMLType base = complexType.getBaseType();
        if (base != null) {
            if (base.isComplexType()) {
                String baseClassName = null;
                component.setView(base);
                if (base.getSchema() == complexType.getSchema()) {
                    ClassInfo cInfo = state.resolve(base);
                    if (cInfo == null) {
                        JClass[] classes = this.createSourceCode(component, state.getSGStateInfo());
                        cInfo = state.resolve(base);
                        baseClassName = classes[0].getName();
                    } else {
                        baseClassName = cInfo.getJClass().getName();
                    }
                    classInfo.setBaseClass(cInfo);
                } else {
                    baseClassName = component.getQualifiedName();
                }
                component.setView(complexType);
                state.jClass.setSuperClass(baseClassName);
            }
            if (complexType.getContentType().getType() == 4) {
                SimpleContent simpleContent = (SimpleContent)complexType.getContentType();
                SimpleType temp = simpleContent.getSimpleType();
                SimpleType baseType = (SimpleType)temp.getBaseType();
                XSType xsType = this._typeConversion.convertType(temp, state.packageName);
                FieldInfo fieldInfo = null;
                if (baseType != null && this.extendsSimpleType(state.jClass, baseType, state)) {
                    if (xsType.isEnumerated()) {
                        fieldInfo = this.memberFactory.createFieldInfoForContent(xsType);
                        fieldInfo.setBound(false);
                        this.handleField(fieldInfo, state);
                        String mname = fieldInfo.getReadMethodName();
                        JClass jClass = state.jClass;
                        JMethod method = jClass.getMethod(mname, 0);
                        jClass.removeMethod(method);
                        mname = fieldInfo.getWriteMethodName();
                        method = jClass.getMethod(mname, 0);
                        JSourceCode jsc = method.getSourceCode();
                        jsc.add("super.");
                        jsc.append(mname);
                        jsc.append("(this.");
                        jsc.append(fieldInfo.getName());
                        jsc.append(".toString());");
                    }
                } else {
                    while (temp.getBaseType() != null) {
                        temp = (SimpleType)temp.getBaseType();
                    }
                    xsType = this._typeConversion.convertType(temp, state.packageName);
                    fieldInfo = this.memberFactory.createFieldInfoForContent(xsType);
                    this.handleField(fieldInfo, state);
                }
            }
        }
        if (!state.isCreateGroupItem()) {
            this.processAttributes(complexType, state);
            component.setView(complexType);
            if (complexType.getContentType() == ContentType.mixed) {
                FieldInfo fieldInfo = this.memberFactory.createFieldInfoForContent(new XSString());
                this.handleField(fieldInfo, state);
            }
        }
        this.processContentModel(complexType, state);
    }

    private void processContentModel(ContentModelGroup contentModel, FactoryState state) {
        Enumeration enumeration = contentModel.enumerate();
        if (state.classInfo.isChoice() && state.fieldInfoForChoice == null) {
            state.fieldInfoForChoice = this.memberFactory.createFieldInfoForChoiceValue();
            state.fieldInfoForChoice.createJavaField(state.jClass);
            state.fieldInfoForChoice.createAccessMethods(state.jClass);
        }
        FieldInfo fieldInfo = null;
        XMLBindingComponent component = new XMLBindingComponent(this._config);
        if (this._binding != null) {
            component.setBinding(this._binding);
        }
        while (enumeration.hasMoreElements()) {
            Annotated annotated = (Annotated)enumeration.nextElement();
            component.setView(annotated);
            switch (annotated.getStructureType()) {
                case 8: {
                    fieldInfo = this.memberFactory.createFieldInfo(component, state);
                    if (contentModel.getMinOccurs() == 0) {
                        fieldInfo.setRequired(false);
                    }
                    this.handleField(fieldInfo, state);
                    break;
                }
                case 10: {
                    Group group = (Group)annotated;
                    if (contentModel instanceof ComplexType || contentModel instanceof ModelGroup) {
                        if (group.getOrder() == Order.choice) {
                            state.classInfo.getGroupInfo().setAsChoice();
                        } else if (group.getOrder() == Order.all) {
                            state.classInfo.getGroupInfo().setAsAll();
                        } else if (group.getOrder() == Order.seq) {
                            state.classInfo.getGroupInfo().setAsSequence();
                        }
                    }
                    if (!(contentModel instanceof ComplexType) && !(contentModel instanceof ModelGroup)) {
                        ModelGroup mg;
                        if (contentModel instanceof ModelGroup && (mg = (ModelGroup)contentModel).isReference()) {
                            contentModel = mg.getReference();
                        }
                        if (contentModel.getParticleCount() <= 0) break;
                        fieldInfo = this.memberFactory.createFieldInfo(component, state.getSGStateInfo());
                        this.handleField(fieldInfo, state);
                        break;
                    }
                    this.processContentModel(group, state);
                    break;
                }
                case 16: {
                    ModelGroup modelgroup = (ModelGroup)annotated;
                    if (modelgroup.getName() != null) {
                        if (modelgroup.isReference()) {
                            modelgroup = modelgroup.getReference();
                        }
                        if (modelgroup.getParticleCount() <= 0) break;
                        fieldInfo = this.memberFactory.createFieldInfo(component, state.getSGStateInfo());
                        this.handleField(fieldInfo, state);
                        break;
                    }
                    this.processContentModel(modelgroup.getContentModelGroup(), state);
                    break;
                }
                case 24: {
                    Wildcard wildcard = (Wildcard)annotated;
                    FieldInfo fieldForAny = this.memberFactory.createFieldInfoForAny(wildcard);
                    this.handleField(fieldForAny, state);
                    break;
                }
            }
        }
    }

    private void processEnumeration(SimpleType simpleType, FactoryState state) {
        if (this._config.useEnumeratedTypeInterface()) {
            state.jClass.addImport(ENUM_ACCESS_INTERFACE);
            state.jClass.addInterface(ENUM_ACCESS_INTERFACE);
        }
        switch (this.enumerationType) {
            case 0: {
                this.processEnumerationAsBaseType(simpleType, state);
                break;
            }
            default: {
                this.processEnumerationAsNewObject(simpleType, state);
            }
        }
    }

    private void processEnumerationAsNewObject(SimpleType simpleType, FactoryState state) {
        Enumeration enumeration = simpleType.getFacets("enumeration");
        boolean useValuesAsName = true;
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String possibleId = this.translateEnumValueToIdentifier(facet.getValue());
            if (JavaNaming.isValidJavaIdentifier(possibleId)) continue;
            useValuesAsName = false;
            break;
        }
        enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.jClass;
        String className = jClass.getLocalName();
        JField field = null;
        JField fHash = new JField(SGTypes.Hashtable, "_memberTable");
        fHash.setInitString("init()");
        fHash.getModifiers().setStatic(true);
        JDocComment jdc = null;
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        constructor.addParameter(new JParameter(JType.Int, "type"));
        constructor.addParameter(new JParameter(SGTypes.String, "value"));
        jsc = constructor.getSourceCode();
        jsc.add("this.type = type;");
        jsc.add("this.stringValue = value;");
        JMethod mValueOf = new JMethod(jClass, "valueOf");
        mValueOf.addParameter(new JParameter(SGTypes.String, "string"));
        mValueOf.getModifiers().setStatic(true);
        jClass.addMethod(mValueOf);
        jdc = mValueOf.getJDocComment();
        jdc.appendComment("Returns a new " + className);
        jdc.appendComment(" based on the given String value.");
        jsc = mValueOf.getSourceCode();
        jsc.add("java.lang.Object obj = null;");
        jsc.add("if (string != null) ");
        if (this._caseInsensitive) {
            jsc.append("obj = _memberTable.get(string.toLowerCase());");
        } else {
            jsc.append("obj = _memberTable.get(string);");
        }
        jsc.add("if (obj == null) {");
        jsc.indent();
        jsc.add("String err = \"'\" + string + \"' is not a valid ");
        jsc.append(className);
        jsc.append("\";");
        jsc.add("throw new IllegalArgumentException(err);");
        jsc.unindent();
        jsc.add("}");
        jsc.add("return (");
        jsc.append(className);
        jsc.append(") obj;");
        JMethod mEnumerate = new JMethod(SGTypes.Enumeration, "enumerate");
        mEnumerate.getModifiers().setStatic(true);
        jClass.addMethod(mEnumerate);
        jdc = mEnumerate.getJDocComment();
        jdc.appendComment("Returns an enumeration of all possible instances of ");
        jdc.appendComment(className);
        mEnumerate.getSourceCode().add("return _memberTable.elements();");
        JMethod mToString = new JMethod(SGTypes.String, "toString");
        jClass.addMethod(mToString);
        jdc = mToString.getJDocComment();
        jdc.appendComment("Returns the String representation of this ");
        jdc.appendComment(className);
        mToString.getSourceCode().add("return this.stringValue;");
        JMethod mInit = new JMethod(SGTypes.Hashtable, "init");
        jClass.addMethod(mInit);
        mInit.getModifiers().makePrivate();
        mInit.getModifiers().setStatic(true);
        mInit.getSourceCode().add("Hashtable members = new Hashtable();");
        JMethod mReadResolve = new JMethod(SGTypes.Object, "readResolve");
        mReadResolve.getModifiers().makePrivate();
        jClass.addMethod(mReadResolve);
        jdc = mReadResolve.getJDocComment();
        jdc.appendComment(" will be called during deserialization to replace ");
        jdc.appendComment("the deserialized object with the correct constant ");
        jdc.appendComment("instance. <br/>");
        jsc = mReadResolve.getSourceCode();
        jsc.add("return valueOf(this.stringValue);");
        int count = 0;
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String value = facet.getValue();
            String typeName = null;
            String objName = null;
            objName = useValuesAsName ? this.translateEnumValueToIdentifier(value) : "VALUE_" + count;
            typeName = objName + "_TYPE";
            boolean addInitializerCode = true;
            if (jClass.getField(objName) != null) {
                jClass.removeField(objName);
                jClass.removeField(typeName);
                addInitializerCode = false;
            }
            field = new JField(JType.Int, typeName);
            field.setComment("The " + value + " type");
            JModifiers modifiers = field.getModifiers();
            modifiers.setFinal(true);
            modifiers.setStatic(true);
            modifiers.makePublic();
            field.setInitString(Integer.toString(count));
            jClass.addField(field);
            field = new JField(jClass, objName);
            field.setComment("The instance of the " + value + " type");
            modifiers = field.getModifiers();
            modifiers.setFinal(true);
            modifiers.setStatic(true);
            modifiers.makePublic();
            StringBuffer init = new StringBuffer();
            init.append("new ");
            init.append(className);
            init.append("(");
            init.append(typeName);
            init.append(", \"");
            init.append(SourceFactory.escapeValue(value));
            init.append("\")");
            field.setInitString(init.toString());
            jClass.addField(field);
            if (addInitializerCode) {
                jsc = mInit.getSourceCode();
                jsc.add("members.put(\"");
                jsc.append(SourceFactory.escapeValue(value));
                if (this._caseInsensitive) {
                    jsc.append("\".toLowerCase(), ");
                } else {
                    jsc.append("\", ");
                }
                jsc.append(objName);
                jsc.append(");");
            }
            ++count;
        }
        mInit.getSourceCode().add("return members;");
        jClass.addField(fHash);
        field = new JField(JType.Int, "type");
        field.setInitString("-1");
        jClass.addField(field);
        field = new JField(SGTypes.String, "stringValue");
        field.setInitString("null");
        jClass.addField(field);
        JMethod mGetType = new JMethod(JType.Int, "getType");
        mGetType.getSourceCode().add("return this.type;");
        jdc = mGetType.getJDocComment();
        jdc.appendComment("Returns the type of this " + className);
        jClass.addMethod(mGetType);
    }

    private void processEnumerationAsBaseType(SimpleType simpleType, FactoryState state) {
        SimpleType base = (SimpleType)simpleType.getBaseType();
        XSType baseType = null;
        baseType = base == null ? new XSString() : this._typeConversion.convertType(base);
        Enumeration enumeration = simpleType.getFacets("enumeration");
        JClass jClass = state.jClass;
        String className = jClass.getLocalName();
        JField fValues = null;
        JDocComment jdc = null;
        JSourceCode jsc = null;
        JConstructor constructor = jClass.getConstructor(0);
        constructor.getModifiers().makePrivate();
        fValues = new JField(baseType.getJType().createArray(), "values");
        int count = 0;
        StringBuffer values = new StringBuffer("{\n");
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String value = facet.getValue();
            if (count > 0) {
                values.append(",\n");
            }
            values.append("    ");
            if (baseType.getType() == 1) {
                values.append('\"');
                values.append(SourceFactory.escapeValue(value));
                values.append('\"');
            } else {
                values.append(value);
            }
            ++count;
        }
        values.append("\n}");
        fValues.setInitString(values.toString());
        jClass.addField(fValues);
        JMethod method = new JMethod(jClass, "valueOf");
        method.addParameter(new JParameter(SGTypes.String, "string"));
        method.getModifiers().setStatic(true);
        jClass.addMethod(method);
        jdc = method.getJDocComment();
        jdc.appendComment("Returns the " + baseType.getJType());
        jdc.appendComment(" based on the given String value.");
        jsc = method.getSourceCode();
        jsc.add("for (int i = 0; i < values.length; i++) {");
        jsc.add("}");
        jsc.add("throw new IllegalArgumentException(\"");
        jsc.append("Invalid value for ");
        jsc.append(className);
        jsc.append(": \" + string + \".\");");
    }

    private String translateEnumValueToIdentifier(String enumValue) {
        try {
            int intVal = Integer.parseInt(enumValue);
            if (intVal >= 0) {
                return "VALUE_" + intVal;
            }
            return "VALUE_NEG_" + Math.abs(intVal);
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer(enumValue.toUpperCase());
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if ("[](){}<>'`\"".indexOf(c) >= 0) {
                    sb.deleteCharAt(i);
                    --i;
                    continue;
                }
                if (!Character.isWhitespace(c) && "\\/?~!@#$%^&*-+=:;.,".indexOf(c) < 0) continue;
                sb.setCharAt(i, '_');
            }
            return sb.toString();
        }
    }

    private void handleField(FieldInfo fieldInfo, FactoryState state) {
        String warn;
        SGStateInfo sInfo;
        if (fieldInfo == null) {
            return;
        }
        if (CLASS_METHOD_SUFFIX.equals(fieldInfo.methodSuffix())) {
            sInfo = state.getSGStateInfo();
            if (!sInfo.getSuppressNonFatalWarnings()) {
                warn = "warning a field name conflicts with \"class\", please use a binding file to specify a different name for the " + fieldInfo.getNodeTypeName() + " '" + fieldInfo.getNodeName() + "'.";
                sInfo.getDialog().notify(warn);
            }
        } else if (CLASS_KEYWORD.equals(fieldInfo.getNodeName()) && !(sInfo = state.getSGStateInfo()).getSuppressNonFatalWarnings()) {
            warn = "warning a field name conflicts with \"class\" and is being replaced by \"clazz\". You may use a binding file to specify a different name for the " + fieldInfo.getNodeTypeName() + " '" + fieldInfo.getNodeName() + "'.";
            sInfo.getDialog().notify(warn);
        }
        JSourceCode scInitializer = state.jClass.getConstructor(0).getSourceCode();
        ClassInfo base = state.classInfo.getBaseClass();
        boolean present = false;
        if (base != null) {
            switch (fieldInfo.getNodeType()) {
                case 0: {
                    present = base.getAttributeField(fieldInfo.getNodeName()) != null;
                    break;
                }
                case 1: {
                    present = base.getElementField(fieldInfo.getNodeName()) != null;
                    break;
                }
            }
        }
        state.classInfo.addFieldInfo(fieldInfo);
        boolean bl = present = present && !fieldInfo.isMultivalued();
        if (!present) {
            if (state.fieldInfoForChoice != null && fieldInfo != state.fieldInfoForChoice) {
                fieldInfo.setReference(state.fieldInfoForChoice.getName());
            }
            fieldInfo.createJavaField(state.jClass);
            if (!fieldInfo.isTransient()) {
                fieldInfo.createAccessMethods(state.jClass);
                if (fieldInfo.isBound()) {
                    state.setBoundProperties(true);
                }
            }
        }
        fieldInfo.generateInitializerCode(scInitializer);
    }

    private boolean extendsSimpleType(JClass jClass, SimpleType type, FactoryState state) {
        ClassInfo cInfo;
        String superClassName = jClass.getSuperClass();
        if (superClassName != null && (cInfo = state.resolve(type)) != null) {
            return superClassName.equals(cInfo.getJClass().getName());
        }
        return false;
    }

    private static String escapeValue(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String normalize(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length];
        int count = 0;
        int i = 0;
        boolean skip = false;
        while (i < chars.length) {
            char ch;
            if ((ch = chars[i++]) == ' ' || ch == '\t') {
                if (!skip && count != 0) {
                    newChars[count++] = 32;
                }
                skip = true;
                continue;
            }
            if (count == 0 && (ch == '\r' || ch == '\n')) continue;
            newChars[count++] = ch;
            skip = false;
        }
        return new String(newChars, 0, count);
    }
}

