/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import org.castor.util.Base64Decoder;
import org.exolab.castor.util.Messages;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

class MozillaEntryConsumer
extends HandlerBase {
    private String _entryDN;
    private LDAPAttributeSet _attrSet;
    private LDAPAttribute _attr;
    private StringBuffer _value;
    private Base64Decoder _decoder;
    private Vector _entries = new Vector();

    MozillaEntryConsumer() {
    }

    public Enumeration getEntries() {
        return this._entries.elements();
    }

    public void startElement(String tagName, AttributeList attr) throws SAXException {
        if (!tagName.equals("directory-entries")) {
            if (tagName.equals("entry")) {
                if (this._attrSet != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", tagName));
                }
                this._attrSet = new LDAPAttributeSet();
                this._entryDN = attr.getValue("dn");
            } else if (tagName.equals("objectclass")) {
                if (this._attrSet == null || this._attr != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", tagName));
                }
                this._attr = new LDAPAttribute("objectclass");
            } else if (tagName.equals("attr")) {
                if (this._attrSet == null || this._attr != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", tagName));
                }
                this._attr = new LDAPAttribute(attr.getValue("name"));
            } else if (tagName.equals("value") || tagName.equals("oc-value")) {
                if (this._attrSet == null || this._attr == null || this._value != null) {
                    throw new SAXException(Messages.format("dsml.openingTagNotRecognized", tagName));
                }
                if ("base64".equals(attr.getValue("encoding"))) {
                    this._decoder = new Base64Decoder();
                } else {
                    this._value = new StringBuffer();
                }
            } else {
                throw new SAXException(Messages.format("dsml.openingTagNotRecognized", tagName));
            }
        }
    }

    public void endElement(String tagName) throws SAXException {
        if (tagName.equals("directory-entries")) {
            if (this._attrSet != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", tagName));
            }
        } else if (tagName.equals("entry")) {
            if (this._attrSet == null || this._attr != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", tagName));
            }
            this._entries.addElement(new LDAPEntry(this._entryDN, this._attrSet));
            this._entryDN = null;
            this._attrSet = null;
        } else if (tagName.equals("objectclass") || tagName.equals("attr")) {
            if (this._attrSet == null || this._attr == null || this._value != null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", tagName));
            }
            this._attrSet.add(this._attr);
            this._attr = null;
        } else if (tagName.equals("value") || tagName.equals("oc-value")) {
            if (this._attrSet == null || this._attr == null || this._value == null && this._decoder == null) {
                throw new SAXException(Messages.format("dsml.closingTagNotRecognized", tagName));
            }
            if (this._decoder != null) {
                this._attr.addValue(this._decoder.getByteArray());
                this._decoder = null;
            } else {
                this._attr.addValue(this._value.toString());
                this._value = null;
            }
        } else {
            throw new SAXException(Messages.format("dsml.closingTagNotRecognized", tagName));
        }
    }

    public void characters(char[] chars, int offset, int length) {
        if (this._decoder != null) {
            this._decoder.translate(new String(chars, offset, length));
        } else if (this._value != null) {
            this._value.append(chars, offset, length);
        }
    }
}

