/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.TransactionContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class ClassMolderHelper {
    public static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$persist$ClassMolderHelper == null ? (class$org$exolab$castor$persist$ClassMolderHelper = ClassMolderHelper.class$("org.exolab.castor.persist.ClassMolderHelper")) : class$org$exolab$castor$persist$ClassMolderHelper));
    static /* synthetic */ Class class$org$exolab$castor$persist$ClassMolderHelper;

    private ClassMolderHelper() {
    }

    public static Vector resolve(MappingLoader loader, LockEngine lock, PersistenceFactory factory) throws MappingException, ClassNotFoundException {
        Vector<ClassMolder> result = new Vector<ClassMolder>();
        DatingService ds = new DatingService(loader.getClassLoader());
        Enumeration enumeration = loader.listJavaClasses();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor desc = loader.getDescriptor((Class)enumeration.nextElement());
            Persistence persist = factory.getPersistence(desc);
            ClassMolder mold = new ClassMolder(ds, loader, lock, desc, persist);
            result.add(mold);
        }
        ds.close();
        return result;
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && ((BigDecimal)o1).compareTo((BigDecimal)o2) == 0) {
            return true;
        }
        if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
            Timestamp t1 = (Timestamp)o1;
            Timestamp t2 = (Timestamp)o2;
            return t1.getTime() == t2.getTime() && t1.getNanos() / 1000000 == t2.getNanos() / 1000000;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public static boolean isEquals(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    public static ArrayList extractIdentityList(TransactionContext tx, ClassMolder molder, Object col) {
        if (col == null) {
            return new ArrayList();
        }
        if (col instanceof Collection) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Iterator itor = ((Collection)col).iterator();
            while (itor.hasNext()) {
                Object id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Iterator) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Iterator itor = (Iterator)col;
            while (itor.hasNext()) {
                Object id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Enumeration) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Enumeration enumeration = (Enumeration)col;
            while (enumeration.hasMoreElements()) {
                Object id = molder.getIdentity(tx, enumeration.nextElement());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Map) {
            ArrayList idList = new ArrayList();
            Iterator itor = ((Map)col).keySet().iterator();
            while (itor.hasNext()) {
                idList.add(itor.next());
            }
            return idList;
        }
        if (col.getClass().isArray()) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Object[] arrayCol = (Object[])col;
            for (int i = 0; i < arrayCol.length; ++i) {
                Object id = molder.getIdentity(tx, arrayCol[i]);
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        throw new IllegalArgumentException("A Collection or Map is expected!");
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Enumeration) {
            return Collections.list((Enumeration)object).iterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object.getClass().isArray()) {
            final class ArrayIterator
            implements Iterator {
                private Object[] _array;
                private int _i = 0;

                ArrayIterator(Object[] array) {
                    this._array = array;
                }

                public boolean hasNext() {
                    return this._i < this._array.length;
                }

                public Object next() {
                    return this._array[this._i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new ArrayIterator((Object[])object);
        }
        throw new IllegalArgumentException();
    }

    public static FieldMapping[] getFullFields(ClassMapping clsMap) throws MappingException {
        FieldMapping[] fields = null;
        ClassMapping extend = (ClassMapping)clsMap.getExtends();
        if (extend != null) {
            int i;
            ClassMapping origin = extend;
            while (origin.getExtends() != null) {
                origin = (ClassMapping)origin.getExtends();
            }
            String[] identities = origin.getIdentity();
            identities = MappingLoader.getIdentityColumnNames(identities, origin);
            FieldMapping[] extendFields = ClassMolderHelper.getFullFields(extend);
            FieldMapping[] thisFields = clsMap.getClassChoice().getFieldMapping();
            ArrayList<FieldMapping> fieldList = new ArrayList<FieldMapping>(extendFields.length + thisFields.length - identities.length);
            for (i = 0; i < extendFields.length; ++i) {
                fieldList.add(extendFields[i]);
            }
            int j = 0;
            for (i = 0; i < thisFields.length; ++i) {
                boolean idfield = false;
                for (int k = 0; k < identities.length; ++k) {
                    if (!thisFields[i].getName().equals(identities[k])) continue;
                    idfield = true;
                    break;
                }
                if (idfield) continue;
                fieldList.add(thisFields[i]);
                ++j;
            }
            fields = new FieldMapping[fieldList.size()];
            fieldList.toArray(fields);
        } else {
            String[] identities = clsMap.getIdentity();
            if ((identities = MappingLoader.getIdentityColumnNames(identities, clsMap)) == null || identities.length == 0) {
                throw new MappingException("Identity is null!");
            }
            FieldMapping[] thisFields = clsMap.getClassChoice().getFieldMapping();
            fields = new FieldMapping[thisFields.length - identities.length];
            int j = 0;
            for (int i = 0; i < thisFields.length; ++i) {
                boolean idfield = false;
                for (int k = 0; k < identities.length; ++k) {
                    if (!thisFields[i].getName().equals(identities[k])) continue;
                    idfield = true;
                    break;
                }
                if (idfield) continue;
                fields[j] = thisFields[i];
                ++j;
            }
        }
        return fields;
    }

    public static FieldMapping[] getIdFields(ClassMapping clsMap) throws MappingException {
        ClassMapping base = clsMap;
        while (base.getExtends() != null) {
            base = (ClassMapping)base.getExtends();
        }
        Object fmDepended = null;
        String[] identities = base.getIdentity();
        if ((identities = MappingLoader.getIdentityColumnNames(identities, base)) == null || identities.length == 0) {
            throw new MappingException("Identity is null!");
        }
        FieldMapping[] fmIds = new FieldMapping[identities.length];
        FieldMapping[] fmBase = base.getClassChoice().getFieldMapping();
        block1: for (int i = 0; i < fmBase.length; ++i) {
            for (int k = 0; k < identities.length; ++k) {
                if (!fmBase[i].getName().equals(identities[k])) continue;
                fmIds[k] = fmBase[i];
                continue block1;
            }
        }
        if (fmDepended == null) {
            return fmIds;
        }
        FieldMapping[] fmResult = new FieldMapping[(fmDepended).length + identities.length];
        System.arraycopy(fmIds, 0, fmResult, 0, fmIds.length);
        System.arraycopy(fmDepended, 0, fmResult, fmIds.length, (fmDepended).length);
        return fmIds;
    }

    public static Collection getAddedValuesList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            return new ArrayList(0);
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return ((Map)collection).values();
            }
            Map newMap = (Map)collection;
            ArrayList added = new ArrayList(newMap.size());
            Iterator newItor = newMap.entrySet().iterator();
            while (newItor.hasNext()) {
                Map.Entry newId = newItor.next();
                if (orgIds.contains(newId.getKey())) continue;
                added.add(newId.getValue());
            }
            return added;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return (Collection)collection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Collection newValues = (Collection)collection;
            ArrayList added = new ArrayList(newValues.size());
            Iterator newItor = newValues.iterator();
            while (newItor.hasNext()) {
                Object newValue = newItor.next();
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection instanceof Iterator) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                Iterator iterator = (Iterator)collection;
                ArrayList returnCollection = new ArrayList();
                while (iterator.hasNext()) {
                    returnCollection.add(iterator.next());
                }
                return returnCollection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Iterator newValuesIterator = (Iterator)collection;
            ArrayList added = new ArrayList();
            while (newValuesIterator.hasNext()) {
                Object newValue = newValuesIterator.next();
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection instanceof Enumeration) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return Collections.list((Enumeration)collection);
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Enumeration newValues = (Enumeration)collection;
            ArrayList added = new ArrayList();
            while (newValues.hasMoreElements()) {
                Object newValue = newValues.nextElement();
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                Object[] newValues = (Object[])collection;
                ArrayList<Object> result = new ArrayList<Object>(newValues.length);
                for (int i = 0; i < newValues.length; ++i) {
                    result.add(newValues[i]);
                }
                return result;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Object[] newValues = (Object[])collection;
            ArrayList<Object> added = new ArrayList<Object>(newValues.length);
            for (int i = 0; i < newValues.length; ++i) {
                Object newValue = newValues[i];
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    public static Collection getRemovedIdsList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            if (orgIds == null) {
                return new ArrayList(0);
            }
            return orgIds;
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Map newMap = (Map)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(orgIds.size());
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Enumeration) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Enumeration newCol = (Enumeration)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            while (newCol.hasMoreElements()) {
                Object newObject = newCol.nextElement();
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Collection newCol = (Collection)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            Iterator newColItor = newCol.iterator();
            while (newColItor.hasNext()) {
                Object newObject = newColItor.next();
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Iterator) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Iterator collectionIterator = (Iterator)collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            while (collectionIterator.hasNext()) {
                Object newObject = collectionIterator.next();
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection.getClass().isArray()) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Object[] newCol = (Object[])collection;
            Iterator orgItor = orgIds.iterator();
            ArrayList removed = new ArrayList(0);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (int i = 0; i < newCol.length; ++i) {
                Object newObject = newCol[i];
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

