/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFile;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.ImageElementValidationItem;
import com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator.JrxmlValidationDialog;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.JMDIFrame;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RepositoryJrxmlFile
extends RepositoryFile
implements ReportFrameActivatedListener {
    private JReportFrame reportFrame = null;

    public RepositoryJrxmlFile(JServer server, ResourceDescriptor descriptor) {
        super(server, descriptor);
        MainFrame.getMainInstance().addReportFrameActivatedListener((ReportFrameActivatedListener)this);
    }

    public String toString() {
        if (this.getDescriptor() != null) {
            return "" + this.getDescriptor().getLabel();
        }
        return "???";
    }

    public void reportFrameActivated(ReportFrameActivatedEvent reportFrameActivatedEvent) {
        if (this.getReportFrame() == null) {
            return;
        }
        if (reportFrameActivatedEvent.getReportFrame() == null) {
            this.setReportFrame(null);
            IRPlugin.getMainInstance().getRepositoryExplorer().updateToolBar();
            return;
        }
        JInternalFrame[] frames = MainFrame.getMainInstance().getJMDIDesktopPane().getAllFrames();
        boolean found = false;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != this.getReportFrame()) continue;
            found = true;
            break;
        }
        if (!found) {
            this.setReportFrame(null);
            IRPlugin.getMainInstance().getRepositoryExplorer().updateToolBar();
        }
    }

    public void editFile() throws Exception {
        if (this.getReportFrame() == null) {
            String tmpFileName = IRPlugin.createTmpFileName(this.getDescriptor().getName(), ".jrxml");
            this.getServer().getWSClient().get(this.getDescriptor(), new File(tmpFileName));
            this.setReportFrame(MainFrame.getMainInstance().openFile(tmpFileName));
            for (int i = 0; i < this.getReportFrame().getReport().getJRproperties().size(); ++i) {
                JRProperty p = (JRProperty)this.getReportFrame().getReport().getJRproperties().get(i);
                if (!p.getName().equals("com.jaspersoft.ji.adhoc") || !p.getValue().equals("1")) continue;
                p.setValue("0");
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (JOptionPane.showConfirmDialog((Component)MainFrame.getMainInstance(), IRPlugin.getString("messages.adhoc", "You have selected to edit an Ad Hoc report.\nIf you continue, the report will lose its sorting and grouping.\nFurthermore, any changes you make in iReport will be lost\nnext Time you edit it via the Ad Hoc report editor.\nContinue anyway?"), IRPlugin.getString("alert", "Alert!"), 0, 2) == 1) {
                                RepositoryJrxmlFile.this.getReportFrame().setVisible(false);
                                RepositoryJrxmlFile.this.getReportFrame().getMainFrame().getJMDIDesktopPane().internalFrameClosed((JMDIFrame)RepositoryJrxmlFile.this.reportFrame);
                                RepositoryJrxmlFile.this.getReportFrame().dispose();
                            }
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.loadRepositoryImages(this.getReportFrame().getReport().getElements());
        } else {
            this.getReportFrame().setSelected(true);
        }
    }

    protected void loadRepositoryImages(Vector elements) {
        Enumeration enumElements = elements.elements();
        while (enumElements.hasMoreElements()) {
            ReportElement re = (ReportElement)enumElements.nextElement();
            if (re instanceof ImageReportElement) {
                ImageReportElement ire = (ImageReportElement)re;
                String expression = ire.getImageExpression();
                expression = Misc.string_replace((String)"\\", (String)"\\\\", (String)expression);
                expression = Misc.string_replace((String)"", (String)"\"", (String)expression);
                if ((ire.getImageClass().length() == 0 || ire.getImageClass().equals("java.lang.String")) && expression.toLowerCase().startsWith("repo:")) {
                    ResourceDescriptor rd = new ResourceDescriptor();
                    if ((expression = expression.substring(5)).startsWith("/")) {
                        rd.setUriString(expression);
                    } else {
                        rd.setUriString(this.getDescriptor().getParentFolder() + "/" + expression);
                    }
                    RepositoryFile rf = new RepositoryFile(this.getServer(), rd);
                    try {
                        String imgFile = rf.getFile();
                        if (imgFile != null) {
                            ImageIcon img = new ImageIcon(imgFile);
                            ire.setImg(img.getImage());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (!(re instanceof CrosstabReportElement)) continue;
            this.loadRepositoryImages(((CrosstabReportElement)re).getElements());
        }
    }

    public JReportFrame getReportFrame() {
        return this.reportFrame;
    }

    public void setReportFrame(JReportFrame reportFrame) {
        this.reportFrame = reportFrame;
    }

    public boolean validateUrls(JServer server, RepositoryReportUnit repoUnit) {
        ArrayList<ImageElementValidationItem> imageElementValidationItems = new ArrayList<ImageElementValidationItem>();
        if (this.getReportFrame() != null) {
            Vector elements = this.getReportFrame().getReport().getElements();
            for (int i = 0; i < elements.size(); ++i) {
                ReportElement re = (ReportElement)elements.elementAt(i);
                if (!(re instanceof ImageReportElement)) continue;
                ImageReportElement ire = (ImageReportElement)re;
                String fname = ire.getImageExpression();
                if (!ire.getImageClass().equals("java.lang.String") || ire.getImageExpression().startsWith("\"repo:") || fname.length() <= 3 || fname.charAt(0) != '\"' || fname.charAt(fname.length() - 1) != '\"' || ire.getImageExpression().indexOf("$F{") >= 0 || ire.getImageExpression().indexOf("$P{") >= 0 || ire.getImageExpression().indexOf("$V{") >= 0 || ire.getImageExpression().indexOf("$R{") >= 0) continue;
                fname = Misc.string_replace((String)"\\", (String)"\\\\", (String)fname);
                fname = Misc.string_replace((String)"\\", (String)"\\\\", (String)fname);
                File f = new File(fname = Misc.string_replace((String)"", (String)"\"", (String)fname));
                if (!f.exists()) continue;
                ImageElementValidationItem ievi = new ImageElementValidationItem();
                ievi.setOriginalFileName(f);
                String name = this.getValidName(f.getName(), repoUnit);
                ievi.setResourceName(name);
                ievi.setProposedExpression("repo:" + name);
                ievi.setReportElement(ire);
                imageElementValidationItems.add(ievi);
            }
            Report report = this.getReportFrame().getReport();
            boolean skipValidation = false;
            for (int i = 0; i < report.getJRproperties().size(); ++i) {
                JRProperty prop = (JRProperty)report.getJRproperties().get(i);
                if (prop.getName() == null || !prop.getName().equals("com.jaspersoft.irplugin.validation")) continue;
                if (!prop.getValue().equals("0")) break;
                skipValidation = true;
                break;
            }
            if (imageElementValidationItems.size() > 0 && !skipValidation) {
                JrxmlValidationDialog jvd = new JrxmlValidationDialog((Frame)MainFrame.getMainInstance(), true);
                jvd.setImageElementVelidationItems(imageElementValidationItems);
                jvd.setServer(server);
                jvd.setReportUnit(repoUnit);
                jvd.setReport(this.getReportFrame().getReport());
                jvd.setVisible(true);
                if (jvd.getDialogResult() == 2) {
                    return false;
                }
            }
        }
        return true;
    }

    public String getValidName(String name, RepositoryReportUnit repoUnit) {
        return this.getValidName(name, repoUnit, 0);
    }

    private String getValidName(String name, RepositoryReportUnit repoUnit, int k) {
        String ext = "";
        String base = name;
        if (name.lastIndexOf(".") > 0) {
            ext = name.substring(name.lastIndexOf("."));
            base = name.substring(0, name.lastIndexOf("."));
        }
        String newName = base + (k == 0 ? "" : "-" + k) + ext;
        for (int i = 0; i < repoUnit.getDescriptor().getChildren().size(); ++i) {
            ResourceDescriptor rd = (ResourceDescriptor)repoUnit.getDescriptor().getChildren().get(i);
            if (!rd.getName().equals(newName)) continue;
            return this.getValidName(name, repoUnit, ++k);
        }
        return newName;
    }
}

