/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.log;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.log.LogHandler;
import com.tonbeller.wcf.utils.SoftException;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.Document;

public class LogForm
extends FormComponent {
    LogHandler logHandler;
    String logDir;
    String logConf = LogHandler.getDefault();
    String logVersion;
    Locale locale;

    public LogForm(String id, Component parent, Document doc, String logDir) throws Exception {
        super(id, parent, doc);
        this.logDir = logDir;
    }

    public void initialize(RequestContext context) throws Exception {
        try {
            String ctxname = context.getRequest().getContextPath();
            if (ctxname.startsWith("/")) {
                ctxname = ctxname.substring(1);
            }
            this.locale = Resources.instance().getLocaleContextHolderLocale();
            if (this.locale == null) {
                this.locale = context.getLocale();
            }
            this.logHandler = this.createLogHandler(this.logDir, this.locale, ctxname);
            this.logVersion = this.logHandler.version();
        }
        catch (IOException e) {
            throw new SoftException(e);
        }
        super.initialize(context);
    }

    protected LogHandler createLogHandler(String logDir, Locale locale, String ctxname) throws IOException {
        return new LogHandler(logDir, locale, ctxname);
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public String getLogConf() {
        return this.logConf;
    }

    public void setLogConf(String logConf) {
        this.logConf = logConf;
        try {
            this.logHandler.applyConfig(logConf);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new FormatException(msg);
        }
    }

    public String getLogVersion() {
        return this.logVersion;
    }

    public String getLogFile() {
        return this.logHandler.getLogFile().getAbsolutePath();
    }

    public void setLogFile(String logFile) {
        this.logHandler.setLogFile(new File(logFile));
    }

    public String getLogLevel() {
        return this.logHandler.getRootLoggerLevel();
    }
}

