/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tabbed;

import com.tonbeller.wcf.component.FormListener;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.NodeHandler;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.tabbed.PanelChangeEvent;
import com.tonbeller.wcf.tabbed.PanelChangeListener;
import com.tonbeller.wcf.tabbed.TabbedHandler;
import com.tonbeller.wcf.tree.TreeHandler;
import com.tonbeller.wcf.ui.XoplonCtrl;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Element;

public class PanelSupport
implements NodeHandler,
PanelChangeListener,
FormListener {
    private static Logger logger = Logger.getLogger((Class)PanelSupport.class);
    protected FormComponent formComponent;
    protected TabbedHandler tabbedHandler;
    protected Element panelElement;

    public void initialize(RequestContext context, XmlComponent comp, Element element) throws Exception {
        this.formComponent = (FormComponent)comp;
        this.panelElement = element;
        this.formComponent.addFormListener(this);
        Element tabbedElement = (Element)element.getParentNode();
        this.tabbedHandler = (TabbedHandler)this.formComponent.getHandler(tabbedElement);
        this.tabbedHandler.addPanelChangedListener(this);
    }

    public void destroy(HttpSession session) throws Exception {
        this.formComponent.removeFormListener(this);
        this.tabbedHandler.removePanelChangedListener(this);
    }

    protected TreeHandler findTreeHandler(FormComponent fc) throws JaxenException {
        DOMXPath dx = new DOMXPath("//xtree");
        Element elem = (Element)dx.selectSingleNode((Object)fc.getDocument());
        if (elem == null) {
            return null;
        }
        return (TreeHandler)fc.getHandler(elem);
    }

    public void render(RequestContext context) throws Exception {
    }

    public void panelChanged(PanelChangeEvent event) {
    }

    public boolean validate(RequestContext context) {
        return true;
    }

    public void revert(RequestContext context) {
    }

    public FormComponent getFormComponent() {
        return this.formComponent;
    }

    public TabbedHandler getTabbedHandler() {
        return this.tabbedHandler;
    }

    public boolean isHidden() {
        return XoplonCtrl.isHidden(this.panelElement);
    }

    public void setHidden(RequestContext context, boolean hidden) {
        this.tabbedHandler.setHidden(context, this.panelElement, hidden);
    }
}

