/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateBeforeDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.DefaultDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class HibernateCompositeDeleteListener
extends DefaultDeleteEventListener {
    private List listeners;

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void onDelete(DeleteEvent event) throws HibernateException {
        super.onDelete(event);
        this.fireListeners(event);
    }

    protected void cascadeBeforeDelete(EventSource session, EntityPersister persister, Object entity, EntityEntry entityEntry, Set transientEntities) throws HibernateException {
        super.cascadeBeforeDelete(session, persister, entity, entityEntry, transientEntities);
        this.fireBeforeListeners(new DeleteEvent(entity, session));
    }

    protected void fireListeners(DeleteEvent event) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof HibernateDeleteListener)) continue;
                this.fireListener((HibernateDeleteListener)listener, event);
            }
        }
    }

    protected void fireListener(HibernateDeleteListener listener, DeleteEvent event) {
        listener.onDelete(event.getObject());
    }

    protected void fireBeforeListeners(DeleteEvent event) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                Object listener = it.next();
                if (!(listener instanceof HibernateBeforeDeleteListener)) continue;
                this.fireListener((HibernateBeforeDeleteListener)listener, event);
            }
        }
    }

    protected void fireListener(HibernateBeforeDeleteListener listener, DeleteEvent event) {
        listener.beforeDelete(event);
    }
}

