/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.common.service.ServletContextInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.util.ValidationUtil;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

public class ReportUnitValidator
implements ResourceValidator {
    private RepositoryService repository;
    private ServletContextInformation servletContextInformation;

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }

    public ServletContextInformation getServletContextInformation() {
        return this.servletContextInformation;
    }

    public void setServletContextInformation(ServletContextInformation servletContextInformation) {
        this.servletContextInformation = servletContextInformation;
    }

    public ValidationErrors validate(Resource resource, ValidationErrorFilter filter) {
        ValidationErrorsImpl errors = new ValidationErrorsImpl();
        ReportUnit report = (ReportUnit)resource;
        this.validateLabel(report, filter, (ValidationErrors)errors);
        this.validateName(report, filter, (ValidationErrors)errors);
        this.validateDescription(report, filter, (ValidationErrors)errors);
        this.validateInputControlView(report, filter, (ValidationErrors)errors);
        this.validateRenderingView(report, filter, (ValidationErrors)errors);
        return errors;
    }

    private void validateLabel(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        if (filter == null || filter.matchErrorField("reportUnit.label")) {
            if (report.getLabel() == null || report.getLabel().trim().length() == 0) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.not.empty", null, null, "reportUnit.label"));
            } else if (report.getLabel().length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.label"));
            }
        }
    }

    private void validateName(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        if (filter == null || filter.matchErrorField("reportUnit.name")) {
            if (report.getName() == null || report.getName().trim().length() == 0) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.not.empty", null, null, "reportUnit.name"));
            } else if (report.getName().length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.name"));
            } else if (!ValidationUtil.regExValidateName(report.getName())) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.invalid.chars", null, null, "reportUnit.name"));
            } else if (filter != null && filter.matchErrorCode("ReportDetailsValidator.error.duplicate") && this.getRepositoryService().repositoryPathExists(null, report.getURIString())) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.duplicate", null, null, "reportUnit.name"));
            }
        }
    }

    private void validateDescription(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        if ((filter == null || filter.matchErrorField("reportUnit.description")) && report.getDescription() != null && report.getDescription().length() > 250) {
            errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.description"));
        }
    }

    private void validateInputControlView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        String inputControlView;
        if ((filter == null || filter.matchErrorField("reportUnit.inputControlRenderingView")) && (inputControlView = report.getInputControlRenderingView()) != null && inputControlView.length() > 0) {
            if (inputControlView.length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.inputControlRenderingView"));
            } else if (!this.getServletContextInformation().jspExists(inputControlView)) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.inputControlRenderingView"));
            }
        }
    }

    private void validateRenderingView(ReportUnit report, ValidationErrorFilter filter, ValidationErrors errors) {
        String reportRenderingView;
        if ((filter == null || filter.matchErrorField("reportUnit.reportRenderingView")) && (reportRenderingView = report.getReportRenderingView()) != null && reportRenderingView.length() > 0) {
            if (reportRenderingView.length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.too.long", null, null, "reportUnit.reportRenderingView"));
            } else if (!this.getServletContextInformation().jspExists(reportRenderingView)) {
                errors.add((ValidationError)new ValidationErrorImpl("ReportDetailsValidator.error.inexisting.jsp", null, null, "reportUnit.reportRenderingView"));
            }
        }
    }
}

