/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryServiceSecurityChecker {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$RepositoryServiceSecurityChecker == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$RepositoryServiceSecurityChecker = RepositoryServiceSecurityChecker.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositoryServiceSecurityChecker")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$RepositoryServiceSecurityChecker));
    private RepositoryService securityChecker;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$RepositoryServiceSecurityChecker;

    public void filterResources(List allResources, Map removableResources, Map editableResources) {
        Iterator iter = allResources.iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            this.filterResource(res, removableResources, editableResources);
        }
    }

    public void filterResource(Resource resource, Map removableResources, Map editableResources) {
        if (this.isEditable(resource)) {
            editableResources.put(resource.getURIString(), "true");
            log.debug((Object)(resource.getURIString() + ": " + (editableResources.containsKey(resource.getURIString()) ? "EDIT" : "??edit??")));
        }
        if (this.isRemovable(resource)) {
            removableResources.put(resource.getURIString(), "true");
            log.debug((Object)(resource.getURIString() + ": " + (removableResources.containsKey(resource.getURIString()) ? "DELETE" : "??delete??")));
        }
    }

    public boolean isEditable(Resource resource) {
        try {
            this.securityChecker.saveResource(null, resource);
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("No UPDATE permission for < " + resource.getURIString() + ">:" + e.getMessage()));
            return false;
        }
    }

    public boolean isRemovable(Resource resource) {
        try {
            this.securityChecker.deleteResource(null, resource.getURI());
            return true;
        }
        catch (Exception e) {
            log.debug((Object)("No DELETE permission for < " + resource.getURIString() + ">:" + e.getMessage()));
            return false;
        }
    }

    public RepositoryService getSecurityChecker() {
        return this.securityChecker;
    }

    public void setSecurityChecker(RepositoryService securityChecker) {
        this.securityChecker = securityChecker;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

