/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorsImpl;
import com.jaspersoft.jasperserver.api.common.util.CollatorFactory;
import com.jaspersoft.jasperserver.api.common.util.DefaultCollatorFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceValidator;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateFilter;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.ContentRepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.SortingUtils;
import com.jaspersoft.jasperserver.api.metadata.view.domain.Filter;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateRepositoryServiceImpl
extends HibernateDaoImpl
implements HibernateRepositoryService,
ReferenceResolver {
    private static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryServiceImpl == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryServiceImpl = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.HibernateRepositoryServiceImpl")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryServiceImpl));
    protected static final String TEMP_NAME_PREFIX = "*";
    protected static final int TEMP_NAME_PREFIX_LENGTH = "*".length();
    protected static final String CHILDREN_FOLDER_SUFFIX = "_files";
    private ResourceFactory resourceFactory;
    private ResourceFactory persistentClassMappings;
    private Map validatorMappings;
    private ThreadLocal tempNameResources;
    private CollatorFactory collatorFactory = new DefaultCollatorFactory();
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$HibernateRepositoryServiceImpl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource;

    public HibernateRepositoryServiceImpl() {
        this.tempNameResources = new ThreadLocal();
    }

    public ResourceFactory getPersistentClassMappings() {
        return this.persistentClassMappings;
    }

    public void setPersistentClassMappings(ResourceFactory persistentClassMappings) {
        this.persistentClassMappings = persistentClassMappings;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public Map getValidatorMappings() {
        return this.validatorMappings;
    }

    public void setValidatorMappings(Map validatorMappings) {
        this.validatorMappings = validatorMappings;
    }

    public ResourceValidator getValidator(Resource resource) {
        return resource == null ? null : (ResourceValidator)this.validatorMappings.get(resource.getResourceType());
    }

    public Resource getResource(ExecutionContext context, String uri) {
        return this.getResourceUnsecure(context, uri);
    }

    public Resource getResourceUnsecure(ExecutionContext context, final String uri) {
        return (Resource)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResource(uri, null);
            }
        });
    }

    public Resource getResource(ExecutionContext context, final String uri, final Class resourceType) {
        return (Resource)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResource(uri, resourceType);
            }
        });
    }

    protected Object loadResource(String uri, Class resourceType) {
        Resource resource;
        Class persistentClass = this.resourcePersistentClass(resourceType);
        RepoResource repoResource = this.findByURI(persistentClass, uri, false);
        if (repoResource == null) {
            log.debug((Object)("Resource not found at \"" + uri + "\""));
            resource = null;
        } else {
            resource = (Resource)repoResource.toClient(this.resourceFactory);
        }
        return resource;
    }

    protected Class resourcePersistentClass(Class resourceType) {
        Class persistentClass = resourceType == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource) : this.getPersistentClassMappings().getImplementationClass(resourceType);
        return persistentClass;
    }

    public void saveFolder(ExecutionContext context, final Folder folder) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.saveFolder(folder);
                return null;
            }
        });
    }

    protected void saveFolder(Folder folder) {
        RepoFolder repoFolder = this.getFolder(folder.getURIString(), false);
        if (folder.isNew()) {
            if (repoFolder != null || this.resourceExists(folder.getURIString())) {
                throw new JSDuplicateResourceException("jsexception.folder.already.exists", new Object[]{folder.getURIString()});
            }
            repoFolder = new RepoFolder();
            repoFolder.setCreationDate(this.getOperationTimestamp());
        } else if (repoFolder == null) {
            String quotedURI = "\"" + folder.getURIString() + "\"";
            throw new JSException("jsexception.folder.not.found", new Object[]{quotedURI});
        }
        String parentURI = folder.getParentFolder();
        RepoFolder parent = parentURI == null && folder.getName().equals("/") ? null : this.getFolder(parentURI, true);
        repoFolder.set(folder, parent);
        this.getHibernateTemplate().saveOrUpdate((Object)repoFolder);
    }

    protected RepoFolder getFolder(String uri, boolean required) {
        RepoFolder folder;
        if (uri == null || uri.length() == 0 || uri.equals("/")) {
            return this.getRootFolder();
        }
        String repoURIPrefix = "repo:";
        String workUri = uri.startsWith("repo:") ? uri.substring("repo:".length()) : uri;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder));
        criteria.add((Criterion)Restrictions.naturalId().set("URI", (Object)workUri));
        List foldersList = this.getHibernateTemplate().findByCriteria(criteria);
        if (foldersList.isEmpty()) {
            if (required) {
                String quotedURI = "\"" + uri + "\"";
                throw new JSResourceNotFoundException("jsexception.folder.not.found.at", new Object[]{quotedURI});
            }
            log.debug((Object)("Folder not found at \"" + uri + "\""));
            folder = null;
        } else {
            folder = (RepoFolder)foldersList.get(0);
        }
        return folder;
    }

    protected RepoFolder getRootFolder() {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder));
        criteria.add((Criterion)Restrictions.naturalId().set("URI", (Object)"/"));
        List foldersList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoFolder root = foldersList.isEmpty() ? null : (RepoFolder)foldersList.get(0);
        return root;
    }

    public ValidationErrors validateResource(ExecutionContext context, Resource resource, ValidationErrorFilter filter) {
        ResourceValidator validator = this.getValidator(resource);
        if (validator != null) {
            return validator.validate(resource, filter);
        }
        return new ValidationErrorsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResource(ExecutionContext context, final Resource resource) {
        this.initTempNameResources();
        try {
            this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                public Object execute() {
                    RepoResource repo = HibernateRepositoryServiceImpl.this.getRepoResource(resource);
                    repo.copyFromClient(resource, HibernateRepositoryServiceImpl.this);
                    RepoResource repositoryResource = repo;
                    HibernateRepositoryServiceImpl.this.getHibernateTemplate().saveOrUpdate((Object)repositoryResource);
                    return null;
                }
            });
            if (!this.tempNameResources().isEmpty()) {
                this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

                    public Object execute() {
                        HibernateTemplate template = HibernateRepositoryServiceImpl.this.getHibernateTemplate();
                        Iterator it = HibernateRepositoryServiceImpl.this.tempNameResources().iterator();
                        while (it.hasNext()) {
                            RepoResource res = (RepoResource)it.next();
                            res.setName(res.getName().substring(TEMP_NAME_PREFIX_LENGTH));
                            template.save((Object)res);
                        }
                        return null;
                    }
                });
            }
        }
        finally {
            this.resetTempNameResources();
        }
    }

    protected void initTempNameResources() {
        this.tempNameResources.set(new HashSet());
    }

    protected void resetTempNameResources() {
        this.tempNameResources.set(null);
    }

    protected Set tempNameResources() {
        return (Set)this.tempNameResources.get();
    }

    public RepoResource getRepoResource(Resource resource) {
        RepoResource repo;
        Class persistentClass = this.getPersistentClassMappings().getImplementationClass(resource.getClass());
        if (persistentClass == null) {
            String quotedResource = "\"" + resource.getClass().getName() + "\"";
            throw new JSException("jsexception.no.persistent.class.mapped.to", new Object[]{quotedResource});
        }
        if (resource.isNew()) {
            if (this.pathExists(resource.getURIString())) {
                String quotedResource = "\"" + resource.getURIString() + "\"";
                throw new JSDuplicateResourceException("jsexception.resource.already.exists", new Object[]{quotedResource});
            }
            repo = this.createPersistentResource(persistentClass);
            RepoFolder parent = this.getFolder(resource.getParentFolder(), true);
            repo.setParent(parent);
        } else {
            repo = this.findByURI(persistentClass, resource.getURIString(), false);
            if (repo == null) {
                String quotedURI = "\"" + resource.getURIString() + "\"";
                throw new JSException("jsexception.resource.does.not.exist", new Object[]{quotedURI});
            }
        }
        return repo;
    }

    public boolean resourceExists(ExecutionContext executionContext, String uri) {
        return this.resourceExists(uri);
    }

    public boolean resourceExists(ExecutionContext executionContext, String uri, Class resourceType) {
        return this.resourceExists(uri, resourceType);
    }

    public boolean resourceExists(ExecutionContext executionContext, FilterCriteria filterCriteria) {
        boolean exists;
        DetachedCriteria criteria = this.translateFilterToCriteria(filterCriteria);
        if (criteria == null) {
            exists = false;
        } else {
            criteria.setProjection(Projections.rowCount());
            List countList = this.getHibernateTemplate().findByCriteria(criteria);
            int count = (Integer)countList.get(0);
            exists = count > 0;
        }
        return exists;
    }

    protected boolean resourceExists(String uri) {
        return this.resourceExists(uri, null);
    }

    protected boolean resourceExists(String uri, Class type) {
        int sep = uri.lastIndexOf("/");
        boolean exists = false;
        if (sep >= 0) {
            String name = uri.substring(sep + Folder.SEPARATOR_LENGTH);
            String folderName = uri.substring(0, sep);
            RepoFolder folder = this.getFolder(folderName, false);
            if (folder != null) {
                exists = this.resourceExists(folder, name, type);
            }
        }
        return exists;
    }

    public ResourceLookup[] findResource(final ExecutionContext context, final FilterCriteria filterCriteria) {
        return (ResourceLookup[])this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResources(context, filterCriteria);
            }
        });
    }

    public ResourceLookup[] findResources(final ExecutionContext context, final FilterCriteria[] filterCriteria) {
        return (ResourceLookup[])this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                return HibernateRepositoryServiceImpl.this.loadResources(context, filterCriteria);
            }
        });
    }

    public List loadClientResources(FilterCriteria filterCriteria) {
        List repoResources = this.loadRepoResourceList(filterCriteria);
        ArrayList<Object> result = new ArrayList<Object>(repoResources.size());
        Iterator iter = repoResources.iterator();
        while (iter.hasNext()) {
            RepoResource repoResource = (RepoResource)iter.next();
            result.add(repoResource.toClient(this.resourceFactory));
        }
        return result;
    }

    public List loadResourcesList(FilterCriteria filterCriteria) {
        return this.loadResourcesList(null, filterCriteria);
    }

    public List loadResourcesList(ExecutionContext context, FilterCriteria filterCriteria) {
        List repoResources = this.loadRepoResourceList(context, filterCriteria);
        return this.toLookups(repoResources);
    }

    public List loadResourcesList(ExecutionContext context, FilterCriteria[] filterCriteria) {
        List repoResources;
        if (filterCriteria.length == 1) {
            repoResources = this.loadRepoResourceList(context, filterCriteria[0]);
        } else {
            repoResources = new ArrayList();
            for (int i = 0; i < filterCriteria.length; ++i) {
                FilterCriteria criteria = filterCriteria[i];
                List criteriaRes = this.loadRepoResourceList(context, criteria, false);
                if (criteriaRes == null) continue;
                repoResources.addAll(criteriaRes);
            }
            this.sortRepoResourcesByURI(context, repoResources);
        }
        return this.toLookups(repoResources);
    }

    protected List toLookups(List repoResources) {
        ArrayList<ResourceLookup> result = new ArrayList<ResourceLookup>(repoResources.size());
        Iterator iter = repoResources.iterator();
        while (iter.hasNext()) {
            RepoResource repoResource = (RepoResource)iter.next();
            result.add(repoResource.toClientLookup());
        }
        return result;
    }

    protected ResourceLookup[] loadResources(ExecutionContext context, FilterCriteria filterCriteria) {
        List repoResources = this.loadResourcesList(context, filterCriteria);
        ResourceLookup[] resourceLookups = new ResourceLookup[repoResources.size()];
        resourceLookups = repoResources.toArray(resourceLookups);
        return resourceLookups;
    }

    protected ResourceLookup[] loadResources(ExecutionContext context, FilterCriteria[] filterCriteria) {
        List repoResources = this.loadResourcesList(context, filterCriteria);
        ResourceLookup[] resourceLookups = new ResourceLookup[repoResources.size()];
        resourceLookups = repoResources.toArray(resourceLookups);
        return resourceLookups;
    }

    public List loadRepoResourceList(FilterCriteria filterCriteria) {
        return this.loadRepoResourceList(null, filterCriteria);
    }

    protected List loadRepoResourceList(ExecutionContext context, FilterCriteria filterCriteria) {
        return this.loadRepoResourceList(context, filterCriteria, true);
    }

    public List loadRepoResourceList(ExecutionContext context, FilterCriteria filterCriteria, boolean sort) {
        DetachedCriteria criteria = this.translateFilterToCriteria(filterCriteria);
        if (criteria == null) {
            return new ArrayList();
        }
        List repoResources = this.getHibernateTemplate().findByCriteria(criteria);
        if (sort) {
            this.sortRepoResourcesByURI(context, repoResources);
        }
        return repoResources;
    }

    protected DetachedCriteria translateFilterToCriteria(FilterCriteria filterCriteria) {
        DetachedCriteria criteria;
        Class filterClass;
        Class clazz = filterClass = filterCriteria == null ? null : filterCriteria.getFilterClass();
        Class persistentClass = filterClass == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource) : this.getPersistentClassMappings().getImplementationClass(filterClass);
        if (persistentClass == null) {
            criteria = null;
        } else {
            List filterElements;
            criteria = DetachedCriteria.forClass((Class)persistentClass);
            criteria.createAlias("parent", "parent");
            criteria.add((Criterion)Restrictions.eq((String)"parent.hidden", (Object)Boolean.FALSE));
            if (filterCriteria != null && !(filterElements = filterCriteria.getFilterElements()).isEmpty()) {
                Conjunction conjunction = Restrictions.conjunction();
                HibernateFilter filter = new HibernateFilter((Junction)conjunction, this);
                Iterator it = filterElements.iterator();
                while (it.hasNext()) {
                    FilterElement filterElement = (FilterElement)it.next();
                    filterElement.apply((Filter)filter);
                }
                criteria.add((Criterion)conjunction);
            }
        }
        return criteria;
    }

    protected void sortRepoResourcesByURI(ExecutionContext context, List repoResources) {
        SortingUtils.sortRepoResourcesByURI(this.getCollator(context), repoResources);
    }

    public Resource newResource(ExecutionContext context, Class _class) {
        return this.resourceFactory.newResource(context, _class);
    }

    public RepoResource findByURI(Class persistentClass, String uri, boolean required) {
        if (uri == null) {
            throw new JSException("jsexception.null.uri");
        }
        String repoURIPrefix = "repo:";
        String workUri = uri.startsWith("repo:") ? uri.substring("repo:".length()) : uri;
        int sep = workUri.lastIndexOf("/");
        RepoResource res = null;
        if (sep >= 0) {
            String name = workUri.substring(sep + Folder.SEPARATOR_LENGTH);
            String folderName = workUri.substring(0, sep);
            log.debug((Object)("Looking for name: " + name + " in folder: " + folderName));
            RepoFolder folder = this.getFolder(folderName, false);
            if (folder != null) {
                res = this.findByName(persistentClass, folder, name, required);
            } else {
                log.debug((Object)("No folder: " + folderName));
            }
        }
        if (required && res == null) {
            String quotedURI = "\"" + uri + "\"";
            throw new JSResourceNotFoundException("jsexception.resource.of.type.not.found", new Object[]{quotedURI, persistentClass});
        }
        return res;
    }

    protected RepoResource findByName(Class persistentClass, RepoFolder folder, String name, boolean required) {
        RepoResource res;
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)persistentClass);
        criteria.add((Criterion)Restrictions.naturalId().set("name", (Object)name).set("parent", (Object)folder));
        List resourceList = this.getHibernateTemplate().findByCriteria(criteria);
        if (resourceList.isEmpty()) {
            if (required) {
                String uri = "\"" + folder.getURI() + "/" + name + "\"";
                throw new JSResourceNotFoundException("jsexception.resource.of.type.not.found", new Object[]{uri, persistentClass});
            }
            res = null;
        } else {
            res = (RepoResource)resourceList.get(0);
        }
        return res;
    }

    protected boolean resourceExists(RepoFolder folder, String name, Class resourceType) {
        Class persistentClass = this.resourcePersistentClass(resourceType);
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)persistentClass);
        criteria.add((Criterion)Restrictions.naturalId().set("name", (Object)name).set("parent", (Object)folder));
        criteria.setProjection(Projections.rowCount());
        List countList = this.getHibernateTemplate().findByCriteria(criteria);
        int count = (Integer)countList.get(0);
        return count > 0;
    }

    protected RepoResource createPersistentResource(Class persistentClass) {
        try {
            RepoResource repo = (RepoResource)persistentClass.newInstance();
            repo.setCreationDate(this.getOperationTimestamp());
            return repo;
        }
        catch (InstantiationException e) {
            log.fatal((Object)"Error instantiating persistent resource", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)"Error instantiating persistent resource", (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected RepoResource getRepositoryReference(RepoResource owner, Resource res) {
        Class persistentClass = this.getPersistentClassMappings().getImplementationClass(res.getClass());
        if (persistentClass == null) {
            String quotedClass = "\"" + res.getClass().getName() + "\"";
            throw new JSException("jsexception.no.persistent.class.mapped.to", new Object[]{quotedClass});
        }
        RepoResource repo = null;
        RepoFolder folder = owner.getChildrenFolder();
        if (res.isNew()) {
            boolean tempName = folder != null && !folder.isNew() && this.resourceExists(folder, res.getName(), null);
            repo = this.createPersistentResource(persistentClass);
            if (tempName) {
                this.tempNameResources().add(repo);
            }
        } else {
            if (folder != null && !folder.isNew()) {
                repo = this.findByName(persistentClass, folder, res.getName(), false);
            }
            if (repo == null) {
                String quotedResource = "\"" + res.getURIString() + "\"";
                throw new JSException("jsexception.resource.does.not.exist", new Object[]{quotedResource});
            }
        }
        return repo;
    }

    public RepoResource getReference(RepoResource owner, ResourceReference resourceRef, Class persistentReferenceClass) {
        if (resourceRef == null) {
            return null;
        }
        RepoResource repoRes = resourceRef.isLocal() ? this.getReference(owner, resourceRef.getLocalResource(), persistentReferenceClass) : this.findByURI(persistentReferenceClass, resourceRef.getReferenceURI(), true);
        return repoRes;
    }

    public RepoResource getReference(RepoResource owner, Resource resource, Class persistentReferenceClass) {
        if (resource == null) {
            return null;
        }
        RepoResource repoRes = this.getRepositoryReference(owner, resource);
        RepoFolder local = owner.getChildrenFolder();
        if (local == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating children folder for " + this));
            }
            local = new RepoFolder();
            local.setCreationDate(this.getOperationTimestamp());
            local.setName(this.getChildrenFolderName(owner.getName()));
            local.setLabel(owner.getLabel());
            local.setDescription(owner.getDescription());
            local.setParent(owner.getParent());
            local.setHidden(true);
            local.setURI();
            owner.setChildrenFolder(local);
        }
        owner.addNewChild(repoRes);
        repoRes.copyFromClient(resource, this);
        if (this.tempNameResources().contains(repoRes)) {
            repoRes.setName(TEMP_NAME_PREFIX + repoRes.getName());
        }
        return repoRes;
    }

    public List getAllFolders(final ExecutionContext context) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                DetachedCriteria criteria = DetachedCriteria.forClass((Class)(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFolder));
                criteria.add((Criterion)Restrictions.eq((String)"hidden", (Object)Boolean.FALSE));
                List repoFolders = HibernateRepositoryServiceImpl.this.getHibernateTemplate().findByCriteria(criteria);
                ArrayList<Folder> folders = new ArrayList<Folder>(repoFolders.size());
                Iterator iter = repoFolders.iterator();
                while (iter.hasNext()) {
                    RepoFolder repoFolder = (RepoFolder)iter.next();
                    Folder folder = repoFolder.toClient();
                    folders.add(folder);
                }
                SortingUtils.sortFoldersByURI(HibernateRepositoryServiceImpl.this.getCollator(context), folders);
                return folders;
            }
        });
    }

    public List getSubFolders(final ExecutionContext context, final String folderURI) {
        return (List)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                ArrayList<Folder> subfolders;
                final RepoFolder folder = HibernateRepositoryServiceImpl.this.getFolder(folderURI, false);
                if (folder == null) {
                    subfolders = new ArrayList<Folder>();
                } else {
                    List folders = HibernateRepositoryServiceImpl.this.getHibernateTemplate().executeFind(new HibernateCallback(){

                        public Object doInHibernate(Session session) throws HibernateException, SQLException {
                            return session.createFilter((Object)folder.getSubFolders(), "where hidden = false").list();
                        }
                    });
                    subfolders = new ArrayList(folders.size());
                    Iterator it = folders.iterator();
                    while (it.hasNext()) {
                        RepoFolder repoFolder = (RepoFolder)it.next();
                        subfolders.add(repoFolder.toClient());
                    }
                    SortingUtils.sortFoldersByName(HibernateRepositoryServiceImpl.this.getCollator(context), subfolders);
                }
                return subfolders;
            }
        });
    }

    public FileResourceData getResourceData(ExecutionContext context, final String uri) throws JSResourceNotFoundException {
        return (FileResourceData)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                RepoFileResource res = (RepoFileResource)HibernateRepositoryServiceImpl.this.findByURI(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoFileResource, uri, true);
                while (res.isFileReference()) {
                    res = res.getReference();
                }
                return res.copyData();
            }
        });
    }

    public FileResourceData getContentResourceData(ExecutionContext context, final String uri) throws JSResourceNotFoundException {
        return (FileResourceData)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                ContentRepoFileResource res = (ContentRepoFileResource)HibernateRepositoryServiceImpl.this.findByURI(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.ContentRepoFileResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$ContentRepoFileResource, uri, true);
                return res.copyData();
            }
        });
    }

    public RepoResource getExternalReference(String uri, Class persistentReferenceClass) {
        return this.findByURI(persistentReferenceClass, uri, true);
    }

    public RepoResource getPersistentReference(String uri, Class clientReferenceClass) {
        Class persistentClass = clientReferenceClass == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource) : this.getPersistentClassMappings().getImplementationClass(clientReferenceClass);
        return this.findByURI(persistentClass, uri, true);
    }

    public void deleteResource(ExecutionContext context, final String uri) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.deleteResource(uri);
                return null;
            }
        });
    }

    protected void deleteResource(String uri) {
        RepoResource repoResource = this.findByURI(class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource == null ? (class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource = HibernateRepositoryServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource")) : class$com$jaspersoft$jasperserver$api$metadata$common$service$impl$hibernate$persistent$RepoResource, uri, true);
        this.getHibernateTemplate().delete((Object)repoResource);
    }

    public void deleteFolder(ExecutionContext context, final String uri) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryServiceImpl.this.deleteFolder(uri);
                return null;
            }
        });
    }

    protected void deleteFolder(String uri) {
        RepoFolder folder = this.getFolder(uri, true);
        this.getHibernateTemplate().delete((Object)folder);
    }

    public void delete(ExecutionContext context, final String[] resourceURIs, final String[] folderURIs) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                int i;
                if (resourceURIs != null && resourceURIs.length > 0) {
                    for (i = 0; i < resourceURIs.length; ++i) {
                        HibernateRepositoryServiceImpl.this.deleteResource(resourceURIs[i]);
                    }
                }
                if (folderURIs != null && folderURIs.length > 0) {
                    for (i = 0; i < folderURIs.length; ++i) {
                        HibernateRepositoryServiceImpl.this.deleteFolder(folderURIs[i]);
                    }
                }
                return null;
            }
        });
    }

    public Folder getFolder(ExecutionContext context, String uri) {
        return this.getFolderUnsecure(context, uri);
    }

    public boolean folderExists(ExecutionContext context, String uri) {
        return this.folderExists(uri);
    }

    public Folder getFolderUnsecure(ExecutionContext context, final String uri) {
        return (Folder)this.executeCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                RepoFolder repoFolder = HibernateRepositoryServiceImpl.this.getFolder(uri, false);
                Folder folder = repoFolder == null ? null : repoFolder.toClient();
                return folder;
            }
        });
    }

    protected boolean folderExists(String uri) {
        return this.getFolder(uri, false) != null;
    }

    public String getChildrenFolderName(String resourceName) {
        return resourceName + CHILDREN_FOLDER_SUFFIX;
    }

    public CollatorFactory getCollatorFactory() {
        return this.collatorFactory;
    }

    public void setCollatorFactory(CollatorFactory collatorFactory) {
        this.collatorFactory = collatorFactory;
    }

    protected Collator getCollator(ExecutionContext context) {
        return this.getCollatorFactory().getCollator(context);
    }

    protected boolean pathExists(String uri) {
        return this.resourceExists(uri) || this.folderExists(uri);
    }

    public boolean repositoryPathExists(ExecutionContext context, String uri) {
        return this.pathExists(uri);
    }

    public void hideFolder(String uri) {
        this.setFolderHiddenFlag(uri, true);
    }

    public void unhideFolder(String uri) {
        this.setFolderHiddenFlag(uri, false);
    }

    private void setFolderHiddenFlag(String uri, boolean hidden) {
        RepoFolder folder = this.getFolder(uri, false);
        if (folder != null && folder.isHidden() != hidden) {
            folder.setHidden(hidden);
            this.getHibernateTemplate().saveOrUpdate((Object)folder);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

