/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryEventListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryEventListenerRegistry;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HibernateResourceDeleteListener
implements HibernateDeleteListener,
RepositoryEventListenerRegistry {
    private ResourceFactory persistentClassMappings;
    private List listeners;

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    protected void ensureListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public void registerListener(RepositoryEventListener listener) {
        this.ensureListeners();
        this.listeners.add(listener);
    }

    public void deregisterListener(RepositoryEventListener listener) {
        this.ensureListeners();
        this.listeners.remove(listener);
    }

    public ResourceFactory getPersistentClassMappings() {
        return this.persistentClassMappings;
    }

    public void setPersistentClassMappings(ResourceFactory persistentClassMappings) {
        this.persistentClassMappings = persistentClassMappings;
    }

    public void onDelete(Object o) {
        if (o instanceof RepoResource) {
            this.fireListeners((RepoResource)o);
        } else if (o instanceof RepoFolder) {
            this.fireListeners((RepoFolder)o);
        }
    }

    protected void fireListeners(RepoResource resource) {
        Class resourceItf;
        if (this.listeners != null && !this.listeners.isEmpty() && (resourceItf = this.persistentClassMappings.getInterface(resource.getClass())) != null) {
            String resourceURI = resource.getResourceURI();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                RepositoryEventListener listener = (RepositoryEventListener)it.next();
                this.fireListener(listener, resourceItf, resourceURI);
            }
        }
    }

    protected void fireListener(RepositoryEventListener listener, Class resourceItf, String resourceURI) {
        listener.onResourceDelete(resourceItf, resourceURI);
    }

    protected void fireListeners(RepoFolder folder) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            String folderURI = folder.getResourceURI();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                RepositoryEventListener listener = (RepositoryEventListener)it.next();
                this.fireListener(listener, folderURI);
            }
        }
    }

    protected void fireListener(RepositoryEventListener listener, String folderURI) {
        listener.onFolderDelete(folderURI);
    }
}

