/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.impl.IdedObject;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import java.util.Date;

public abstract class RepoResourceBase
implements IdedObject {
    protected long id;
    protected int version = -1;
    protected Date creationDate;
    protected String name = null;
    protected String label = null;
    protected String description = null;
    protected RepoFolder parent;

    protected RepoResourceBase() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RepoFolder getParent() {
        return this.parent;
    }

    public void setParent(RepoFolder parent) {
        this.parent = parent;
    }

    protected abstract Class getClientItf();

    public Object toClient(ResourceFactory resourceFactory) {
        Class clientItf = this.getClientItf();
        Resource clientRes = resourceFactory.newResource(null, clientItf);
        return clientRes;
    }

    public void copyFromClient(Object objIdent, PersistentObjectResolver resolver) {
        this.copyFrom((Resource)objIdent);
    }

    protected void copyFrom(Resource clientRes) {
        if (!this.isNew() && this.getVersion() != clientRes.getVersion()) {
            throw new JSException("jsexception.resource.no.match.versions", new Object[]{this.getResourceURI(), new Integer(clientRes.getVersion()), new Integer(this.getVersion())});
        }
        this.setName(clientRes.getName());
        this.setLabel(clientRes.getLabel());
        this.setDescription(clientRes.getDescription());
    }

    protected void copyTo(Resource clientRes) {
        clientRes.setVersion(this.getVersion());
        clientRes.setCreationDate(this.getCreationDate());
        clientRes.setName(this.getName());
        clientRes.setLabel(this.getLabel());
        clientRes.setDescription(this.getDescription());
        RepoFolder parentFolder = this.getParent();
        if (parentFolder != null) {
            clientRes.setParentFolder(parentFolder.getURI());
        }
    }

    public String getResourceURI() {
        RepoFolder parentFolder = this.getParent();
        String uri = parentFolder == null || parentFolder.isRoot() ? "/" + this.getName() : parentFolder.getURI() + "/" + this.getName();
        return uri;
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }
}

