/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.validation.Errors;

public class ValidationUtil {
    private static final Pattern PATTERN_NAME = Pattern.compile("(\\p{L}|\\p{N}|(\\_)|(\\.)|(\\-)|[;@])+");

    public static boolean regExValidateName(String inp) throws PatternSyntaxException {
        Matcher mat = PATTERN_NAME.matcher(inp.trim());
        return mat.matches();
    }

    public static void copyErrors(ValidationErrors errors, Errors uiErrors) {
        if (errors != null && uiErrors != null) {
            Iterator it = errors.getErrors().iterator();
            while (it.hasNext()) {
                ValidationError error = (ValidationError)it.next();
                uiErrors.rejectValue(error.getField(), error.getErrorCode());
            }
        }
    }
}

