/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class JIPortletAuthenticationProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$JIPortletAuthenticationProcessingFilter == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$JIPortletAuthenticationProcessingFilter = JIPortletAuthenticationProcessingFilter.class$("com.jaspersoft.jasperserver.api.metadata.user.service.impl.JIPortletAuthenticationProcessingFilter")) : class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$JIPortletAuthenticationProcessingFilter));
    private List trustedIpAddress;
    private UserAuthorityService userService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$JIPortletAuthenticationProcessingFilter;

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String base64Token;
        String token;
        int delim;
        String incomingIPAddress;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trusted Host Authentication.");
        }
        if ((incomingIPAddress = request.getRemoteAddr()) == null || !this.isFromTrustedHost(incomingIPAddress)) {
            chain.doFilter(request, response);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested from Trusted Host IP:" + incomingIPAddress));
        }
        List<String> roleList = new ArrayList<String>();
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String header = httpRequest.getHeader("Authorization");
        String userName = null;
        String password = null;
        if (header != null && header.startsWith("Basic ") && (delim = (token = new String(Base64.decodeBase64((byte[])(base64Token = header.substring(6)).getBytes()))).indexOf(":")) != -1) {
            userName = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        if (userName == null || userName.trim().length() == 0) {
            chain.doFilter(request, response);
            return;
        }
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        if (existingAuth != null && existingAuth.getName().equals(userName) && existingAuth.isAuthenticated()) {
            chain.doFilter(request, response);
            return;
        }
        if (this.doesUserExist(userName)) {
            String oldPassword;
            if (this.isInternalUser(userName) && !this.haveSamePassword(oldPassword = this.getUserPaswordFromRepository(userName), password)) {
                this.updatePassword(userName, password);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updated Password for User:" + userName));
                }
            }
            roleList = this.getUserRoleList(userName);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created New User:" + userName));
            }
            roleList.add("ROLE_USER");
            roleList.add("ROLE_PORTLET");
            this.createUserWithRoles(userName, password, roleList, false);
        }
        SecurityContextHolder.getContext().setAuthentication(this.createAuthenticationObject(userName, password, roleList, request));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Created Authentication Object within JIPortletAuthenticationProcessingFilter");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private boolean isFromTrustedHost(String ipAddress) {
        if (this.trustedIpAddress == null || ipAddress == null) {
            return false;
        }
        if (this.trustedIpAddress.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.trustedIpAddress.size(); ++i) {
            if (!((String)this.trustedIpAddress.get(i)).equals(ipAddress)) continue;
            return true;
        }
        return false;
    }

    private boolean doesUserExist(String userName) {
        return this.userService.userExists(null, userName);
    }

    private boolean isInternalUser(String userName) {
        User user = this.userService.getUser(null, userName);
        return !user.isExternallyDefined();
    }

    private void createUserWithRoles(String userName, String password, List roleList, boolean externalUser) {
        User user = this.userService.newUser(null);
        user.setExternallyDefined(externalUser);
        user.setUsername(userName);
        user.setPassword(password);
        user.setFullName(userName);
        user.setEnabled(true);
        user.setEmailAddress(userName);
        HashSet<Role> roleSet = new HashSet<Role>();
        for (int i = 0; i < roleList.size(); ++i) {
            Role role = this.userService.newRole(null);
            role.setRoleName((String)roleList.get(i));
            roleSet.add(role);
        }
        user.setRoles(roleSet);
        this.userService.putUser(null, user);
    }

    private Authentication createAuthenticationObject(String userName, String password, List roleList, ServletRequest request) {
        GrantedAuthorityImpl[] roleListArray = new GrantedAuthorityImpl[roleList.size()];
        for (int i = 0; i < roleList.size(); ++i) {
            roleListArray[i] = new GrantedAuthorityImpl((String)roleList.get(i));
        }
        User user = this.userService.getUser(null, userName);
        MetadataUserDetails md = new MetadataUserDetails(user);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)md, (Object)password, (GrantedAuthority[])roleListArray);
        authRequest.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)request));
        return authRequest;
    }

    private String getUserPaswordFromRepository(String userName) {
        User user = this.userService.getUser(null, userName);
        return user.getPassword();
    }

    private boolean haveSamePassword(String oldPassword, String newPassword) {
        return oldPassword.equals(newPassword);
    }

    private void updatePassword(String userName, String newPassword) {
        User user = this.userService.getUser(null, userName);
        user.setPassword(newPassword);
        this.userService.putUser(null, user);
    }

    private List getUserRoleList(String userName) {
        ArrayList<String> roles = new ArrayList<String>();
        User user = this.userService.getUser(null, userName);
        if (user != null) {
            Iterator iter = user.getRoles().iterator();
            while (iter.hasNext()) {
                roles.add(((Role)iter.next()).getRoleName());
            }
        }
        return roles;
    }

    public List getTrustedIpAddress() {
        return this.trustedIpAddress;
    }

    public void setTrustedIpAddress(List trustedIpAddress) {
        this.trustedIpAddress = trustedIpAddress;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

