/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ExternalUserService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MetadataAuthenticationProcessingFilter
implements Filter,
InitializingBean {
    private static Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$MetadataAuthenticationProcessingFilter == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$MetadataAuthenticationProcessingFilter = MetadataAuthenticationProcessingFilter.class$("com.jaspersoft.jasperserver.api.metadata.user.service.impl.MetadataAuthenticationProcessingFilter")) : class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$MetadataAuthenticationProcessingFilter));
    protected ExternalUserService externalUserService;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$MetadataAuthenticationProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.externalUserService);
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (log.isDebugEnabled()) {
            if (auth == null) {
                log.debug((Object)"No authentication token");
            } else {
                log.debug((Object)("Authentication token: '" + auth + "'"));
            }
        }
        if (auth != null && auth.getPrincipal() != null && auth.getPrincipal() instanceof UserDetails && !(auth.getPrincipal() instanceof MetadataUserDetails)) {
            Authentication newAuth;
            UserDetails userDetails = (UserDetails)auth.getPrincipal();
            this.getExternalUserService().maintainInternalUser(userDetails);
            this.getExternalUserService().makeUserLoggedIn(userDetails.getUsername());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Populated SecurityContextHolder with JI metadata token: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
            }
            if ((newAuth = SecurityContextHolder.getContext().getAuthentication()).getPrincipal() instanceof MetadataUserDetails) {
                MetadataUserDetails newPrincipal = (MetadataUserDetails)newAuth.getPrincipal();
                newPrincipal.setOriginalUserDetails(userDetails);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("SecurityContextHolder was changed to a different JI internal metadata token: " + (auth == null ? "authentication was null" : (auth.getPrincipal() == null ? "authentication principal was null" : "authentication principal was: '" + auth.getPrincipal()) + "'")));
        }
        chain.doFilter(request, response);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After chain, JI metadata token is: '" + SecurityContextHolder.getContext().getAuthentication() + "'"));
        }
    }

    public ExternalUserService getExternalUserService() {
        return this.externalUserService;
    }

    public void setExternalUserService(ExternalUserService externalUserService) {
        this.externalUserService = externalUserService;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

