/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.PersistentObjectResolver;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoRole;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.ExternalUserService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.switchuser.SwitchUserGrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class UserAuthorityServiceImpl
extends HibernateDaoImpl
implements UserDetailsService,
ExternalUserService,
PersistentObjectResolver {
    protected static final Log log = LogFactory.getLog((Class)(class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$UserAuthorityServiceImpl == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$UserAuthorityServiceImpl = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl")) : class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$UserAuthorityServiceImpl));
    private ResourceFactory objectFactory;
    private ResourceFactory persistentClassFactory;
    private ProfileAttributeService profileAttributeService;
    private List defaultInternalRoles;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$service$impl$UserAuthorityServiceImpl;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$domain$User;
    static /* synthetic */ Class class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role;

    public ResourceFactory getObjectMappingFactory() {
        return this.objectFactory;
    }

    public void setObjectMappingFactory(ResourceFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ResourceFactory getPersistentClassFactory() {
        return this.persistentClassFactory;
    }

    public void setPersistentClassFactory(ResourceFactory persistentClassFactory) {
        this.persistentClassFactory = persistentClassFactory;
    }

    public ProfileAttributeService getProfileAttributeService() {
        return this.profileAttributeService;
    }

    public void setProfileAttributeService(ProfileAttributeService p) {
        this.profileAttributeService = p;
        p.setUserAuthorityService((UserAuthorityService)this);
    }

    protected RepoUser getRepoUser(ExecutionContext context, String username) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User));
        criteria.add((Criterion)Restrictions.eq((String)"username", (Object)username));
        List userList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoUser user = null;
        if (userList.isEmpty()) {
            log.debug((Object)("User not found with username \"" + username + "\""));
        } else {
            user = (RepoUser)userList.get(0);
        }
        return user;
    }

    public User getUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        User userDTO = null;
        if (user != null) {
            userDTO = (User)user.toClient(this.getObjectMappingFactory());
            List attrs = this.getProfileAttributeService().getProfileAttributesForPrincipal(null, (Object)user);
            userDTO.setAttributes(attrs);
        } else {
            log.debug((Object)("No such user as: " + username));
        }
        return userDTO;
    }

    protected RepoUser getRepoUser(ExecutionContext context, Long id) {
        RepoUser user = (RepoUser)this.getHibernateTemplate().load(this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User), (Serializable)id);
        return user;
    }

    protected User getUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        User userDTO = null;
        if (user != null) {
            userDTO = (User)user.toClient(this.getObjectMappingFactory());
        }
        return userDTO;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User u = this.getUser(null, username);
        if (u == null) {
            throw new UsernameNotFoundException("User not found with username \"" + username + "\"");
        }
        return new MetadataUserDetails(u);
    }

    public void putUser(ExecutionContext context, User aUser) {
        RepoUser existingUser = this.getRepoUser(context, aUser.getUsername());
        if (existingUser == null) {
            existingUser = (RepoUser)this.getPersistentClassFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User);
        }
        existingUser.copyFromClient(aUser, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingUser);
    }

    public List getUsers(ExecutionContext context, FilterCriteria filterCriteria) {
        List results = this.getHibernateTemplate().loadAll(this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User));
        ArrayList<User> userDTOs = null;
        if (results != null) {
            userDTOs = new ArrayList<User>(results.size());
            Iterator it = results.iterator();
            while (it.hasNext()) {
                RepoUser u = (RepoUser)it.next();
                User newUser = (User)u.toClient(this.getObjectMappingFactory());
                userDTOs.add(newUser);
            }
        }
        return userDTOs;
    }

    public User newUser(ExecutionContext context) {
        return (User)this.getObjectMappingFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User);
    }

    protected boolean disableUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        if (user != null && user.isEnabled()) {
            user.setEnabled(false);
            return true;
        }
        return false;
    }

    public boolean disableUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user != null && user.isEnabled()) {
            user.setEnabled(false);
            return true;
        }
        return false;
    }

    protected boolean enableUser(ExecutionContext context, Long id) {
        RepoUser user = this.getRepoUser(context, id);
        if (user != null && !user.isEnabled()) {
            user.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean enableUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user != null && !user.isEnabled()) {
            user.setEnabled(true);
            return true;
        }
        return false;
    }

    public void deleteUser(ExecutionContext context, String username) {
        RepoUser user = this.getRepoUser(context, username);
        if (user == null) {
            return;
        }
        this.removeAllRoles(context, user);
        this.getHibernateTemplate().delete((Object)user);
    }

    public void addRole(ExecutionContext context, User user, Role role) {
        if (user == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user.getUsername());
        if (existingUser != null) {
            RepoRole existingRole = this.getRepoRole(context, role.getRoleName());
            existingUser.addRole(existingRole);
            this.putUser(null, existingUser);
        }
        user.addRole(role);
    }

    public void removeRole(ExecutionContext context, User user, Role role) {
        if (user == null || role == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user.getUsername());
        if (existingUser != null) {
            RepoRole r = this.getRepoRole(context, role.getRoleName());
            if (r != null) {
                existingUser.removeRole(r);
                this.putUser(null, existingUser);
            } else {
                log.debug((Object)("removeRole: No role such as " + role.getRoleName()));
            }
        } else {
            log.debug((Object)("removeRole: No user such as " + user.getUsername()));
        }
        user.removeRole(role);
    }

    public void removeAllRoles(ExecutionContext context, User user) {
        if (user == null) {
            return;
        }
        RepoUser existingUser = this.getRepoUser(context, user.getUsername());
        if (existingUser == null) {
            return;
        }
        existingUser.getRoles().clear();
        this.putUser(null, existingUser);
    }

    public Role getRole(ExecutionContext context, String roleName) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.Role")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role));
        criteria.add((Criterion)Restrictions.eq((String)"roleName", (Object)roleName));
        List roleList = this.getHibernateTemplate().findByCriteria(criteria);
        Role role = null;
        if (roleList.isEmpty()) {
            log.debug((Object)("Role not found with role name \"" + roleName + "\""));
        } else {
            RepoRole repoRole = (RepoRole)roleList.get(0);
            role = (Role)repoRole.toClient(this.getObjectMappingFactory());
        }
        return role;
    }

    protected RepoRole getRepoRole(ExecutionContext context, String roleName) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.Role")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role));
        criteria.add((Criterion)Restrictions.eq((String)"roleName", (Object)roleName));
        List userList = this.getHibernateTemplate().findByCriteria(criteria);
        RepoRole role = null;
        if (userList.isEmpty()) {
            log.debug((Object)("Role not found with role name \"" + roleName + "\""));
        } else {
            role = (RepoRole)userList.get(0);
        }
        return role;
    }

    public void putRole(ExecutionContext context, Role aRole) {
        RepoRole existingRole = this.getRepoRole(context, aRole.getRoleName());
        log.debug((Object)("putRole: " + aRole.getRoleName() + ", " + existingRole));
        if (existingRole == null) {
            existingRole = (RepoRole)this.getPersistentClassFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.Role")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role);
            log.debug((Object)"New Object");
        }
        existingRole.copyFromClient(aRole, this);
        this.getHibernateTemplate().saveOrUpdate((Object)existingRole);
        Set repoUsers = existingRole.getUsers();
        Iterator it = repoUsers.iterator();
        while (it.hasNext()) {
            RepoUser repoUser = (RepoUser)it.next();
            repoUser.getRoles().remove(this.getPersistentObject(aRole));
        }
        Set users = aRole.getUsers();
        Iterator it2 = users.iterator();
        while (it2.hasNext()) {
            User user = (User)it2.next();
            this.addRole(context, user, aRole);
        }
    }

    public List getRoles(ExecutionContext context, FilterCriteria filterCriteria) {
        List results = this.getHibernateTemplate().loadAll(this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.Role")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role));
        ArrayList<Role> roleDTOs = null;
        if (results != null) {
            roleDTOs = new ArrayList<Role>(results.size());
            Iterator it = results.iterator();
            while (it.hasNext()) {
                RepoRole r = (RepoRole)it.next();
                Role newRole = (Role)r.toClient(this.getObjectMappingFactory());
                roleDTOs.add(newRole);
            }
        }
        return roleDTOs;
    }

    public Role newRole(ExecutionContext context) {
        return (Role)this.getObjectMappingFactory().newObject(class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.Role")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$Role);
    }

    public void deleteRole(ExecutionContext context, String roleName) {
        RepoRole role = this.getRepoRole(context, roleName);
        if (role == null) {
            return;
        }
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.getPersistentClassFactory().getImplementationClass(class$com$jaspersoft$jasperserver$api$metadata$user$domain$User == null ? (class$com$jaspersoft$jasperserver$api$metadata$user$domain$User = UserAuthorityServiceImpl.class$("com.jaspersoft.jasperserver.api.metadata.user.domain.User")) : class$com$jaspersoft$jasperserver$api$metadata$user$domain$User));
        criteria.createAlias("roles", "r").add((Criterion)Restrictions.eq((String)"r.roleName", (Object)roleName));
        List userList = this.getHibernateTemplate().findByCriteria(criteria);
        Iterator it = userList.iterator();
        while (it.hasNext()) {
            RepoUser u = (RepoUser)it.next();
            u.removeRole(role);
        }
        this.getHibernateTemplate().delete((Object)role);
    }

    public List getUsersNotInRole(ExecutionContext context, String roleName) {
        List allUsers = this.getUsers(context, null);
        List usersInRole = this.getUsersInRole(context, roleName);
        allUsers.removeAll(usersInRole);
        return allUsers;
    }

    public List getUsersInRole(ExecutionContext context, String roleName) {
        RepoRole repoRole = this.getRepoRole(context, roleName);
        Set repoUsers = repoRole.getUsers();
        ArrayList<User> users = new ArrayList<User>();
        Iterator it = repoUsers.iterator();
        while (it.hasNext()) {
            RepoUser repoUser = (RepoUser)it.next();
            User user = (User)repoUser.toClient(this.getObjectMappingFactory());
            users.add(user);
        }
        return users;
    }

    public List getAssignedRoles(ExecutionContext context, String userName) {
        RepoUser repoUser = this.getRepoUser(context, userName);
        Set repoRoles = repoUser.getRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        Iterator it = repoRoles.iterator();
        while (it.hasNext()) {
            RepoRole repoRole = (RepoRole)it.next();
            Role role = (Role)repoRole.toClient(this.getObjectMappingFactory());
            roles.add(role);
        }
        return roles;
    }

    public List getAvailableRoles(ExecutionContext context, String userName) {
        List allRoles = this.getRoles(context, null);
        List assignedRoles = this.getAssignedRoles(null, userName);
        allRoles.removeAll(assignedRoles);
        return allRoles;
    }

    public boolean roleExists(ExecutionContext context, String roleName) {
        return this.getRole(context, roleName) != null;
    }

    public Object getPersistentObject(Object clientObject) {
        if (clientObject instanceof Role) {
            Role r = (Role)clientObject;
            return this.getRepoRole(null, r.getRoleName());
        }
        if (clientObject instanceof User) {
            User u = (User)clientObject;
            return this.getRepoUser(null, u.getUsername());
        }
        return null;
    }

    public void maintainInternalUser(UserDetails externalUserDetails) {
        log.debug((Object)("External user: " + externalUserDetails.getUsername()));
        User user = this.getUser((ExecutionContext)new ExecutionContextImpl(), externalUserDetails.getUsername());
        if (user == null) {
            user = this.createNewExternalUser(externalUserDetails);
        }
        this.alignInternalAndExternalUser(externalUserDetails, user);
    }

    private User createNewExternalUser(UserDetails userDetails) {
        User user = this.newUser((ExecutionContext)new ExecutionContextImpl());
        user.setUsername(userDetails.getUsername());
        user.setFullName(userDetails.getUsername());
        user.setExternallyDefined(true);
        user.setEnabled(true);
        log.warn((Object)("Created new external user: " + user.getUsername()));
        return user;
    }

    private void alignInternalAndExternalUser(UserDetails userDetails, User user) {
        Collection defaultInternalRolesToAdd;
        Collection rolesNeedingRemoval;
        Collection newExternalRoles;
        Set externalRoles = this.getRolesFromUserDetails(userDetails);
        Predicate externallyDefinedRoles = new Predicate(){

            public boolean evaluate(Object input) {
                if (!(input instanceof Role)) {
                    return false;
                }
                return ((Role)input).isExternallyDefined();
            }
        };
        Set currentRoles = user.getRoles();
        boolean persistUserNeeded = currentRoles.size() == 0;
        Collection currentExternalRoles = CollectionUtils.select((Collection)user.getRoles(), (Predicate)externallyDefinedRoles);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Login of external User: " + userDetails.getUsername()));
            log.debug((Object)("Roles from authentication:\n" + this.roleCollectionToString(externalRoles)));
            log.debug((Object)("Current roles from metadata:\n" + this.roleCollectionToString(user.getRoles())));
            log.debug((Object)("Current external roles for user from metadata: " + user.getUsername() + "\n" + this.roleCollectionToString(currentExternalRoles)));
        }
        if ((newExternalRoles = CollectionUtils.subtract((Collection)externalRoles, (Collection)currentExternalRoles)).size() > 0) {
            currentRoles.addAll(newExternalRoles);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Added following external roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(newExternalRoles)));
            }
            persistUserNeeded = true;
        }
        if ((rolesNeedingRemoval = CollectionUtils.subtract((Collection)currentExternalRoles, (Collection)externalRoles)).size() > 0) {
            currentRoles.removeAll(rolesNeedingRemoval);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Removed following external roles from: " + user.getUsername() + "\n" + this.roleCollectionToString(rolesNeedingRemoval)));
            }
            persistUserNeeded = true;
        }
        if ((defaultInternalRolesToAdd = CollectionUtils.subtract((Collection)this.getNewDefaultInternalRoles(), (Collection)currentRoles)).size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Default internal roles: " + this.roleCollectionToString(this.getNewDefaultInternalRoles())));
            }
            currentRoles.addAll(defaultInternalRolesToAdd);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Added following new default internal roles to: " + user.getUsername() + "\n" + this.roleCollectionToString(defaultInternalRolesToAdd)));
            }
            persistUserNeeded = true;
        }
        if (persistUserNeeded) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
            user.setRoles(currentRoles);
            this.putUser((ExecutionContext)new ExecutionContextImpl(), user);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Updated user: " + user.getUsername() + ". Roles are now:\n" + this.roleCollectionToString(currentRoles)));
            }
        }
    }

    private String roleCollectionToString(Collection coll) {
        Iterator it = coll.iterator();
        StringBuffer rolesPrint = new StringBuffer();
        while (it.hasNext()) {
            String s = ((Role)it.next()).getRoleName();
            rolesPrint.append(s).append("\n");
        }
        return rolesPrint.toString();
    }

    private Set getRolesFromUserDetails(UserDetails ud) {
        HashSet<Role> set = new HashSet<Role>();
        GrantedAuthority[] authorities = ud.getAuthorities();
        if (authorities == null || authorities.length == 0) {
            return set;
        }
        for (int i = 0; i < authorities.length; ++i) {
            GrantedAuthority auth = authorities[i];
            String authorityName = auth.getAuthority();
            authorityName = authorityName.replace(' ', '_');
            set.add(this.getOrCreateRole(authorityName, true));
        }
        return set;
    }

    public static Authentication getSourceAuthentication() {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        Authentication original = null;
        GrantedAuthority[] authorities = current.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!(authorities[i] instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)authorities[i]).getSource();
            log.debug((Object)("Found original switch user granted authority [" + original + "]"));
        }
        return original;
    }

    public static boolean isUserSwitched() {
        return UserAuthorityServiceImpl.getSourceAuthentication() != null;
    }

    private Set getNewDefaultInternalRoles() {
        HashSet<Role> set = new HashSet<Role>();
        if (this.getDefaultInternalRoles() == null || this.getDefaultInternalRoles().size() == 0) {
            return set;
        }
        for (int i = 0; i < this.getDefaultInternalRoles().size(); ++i) {
            String roleName = (String)this.getDefaultInternalRoles().get(i);
            set.add(this.getOrCreateRole(roleName, false));
        }
        return set;
    }

    private Role getOrCreateRole(String roleName, boolean externallyDefined) {
        Role r = this.getRole((ExecutionContext)new ExecutionContextImpl(), roleName);
        if (r == null) {
            r = this.newRole((ExecutionContext)new ExecutionContextImpl());
            r.setRoleName(roleName);
            r.setExternallyDefined(externallyDefined);
            this.putRole((ExecutionContext)new ExecutionContextImpl(), r);
            log.warn((Object)("Created new " + (externallyDefined ? "external" : "internal") + " role: " + roleName));
        }
        return r;
    }

    public void makeUserLoggedIn(String username) {
        try {
            UserDetails ourUserDetails = this.loadUserByUsername(username);
            if (ourUserDetails.getAuthorities().length != 0) {
                UsernamePasswordAuthenticationToken ourAuthentication = new UsernamePasswordAuthenticationToken((Object)ourUserDetails, (Object)ourUserDetails.getPassword(), ourUserDetails.getAuthorities());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting Authentication to: " + ourAuthentication));
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)ourAuthentication);
            } else {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }
        catch (UsernameNotFoundException e) {
            log.warn((Object)("User: " + username + " was not found to make them logged in"));
        }
    }

    public List getDefaultInternalRoles() {
        return this.defaultInternalRoles;
    }

    public void setDefaultInternalRoles(List defaultInternalRoles) {
        this.defaultInternalRoles = defaultInternalRoles;
    }

    public boolean userExists(ExecutionContext context, String username) {
        return this.getUser(context, username) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

