/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletRequestParameterMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class PortletExternalContext
implements ExternalContext {
    private PortletContext context;
    private PortletRequest request;
    private PortletResponse response;

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getDispatcherPath() {
        return null;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public ParameterMap getRequestParameterMap() {
        return new LocalParameterMap((Map)((Object)new PortletRequestParameterMap(this.request)));
    }

    public MutableAttributeMap getRequestMap() {
        return new LocalAttributeMap((Map)((Object)new PortletRequestMap(this.request)));
    }

    public SharedAttributeMap getSessionMap() {
        return new LocalSharedAttributeMap(new PortletSessionMap(this.request, 2));
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return new LocalSharedAttributeMap(new PortletSessionMap(this.request, 1));
    }

    public SharedAttributeMap getApplicationMap() {
        return new LocalSharedAttributeMap(new PortletContextMap(this.context));
    }

    public MutableAttributeMap getUserInfoMap() {
        Map userInfo = (Map)this.request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            return new LocalAttributeMap(userInfo);
        }
        return null;
    }

    public PortletContext getContext() {
        return this.context;
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("requestParameterMap", (Object)this.getRequestParameterMap()).toString();
    }
}

